/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.controller;

import com.turborilla.mule.MuleException;
import com.turborilla.mule.Properties;
import com.turborilla.mule.controller.GameController;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.network.Client;
import com.turborilla.mule.network.ClientId;
import com.turborilla.mule.network.MessageReceiver;
import com.turborilla.mule.network.TCPMessage;
import com.turborilla.mule.view.GameInput;
import com.turborilla.mule.view.ReconnectPainter;
import com.turborilla.mule.view.View;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class ReconnectController2
extends MessageReceiver {
    private static final Logger logger = Logger.getLogger("mule");
    private GameModel model;
    private GameController controller;
    private View view;
    private boolean enabled;
    private ClientId clientId;
    private long retryConnectTime;
    private int numRetryConnection;

    public ReconnectController2(GameController gameController) {
        this.controller = gameController;
        this.enabled = false;
    }

    public void begin(GameModel gameModel, GameController gameController, View view) {
        this.model = gameModel;
        this.controller = gameController;
        this.view = view;
        logger.info("Reconnecting");
        this.enabled = true;
        this.retryConnectTime = 0L;
        this.numRetryConnection = 0;
        Client client = this.controller.getClient();
        this.clientId = client.getClientId();
        this.connect();
    }

    private Client connect() {
        this.controller.getClient().close();
        Client client = new Client();
        this.controller.setClient(client);
        try {
            client.connect(this.model.getGameInfo().getServerAddress());
        }
        catch (MuleException muleException) {
            logger.severe(muleException.toString());
        }
        this.retryConnectTime = System.currentTimeMillis() + Properties.mule.retryConnectTime;
        ++this.numRetryConnection;
        return client;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void update(GameInput gameInput) {
        Client client = this.controller.getClient();
        if (!client.isConnected()) {
            if (System.currentTimeMillis() > this.retryConnectTime) {
                this.connect();
            }
            try {
                if (client.finishConnect()) {
                    client.sendTCP(new TCPMessage.ReconnectJoinMessage(this.clientId));
                }
            }
            catch (IOException iOException) {
                logger.severe(iOException.toString());
            }
        }
    }

    private void end() {
        this.enabled = false;
        this.model = null;
        this.view = null;
        this.controller = null;
    }

    public void draw() {
        Client client = this.controller.getClient();
        ReconnectPainter reconnectPainter = this.view.getReconnectPainter();
        reconnectPainter.draw(this.model.getUsers(), new ArrayList<Integer>());
        if (!client.isConnected()) {
            reconnectPainter.drawStatus("Connecting (" + this.numRetryConnection + ") ...");
        } else {
            reconnectPainter.drawStatus("Awaiting game state");
        }
    }
}

