/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.controller;

import com.turborilla.mule.MuleException;
import com.turborilla.mule.MuleFileNotFoundException;
import com.turborilla.mule.Properties;
import com.turborilla.mule.Settings;
import com.turborilla.mule.ai.AIPlayerController;
import com.turborilla.mule.controller.GameControllerListener;
import com.turborilla.mule.controller.GameModelSerializer;
import com.turborilla.mule.controller.PlayerController;
import com.turborilla.mule.controller.ReconnectController2;
import com.turborilla.mule.controller.UserController;
import com.turborilla.mule.controller.phase.AuctionPhase;
import com.turborilla.mule.controller.phase.CollectionPhase;
import com.turborilla.mule.controller.phase.ColonyEventPhase;
import com.turborilla.mule.controller.phase.ConnectPhase;
import com.turborilla.mule.controller.phase.DevelopmentPhaseMulti;
import com.turborilla.mule.controller.phase.DevelopmentPhaseSingle;
import com.turborilla.mule.controller.phase.FastDevelopmentPhase;
import com.turborilla.mule.controller.phase.GameLobbyPhase;
import com.turborilla.mule.controller.phase.IntroPhase;
import com.turborilla.mule.controller.phase.LandAuctionPhase;
import com.turborilla.mule.controller.phase.LandGrantPhase;
import com.turborilla.mule.controller.phase.PhaseController;
import com.turborilla.mule.controller.phase.PlayerEventPhase;
import com.turborilla.mule.controller.phase.ProductionPhase;
import com.turborilla.mule.controller.phase.SummaryPhase2;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Phase;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.User;
import com.turborilla.mule.model.UserInfo;
import com.turborilla.mule.model.util.NetworkTimer;
import com.turborilla.mule.network.Client;
import com.turborilla.mule.network.MasterClient;
import com.turborilla.mule.network.Message;
import com.turborilla.mule.network.MessageReceiver;
import com.turborilla.mule.network.Server;
import com.turborilla.mule.network.ServerMessageHandler;
import com.turborilla.mule.network.ServerObserver;
import com.turborilla.mule.network.TCPMessage;
import com.turborilla.mule.network.UDPMessage;
import com.turborilla.mule.sound.SoundPlayer;
import com.turborilla.mule.view.GameInput;
import com.turborilla.mule.view.MapSkin;
import com.turborilla.mule.view.MapSkinParser;
import com.turborilla.mule.view.Transition;
import com.turborilla.mule.view.View;
import com.turborilla.mule.view.ViewProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.opengl.Display;
import org.newdawn.slick.SlickException;

public class GameController
extends MessageReceiver
implements ServerObserver {
    private Logger logger = Logger.getLogger("mule");
    private long frame = 0L;
    private UserInfo userInfo;
    private EnumMap<Phase, PhaseController> phases;
    private PhaseController prevPhase;
    private PhaseController phase;
    private Transition phaseTransition;
    private Client client;
    private Server localServer;
    private MasterClient masterClient;
    private GameModel model;
    private View view;
    private UserController userController;
    private ReconnectController2 reconnectController;
    private GameModelSerializer modelSerializer;
    private long lastSavedModelFrame = -1L;
    private long readyTimeout;
    private String closeString = null;
    private boolean closeRequested = false;
    public boolean debugDisconnect = false;
    private boolean isWindowFocused = true;
    public ArrayList<GameControllerListener> listeners;
    private long synchonizationChecksum = 0L;
    private boolean synchonizationFailed = false;

    public GameController(GameModel gameModel, View view, GameInput gameInput, MasterClient masterClient, UserInfo userInfo) {
        this.userInfo = userInfo;
        this.view = view;
        this.masterClient = masterClient;
        this.client = new Client();
        this.userController = new UserController(this, gameInput);
        this.reconnectController = new ReconnectController2(this);
        this.modelSerializer = new GameModelSerializer();
        this.listeners = new ArrayList();
        this.phases = new EnumMap(Phase.class);
        this.phases.put(Phase.CONNECT, new ConnectPhase());
        this.phases.put(Phase.GAME_LOBBY, new GameLobbyPhase());
        this.phases.put(Phase.INTRO, new IntroPhase());
        this.phases.put(Phase.LAND_GRANT, new LandGrantPhase());
        this.phases.put(Phase.PLAYER_EVENT, new PlayerEventPhase());
        this.phases.put(Phase.COLONY_EVENT_A, new ColonyEventPhase(true));
        this.phases.put(Phase.PRODUCTION, new ProductionPhase());
        this.phases.put(Phase.COLONY_EVENT_B, new ColonyEventPhase(false));
        this.phases.put(Phase.COLLECTION_CRYSTITE, new CollectionPhase(Resource.Crystite));
        this.phases.put(Phase.COLLECTION_SMITHORE, new CollectionPhase(Resource.Smithore));
        this.phases.put(Phase.COLLECTION_ENERGY, new CollectionPhase(Resource.Energy));
        this.phases.put(Phase.COLLECTION_FOOD, new CollectionPhase(Resource.Food));
        this.phases.put(Phase.AUCTION_CRYSTITE, new AuctionPhase(Resource.Crystite));
        this.phases.put(Phase.AUCTION_SMITHORE, new AuctionPhase(Resource.Smithore));
        this.phases.put(Phase.AUCTION_ENERGY, new AuctionPhase(Resource.Energy));
        this.phases.put(Phase.AUCTION_FOOD, new AuctionPhase(Resource.Food));
        this.phases.put(Phase.LAND_AUCTION, new LandAuctionPhase());
        this.phases.put(Phase.SUMMARY, new SummaryPhase2());
        this.setModel(gameModel);
    }

    public long getFrame() {
        return this.frame;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public Server getServer() {
        return this.localServer;
    }

    public void setServer(Server server) {
        if (this.localServer != null) {
            this.localServer.removeObserver(this);
        }
        this.localServer = server;
        this.localServer.getMessageHandler().set(this.model);
        if (this.localServer != null) {
            this.localServer.addObserver(this);
        }
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void update(GameInput gameInput) {
        this.serverUpdate();
        this.isWindowFocused = Display.isActive();
        if (!this.isWindowFocused) {
            gameInput.clearKeyStates();
        }
        if (gameInput.isPressed(6) && !Display.isFullscreen()) {
            for (GameControllerListener object : this.listeners) {
                object.startChat();
            }
        }
        this.checkMessageTimeout();
        this.checkReadyTimeout();
        this.masterClient.receiveResponses();
        try {
            if (!this.debugDisconnect) {
                this.client.receiveMessages();
            }
        }
        catch (IOException iOException) {
            this.logger.severe("Client failed to receive. " + iOException.toString());
            this.reconnect(iOException.getMessage());
        }
        this.model.getTimerManager().setFrame(this.frame);
        this.applyReceivedMessages();
        if (this.closeRequested) {
            return;
        }
        if (this.reconnectController.isEnabled()) {
            this.reconnectController.update(gameInput);
        } else {
            this.model.getTimerManager().update(this.client);
            for (Player player : this.model.getPlayers()) {
                PlayerController playerController = player.getController();
                if (!(playerController instanceof AIPlayerController)) continue;
                ((AIPlayerController)playerController).update(this.model, this.frame);
            }
            if (this.phaseTransition != null) {
                this.phaseTransition.update(Properties.mule.delta);
                if (this.phaseTransition.isComplete()) {
                    this.prevPhase.endTransitionComplete();
                    this.phase.beginTransitionComplete();
                    this.phaseTransition = null;
                }
            }
            this.phase.update(gameInput);
            ++this.frame;
        }
        this.view.update();
        SoundPlayer.get().update();
        try {
            if (!this.debugDisconnect) {
                this.client.sendMessages();
            }
            this.client.sendAliveMessages();
        }
        catch (IOException iOException) {
            this.logger.warning("Client failed to send. " + iOException.toString());
            this.reconnect(iOException.getMessage());
        }
        this.serverUpdate();
    }

    public void idle() {
        this.serverUpdate();
    }

    private void serverUpdate() {
        if (this.localServer != null) {
            try {
                this.localServer.acceptClients();
                this.localServer.receiveMessages();
                this.localServer.sendMessages();
            }
            catch (IOException iOException) {
                this.logger.log(Level.SEVERE, iOException.toString(), iOException);
            }
        }
    }

    public void draw() {
        ViewProperties viewProperties = ViewProperties.get();
        this.view.beginFrame();
        if (this.view.isHUDEnabled()) {
            this.view.setScissorBox(viewProperties.getPlayViewX(), viewProperties.getPlayViewY(), viewProperties.getPlayViewWidth(), viewProperties.getPlayViewHeight());
        }
        if (this.phaseTransition != null) {
            this.view.drawTransition(this.phaseTransition, this.prevPhase, this.phase);
        } else {
            this.phase.draw();
        }
        this.view.drawInfoMessages();
        this.view.drawTerminalMessage();
        this.view.drawTitle();
        if (this.view.isHUDEnabled()) {
            this.view.clearScissorBox();
            this.view.getHUDPainter().draw(this.model.getPlayersInRankOrder(), this.model.getMyPlayer(), this.model.getShop(), this.model.getRound());
        }
        if (this.reconnectController.isEnabled()) {
            this.reconnectController.draw();
        }
        if (!this.isWindowFocused) {
            this.view.drawFocusLost();
        }
    }

    private void applyReceivedMessages() {
        while (this.client.hasNextMessage()) {
            Message message = this.client.nextMessage();
            message.accept(this);
            if (this.reconnectController.isEnabled()) {
                message.accept(this.reconnectController);
            }
            message.accept(this.userController);
            message.accept(this.phase);
        }
        this.client.tickDelayedMessages();
    }

    public void apply(TCPMessage.ReadyMessage readyMessage) {
        User user = this.model.getUser(readyMessage.getUserNumber());
        if (user != null) {
            user.setReady(true);
            if (user == this.model.getMyUser()) {
                long l = System.currentTimeMillis();
                Properties.mule.getClass();
                this.readyTimeout = l + 20000L;
            }
        }
        this.beginNextPhase();
    }

    public void apply(TCPMessage.TimerStartedMessage timerStartedMessage) {
        this.model.getTimerManager().apply(timerStartedMessage);
    }

    public void apply(TCPMessage.TimerFinishedMessage timerFinishedMessage) {
        NetworkTimer networkTimer = this.model.getTimerManager().apply(timerFinishedMessage);
        this.phase.timerFinished(networkTimer);
    }

    public void apply(UDPMessage.SynchronizeTimerMessage synchronizeTimerMessage) {
        this.model.getTimerManager().apply(synchronizeTimerMessage);
    }

    public void apply(TCPMessage.ChatMessage chatMessage) {
        User user = this.model.getUser(chatMessage.getUserNumber());
        this.logger.info(user + " chat: " + chatMessage.text);
        for (GameControllerListener gameControllerListener : this.listeners) {
            gameControllerListener.chatMessageUser(chatMessage.text, chatMessage.getUserNumber());
        }
    }

    public void apply(TCPMessage.SystemChatMessage systemChatMessage) {
        this.sendSystemChatMessage(systemChatMessage.text);
    }

    public void sendChatMessage(String string) {
        User user = this.model.getMyUser();
        if (user != null) {
            user.send(this.client, new TCPMessage.ChatMessage(string));
        }
    }

    public void sendSystemChatMessage(String string, User user) {
        this.sendSystemChatMessage(string, user.getName(), user.getColorIndex());
    }

    public void sendSystemChatMessage(String string) {
        this.sendSystemChatMessage(string, "", 0);
    }

    private void sendSystemChatMessage(String string, String string2, int n) {
        for (GameControllerListener gameControllerListener : this.listeners) {
            gameControllerListener.chatMessageSystem(string, string2, n);
        }
    }

    public void sendChatLog() {
        for (GameControllerListener gameControllerListener : this.listeners) {
            gameControllerListener.sendChatLog(this.model.getGameInfo().getGameID());
        }
    }

    public void beginNextPhase() {
        while (this.model.canGoToNextPhase()) {
            for (User user : this.model.getUsers()) {
                if (user.isAccepted()) continue;
                this.logger.info(user.toString() + " is not accepted");
            }
            this.readyTimeout = 0L;
            if (this.phase != null) {
                if (this.phaseTransition != null) {
                    this.logger.info("Forcibly ending uncompleted phase transition");
                    this.prevPhase.endTransitionComplete();
                    this.phase.beginTransitionComplete();
                }
                this.model.aiEndPhase();
                this.phaseTransition = this.phase.end();
                if (this.phaseTransition == null) {
                    this.phase.endTransitionComplete();
                }
                if (this.prevPhase != null) {
                    this.prevPhase.set(null, null, null);
                }
                this.prevPhase = this.phase;
                for (GameControllerListener gameControllerListener : this.listeners) {
                    gameControllerListener.phaseEnded();
                }
            }
            this.model.goToNextPhase();
            this.logger.info("--------- " + (Object)((Object)this.model.getPhase()) + " #" + this.model.getRound() + " --------------------------------------------------------");
            this.acceptPendingUsers();
            if (this.isServer()) {
                this.localServer.logRoundtrip();
            }
            this.client.logRoundtripTime();
            this.phase = this.phases.get((Object)this.model.getPhase());
            this.phase.set(this.model, this, this.view);
            this.phase.begin();
            this.model.aiBeginPhase();
            if (this.phaseTransition != null) continue;
            this.phase.beginTransitionComplete();
        }
    }

    private void checkMessageTimeout() {
        if (this.client.checkTCPTimeOut()) {
            if (this.localServer != null) {
                this.logger.severe("Client timed out from it's local server.");
            }
            String string = "Your network connection timed out";
            this.logger.severe(string);
            this.sendSystemChatMessage(string);
            this.view.getMessagePainter().addInfoMessage(string);
            this.client.clearTCPTimeOut();
        }
    }

    private void checkReadyTimeout() {
        if (this.readyTimeout == 0L) {
            return;
        }
        if (System.currentTimeMillis() > this.readyTimeout) {
            this.readyTimeout = 0L;
            for (User user : this.model.getUsers()) {
                if (user.isReady()) continue;
                String string = user.getName() + " is not responding to continue";
                this.logger.severe(string);
                this.sendSystemChatMessage("%s is not responding to continue", user);
                this.view.getMessagePainter().addInfoMessage(string);
            }
            this.sendSystemChatMessage("Users who are not responding must be kicked to continue the game");
        }
    }

    public void reconnect(String string) {
        this.client.close();
        if (this.model.isGameOver()) {
            this.sendSystemChatMessage("You were disconnected");
        } else if (!this.model.isGameStarted()) {
            this.requestClose("You were disconnected\n" + string, true);
        } else if (!this.reconnectController.isEnabled()) {
            this.requestClose("You were disconnected\n" + string, true);
        }
    }

    public void userDisconnected(int n) {
        User user = this.model.getUser(n);
        if (user != null) {
            this.client.sendTCP(new TCPMessage.UserDisconnectedMessage(user.getUserNumber()));
        }
    }

    public void setModel(GameModel gameModel) {
        Object object;
        this.logger.info("++++++++ New Model: " + (Object)((Object)gameModel.getPhase()) + " #" + gameModel.getRound() + " +++++++++++++++++++++++++++++++++++++++++++");
        String string = this.model == null ? null : this.model.getGameInfo().getMapSkin();
        String string2 = gameModel.getGameInfo().getMapSkin();
        if (string2 != null && !string2.equals(string)) {
            try {
                object = new MapSkinParser(string2);
                MapSkin mapSkin = new MapSkin((MapSkinParser)object);
                gameModel.getMap().setSkin(mapSkin);
                this.view.setMapSkin(mapSkin);
            }
            catch (MuleException muleException) {
                throw new RuntimeException(muleException);
            }
            catch (SlickException slickException) {
                throw new RuntimeException(slickException);
            }
            catch (MuleFileNotFoundException muleFileNotFoundException) {
                throw new RuntimeException(muleFileNotFoundException.getMessage());
            }
        }
        this.model = gameModel;
        if (this.model.getGameInfo().isSingleDevelopment()) {
            this.phases.put(Phase.DEVELOPMENT, new DevelopmentPhaseSingle());
            this.phases.put(Phase.FAST_DEVELOPMENT, new FastDevelopmentPhase());
        } else {
            this.phases.put(Phase.DEVELOPMENT, new DevelopmentPhaseMulti());
        }
        this.userController.setModel(gameModel);
        object = gameModel.getMyUser();
        if (object != null && !((User)object).isAccepted()) {
            this.logger.severe("My user " + object.toString() + " is not accepted in the new model.");
        }
        if (this.isServer()) {
            this.getServerMessageHandler().set(gameModel);
        }
        gameModel.addObserver(this.view);
        this.view.setHUDEnabled(true);
        for (GameControllerListener gameControllerListener : this.listeners) {
            gameControllerListener.setGameModel(gameModel);
        }
        if (this.phase != null) {
            this.phase.set(null, null, null);
        }
        if (this.prevPhase != null) {
            this.prevPhase.set(null, null, null);
        }
        this.phaseTransition = null;
        this.prevPhase = null;
        this.phase = this.phases.get((Object)gameModel.getPhase());
        this.phase.set(gameModel, this, this.view);
        this.phase.begin();
        this.phase.beginTransitionComplete();
        this.beginNextPhase();
    }

    public void acceptPendingUsers() {
        block5: {
            block4: {
                if (!this.isServer()) break block4;
                ArrayList<Integer> arrayList = null;
                for (User serializable : this.model.getUsers()) {
                    if (serializable.isAccepted()) continue;
                    serializable.setAccepted(true);
                    if (arrayList == null) {
                        arrayList = new ArrayList<Integer>();
                    }
                    arrayList.add(serializable.getUserNumber());
                }
                if (arrayList == null) break block5;
                for (Integer n : arrayList) {
                    this.localServer.acceptClientJoin(n);
                }
                break block5;
            }
            for (User user : this.model.getUsers()) {
                if (user.isAccepted()) continue;
                user.setAccepted(true);
            }
        }
    }

    private void saveModel() {
        if (this.isServer() && this.frame != this.lastSavedModelFrame) {
            byte[] byArray = null;
            if (this.isServer()) {
                try {
                    byArray = this.modelSerializer.serializeModel(this.model);
                    this.modelSerializer.saveModelToFile(byArray);
                }
                catch (IOException iOException) {
                    this.logger.severe("Failed to save model file. " + iOException.getMessage());
                    iOException.printStackTrace();
                }
            }
            this.lastSavedModelFrame = this.frame;
        }
    }

    public boolean isServer() {
        return this.localServer != null;
    }

    public void kick(int n) {
        if (this.isServer() && this.client != null && this.client.isConnected()) {
            User user = this.model.getUser(n);
            if (user == null) {
                return;
            }
            if (this.model.isGameStarted() && this.model.getLocalUsers().contains(user)) {
                return;
            }
            if (user == this.model.getMyUser()) {
                return;
            }
            this.client.sendTCP(new TCPMessage.KickUserMessage(user.getUserNumber()));
        }
    }

    public MasterClient getMasterClient() {
        return this.masterClient;
    }

    public void addListener(GameControllerListener gameControllerListener) {
        this.listeners.add(gameControllerListener);
        gameControllerListener.setGameModel(this.model);
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public UserController getUserController() {
        return this.userController;
    }

    public ServerMessageHandler getServerMessageHandler() {
        return this.localServer.getMessageHandler();
    }

    public void close() {
        this.logger.info("-------- CLOSING GAME CONTROLLER ----------------------------------");
        User user = this.model.getMyUser();
        if (user != null) {
            if (this.isServer() && this.model.getGameInfo().getGameID() != 0L) {
                this.masterClient.sendUserLeft(user.getUserId(), user.getUserNumber());
            }
            if (this.model.isGameStarted()) {
                if (this.isServer()) {
                    this.sendChatLog();
                }
                this.masterClient.sendLog(this.model.getGameInfo().getGameID(), "normal", "log.txt");
            }
        }
        if (user != null && this.client != null && this.client.isConnected()) {
            try {
                user.send(this.client, new TCPMessage.UserLeftMessage());
                boolean bl = false;
                long l = System.currentTimeMillis();
                while (true) {
                    if (System.currentTimeMillis() - l > Properties.mule.maxGameCloseTime) {
                        this.logger.info("Game close time exceeded.");
                        break;
                    }
                    this.client.sendMessages();
                    if (this.isServer()) {
                        this.localServer.receiveMessages();
                        this.localServer.sendMessages();
                    }
                    this.client.receiveMessages();
                    while (this.client.hasNextMessage()) {
                        TCPMessage.UserLeftMessage userLeftMessage;
                        Message message = this.client.nextMessage();
                        if (!(message instanceof TCPMessage.UserLeftMessage) || (userLeftMessage = (TCPMessage.UserLeftMessage)message).getUserNumber() != user.getUserNumber()) continue;
                        this.logger.info("Got my UserLeft (" + userLeftMessage.getUserNumber() + ") message.");
                        this.client.close();
                        bl = true;
                        if (!this.isServer()) continue;
                        this.localServer.removeAllClients();
                    }
                    if (bl && (!this.isServer() || this.localServer.numRemovedClients() == 0)) break;
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        this.logger.log(Level.SEVERE, interruptedException.toString(), interruptedException);
                    }
                }
                this.logger.info("Left server in " + (System.currentTimeMillis() - l) + " ms");
            }
            catch (IOException iOException) {
                this.logger.warning("Failed to send user left. " + iOException.toString());
            }
        }
        if (this.client != null) {
            this.client.close();
        }
        if (this.isServer()) {
            this.localServer.close();
        }
    }

    public void gameStarted() {
        for (GameControllerListener gameControllerListener : this.listeners) {
            gameControllerListener.gameStarted();
        }
    }

    public void gameEnded() {
        for (GameControllerListener gameControllerListener : this.listeners) {
            gameControllerListener.gameEnded();
        }
    }

    public void requestClose(String string, boolean bl) {
        this.closeRequested = true;
        this.closeString = string;
        this.logger.info("Close Requested: " + string);
        if (bl) {
            this.client.close();
        }
    }

    public boolean isCloseRequested() {
        return this.closeRequested;
    }

    public String getCloseString() {
        return this.closeString;
    }

    void userRemoved(User user) {
        if (this.phase != null) {
            this.phase.userRemoved(user);
        }
    }

    public void checkClientSynchronization() {
        this.synchonizationChecksum = this.model.getRandom().nextLong();
        this.logger.info("Sending synchonization checksum: " + this.synchonizationChecksum);
        this.model.getMyUser().sendToOthers(this.getClient(), new TCPMessage.SynchronizedCheckMessage(this.synchonizationChecksum));
    }

    public void apply(TCPMessage.SynchronizedCheckMessage synchronizedCheckMessage) {
        if (synchronizedCheckMessage.checksum != this.synchonizationChecksum) {
            User user = this.model.getUser(synchronizedCheckMessage.getUserNumber());
            this.logger.warning("Not synchronized with " + user + ", my checksum " + this.synchonizationChecksum + ", other checksum " + synchronizedCheckMessage.checksum);
            if (user != null && !this.synchonizationFailed) {
                this.sendSystemChatMessage("Warning: Game is not synchronized with %s", user);
            }
            this.synchonizationFailed = true;
        } else {
            this.logger.info("Client Synchronization OK");
        }
    }

    public void settingsChanged(Settings settings, Settings settings2) {
        if (settings.fastAiDevelopment != settings2.fastAiDevelopment && this.isServer()) {
            String string = settings2.fastAiDevelopment ? "Host set game to hide computer player development" : "Host set game to show computer player development";
            this.client.sendTCP(new TCPMessage.SystemChatMessage(string));
        }
    }
}

