/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.controller;

import com.turborilla.mule.Properties;
import com.turborilla.mule.controller.AbstractAuctionController;
import com.turborilla.mule.controller.PlayerController;
import com.turborilla.mule.model.Auction;
import com.turborilla.mule.model.AuctionLimits;
import com.turborilla.mule.model.AuctionState;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.util.NetworkTimer;
import com.turborilla.mule.network.UDPMessage;
import com.turborilla.mule.view.ActorSprite;
import com.turborilla.mule.view.GameInput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

public final class AuctionController
extends AbstractAuctionController {
    private static final Logger logger = Logger.getLogger("mule");
    private HashMap<Player, PlayerState> playerStateSequence = new HashMap();
    private int totalStateSequence;

    public AuctionController(Resource resource, boolean bl) {
        super(resource, bl);
    }

    public void onBegin() {
        this.totalStateSequence = 0;
        for (Player player : this.model.getPlayers()) {
            this.playerStateSequence.put(player, new PlayerState());
            player.setAuctionSpeed(Properties.mule.auctionSpeed);
        }
    }

    public void update(GameInput gameInput) {
        AuctionLimits auctionLimits = this.model.getAuction().getCurrentLimits();
        auctionLimits.auctionBuyTick = Integer.MIN_VALUE;
        auctionLimits.auctionSellTick = Integer.MAX_VALUE;
        boolean bl = false;
        block0: for (Player player : this.model.getRemotePlayers()) {
            if (player.getAuctionState().distance(player.getTargetAuctionState(), auctionLimits, this.resource) > 16) {
                player.setAuctionSpeed(Properties.mule.auctionSpeed + 1);
            }
            for (int i = 0; i < player.getAuctionSpeed(); ++i) {
                if (player.getAuctionState().moveTowards(player.getTargetAuctionState(), auctionLimits, this.resource, player)) {
                    player.getAuctionSprite().setIdle(false);
                    if (player.getAuctionState().isInAuction()) {
                        this.slowAuctionTimer();
                    }
                } else {
                    if (player.getTargetAuctionState().isWalking()) {
                        player.getAuctionSprite().setIdle(false);
                        bl = true;
                    } else {
                        player.getAuctionSprite().setIdle(true);
                    }
                    player.setAuctionSpeed(Properties.mule.auctionSpeed);
                    continue block0;
                }
                bl = true;
            }
        }
        this.calcCurrentLimitsRemote();
        for (Player player : this.model.getLocalPlayers()) {
            AuctionState auctionState = player.getAuctionState();
            auctionState.setTick(auctionState.getTick(), auctionLimits, this.resource, player);
        }
        this.calcCurrentLimits();
        for (Player player : this.model.getLocalPlayers()) {
            if (this.model.getPhaseTimer().isStarted() && !player.isFinishedAuction()) {
                int n = player.getAuctionState().getTick();
                PlayerController playerController = player.getController();
                for (int i = 0; i < player.getAuctionSpeed(); ++i) {
                    if (playerController.isUp() && !playerController.isDown()) {
                        this.move(player, ActorSprite.Direction.North);
                        bl = true;
                        continue;
                    }
                    if (playerController.isDown() && !playerController.isUp()) {
                        this.move(player, ActorSprite.Direction.South);
                        bl = true;
                        continue;
                    }
                    this.move(player, ActorSprite.Direction.None);
                    break;
                }
                if (n == player.getAuctionState().getTick()) continue;
                if (player.getAuctionState().isInAuction()) {
                    this.slowAuctionTimer();
                }
                this.calcCurrentLimits();
                continue;
            }
            this.move(player, ActorSprite.Direction.None);
        }
        if (bl) {
            this.sound.loopStepsAuction();
        } else {
            this.sound.stopStepsAuction();
        }
        if (this.controller.isServer()) {
            this.calcTargetLimits();
            this.sendTotalAuctionState();
        } else if (!this.model.getMyUser().isSpectator()) {
            this.sendPlayerAuctionStates();
        }
        NetworkTimer networkTimer = this.model.getPhaseTimer();
        if (!this.landAuction && !this.model.getPhaseTimer().isPaused() && System.currentTimeMillis() >= this.auctionIncreaseSpeedTime) {
            this.model.getPhaseTimer().setSpeed(1.0f);
        }
    }

    private void move(Player player, ActorSprite.Direction direction) {
        AuctionLimits auctionLimits = this.model.getAuction().getCurrentLimits();
        AuctionState auctionState = player.getAuctionState();
        if (direction == ActorSprite.Direction.North) {
            player.getAuctionSprite().setIdle(false);
            auctionState.setTick(auctionState.getTick() + 1, auctionLimits, this.resource, player);
        } else if (direction == ActorSprite.Direction.South) {
            player.getAuctionSprite().setIdle(false);
            auctionState.setTick(auctionState.getTick() - 1, auctionLimits, this.resource, player);
        } else {
            player.getAuctionSprite().setIdle(true);
            auctionState.setTick(auctionState.getTick(), auctionLimits, this.resource, player);
        }
        player.getTargetAuctionState().setState(auctionState.isInAuction(), auctionState.getTick());
    }

    public void sendTotalAuctionState() {
        if (this.controller.getFrame() - this.lastSendAuctionStateFrame < (long)Properties.mule.sendAuctionStateInterval) {
            return;
        }
        boolean bl = true;
        ArrayList<UDPMessage.TotalAuctionStateMessage.PlayerAuctionState> arrayList = new ArrayList<UDPMessage.TotalAuctionStateMessage.PlayerAuctionState>(4);
        for (Player player : this.model.getPlayers()) {
            AuctionState auctionState = player.getTargetAuctionState();
            arrayList.add(new UDPMessage.TotalAuctionStateMessage.PlayerAuctionState(player.getUserNumber(), auctionState.getTick(), auctionState.isInAuction(), player.getAvatar().isWalking()));
            bl = bl && player.isFinishedAuction();
        }
        ++this.totalStateSequence;
        UDPMessage.TotalAuctionStateMessage totalAuctionStateMessage = new UDPMessage.TotalAuctionStateMessage(this.auctionId, this.totalStateSequence, arrayList, bl);
        this.model.getMyPlayer().sendToOthers(this.controller.getClient(), totalAuctionStateMessage);
        this.lastSendAuctionStateFrame = this.controller.getFrame();
    }

    public void apply(UDPMessage.TotalAuctionStateMessage totalAuctionStateMessage) {
        if (totalAuctionStateMessage.sequenceNumber <= this.totalStateSequence) {
            return;
        }
        if (totalAuctionStateMessage.auctionId < this.auctionId) {
            logger.warning("Throwing away total state for old auction");
            return;
        }
        this.totalStateSequence = totalAuctionStateMessage.sequenceNumber;
        for (UDPMessage.TotalAuctionStateMessage.PlayerAuctionState object : totalAuctionStateMessage.playerStates) {
            Player player = this.model.getPlayer(object.userNumber);
            if (player == null) {
                logger.severe("No player with user number " + object.userNumber);
                return;
            }
            AuctionState auctionState = player.getTargetAuctionState();
            auctionState.setState(object.inAuction, object.tick);
            auctionState.setWalking(object.isWalking);
        }
        if (totalAuctionStateMessage.allPlayersFinished) {
            for (Player player : this.model.getPlayers()) {
                player.setFinishedAuction(true);
            }
        }
    }

    public void requestSendMyAuctionState() {
        this.lastSendAuctionStateFrame = 0L;
    }

    private void sendPlayerAuctionStates() {
        if (this.controller.getFrame() - this.lastSendAuctionStateFrame < (long)Properties.mule.sendAuctionStateInterval) {
            return;
        }
        for (Player player : this.model.getLocalPlayers()) {
            AuctionState auctionState = player.getAuctionState();
            PlayerState playerState = this.playerStateSequence.get(player);
            ++playerState.sequenceNumber;
            player.sendToServer(this.controller.getClient(), new UDPMessage.PlayerAuctionStateMessage(this.auctionId, playerState.sequenceNumber, this.transactionCount, player.getAuctionTeleportCount(), auctionState.getTick(), auctionState.isInAuction(), player.getAvatar().isWalking(), player.isFinishedAuction()));
        }
        this.lastSendAuctionStateFrame = this.controller.getFrame();
    }

    public void apply(UDPMessage.PlayerAuctionStateMessage playerAuctionStateMessage, AbstractAuctionController.TransactionCountCallback transactionCountCallback) {
        if (this.controller.isServer()) {
            Player player = this.model.getPlayer(playerAuctionStateMessage.getUserNumber());
            if (player == this.model.getMyPlayer()) {
                logger.warning("Skipping PlayerAuctionStateMessage for my own player");
                return;
            }
            PlayerState playerState = this.playerStateSequence.get(player);
            if (playerAuctionStateMessage.sequenceNumber <= playerState.sequenceNumber) {
                return;
            }
            if (playerAuctionStateMessage.auctionId < this.auctionId) {
                logger.warning("Throwing away player state for old auction");
                return;
            }
            playerState.sequenceNumber = playerAuctionStateMessage.sequenceNumber;
            if (playerAuctionStateMessage.teleportCount < player.getAuctionTeleportCount()) {
                return;
            }
            if (playerAuctionStateMessage.teleportCount > player.getAuctionTeleportCount()) {
                logger.warning("PlayerAuctionState user " + playerAuctionStateMessage.getUserNumber() + " has teleport count (" + playerAuctionStateMessage.teleportCount + ") bigger than expected (" + player.getAuctionTeleportCount() + ")");
            }
            if (player.getAuctionTransactionCount() != playerAuctionStateMessage.transactionCount) {
                player.setAuctionTransactionCount(playerAuctionStateMessage.transactionCount);
                transactionCountCallback.playerTransactionCount();
            }
            AuctionState auctionState = player.getTargetAuctionState();
            auctionState.setWalking(playerAuctionStateMessage.isWalking);
            if (auctionState.getTick() != playerAuctionStateMessage.tick || auctionState.isInAuction() != playerAuctionStateMessage.inAuction) {
                auctionState.setState(playerAuctionStateMessage.inAuction, playerAuctionStateMessage.tick, this.model.getAuction().getTargetLimits(), this.resource, player);
                this.calcTargetLimits();
            }
            if (playerAuctionStateMessage.isFinished) {
                player.setFinishedAuction(true);
            }
        }
    }

    private void calcTargetLimits() {
        Auction auction = this.model.getAuction();
        auction.getTargetLimits().calcBuyAndSellTicks(this.resource, this.model.getShop(), auction.getBuyers(), auction.getSellers(), true, true);
    }

    protected void onEnd() {
        this.playerStateSequence.clear();
    }

    private class PlayerState {
        public int sequenceNumber = 0;

        private PlayerState() {
        }
    }
}

