/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.controller;

import com.turborilla.mule.Properties;
import com.turborilla.mule.controller.GameController;
import com.turborilla.mule.model.Auction;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.util.NetworkTimer;
import com.turborilla.mule.network.UDPMessage;
import com.turborilla.mule.sound.SoundPlayer;
import com.turborilla.mule.view.GameInput;
import java.util.logging.Logger;
import org.newdawn.slick.util.Log;

public abstract class AbstractAuctionController {
    private static Logger logger = Logger.getLogger("mule");
    protected GameController controller;
    protected GameModel model;
    protected SoundPlayer sound;
    protected long auctionIncreaseSpeedTime;
    protected long lastSendAuctionStateFrame;
    protected Resource resource;
    protected boolean landAuction;
    protected byte auctionId;
    protected short transactionCount;

    public AbstractAuctionController(Resource resource, boolean bl) {
        this.resource = resource;
        this.landAuction = bl;
        this.lastSendAuctionStateFrame = 0L;
        this.auctionIncreaseSpeedTime = 0L;
        this.auctionId = 0;
    }

    public abstract void update(GameInput var1);

    public abstract void apply(UDPMessage.TotalAuctionStateMessage var1);

    public abstract void apply(UDPMessage.PlayerAuctionStateMessage var1, TransactionCountCallback var2);

    public final void begin(GameModel gameModel, GameController gameController, SoundPlayer soundPlayer, int n, int n2) {
        if (this.controller != null || this.model != null || this.sound != null) {
            logger.warning("Auction controller was not ended before started again.");
        }
        this.controller = gameController;
        this.model = gameModel;
        this.sound = soundPlayer;
        if (this.landAuction) {
            gameModel.getAuction().beginLandAuction(gameModel, n, n2);
        } else {
            gameModel.getAuction().beginAuction(this.resource, n, n2);
        }
        this.auctionId = (byte)(this.auctionId + 1);
        this.transactionCount = 0;
        logger.info("Begin auction id " + this.auctionId);
        for (Player player : gameModel.getPlayers()) {
            player.getAuctionSprite().setAlwaysIdleSouth(false);
            player.getAuctionSprite().setIdle(true);
            player.setFinishedAuction(false);
            player.setAuctionTransactionCount(this.transactionCount);
        }
        gameModel.getCountdown().reset();
        gameModel.getPhaseTimer().reset();
        this.onBegin();
    }

    protected abstract void onBegin();

    public void startAuction(float f) {
        this.model.getAuction().setBuyersAndSellers(this.model);
        this.calcCurrentLimits();
        this.model.getPhaseTimer().reset();
        this.model.getPhaseTimer().start(f, this.controller.getClient());
        if (this.landAuction) {
            this.model.getPhaseTimer().setSpeed(Properties.mule.landAuctionTimerFastSpeed);
        }
        this.auctionIncreaseSpeedTime = System.currentTimeMillis() + Properties.mule.auctionTimeSpeedUpDelay;
    }

    public void transaction() {
        this.transactionCount = (short)(this.transactionCount + 1);
        Log.info("Transaction #" + this.transactionCount);
    }

    public short getTransaction() {
        return this.transactionCount;
    }

    protected void calcCurrentLimitsRemote() {
        Auction auction = this.model.getAuction();
        auction.getCurrentLimits().calcBuyAndSellTicks(this.resource, this.model.getShop(), auction.getRemoteBuyers(), auction.getRemoteSellers(), false, false);
    }

    public void calcCurrentLimits() {
        Auction auction = this.model.getAuction();
        auction.getCurrentLimits().calcBuyAndSellTicks(this.resource, this.model.getShop(), auction.getBuyers(), auction.getSellers(), false, true);
    }

    protected void slowAuctionTimer() {
        NetworkTimer networkTimer = this.model.getPhaseTimer();
        if (this.landAuction) {
            networkTimer.setSpeed(1.0f);
        } else {
            networkTimer.setSpeed(Properties.mule.auctionTimerSlowSpeed);
            this.auctionIncreaseSpeedTime = System.currentTimeMillis() + Properties.mule.auctionTimeSpeedUpDelay;
        }
    }

    public void requestSendMyAuctionState() {
    }

    public final Resource getResource() {
        return this.resource;
    }

    public void auctionFinished() {
        for (Player player : this.model.getPlayers()) {
            player.getAvatar().stopWalking();
        }
        this.sound.stopStepsAuction();
    }

    public final void end() {
        this.onEnd();
        this.controller = null;
        this.model = null;
        this.sound = null;
    }

    protected abstract void onEnd();

    public abstract void sendTotalAuctionState();

    public static interface TransactionCountCallback {
        public void playerTransactionCount();
    }
}

