/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai.simulator;

import com.turborilla.mule.ai.simulator.SimulatedPlayer;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.map.Factory;
import com.turborilla.mule.model.map.PlanetTile;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SimulatedTile {
    public static final int NO_OWNER = -1;
    public PlanetTile tile;
    public int owner;
    public Resource factoryResource;
    public int adjacencyBonus;

    SimulatedTile() {
    }

    public void initialize(PlanetTile planetTile) {
        this.tile = planetTile;
        this.owner = -1;
        Factory factory = planetTile.getFactory();
        this.factoryResource = factory != null ? factory.getResource() : null;
    }

    public void copy(SimulatedTile simulatedTile) {
        this.tile = simulatedTile.tile;
        this.owner = simulatedTile.owner;
        this.factoryResource = simulatedTile.factoryResource;
        this.adjacencyBonus = simulatedTile.adjacencyBonus;
    }

    public void produce(ArrayList<SimulatedPlayer> arrayList) {
        if (this.owner != -1 && this.factoryResource != null) {
            SimulatedPlayer simulatedPlayer = arrayList.get(this.owner);
            int n = this.tile.getYieldPotential(this.factoryResource);
            n += simulatedPlayer.numFactories(this.factoryResource) / 3;
            n += this.adjacencyBonus;
            switch (this.factoryResource) {
                case Food: {
                    simulatedPlayer.food += n;
                    break;
                }
                case Energy: {
                    simulatedPlayer.energy += n;
                    break;
                }
                case Smithore: {
                    simulatedPlayer.smithore += n;
                    break;
                }
                case Crystite: {
                    simulatedPlayer.crystite += n;
                }
            }
        }
    }

    public int distance(PlanetTile planetTile) {
        return Math.abs(this.tile.getPosX() - planetTile.getPosX()) + Math.abs(this.tile.getPosY() - planetTile.getPosY());
    }
}

