/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai.simulator;

import com.turborilla.mule.Properties;
import com.turborilla.mule.ai.simulator.SimulatedPlayer;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.ResourcePrices;
import com.turborilla.mule.model.Shop;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SimulatedShop {
    public int food;
    public int energy;
    public int smithore;
    public int crystite;
    public ResourcePrices foodPrices = new ResourcePrices();
    public ResourcePrices energyPrices = new ResourcePrices();
    public ResourcePrices smithorePrices = new ResourcePrices();
    public ResourcePrices crystitePrices = new ResourcePrices();
    public int numMules;
    public int mulePrice;

    SimulatedShop() {
    }

    public void initialize(Shop shop) {
        this.numMules = shop.numMules();
        this.mulePrice = shop.getMuleCost();
        this.foodPrices.price = shop.getPrice(Resource.Food);
        this.energyPrices.price = shop.getPrice(Resource.Energy);
        this.smithorePrices.price = shop.getPrice(Resource.Smithore);
        this.crystitePrices.price = shop.getPrice(Resource.Crystite);
        this.foodPrices.sellPrice = shop.getSellPrice(Resource.Food);
        this.energyPrices.sellPrice = shop.getSellPrice(Resource.Energy);
        this.smithorePrices.sellPrice = shop.getSellPrice(Resource.Smithore);
        this.crystitePrices.sellPrice = shop.getSellPrice(Resource.Crystite);
        this.foodPrices.buyPrice = shop.getBuyPrice(Resource.Food);
        this.energyPrices.buyPrice = shop.getBuyPrice(Resource.Energy);
        this.smithorePrices.buyPrice = shop.getBuyPrice(Resource.Smithore);
        this.crystitePrices.buyPrice = shop.getBuyPrice(Resource.Crystite);
        this.food = shop.getFood();
        this.energy = shop.getEnergy();
        this.smithore = shop.getSmithore();
        this.crystite = shop.getCrystite();
    }

    public void copy(SimulatedShop simulatedShop) {
        this.numMules = simulatedShop.numMules;
        this.mulePrice = simulatedShop.mulePrice;
        this.foodPrices.copy(simulatedShop.foodPrices);
        this.energyPrices.copy(simulatedShop.energyPrices);
        this.smithorePrices.copy(simulatedShop.smithorePrices);
        this.crystitePrices.copy(simulatedShop.crystitePrices);
        this.food = simulatedShop.food;
        this.energy = simulatedShop.energy;
        this.smithore = simulatedShop.smithore;
        this.crystite = simulatedShop.crystite;
    }

    public void estimateCrystitePrice() {
        this.crystitePrices.calcCrystitePrice(Properties.mule.shopCrystitePriceDeviance / 2);
    }

    public void estimateSmithorePrice(int n) {
        int n2 = n;
        int n3 = this.numMules + this.smithore / 2;
        this.smithorePrices.calcSmithorePrice(n3, n2, 0);
    }

    public void estimateFoodPrice(ArrayList<SimulatedPlayer> arrayList, int n) {
        int n2 = arrayList.size() * Properties.mule.foodRequirements[n + 1];
        int n3 = this.food;
        for (SimulatedPlayer simulatedPlayer : arrayList) {
            n3 += simulatedPlayer.food;
        }
        this.foodPrices.calcFoodPrice(n3, n2);
    }

    public void estimateEnergyPrice(ArrayList<SimulatedPlayer> arrayList, int n) {
        int n2 = this.energy;
        int n3 = 0;
        for (SimulatedPlayer simulatedPlayer : arrayList) {
            n2 += simulatedPlayer.energy;
            n3 += simulatedPlayer.energyRequirement + 1;
        }
        this.energyPrices.calcEnergyPrice(n2, n3);
    }

    public void buildMules() {
        int n = 2;
        int n2 = Properties.mule.shopStartNumMules - this.numMules;
        int n3 = (n2 = Math.min(n2, Properties.mule.shopMaxBuildMules)) * n;
        if (n3 > this.smithore) {
            n3 = this.smithore - this.smithore % n;
        }
        this.smithore -= n3;
        int n4 = n3 / 2;
        this.numMules += n4;
        this.mulePrice = this.smithorePrices.price * 2;
        this.mulePrice -= this.mulePrice % 10;
    }
}

