/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai.simulator;

import com.turborilla.mule.ai.simulator.DevelopmentPlan;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.map.PlanetTile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public final class DevelopmentPlanList {
    private ArrayList<DevelopmentPlan> plans;
    private int numPlans;
    private final PointComparator pointComparator;

    public DevelopmentPlanList() {
        this(0, new PointComparator());
    }

    DevelopmentPlanList(int n, PointComparator pointComparator) {
        this.plans = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            DevelopmentPlan developmentPlan = new DevelopmentPlan();
            developmentPlan.initialize();
            this.plans.add(developmentPlan);
        }
        this.numPlans = 0;
        this.pointComparator = pointComparator;
    }

    boolean insert(DevelopmentPlan developmentPlan) {
        int n = -1;
        int n2 = this.numPlans - 1;
        while (n2 >= 0) {
            int n3 = this.pointComparator.compare(developmentPlan, this.plans.get(n2));
            if (n3 >= 0) {
                if (n3 != 0) break;
                n = n2;
                break;
            }
            n = n2--;
        }
        if (n == -1) {
            if (this.numPlans < this.plans.size()) {
                this.plans.get(this.numPlans).copy(developmentPlan);
                ++this.numPlans;
                return true;
            }
            return false;
        }
        for (n2 = this.numPlans - 1; n2 > n; --n2) {
            this.plans.get(n2).copy(this.plans.get(n2 - 1));
        }
        this.plans.get(n).copy(developmentPlan);
        return true;
    }

    public void sortByDistanceTo(int n, int n2) {
        this.pointComparator.startX = n;
        this.pointComparator.startY = n2;
        Collections.sort(this.plans, this.pointComparator);
    }

    public int numPlans() {
        return this.numPlans;
    }

    public DevelopmentPlan getPlan(int n) {
        return this.plans.get(n);
    }

    public boolean isEmpty() {
        return this.numPlans == 0;
    }

    public int indexOf(DevelopmentPlan developmentPlan) {
        for (int i = 0; i < this.numPlans; ++i) {
            if (this.plans.get(i) != developmentPlan) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        this.numPlans = 0;
    }

    public int getStartX() {
        return this.pointComparator.startX;
    }

    public int getStartY() {
        return this.pointComparator.startY;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PointComparator
    implements Comparator<DevelopmentPlan> {
        int startX;
        int startY;
        int[] resourceWeights = new int[Resource.values().length];

        public PointComparator() {
            this.setStart(0, 0);
            this.resourceWeights = new int[Resource.values().length];
            this.clearResourceWeights();
        }

        public void setStart(int n, int n2) {
            this.startX = n;
            this.startY = n2;
        }

        public void setResourceWeight(Resource resource, int n) {
            if (resource != null) {
                this.resourceWeights[resource.ordinal()] = n;
            }
        }

        public void clearResourceWeights() {
            for (int i = 0; i < this.resourceWeights.length; ++i) {
                this.resourceWeights[i] = 0;
            }
        }

        @Override
        public int compare(DevelopmentPlan developmentPlan, DevelopmentPlan developmentPlan2) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5 = 0;
            int n6 = 0;
            Resource resource = developmentPlan.getClaimResource();
            Resource resource2 = developmentPlan2.getClaimResource();
            if (resource != null) {
                n5 += this.resourceWeights[resource.ordinal()];
            }
            if (resource2 != null) {
                n6 += this.resourceWeights[resource2.ordinal()];
            }
            if ((n4 = developmentPlan.getResultingPoints() + n5) > (n3 = developmentPlan2.getResultingPoints() + n6)) {
                return -1;
            }
            if (n4 < n3) {
                return 1;
            }
            n4 = developmentPlan.points + n5;
            n3 = developmentPlan2.points + n6;
            if (n4 > n3) {
                return -1;
            }
            if (n4 < n3) {
                return 1;
            }
            PlanetTile planetTile = developmentPlan.getClaimedTile();
            PlanetTile planetTile2 = developmentPlan2.getClaimedTile();
            int n7 = planetTile == null || resource == null ? 0 : planetTile.getYieldPotential(resource);
            int n8 = n2 = planetTile2 == null || resource2 == null ? 0 : planetTile2.getYieldPotential(resource2);
            if (n7 > n2) {
                return -1;
            }
            if (n7 < n2) {
                return 1;
            }
            int n9 = planetTile == null ? Integer.MAX_VALUE : PointComparator.distance(this.startX, this.startY, planetTile.getPosX(), planetTile.getPosY());
            int n10 = n = planetTile2 == null ? Integer.MAX_VALUE : PointComparator.distance(this.startX, this.startY, planetTile2.getPosX(), planetTile2.getPosY());
            if (n9 < n) {
                return -1;
            }
            if (n9 > n) {
                return 1;
            }
            return 0;
        }

        private static int distance(int n, int n2, int n3, int n4) {
            return Math.abs(n3 - n) + Math.abs(n4 - n2);
        }
    }
}

