/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai.search;

import com.turborilla.mule.Properties;
import com.turborilla.mule.ai.CrystiteDeduction;
import com.turborilla.mule.ai.simulator.DevelopmentPlan;
import com.turborilla.mule.ai.simulator.DevelopmentPlanFinder;
import com.turborilla.mule.ai.simulator.DevelopmentPlanList;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.map.PlanetMap;
import java.util.Random;
import java.util.logging.Logger;

public final class PlanManager {
    private static Logger logger = Logger.getLogger("mule");
    private Player myPlayer;
    private Random random;
    private boolean searching;
    private DevelopmentPlanFinder planFinder;
    private int currentPlan;
    private CrystiteDeduction crystiteDeduction;

    public PlanManager(Player player, PlanetMap planetMap, CrystiteDeduction crystiteDeduction, int n, Random random) {
        this.planFinder = new DevelopmentPlanFinder(planetMap, n);
        this.myPlayer = player;
        this.random = random;
        this.searching = false;
        this.crystiteDeduction = crystiteDeduction;
    }

    public void startPlanSearch(GameModel gameModel, boolean bl) {
        this.planFinder.clearResourceWeights();
        if (bl && this.myPlayer.getOwnedTiles().isEmpty()) {
            Resource resource = null;
            float f = this.random.nextFloat();
            resource = f < 0.4f ? Resource.Food : (f < 0.75f ? Resource.Energy : Resource.Smithore);
            Properties.mule.getClass();
            this.planFinder.setResourceWeight(resource, 300);
            logger.info("AI: " + this.myPlayer.getName() + " prefers " + (Object)((Object)resource));
        }
        this.planFinder.startSearch(gameModel, this.myPlayer, this.crystiteDeduction);
        this.searching = true;
        this.currentPlan = 0;
    }

    public void clearPlans() {
        this.planFinder.clearPlans();
        this.currentPlan = 0;
    }

    public void setNumPlans(int n) {
        if (n < Properties.mule.debugPrintPlans) {
            n = Properties.mule.debugPrintPlans;
        }
        this.planFinder.setNumPlans(n);
    }

    public boolean isSearching() {
        return this.searching;
    }

    public boolean finishSearch(GameModel gameModel) {
        if (this.searching && this.planFinder.isSearchFinished()) {
            this.planFinder.logPlans(gameModel, this.myPlayer, this.planFinder.getPlans(), this.planFinder.getPlans().numPlans());
            this.searching = false;
            return true;
        }
        return false;
    }

    public DevelopmentPlanList getPlans() {
        return this.planFinder.getPlans();
    }

    public boolean hasCurrentPlan() {
        DevelopmentPlanList developmentPlanList = this.planFinder.getPlans();
        return developmentPlanList != null && this.currentPlan < developmentPlanList.numPlans();
    }

    public DevelopmentPlan getCurrentPlan() {
        return this.planFinder.getPlans().getPlan(this.currentPlan);
    }

    public void nextPlan() {
        ++this.currentPlan;
    }
}

