/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai.search;

import com.turborilla.mule.Properties;
import com.turborilla.mule.ai.AISystem;
import com.turborilla.mule.ai.AbstractAI;
import com.turborilla.mule.ai.search.PlanManager;
import com.turborilla.mule.ai.search.SearchAI;
import com.turborilla.mule.controller.PlayerControllerState;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.LandGrant;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.map.PlanetTile;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Logger;

public class LandGrantActuator {
    private static Logger logger = Logger.getLogger("mule");
    private Player myPlayer;
    private PlayerControllerState buttonState;
    private PlanManager planManager;
    private PlanetTile claimTile;
    private AISystem aiSystem;
    private int plannedRound;
    private boolean panic;
    private int reactionTime;
    private Random random;

    public LandGrantActuator(PlanManager planManager, PlayerControllerState playerControllerState, Player player, AISystem aISystem, Random random) {
        this.buttonState = playerControllerState;
        this.planManager = planManager;
        this.myPlayer = player;
        this.plannedRound = -1;
        this.aiSystem = aISystem;
        this.reactionTime = 0;
        this.random = random;
    }

    public void begin(GameModel gameModel) {
        this.panic = false;
        this.claimTile = null;
        this.reactionTime = 0;
        this.planManager.clearPlans();
        this.planManager.setNumPlans(gameModel.getPlayers().size());
        this.plannedRound = -1;
        Properties.mule.getClass();
        if (gameModel.getLandGrant().numFreeTiles() < gameModel.getPlayers().size()) {
            logger.info("AI: " + this.myPlayer.getName() + " Not enough tiles, grab any tile.");
            this.panic = true;
        } else {
            this.planManager.startPlanSearch(gameModel, true);
        }
    }

    public void update(GameModel gameModel, long l) {
        if (this.planManager.isSearching()) {
            if (this.planManager.finishSearch(gameModel) && this.planManager.hasCurrentPlan()) {
                this.claimTile = this.planManager.getCurrentPlan().getClaimedTile();
                logger.info("AI: " + this.myPlayer.getName() + " wants " + this.claimTile);
                this.plannedRound = gameModel.getRound();
                this.agreeOnClaims(gameModel);
            }
        } else {
            PlanetTile planetTile = gameModel.getLandGrant().getTile();
            if (planetTile == null) {
                return;
            }
            if (this.panic) {
                this.buttonState.setActionButtonDown(true);
            } else if (planetTile == this.claimTile) {
                if (this.reactionTime > 0) {
                    --this.reactionTime;
                } else {
                    this.buttonState.setActionButtonDown(true);
                }
            }
        }
    }

    public void landClaimed(PlanetTile planetTile, GameModel gameModel) {
        if (planetTile.getOwner() == this.myPlayer) {
            this.panic = false;
            this.claimTile = null;
            return;
        }
        if (planetTile == this.claimTile) {
            this.pickNextTile(gameModel);
        }
        this.setReactionTime(gameModel);
    }

    private void pickNextTile(GameModel gameModel) {
        boolean bl = false;
        block0: while (!bl) {
            this.planManager.nextPlan();
            LandGrant landGrant = gameModel.getLandGrant();
            if (!this.planManager.hasCurrentPlan()) {
                logger.info("AI: " + this.myPlayer.getName() + " panics in land grant!");
                this.panic = true;
                bl = true;
                break;
            }
            int n = landGrant.getTileIndex() + 1;
            int n2 = landGrant.numFreeTiles();
            for (int i = n; i < n2; ++i) {
                PlanetTile planetTile = landGrant.getFreeTile(i);
                if (planetTile != this.planManager.getCurrentPlan().getClaimedTile()) continue;
                logger.info("AI: " + this.myPlayer.getName() + " can't claim " + this.claimTile + " and wants " + planetTile + " instead");
                this.claimTile = planetTile;
                bl = true;
                continue block0;
            }
        }
    }

    private void setReactionTime(GameModel gameModel) {
        this.reactionTime = this.panic || this.claimTile == gameModel.getLandGrant().getNextTile() ? 0 : this.random.nextInt(4);
    }

    private void agreeOnClaims(GameModel gameModel) {
        Object object;
        ArrayList<LandGrantActuator> arrayList = new ArrayList<LandGrantActuator>();
        ArrayList<AbstractAI> arrayList2 = this.aiSystem.getAIs();
        for (AbstractAI object2 : arrayList2) {
            if (!(object2 instanceof SearchAI)) continue;
            object = (SearchAI)object2;
            arrayList.add(((SearchAI)object).landGrantActuator);
        }
        for (LandGrantActuator landGrantActuator : arrayList) {
            if (landGrantActuator.plannedRound == gameModel.getRound()) continue;
            return;
        }
        logger.info("AI: Agrees on tiles to claim.");
        for (int i = 0; i < arrayList.size(); ++i) {
            for (int j = i + 1; j < arrayList.size(); ++j) {
                object = (LandGrantActuator)arrayList.get(i);
                LandGrantActuator landGrantActuator = (LandGrantActuator)arrayList.get(j);
                if (((LandGrantActuator)object).claimTile != landGrantActuator.claimTile) continue;
                if (((LandGrantActuator)object).myPlayer.getRank() < landGrantActuator.myPlayer.getRank()) {
                    logger.info("AI: " + ((LandGrantActuator)object).myPlayer.getName() + " must change tile to claim.");
                    super.pickNextTile(gameModel);
                    continue;
                }
                logger.info("AI: " + landGrantActuator.myPlayer.getName() + " must change tile to claim.");
                landGrantActuator.pickNextTile(gameModel);
            }
        }
        for (LandGrantActuator landGrantActuator : arrayList) {
            landGrantActuator.setReactionTime(gameModel);
        }
    }
}

