/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai.search;

import com.turborilla.mule.Properties;
import com.turborilla.mule.ai.ActionQueueListener;
import com.turborilla.mule.ai.CrystiteDeduction;
import com.turborilla.mule.ai.DevelopmentAction;
import com.turborilla.mule.ai.DevelopmentActionControl;
import com.turborilla.mule.ai.DevelopmentActionQueue2;
import com.turborilla.mule.ai.search.AssayChooser;
import com.turborilla.mule.ai.search.PlanManager;
import com.turborilla.mule.ai.simulator.DevelopmentPlan;
import com.turborilla.mule.controller.WampusMenu;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Mule;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.map.Factory;
import com.turborilla.mule.model.map.PlanetTile;
import com.turborilla.mule.model.util.Timer;
import java.util.Random;
import java.util.logging.Logger;

public class DevelopmentActuator
implements ActionQueueListener {
    private static Logger logger = Logger.getLogger("mule");
    private Player myPlayer;
    private Random random;
    private DevelopmentActionQueue2 actionQueue;
    private DevelopmentActionControl actionControl;
    private PlanManager planManager;
    private AssayChooser assayChooser;
    private CrystiteDeduction crystiteDeduction;
    private boolean hasInitialPlan;
    private float wampusProbability = 0.2f;

    public DevelopmentActuator(DevelopmentActionControl developmentActionControl, PlanManager planManager, CrystiteDeduction crystiteDeduction, Random random) {
        this.myPlayer = developmentActionControl.getMyPlayer();
        this.random = random;
        this.actionQueue = new DevelopmentActionQueue2(this.myPlayer);
        this.actionControl = developmentActionControl;
        this.planManager = planManager;
        this.assayChooser = new AssayChooser(crystiteDeduction, random);
        this.crystiteDeduction = crystiteDeduction;
        this.actionQueue.addListener(this);
    }

    public void begin(GameModel gameModel) {
        this.setNumPlans(gameModel);
        this.actionQueue.clearActions();
        this.hasInitialPlan = false;
        if (this.myPlayer.getDevelopmentTime() < Properties.mule.minDevelopmentTime + 0.5f) {
            logger.info("AI: " + this.myPlayer.getName() + " is short on development time and goes to the pub");
            this.actionQueue.addAction(new DevelopmentAction.GoToPub(this.actionControl));
        } else {
            this.planManager.startPlanSearch(gameModel, true);
        }
    }

    public boolean hasInitialPlan() {
        return this.hasInitialPlan;
    }

    public void enqueueBestPlan(GameModel gameModel) {
        boolean bl = gameModel.getGameInfo().isSingleDevelopment();
        if (this.planManager.hasCurrentPlan()) {
            DevelopmentPlan developmentPlan = this.planManager.getCurrentPlan();
            Mule mule = this.myPlayer.getAvatar().getMule();
            boolean bl2 = mule != null;
            Resource resource = null;
            if (bl2 && mule.getEquipment() != null) {
                resource = mule.getEquipment().getResource();
            }
            int n = gameModel.getShop().numMules();
            int n2 = gameModel.getPlayers().size();
            for (int i = 0; i < developmentPlan.numTiles(); ++i) {
                Resource resource2;
                PlanetTile planetTile = developmentPlan.getTile(i);
                if (!this.enqueueDevelopPlot(planetTile, resource2 = developmentPlan.getResource(i), bl2, resource, n, n2, bl)) continue;
                if (!bl2) {
                    --n;
                }
                bl2 = false;
            }
            logger.info("AI: " + this.myPlayer.getName() + " plans to develop " + developmentPlan.toString());
        }
        if (this.actionQueue.isEmpty()) {
            this.enqueueEndingActions(gameModel);
        }
    }

    private boolean enqueueDevelopPlot(PlanetTile planetTile, Resource resource, boolean bl, Resource resource2, int n, int n2, boolean bl2) {
        if (resource == null) {
            return false;
        }
        Factory factory = planetTile.getFactory();
        if (factory != null && factory.getResource() == resource) {
            return false;
        }
        if (!bl) {
            if (n == 0) {
                return false;
            }
            this.actionQueue.addAction(new DevelopmentAction.GoToMuleStore(this.actionControl));
            this.actionQueue.addAction(new DevelopmentAction.GoToOutfitStore(this.actionControl, resource));
        } else if (resource != resource2) {
            this.actionQueue.addAction(new DevelopmentAction.GoToOutfitStore(this.actionControl, resource));
        }
        this.actionQueue.addAction(new DevelopmentAction.PlaceMule(this.actionControl, planetTile, resource));
        return true;
    }

    public DevelopmentActionQueue2 getActionQueue() {
        return this.actionQueue;
    }

    public void finishSearch(GameModel gameModel) {
        if (this.planManager.finishSearch(gameModel)) {
            if (!this.hasInitialPlan) {
                this.hasInitialPlan = true;
                boolean bl = true;
                if (this.planManager.getCurrentPlan().getClaimResource() == Resource.Crystite) {
                    bl = false;
                }
                if (bl && this.assayChooser.testAssayFirst(gameModel, this.myPlayer) && this.enqueueAssay(gameModel)) {
                    this.planManager.getPlans().clear();
                } else {
                    this.enqueueBestPlan(gameModel);
                }
            } else {
                this.enqueueBestPlan(gameModel);
            }
        }
    }

    public void update(GameModel gameModel, long l) {
        if (this.planManager.isSearching()) {
            this.finishSearch(gameModel);
        } else {
            this.actionQueue.update(gameModel, l);
        }
    }

    public void landClaimed(PlanetTile planetTile, GameModel gameModel) {
        DevelopmentPlan developmentPlan;
        if (planetTile.getOwner() != this.myPlayer && this.planManager.hasCurrentPlan() && planetTile == (developmentPlan = this.planManager.getCurrentPlan()).getClaimedTile()) {
            logger.info("AI: " + this.myPlayer.getName() + " lost claim tile. Trying new plan.");
            this.actionQueue.clearActions();
            this.enqueueBestPlan(gameModel);
        }
    }

    public void wampusCaught(Player player, GameModel gameModel, WampusMenu wampusMenu) {
        this.actionQueue.catchWampus(player, wampusMenu);
    }

    public void assay(Player player, PlanetTile planetTile, GameModel gameModel) {
        this.crystiteDeduction.setKnown(planetTile.getPosX(), planetTile.getPosY(), planetTile.getCrystite());
        this.actionQueue.assay(player);
    }

    public void meteoriteStrike(PlanetTile planetTile) {
        this.crystiteDeduction.setKnown(planetTile.getPosX(), planetTile.getPosY(), 4);
    }

    public void mulesChanged(Player player, GameModel gameModel) {
        if (!gameModel.getGameInfo().isSingleDevelopment() && player != this.myPlayer && gameModel.getShop().numMules() == 0) {
            this.actionQueue.clearActions();
            this.enqueueBestPlan(gameModel);
        }
    }

    public void sortActionsByDistance(int n, int n2) {
        this.planManager.getPlans().sortByDistanceTo(n, n2);
    }

    private void enqueueEndingActions(GameModel gameModel) {
        float f = gameModel.getDevelopment().getTimeLeft();
        boolean bl = false;
        if (this.assayChooser.testAssayLast(gameModel, this.myPlayer)) {
            bl = this.enqueueAssay(gameModel);
        }
        if (!bl) {
            Properties.mule.getClass();
            if (!gameModel.getWampus().isDead() && f > 5.0f && this.random.nextFloat() < this.wampusProbability) {
                this.actionQueue.addAction(new DevelopmentAction.CatchWampus(this.actionControl));
            }
            this.actionQueue.addAction(new DevelopmentAction.GoToPub(this.actionControl));
        }
    }

    private boolean enqueueAssay(GameModel gameModel) {
        PlanetTile planetTile = this.assayChooser.chooseTile(gameModel.getMap(), this.myPlayer);
        if (planetTile == null) {
            return false;
        }
        Timer timer = gameModel.getDevelopment().getDevelopmentTimer();
        float f = timer.isStarted() ? timer.getTime() : this.myPlayer.getDevelopmentTime();
        logger.info("AI: " + this.myPlayer.toString() + " want's to assay " + planetTile.toString() + " with " + f + " time left.");
        this.actionQueue.addAction(new DevelopmentAction.GoToAssayStore(this.actionControl));
        this.actionQueue.addAction(new DevelopmentAction.Assay(this.actionControl, planetTile));
        return true;
    }

    public void actionComplete(GameModel gameModel, DevelopmentAction developmentAction) {
        float f;
        if (this.myPlayer.hasGambled()) {
            logger.info("AI: " + this.myPlayer.toString() + " gambled and can't do more actions.");
            this.actionQueue.clearActions();
        } else if (this.actionQueue.isEmpty()) {
            if (developmentAction instanceof DevelopmentAction.Assay && this.planManager.getPlans().isEmpty()) {
                logger.info("AI: " + this.myPlayer.toString() + " did assay and now needs a new plan.");
                this.actionQueue.clearActions();
                this.planManager.startPlanSearch(gameModel, false);
            } else {
                this.enqueueEndingActions(gameModel);
            }
        } else if (developmentAction instanceof DevelopmentAction.PlaceMule && (f = gameModel.getDevelopment().getTimeLeft()) < 11.0f) {
            logger.info("AI: " + this.myPlayer + " placed mule but is short on time: " + f);
            this.actionQueue.clearActions();
            this.enqueueEndingActions(gameModel);
        }
    }

    private void setNumPlans(GameModel gameModel) {
        if (gameModel.getGameInfo().isSingleDevelopment()) {
            this.planManager.setNumPlans(1);
        } else {
            int n = gameModel.getPlayers().size();
            for (Player player : gameModel.getPlayers()) {
                if (player.hasClaimedLand) continue;
                ++n;
            }
            n = Math.max(1, n);
            this.planManager.setNumPlans(n);
        }
    }
}

