/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai.search;

import com.turborilla.mule.Properties;
import com.turborilla.mule.ai.CrystiteDeduction;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetTile;
import java.util.ArrayList;
import java.util.Random;

public class AssayChooser {
    private CrystiteDeduction crystiteDeduction;
    private Random random;
    private float assayFirstProbability = 0.05f;
    private float assayLastProbability = 0.15f;

    public AssayChooser(CrystiteDeduction crystiteDeduction, Random random) {
        this.crystiteDeduction = crystiteDeduction;
        this.random = random;
    }

    public boolean testAssayFirst(GameModel gameModel, Player player) {
        float f = player.getDevelopmentTime();
        if (f < Properties.mule.maxDevelopmentTime * 0.5f) {
            return false;
        }
        if (this.random.nextFloat() > this.assayFirstProbability) {
            return false;
        }
        Properties.mule.getClass();
        return true;
    }

    public boolean testAssayLast(GameModel gameModel, Player player) {
        if (Properties.mule.debugAssayLast) {
            return true;
        }
        float f = gameModel.getDevelopment().getTimeLeft();
        if (gameModel.getGameInfo().isFastAiDevelopment() ? f < Properties.mule.maxDevelopmentTime * 0.6f : f < Properties.mule.maxDevelopmentTime * 0.25f) {
            return false;
        }
        if (this.random.nextFloat() > this.assayLastProbability) {
            return false;
        }
        Properties.mule.getClass();
        return true;
    }

    public PlanetTile chooseTile(PlanetMap planetMap, Player player) {
        int n;
        ArrayList<PlanetTile> arrayList = new ArrayList<PlanetTile>(15);
        ArrayList<PlanetTile> arrayList2 = new ArrayList<PlanetTile>(40);
        for (int i = 0; i < planetMap.getXSize(); ++i) {
            for (n = 0; n < planetMap.getYSize(); ++n) {
                PlanetTile planetTile = (PlanetTile)planetMap.getTile(i, n);
                if (this.crystiteDeduction.isKnown(planetTile) || planetTile.getType() == PlanetTile.PlanetTileType.Shop) continue;
                if (planetTile.getOwner() == null) {
                    arrayList2.add(planetTile);
                    continue;
                }
                if (planetTile.getOwner() != player || !planetTile.isEmpty()) continue;
                arrayList.add(planetTile);
            }
        }
        ArrayList<PlanetTile> arrayList3 = null;
        if (!arrayList.isEmpty()) {
            arrayList3 = arrayList;
        } else if (!arrayList2.isEmpty()) {
            arrayList3 = arrayList2;
        } else {
            return null;
        }
        n = this.random.nextInt(arrayList3.size());
        return (PlanetTile)arrayList3.get(n);
    }
}

