/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai.adam;

import com.turborilla.mule.MuleLP;
import com.turborilla.mule.MuleMath;
import com.turborilla.mule.Properties;
import com.turborilla.mule.ai.CrystiteDeduction;
import com.turborilla.mule.ai.adam.AdamAI;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetTile;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import lpsolve.LpSolveException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerLP
extends MuleLP {
    private static Logger logger = Logger.getLogger("mule");
    private AdamAI ai;
    private Player myPlayer;

    public PlayerLP(AdamAI adamAI) {
        this.ai = adamAI;
        this.myPlayer = adamAI.getMyPlayer();
    }

    protected void printBonuses() {
        int n;
        if (this.useEOS()) {
            for (PlanetTile planetTile : this.getTiles()) {
                Resource[] resourceArray = Resource.values();
                int n2 = resourceArray.length;
                for (n = 0; n < n2; ++n) {
                    Resource resource = resourceArray[n];
                    if (!this.Bvars[this.getEOSIndex(planetTile, resource) - 1]) continue;
                    logger.info("AI: " + this.myPlayer.getName() + " got an EOS bonus for " + (Object)((Object)resource) + " on plot " + planetTile);
                }
            }
        }
        if (this.useLCT()) {
            for (Resource resource : Resource.values()) {
                for (n = 0; n < this.numTiles() / 3; ++n) {
                    if (!this.Bvars[this.getLCTIndex(resource, n + 1) - 1]) continue;
                    logger.info("AI: " + this.myPlayer.getName() + " got an LCT (level " + (n + 1) + ") bonus on all of its " + resource.getName() + " tiles.");
                }
            }
        }
    }

    double getVal(double[] dArray) {
        return this.lp.getConstrValue(0, this.lp.getNcolumns(), dArray, IdentityMask);
    }

    private void makeObjectiveFunction(GameModel gameModel, CrystiteDeduction crystiteDeduction) throws LpSolveException {
        int n = this.ai.getPriceCalculator().getShopPrice(gameModel, Resource.Food);
        int n2 = this.ai.getPriceCalculator().getShopPrice(gameModel, Resource.Energy);
        int n3 = Math.max(this.ai.getPriceCalculator().getShopPrice(gameModel, Resource.Smithore), 10 * (15 - gameModel.getRound()));
        int n4 = 100;
        for (Resource resource : Resource.values()) {
            for (PlanetTile planetTile : this.getTiles()) {
                switch (resource) {
                    case Food: {
                        this.row[this.getColIndex((PlanetTile)planetTile, (Resource)resource) - 1] = planetTile.getYieldPotential(resource) * n;
                        if (!this.useEOS()) break;
                        this.row[this.getEOSIndex((PlanetTile)planetTile, (Resource)resource) - 1] = n;
                        break;
                    }
                    case Energy: {
                        this.row[this.getColIndex((PlanetTile)planetTile, (Resource)resource) - 1] = planetTile.getYieldPotential(resource) * n2;
                        if (!this.useEOS()) break;
                        this.row[this.getEOSIndex((PlanetTile)planetTile, (Resource)resource) - 1] = n2;
                        break;
                    }
                    case Smithore: {
                        this.row[this.getColIndex((PlanetTile)planetTile, (Resource)resource) - 1] = planetTile.getYieldPotential(resource) * n3;
                        if (!this.useEOS()) break;
                        this.row[this.getEOSIndex((PlanetTile)planetTile, (Resource)resource) - 1] = n3;
                        break;
                    }
                    case Crystite: {
                        this.row[this.getColIndex((PlanetTile)planetTile, (Resource)resource) - 1] = crystiteDeduction.getDeduction(planetTile) * n4;
                        if (!this.useEOS()) break;
                        this.row[this.getEOSIndex((PlanetTile)planetTile, (Resource)resource) - 1] = n4;
                    }
                }
            }
            if (!this.useLCT()) continue;
            block14: for (int i = 0; i < this.numTiles() / 3; ++i) {
                switch (resource) {
                    case Food: {
                        this.row[this.getLCTIndex((Resource)resource, (int)(i + 1)) - 1] = 3 * (i + 1) * (i + 1) * n;
                        continue block14;
                    }
                    case Energy: {
                        this.row[this.getLCTIndex((Resource)resource, (int)(i + 1)) - 1] = 3 * (i + 1) * (i + 1) * n2;
                        continue block14;
                    }
                    case Smithore: {
                        this.row[this.getLCTIndex((Resource)resource, (int)(i + 1)) - 1] = 3 * (i + 1) * (i + 1) * n3;
                        continue block14;
                    }
                    case Crystite: {
                        this.row[this.getLCTIndex((Resource)resource, (int)(i + 1)) - 1] = 3 * (i + 1) * (i + 1) * n4;
                    }
                }
            }
        }
        for (PlanetTile planetTile : this.getTiles()) {
            if (planetTile.isEmpty()) continue;
            int n5 = this.getColIndex(planetTile, planetTile.getFactory().getResource()) - 1;
            this.row[n5] = this.row[n5] + 1.0;
        }
        this.lp.setObjFnex(this.lp.getNcolumns(), this.row, IdentityMask);
        this.lp.setMaxim();
    }

    protected void makeFoodConstraintByRound(int n) throws LpSolveException {
        int n2 = (int)Math.max(0.0, Math.ceil(0.5 * (double)(this.myPlayer.getFood() - Properties.mule.foodRequirements[n])));
        super.makeResourceThresholdConstraint(Resource.Food, Properties.mule.foodRequirements[n + 1] - n2 - 1, null, true);
    }

    private void makeEnergyConstraint() throws LpSolveException {
        super.makeEnergyConstraint(this.myPlayer.getEnergy());
    }

    private void makeFutureEnergyConstraint() throws LpSolveException {
        super.makeFutureEnergyConstraint(-1 * (int)Math.max(0.0, Math.ceil(0.75 * (double)(this.myPlayer.getEnergy() - this.myPlayer.getEnergyRequirement()))));
    }

    private void makeMoneyConstraint(GameModel gameModel) throws LpSolveException {
        int n = this.myPlayer.getMoney();
        if (gameModel.getWampus().hasMountains()) {
            n += gameModel.getWampus().getMoneyReward();
        }
        super.makeMoneyConstraint(gameModel.getShop().getMuleCost(), n);
    }

    private int getOptimumLayoutValue(GameModel gameModel, CrystiteDeduction crystiteDeduction, Collection<PlanetTile> collection, boolean bl, boolean bl2) {
        if (!this.makeNewLP(collection, bl, bl2)) {
            return -1;
        }
        int n = -1;
        try {
            this.lp.setAddRowmode(true);
            super.makeFutureEnergyConstraint(0);
            super.makeResourceThresholdConstraint(Resource.Food, Properties.mule.foodRequirements[gameModel.getRound()], null, true);
            this.makeTileConstraints();
            this.makeRiverConstraints();
            this.lp.setAddRowmode(false);
            this.makeIP();
            this.makeObjectiveFunction(gameModel, crystiteDeduction);
            this.status = this.solveLP(0);
            n = (int)this.lp.getObjective();
            if (Properties.mule.debugLP) {
                this.lp.printLp();
                this.lp.printObjective();
                this.lp.printSolution(this.lp.getNorigColumns());
            }
        }
        catch (LpSolveException lpSolveException) {
            this.status = -1;
            System.err.println("Error in PlayerLP.getTileValues: " + lpSolveException.toString());
        }
        return n;
    }

    public int getTileValue(GameModel gameModel, CrystiteDeduction crystiteDeduction, PlanetTile planetTile, boolean bl, boolean bl2) {
        int n;
        int n2;
        Collection<PlanetTile> collection = this.myPlayer.getOwnedTiles();
        if (collection.contains(planetTile)) {
            collection.remove(planetTile);
            n2 = this.getOptimumLayoutValue(gameModel, crystiteDeduction, collection, bl, bl2);
            collection.add(planetTile);
            n = this.getOptimumLayoutValue(gameModel, crystiteDeduction, collection, bl, bl2);
        } else {
            collection.add(planetTile);
            n = this.getOptimumLayoutValue(gameModel, crystiteDeduction, collection, bl, bl2);
            collection.remove(planetTile);
            n2 = this.getOptimumLayoutValue(gameModel, crystiteDeduction, collection, bl, bl2);
        }
        if (this.status == 2) {
            return -1;
        }
        return Math.max(0, n - n2);
    }

    public boolean getLandGrantValues(GameModel gameModel, CrystiteDeduction crystiteDeduction, Map<PlanetTile, Integer> map) {
        int n;
        int n2;
        if (gameModel.getRound() < Properties.mule.startLP) {
            return false;
        }
        PlanetMap planetMap = gameModel.getMap();
        PlanetTile planetTile = planetMap.getShopTile();
        for (n2 = 0; n2 < planetMap.getYSize(); ++n2) {
            for (n = 0; n < planetMap.getXSize(); ++n) {
                PlanetTile planetTile2 = (PlanetTile)planetMap.getTile(n, n2);
                if (planetTile2.getOwner() != null || planetTile2 == planetTile) continue;
                this.myPlayer.getOwnedTiles().add(planetTile2);
                int n3 = MuleMath.tileDistance(planetTile2, planetTile);
                this.Dvars[n2 + planetMap.getYSize() * n] = this.getOptimumLayoutValue(gameModel, crystiteDeduction, this.myPlayer.getOwnedTiles(), true, false) - n3;
                this.myPlayer.getOwnedTiles().remove(planetTile2);
                if (this.status != 2) continue;
                return false;
            }
        }
        map.clear();
        for (n2 = 0; n2 < planetMap.getYSize(); ++n2) {
            for (n = 0; n < planetMap.getXSize(); ++n) {
                map.put((PlanetTile)planetMap.getTile(n, n2), (int)this.Dvars[n2 + planetMap.getYSize() * n]);
            }
        }
        return true;
    }

    public boolean makeDevelopmentPlan(GameModel gameModel, CrystiteDeduction crystiteDeduction, boolean bl, boolean bl2, Map<PlanetTile, Resource> map) {
        if (gameModel.getRound() < Properties.mule.startLP || !this.makeNewLP(this.myPlayer.getOwnedTiles(), bl, bl2)) {
            return false;
        }
        logger.info("AI: " + this.myPlayer.getName() + " started Development LP.");
        try {
            this.lp.setAddRowmode(true);
            if (this.myPlayer.getEnergy() > 0 && gameModel.getRound() != 12) {
                this.makeFoodConstraintByRound(gameModel.getRound() + 1);
            }
            this.makeEnergyConstraint();
            if (gameModel.getRound() != 12) {
                this.makeFutureEnergyConstraint();
            }
            this.makeMuleConstraint(gameModel.getShop().numMules());
            this.makeMoneyConstraint(gameModel);
            this.makeTimeConstraints(3, 5, 5);
            this.makeTileConstraints();
            this.makeRiverConstraints();
            this.lp.setAddRowmode(false);
            this.makeObjectiveFunction(gameModel, crystiteDeduction);
            this.makeIP();
            boolean bl3 = map.isEmpty();
            if (bl3) {
                for (PlanetTile planetTile : this.myPlayer.getOwnedTiles()) {
                    map.put(planetTile, PlanetTile.getResourceFromTile(planetTile));
                }
            }
            this.tryToFindFeasibleSolution(map);
            if (bl3) {
                map.clear();
            }
            this.status = this.solveLP(3);
            if (Properties.mule.debugLP) {
                this.lp.printLp();
                this.lp.printSolution(this.lp.getNorigColumns());
                this.printBonuses();
            }
            if (this.status != 0 && this.status != 1) {
                System.err.println("Status of LP is " + this.lp.getStatustext(this.status));
                return false;
            }
            logger.info("AI: " + this.myPlayer.getName() + " finished Development LP in time " + (int)(this.lp.timeElapsed() * 1000.0) + "ms");
            logger.info("\tOptimal Value: " + this.lp.getObjective());
            this.getSolutionVector(this.numVariables());
            map.clear();
            for (PlanetTile planetTile : this.getTiles()) {
                for (Resource resource : Resource.values()) {
                    if (!this.Bvars[this.getColIndex(planetTile, resource) - 1]) continue;
                    map.put(planetTile, resource);
                }
            }
        }
        catch (LpSolveException lpSolveException) {
            this.status = -1;
            System.err.println("LP Error" + lpSolveException.toString());
        }
        return true;
    }

    private void tryToFindFeasibleSolution(Map<PlanetTile, Resource> map) throws LpSolveException {
        int n = this.lp.getNcolumns();
        double[] dArray = this.getVectorFromMap(this.myPlayer.getOwnedTiles(), map);
        if (this.isFeasible(dArray)) {
            double d = this.lp.getConstrValue(0, n, dArray, IdentityMask);
            this.lp.setObjBound(d);
            logger.info("AI: " + this.myPlayer.getName() + " got lower bound of " + d + " from previous solution.");
            return;
        }
        boolean bl = this.lp.getConstrValue(1, n, dArray, IdentityMask) <= this.lp.getRh(1);
        boolean bl2 = this.lp.getConstrValue(2, n, dArray, IdentityMask) <= this.lp.getRh(2);
        boolean bl3 = this.lp.getConstrValue(3, n, dArray, IdentityMask) <= this.lp.getRh(3);
        for (PlanetTile planetTile : this.myPlayer.getOwnedTiles()) {
            if (!planetTile.isEmpty()) continue;
            if (bl) {
                dArray[this.getColIndex((PlanetTile)planetTile, (Resource)Resource.Food) - 1] = 1.0;
                bl = this.lp.getConstrValue(1, n, dArray, IdentityMask) <= this.lp.getRh(1);
                continue;
            }
            if (!bl3) continue;
            dArray[this.getColIndex((PlanetTile)planetTile, (Resource)Resource.Energy) - 1] = 1.0;
            bl3 = this.lp.getConstrValue(3, n, dArray, IdentityMask) <= this.lp.getRh(3);
        }
        if (this.isFeasible(dArray)) {
            double d = this.lp.getConstrValue(0, n, dArray, IdentityMask);
            this.lp.setObjBound(d);
            logger.info("AI: " + this.myPlayer.getName() + " got lower bound of " + d + " from previous solution, plus 1 round of fudging.");
            return;
        }
        for (PlanetTile planetTile : this.myPlayer.getOwnedTiles()) {
            Resource resource = null;
            for (Resource resource2 : Resource.values()) {
                if (!(dArray[this.getColIndex(planetTile, resource2)] > 0.0)) continue;
                resource = resource2;
            }
            if (resource != Resource.Smithore && resource != Resource.Crystite) continue;
            if (bl) {
                dArray[this.getColIndex((PlanetTile)planetTile, (Resource)Resource.Food) - 1] = 1.0;
                dArray[this.getColIndex((PlanetTile)planetTile, (Resource)resource) - 1] = 0.0;
                bl = this.lp.getConstrValue(1, n, dArray, IdentityMask) <= this.lp.getRh(1);
                continue;
            }
            if (!bl3 && !bl2) continue;
            dArray[this.getColIndex((PlanetTile)planetTile, (Resource)Resource.Energy) - 1] = 1.0;
            dArray[this.getColIndex((PlanetTile)planetTile, (Resource)resource) - 1] = 0.0;
            bl2 = this.lp.getConstrValue(2, n, dArray, IdentityMask) <= this.lp.getRh(2);
            bl3 = this.lp.getConstrValue(3, n, dArray, IdentityMask) <= this.lp.getRh(3);
        }
        if (this.isFeasible(dArray)) {
            double d = this.lp.getConstrValue(0, n, dArray, IdentityMask);
            this.lp.setObjBound(d);
            logger.info("AI: " + this.myPlayer.getName() + " got lower bound of " + d + " from previous solution, plus 2 rounds of fudging.");
            return;
        }
        logger.info("AI: " + this.myPlayer.getName() + " couldn't find a lower bound using the previous solution (even with fudging).");
    }
}

