/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai.adam;

import com.turborilla.mule.Properties;
import com.turborilla.mule.ai.AISystem;
import com.turborilla.mule.ai.AbstractAI;
import com.turborilla.mule.ai.adam.AdamAI;
import com.turborilla.mule.ai.adam.PlayerLP;
import com.turborilla.mule.ai.adam.SearchPlanManager;
import com.turborilla.mule.controller.PlayerControllerState;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.LandGrant;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.map.PlanetTile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public class LandGrantActuator {
    private static Logger logger = Logger.getLogger("mule");
    private AdamAI ai;
    private Player myPlayer;
    private PlayerControllerState buttonState;
    private SearchPlanManager planManager;
    private PlanetTile claimTile;
    private AISystem aiSystem;
    private int plannedRound;
    private boolean panic;
    private int reactionTime;
    LandGrantSort mySort;
    private boolean useTileOrder;
    private LinkedList<PlanetTile> tileOrder;
    private Map<PlanetTile, Integer> tileValues;

    public LandGrantActuator(AdamAI adamAI, SearchPlanManager searchPlanManager, PlayerControllerState playerControllerState, Player player, AISystem aISystem) {
        this.ai = adamAI;
        this.buttonState = playerControllerState;
        this.planManager = searchPlanManager;
        this.myPlayer = player;
        this.plannedRound = -1;
        this.aiSystem = aISystem;
        this.reactionTime = 0;
        this.tileOrder = new LinkedList();
        this.tileValues = new TreeMap<PlanetTile, Integer>();
        this.mySort = new LandGrantSort(this.tileValues);
    }

    private void getAdamTile() {
        this.claimTile = this.tileOrder.poll();
        if (this.claimTile == null) {
            logger.info("AI: " + this.myPlayer.getName() + " doesn't have anything left to want.");
            this.panic = true;
        } else {
            logger.info("AI: " + this.myPlayer.getName() + " wants " + this.claimTile);
        }
    }

    public void begin(GameModel gameModel, PlayerLP playerLP) {
        this.panic = false;
        this.claimTile = null;
        this.reactionTime = 0;
        this.useTileOrder = playerLP != null && playerLP.getLandGrantValues(gameModel, this.ai.getCrystiteDeduction(), this.tileValues);
        Properties.mule.getClass();
        if (gameModel.getLandGrant().numFreeTiles() < gameModel.getPlayers().size()) {
            logger.info("AI: " + this.myPlayer.getName() + " Not enough tiles, grab any tile.");
            this.panic = true;
        } else if (this.useTileOrder) {
            logger.info("AI: " + this.myPlayer.getName() + " is using the LP to pick tiles.");
            this.tileOrder.clear();
            this.tileOrder.addAll(this.tileValues.keySet());
            Collections.sort(this.tileOrder, this.mySort);
            this.getAdamTile();
            this.plannedRound = gameModel.getRound();
            this.agreeOnClaims(gameModel);
        } else {
            this.planManager.clearPlans();
            this.planManager.setNumPlans(gameModel.getPlayers().size());
            this.plannedRound = -1;
            logger.info("AI: " + this.myPlayer.getName() + " is using the search to pick a tile.");
            this.planManager.startPlanSearch(gameModel, this.ai.getCrystiteDeduction(), true);
        }
    }

    public void update(GameModel gameModel, long l) {
        if (!this.useTileOrder && this.planManager.isSearching()) {
            if (this.planManager.finishSearch(gameModel) && this.planManager.hasCurrentPlan()) {
                this.claimTile = this.planManager.getCurrentPlan().getClaimedTile();
                logger.info("AI: " + this.myPlayer.getName() + " wants " + this.claimTile);
                this.plannedRound = gameModel.getRound();
                this.agreeOnClaims(gameModel);
            }
        } else {
            PlanetTile planetTile = gameModel.getLandGrant().getTile();
            if (planetTile == null) {
                return;
            }
            if (this.panic) {
                this.buttonState.setActionButtonDown(true);
            } else if (planetTile != this.claimTile) {
                if (this.useTileOrder && this.tileOrder.contains(planetTile)) {
                    this.tileOrder.remove(planetTile);
                }
            } else if (this.reactionTime > 0) {
                --this.reactionTime;
            } else {
                this.buttonState.setActionButtonDown(true);
            }
        }
    }

    public void landClaimed(PlanetTile planetTile, GameModel gameModel) {
        if (planetTile.getOwner() == this.myPlayer) {
            this.panic = false;
            this.claimTile = null;
            return;
        }
        if (planetTile == this.claimTile) {
            this.pickNextTile(gameModel);
        }
        this.setReactionTime(gameModel);
    }

    private void pickNextTile(GameModel gameModel) {
        if (this.useTileOrder) {
            this.getAdamTile();
            return;
        }
        boolean bl = false;
        block0: while (!bl) {
            this.planManager.nextPlan();
            LandGrant landGrant = gameModel.getLandGrant();
            if (!this.planManager.hasCurrentPlan()) {
                logger.info("AI: " + this.myPlayer.getName() + " panics in land grant!");
                this.panic = true;
                bl = true;
                break;
            }
            int n = landGrant.getTileIndex() + 1;
            int n2 = landGrant.numFreeTiles();
            for (int i = n; i < n2; ++i) {
                PlanetTile planetTile = landGrant.getFreeTile(i);
                if (planetTile != this.planManager.getCurrentPlan().getClaimedTile()) continue;
                logger.info("AI: " + this.myPlayer.getName() + " can't claim " + this.claimTile + " and wants " + planetTile + " instead");
                this.claimTile = planetTile;
                bl = true;
                continue block0;
            }
        }
    }

    private void setReactionTime(GameModel gameModel) {
        this.reactionTime = this.panic || this.claimTile == gameModel.getLandGrant().getNextTile() ? 0 : this.ai.getRandom().nextInt(4);
    }

    private void agreeOnClaims(GameModel gameModel) {
        Object object;
        ArrayList<LandGrantActuator> arrayList = new ArrayList<LandGrantActuator>();
        ArrayList<AbstractAI> arrayList2 = this.aiSystem.getAIs();
        for (AbstractAI object2 : arrayList2) {
            if (!(object2 instanceof AdamAI)) continue;
            object = (AdamAI)object2;
            arrayList.add(((AdamAI)object).landGrantActuator);
        }
        for (LandGrantActuator landGrantActuator : arrayList) {
            if (landGrantActuator.plannedRound == gameModel.getRound()) continue;
            return;
        }
        logger.info("AI: Try to agree on tiles to claim.");
        for (int i = 0; i < arrayList.size(); ++i) {
            for (int j = i + 1; j < arrayList.size(); ++j) {
                object = (LandGrantActuator)arrayList.get(i);
                LandGrantActuator landGrantActuator = (LandGrantActuator)arrayList.get(j);
                if (((LandGrantActuator)object).claimTile != landGrantActuator.claimTile) continue;
                if (((LandGrantActuator)object).myPlayer.getRank() < landGrantActuator.myPlayer.getRank()) {
                    logger.info("AI: " + ((LandGrantActuator)object).myPlayer.getName() + " must pick a different tile.");
                    super.pickNextTile(gameModel);
                    continue;
                }
                logger.info("AI: " + landGrantActuator.myPlayer.getName() + " must pick a different tile.");
                landGrantActuator.pickNextTile(gameModel);
            }
        }
        for (LandGrantActuator landGrantActuator : arrayList) {
            landGrantActuator.setReactionTime(gameModel);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LandGrantSort
    implements Comparator<PlanetTile> {
        Map<PlanetTile, Integer> values;

        LandGrantSort(Map<PlanetTile, Integer> map) {
            this.values = map;
        }

        @Override
        public int compare(PlanetTile planetTile, PlanetTile planetTile2) {
            return this.values.get(planetTile2).compareTo(this.values.get(planetTile));
        }
    }
}

