/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai.adam;

import com.turborilla.mule.MuleMath;
import com.turborilla.mule.controller.PlayerControllerState;
import com.turborilla.mule.model.Auction;
import com.turborilla.mule.model.AuctionLimits;
import com.turborilla.mule.model.AuctionState;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.Shop;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Random;

public class AuctionHelper {
    private Player myPlayer;
    private PlayerControllerState buttonState;
    private int myGap;
    private int startTick;
    private Auction myAuction;
    private Random random;
    boolean initialized;
    LinkedList<Player> otherBuyers;
    LinkedList<Player> otherSellers;
    private TickSort mySort;
    private Resource myResource;
    private Shop myShop;

    public AuctionHelper(Player player, Random random, PlayerControllerState playerControllerState) {
        this.myPlayer = player;
        this.buttonState = playerControllerState;
        this.random = random;
        this.otherBuyers = new LinkedList();
        this.otherSellers = new LinkedList();
        this.mySort = new TickSort();
        this.myGap = 25;
    }

    public void initialize(GameModel gameModel) {
        this.myAuction = gameModel.getAuction();
        this.startTick = this.getState().getTick();
        this.otherBuyers.clear();
        this.otherSellers.clear();
        this.otherBuyers.addAll(this.myAuction.getBuyers());
        this.otherSellers.addAll(this.myAuction.getSellers());
        if (this.myPlayer.isBuyer()) {
            this.otherBuyers.remove(this.myPlayer);
        } else {
            this.otherSellers.remove(this.myPlayer);
        }
        this.myShop = gameModel.getShop();
        switch (gameModel.getPhase()) {
            case AUCTION_CRYSTITE: {
                this.myResource = Resource.Crystite;
                break;
            }
            case AUCTION_ENERGY: {
                this.myResource = Resource.Energy;
                break;
            }
            case AUCTION_FOOD: {
                this.myResource = Resource.Food;
                break;
            }
            case AUCTION_SMITHORE: {
                this.myResource = Resource.Smithore;
            }
        }
        this.myGap = 25 + this.random.nextInt(25);
        this.initialized = true;
    }

    private int getExtendedStartTick() {
        return this.startTick + (this.myPlayer.isBuyer() ? this.getLimits().minTick : this.getLimits().maxTick);
    }

    private AuctionLimits getLimits() {
        return this.myAuction.getCurrentLimits();
    }

    private AuctionState getState() {
        return this.myPlayer.getAuctionState();
    }

    private int myTick() {
        return this.mySort.getExtendedTick(this.myPlayer);
    }

    private boolean shopIsBuying() {
        return this.getLimits().minTick == 0;
    }

    private boolean shopIsSelling() {
        return this.myShop.getResource(this.myResource) > 0;
    }

    public void makeBuyer() {
        if (!this.myPlayer.isBuyer()) {
            this.buttonState.setDownPressed(true);
        }
    }

    public void makeSeller() {
        if (this.myPlayer.isBuyer()) {
            this.buttonState.setUpPressed(true);
        }
    }

    public void sellAt(int n) {
        int n2 = this.getLimits().priceToMinTick(n);
        n2 = MuleMath.clamp(n2, this.getLimits().minTick, this.getLimits().maxTick + 10);
        int n3 = this.myTick() - n2;
        if (n3 >= 0 && n3 <= 2) {
            return;
        }
        this.goTo(n2);
    }

    public void buyAt(int n) {
        int n2 = this.getLimits().priceToMaxTick(n);
        int n3 = (n2 = Math.max(n2, this.getExtendedStartTick())) - this.myTick();
        if (n3 >= 0 && n3 <= 2) {
            return;
        }
        this.goTo(n2);
    }

    public void buyAtMost(int n) {
        int n2 = this.getLimits().priceToMaxTick(n);
        Player player = this.getHighestOtherBuyer();
        n2 = player != null && player.getAuctionState().isInAuction() ? Math.min(n2, player.getAuctionState().getTick() + this.myGap) : Math.min(n2, this.getLimits().minTick + 2);
        int n3 = (n2 = Math.max(n2, this.getExtendedStartTick())) - this.myTick();
        if (n3 >= 0 && n3 <= 2) {
            return;
        }
        this.goTo(n2);
    }

    public void sellAtLeast(int n) {
        int n2 = this.getLimits().priceToMinTick(n);
        Player player = this.getLowestOtherSeller();
        n2 = player != null && player.getAuctionState().isInAuction() ? Math.max(n2, player.getAuctionState().getTick() - this.myGap) : Math.max(n2, this.getLimits().maxTick - 2);
        n2 = MuleMath.clamp(n2, this.getLimits().minTick, this.getLimits().maxTick + 10);
        int n3 = this.myTick() - n2;
        if (n3 >= 0 && n3 <= 2) {
            return;
        }
        this.goTo(n2);
    }

    public void returnToStart() {
        if (this.myPlayer.isBuyer()) {
            if (this.myTick() > this.getExtendedStartTick()) {
                this.buttonState.setDown(true);
            }
        } else if (this.myTick() < this.getExtendedStartTick()) {
            this.buttonState.setUp(true);
        }
    }

    public void goTo(int n) {
        if (n < this.myTick()) {
            this.buttonState.setDown(true);
        } else if (n > this.myTick()) {
            this.buttonState.setUp(true);
        }
    }

    public boolean followPlayer(Player player) {
        if (player == null) {
            return false;
        }
        int n = this.mySort.getExtendedTick(player);
        System.out.println(this.myTick() + "\t" + n + "\t" + this.getExtendedStartTick());
        if (this.myPlayer.isBuyer()) {
            this.goTo(Math.max(this.getExtendedStartTick(), MuleMath.clamp(this.myTick(), n - 2 * this.myGap, n - this.myGap)));
        } else {
            this.goTo(Math.min(this.getExtendedStartTick(), MuleMath.clamp(this.myTick(), n + this.myGap, n + 2 * this.myGap)));
        }
        return true;
    }

    public boolean followLeader() {
        Player player = this.myPlayer.isBuyer() ? this.getHighestOtherBuyer() : this.getLowestOtherSeller();
        return this.followPlayer(player);
    }

    public boolean danceWithLeader(boolean bl) {
        Player player;
        Player player2 = player = this.myPlayer.isBuyer() ? this.getLowestOtherSeller() : this.getHighestOtherBuyer();
        if (bl && (player == null || !player.getAuctionState().isInAuction())) {
            return this.goShopping();
        }
        return this.followPlayer(player);
    }

    private Player getHighestOtherBuyer() {
        if (this.otherBuyers.size() == 0) {
            return null;
        }
        Collections.sort(this.otherBuyers, this.mySort);
        return this.otherBuyers.getLast();
    }

    private Player getLowestOtherSeller() {
        if (this.otherSellers.size() == 0) {
            return null;
        }
        Collections.sort(this.otherSellers, this.mySort);
        return this.otherSellers.getFirst();
    }

    public boolean guardShop() {
        if (this.myPlayer.isBuyer()) {
            if (!this.shopIsBuying() || this.myPlayer.getMoney() < this.myShop.getBuyPrice(this.myResource)) {
                return false;
            }
            this.buyAt(this.myShop.getBuyPrice(this.myResource));
        } else {
            if (!this.shopIsSelling() || this.myPlayer.getResource(this.myResource) == 0) {
                return false;
            }
            this.sellAt(this.myShop.getSellPrice(this.myResource));
        }
        return true;
    }

    public boolean goShopping() {
        if (this.myPlayer.isBuyer()) {
            int n = this.myShop.getSellPrice(this.myResource);
            if (!this.shopIsSelling() || n > this.myPlayer.getMoney()) {
                return false;
            }
            this.goTo(this.getLimits().maxTick);
        } else {
            if (!this.shopIsBuying() || this.myPlayer.getResource(this.myResource) == 0) {
                return false;
            }
            this.goTo(this.getLimits().minTick);
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TickSort
    implements Comparator<Player> {
        private TickSort() {
        }

        @Override
        public int compare(Player player, Player player2) {
            return this.getExtendedTick(player).compareTo(this.getExtendedTick(player2));
        }

        public Integer getExtendedTick(Player player) {
            int n = player.getAuctionState().getTick();
            if (!player.getAuctionState().isInAuction()) {
                n += player.isBuyer() ? ((AuctionHelper)AuctionHelper.this).getLimits().minTick : ((AuctionHelper)AuctionHelper.this).getLimits().maxTick;
            }
            return n;
        }
    }
}

