/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai.adam;

import com.turborilla.mule.MuleMath;
import com.turborilla.mule.ai.adam.AdamAI;
import com.turborilla.mule.ai.adam.AuctionHelper;
import com.turborilla.mule.controller.PlayerControllerState;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Phase;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.Shop;
import com.turborilla.mule.model.map.PlanetTile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuctionActuator {
    private Logger logger = Logger.getLogger("mule");
    private Player myPlayer;
    private PlayerControllerState buttonState;
    private AdamAI ai;
    private int myCritical;
    private int targetPrice;
    private AuctionHelper helper;
    private boolean imLeading;
    private float threshold;
    private int myRandom;
    private Resource resource;
    private int buyoutMask;
    Map<Resource, Collection<PlanetTile>> tilesByResource;

    AuctionActuator(AdamAI adamAI, PlayerControllerState playerControllerState) {
        this.ai = adamAI;
        this.myPlayer = adamAI.getMyPlayer();
        this.buttonState = playerControllerState;
        this.myRandom = MuleMath.closest(adamAI.getRandom().nextInt(20), 4) - 20;
        this.helper = new AuctionHelper(adamAI.getMyPlayer(), adamAI.getRandom(), playerControllerState);
        this.threshold = 0.25f * adamAI.getRandom().nextFloat();
        this.imLeading = false;
        this.buyoutMask = -1;
        this.tilesByResource = new HashMap<Resource, Collection<PlanetTile>>(8);
        for (Resource resource : Resource.values()) {
            this.tilesByResource.put(resource, new TreeSet());
        }
    }

    void begin(GameModel gameModel) {
        switch (gameModel.getPhase()) {
            case AUCTION_CRYSTITE: {
                this.resource = Resource.Crystite;
                break;
            }
            case AUCTION_ENERGY: {
                this.resource = Resource.Energy;
                break;
            }
            case AUCTION_FOOD: {
                this.resource = Resource.Food;
                break;
            }
            case AUCTION_SMITHORE: {
                this.resource = Resource.Smithore;
            }
        }
        this.myCritical = this.myPlayer.getResourceCritical(this.resource, gameModel);
        if (this.resource == Resource.Energy) {
            ++this.myCritical;
        }
        this.calcTargetPrice(gameModel);
        this.helper.initialized = false;
        this.buyoutMask = -1;
        this.imLeading = this.ai.getRandom().nextFloat() < this.threshold;
    }

    void beginAuction(GameModel gameModel) {
        this.helper.initialize(gameModel);
        this.setBuyoutMask(gameModel, 0, 0);
        this.logger.info("AI: " + this.myPlayer.getName() + " has buyout mask " + this.buyoutMask);
    }

    void update(GameModel gameModel, long l) {
        if (gameModel.isLastRound()) {
            if (!this.myPlayer.isContinue()) {
                this.buttonState.setDown(true);
            }
            return;
        }
        if (!gameModel.getCountdown().isFinished()) {
            this.chooseBuySell(gameModel);
            return;
        }
        if (!this.helper.initialized) {
            return;
        }
        if (this.myPlayer.isBuyer()) {
            this.buy(gameModel);
        } else {
            this.sell(gameModel);
        }
    }

    void chooseBuySell(GameModel gameModel) {
        if (gameModel.getRound() == 12) {
            this.helper.makeBuyer();
        }
        int n = this.myPlayer.getResource(this.resource);
        switch (this.resource) {
            case Crystite: {
                if (n > 0) {
                    this.helper.makeSeller();
                    break;
                }
                this.helper.makeBuyer();
                break;
            }
            case Smithore: {
                if (n > 50) {
                    this.helper.makeSeller();
                    return;
                }
                if (n == 0) {
                    this.helper.makeBuyer();
                    return;
                }
                int n2 = gameModel.getAuction().getBuyers().size();
                if (this.myPlayer.isBuyer()) {
                    if (n2 > 2) break;
                    this.helper.makeSeller();
                    break;
                }
                if (n2 < 2) break;
                this.helper.makeBuyer();
                break;
            }
            case Food: 
            case Energy: {
                if (n <= this.myCritical) {
                    this.helper.makeBuyer();
                    break;
                }
                this.helper.makeSeller();
            }
        }
    }

    void buy(GameModel gameModel) {
        int n = this.myPlayer.getResource(this.resource);
        if (this.resource == Resource.Crystite || this.resource == Resource.Smithore) {
            return;
        }
        if (this.helper.otherSellers.isEmpty() && gameModel.getShop().getResource(this.resource) == 0) {
            return;
        }
        if (n < this.myCritical) {
            if (this.helper.goShopping()) {
                return;
            }
            this.helper.buyAt(Math.max(this.targetPrice, gameModel.getShop().getBuyPrice(this.resource)));
            return;
        }
        switch (this.resource) {
            case Food: {
                this.helper.returnToStart();
                return;
            }
            case Energy: {
                this.helper.buyAtMost(this.targetPrice);
                return;
            }
            case Crystite: {
                return;
            }
            case Smithore: {
                return;
            }
        }
    }

    void sell(GameModel gameModel) {
        int n = this.myPlayer.getResource(this.resource);
        if (n == 0) {
            this.helper.returnToStart();
            return;
        }
        if (this.resource == Resource.Smithore || this.resource == Resource.Crystite) {
            if (n > 50 || this.targetPrice < gameModel.getShop().getBuyPrice(this.resource)) {
                this.helper.goShopping();
            } else {
                this.helper.sellAt(this.targetPrice);
            }
            return;
        }
        int n2 = 0;
        for (Player object : this.helper.otherBuyers) {
            n2 += Math.max(0, object.getResourceCritical(this.resource, gameModel) - object.getResource(this.resource));
        }
        int n3 = 0;
        for (Player player : this.helper.otherSellers) {
            n3 += Math.max(0, player.getResource(this.resource) - player.getResourceCritical(this.resource, gameModel));
        }
        int n4 = n - this.myCritical;
        if (n4 <= 0) {
            this.helper.returnToStart();
            return;
        }
        if (n2 > 0 && n3 < n2 && n2 <= gameModel.getShop().getEnergy()) {
            this.helper.guardShop();
            return;
        }
        if (this.resource == Resource.Food && n2 <= 0 && n4 % 2 == 0) {
            this.helper.goShopping();
            return;
        }
        this.helper.sellAtLeast(this.targetPrice);
    }

    void setBuyoutMask(GameModel gameModel, int n, int n2) {
        this.buyoutMask = 0;
        Shop shop = gameModel.getShop();
        int n3 = shop.getResource(this.resource);
        int n4 = this.myPlayer.getMoney();
        if (n4 >= (n3 - n2) * shop.getBuyPrice(this.resource) + n) {
            this.buyoutMask += 4;
        }
        for (Player player : this.helper.otherSellers) {
            n3 += player.getSmithore();
        }
        if (n4 >= (n3 - n2) * shop.getBuyPrice(this.resource) + n) {
            this.buyoutMask += 8;
        }
        for (Player player : this.helper.otherBuyers) {
            n4 += player.getMoney();
        }
        if (n4 >= (n3 - n2) * shop.getBuyPrice(this.resource) + n) {
            this.buyoutMask += 2;
        }
        if (n4 >= ((n3 = shop.getResource(this.resource)) - n2) * shop.getBuyPrice(this.resource) + n) {
            ++this.buyoutMask;
        }
    }

    void calcTargetPrice(GameModel gameModel) {
        this.targetPrice = this.ai.getPriceCalculator().getPlayerPrice(gameModel, this.resource, this.myPlayer);
        if (this.resource == Resource.Crystite || this.resource == Resource.Smithore) {
            this.targetPrice += this.myRandom;
        }
        if (this.myPlayer.isBuyer()) {
            if (gameModel.getShop().getSellPrice(this.resource) < this.targetPrice + 8) {
                this.targetPrice = gameModel.getShop().getSellPrice(this.resource);
            }
        } else if (gameModel.getShop().getBuyPrice(this.resource) > this.targetPrice - 8) {
            this.targetPrice = gameModel.getShop().getBuyPrice(this.resource);
        }
        if (this.myPlayer.isBuyer() && this.myPlayer.getMoney() < this.targetPrice) {
            this.logger.info("AI: " + this.myPlayer.getName() + " target price $" + this.targetPrice + " capped by money $" + this.myPlayer.getMoney());
            this.targetPrice = this.myPlayer.getMoney();
        } else {
            this.logger.info("AI: " + this.myPlayer.getName() + " target price $" + this.targetPrice);
        }
        this.logger.info("AI: " + this.myPlayer.getName() + " calculated the target price (via method 2) to be $" + this.getResourceValue(gameModel, this.resource));
    }

    void calcOldTargetPrice(GameModel gameModel) {
        int n = gameModel.getShop().getBuyPrice(this.resource);
        int n2 = gameModel.getShop().getSellPrice(this.resource);
        if (this.resource == Resource.Crystite) {
            this.targetPrice = MuleMath.closest(80 + this.ai.getRandom().nextInt(20), 4);
            if (this.targetPrice <= n + 4) {
                this.targetPrice = n;
            }
            this.logger.info("AI: " + this.myPlayer.getName() + " target price $" + this.targetPrice);
            return;
        }
        if (this.resource == Resource.Smithore) {
            this.targetPrice = 250 - 20 * gameModel.getRound();
            if (this.targetPrice <= n + 1) {
                this.targetPrice = n;
            }
            this.logger.info("AI: " + this.myPlayer.getName() + " target price $" + this.targetPrice);
        } else {
            int n3 = this.myPlayer.getResource(this.resource);
            int n4 = n3 - this.myCritical;
            int n5 = 0;
            int n6 = 0;
            for (Player player : gameModel.getPlayers()) {
                if (player == this.myPlayer) continue;
                int n7 = player.getResourceCritical(this.resource, gameModel);
                int n8 = player.getResource(this.resource);
                int n9 = n8 - n7;
                if (player.isBuyer()) {
                    if (n9 >= 0) continue;
                    n6 -= n9;
                    continue;
                }
                if (n9 <= 0) continue;
                n5 += n9;
            }
            float f = AuctionActuator.calcPriceRatio(n4, n5, n6, gameModel.getShop().getResource(this.resource), true);
            this.targetPrice = (int)(f * (float)n2 + (1.0f - f) * (float)n);
            if (this.myPlayer.isBuyer() && this.myPlayer.getMoney() < this.targetPrice) {
                this.logger.info("AI: " + this.myPlayer.getName() + " target price $" + this.targetPrice + " ratio " + f + " capped by money $" + this.myPlayer.getMoney());
                this.targetPrice = this.myPlayer.getMoney();
            } else {
                this.logger.info("AI: " + this.myPlayer.getName() + " target price $" + this.targetPrice + " ratio " + f);
            }
        }
    }

    private static float calcPriceRatio(int n, int n2, int n3, int n4, boolean bl) {
        float f = 0.0f;
        if (n > 0) {
            float f2 = 0.03f * (float)n2 + 0.1f * (float)n;
            float f3 = 0.5f * (float)n3 - f2 + 0.3f;
            f = f3;
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f > 1.0f) {
                if (n4 > 0) {
                    f = 1.0f;
                } else if (bl && f > 2.5f) {
                    f = 2.5f;
                }
            }
        } else {
            float f4 = 3.0f * (float)n3 - 4.0f * (float)n;
            float f5 = f4 - 0.3f * (float)n2 + 6.5f;
            f = f5 / 7.5f;
            if (f < 0.0f) {
                f = 0.0f;
            } else if (bl && f > 2.5f) {
                f = 2.5f;
            }
        }
        return f;
    }

    void transaction(GameModel gameModel, ArrayList<Integer> arrayList, ArrayList<Integer> arrayList2) {
        if (gameModel.getPhase() == Phase.AUCTION_ENERGY || gameModel.getPhase() == Phase.AUCTION_FOOD) {
            this.setBuyoutMask(gameModel, 0, 0);
            this.calcTargetPrice(gameModel);
        }
    }

    private void resetTilesByResource() {
        for (Resource resource : Resource.values()) {
            this.tilesByResource.get((Object)resource).clear();
        }
        for (PlanetTile planetTile : this.myPlayer.getOwnedTiles()) {
            if (planetTile.isEmpty()) continue;
            this.tilesByResource.get((Object)planetTile.getFactory().getResource()).add(planetTile);
        }
    }

    public int getResourceValue(GameModel gameModel, Resource resource) {
        if (resource == Resource.Smithore || resource == Resource.Crystite) {
            return this.ai.getPriceCalculator().getPlayerPrice(gameModel, resource, this.myPlayer);
        }
        this.resetTilesByResource();
        Collection<PlanetTile> collection = this.tilesByResource.get((Object)resource);
        int n = this.ai.getPriceCalculator().expectedValue(gameModel, this.tilesByResource);
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        for (PlanetTile planetTile : this.myPlayer.getOwnedTiles()) {
            Resource resource2 = PlanetTile.getResourceFromTile(planetTile);
            if (resource2 == Resource.Smithore || resource2 == Resource.Crystite) {
                this.tilesByResource.get((Object)resource2).remove(planetTile);
                collection.add(planetTile);
                n2 = this.ai.getPriceCalculator().expectedValue(gameModel, this.tilesByResource);
                collection.remove(planetTile);
                this.tilesByResource.get((Object)resource2).add(planetTile);
                n2 = (n - n2) / planetTile.getYieldPotential(resource);
            }
            n3 = Math.min(n3, n2);
        }
        return n3;
    }
}

