/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai.adam;

import com.turborilla.mule.Properties;
import com.turborilla.mule.ai.AISystem;
import com.turborilla.mule.ai.AbstractAI;
import com.turborilla.mule.ai.CrystiteDeduction;
import com.turborilla.mule.ai.DevelopmentAction;
import com.turborilla.mule.ai.DevelopmentActionControl;
import com.turborilla.mule.ai.PathWalker;
import com.turborilla.mule.ai.adam.AuctionActuator;
import com.turborilla.mule.ai.adam.DevelopmentActuator;
import com.turborilla.mule.ai.adam.DevelopmentPlanner;
import com.turborilla.mule.ai.adam.FastDevelopmentActuator;
import com.turborilla.mule.ai.adam.LandAuctionActuator;
import com.turborilla.mule.ai.adam.LandGrantActuator;
import com.turborilla.mule.ai.adam.LandRushActuator;
import com.turborilla.mule.ai.adam.PlayerLP;
import com.turborilla.mule.ai.adam.PriceCalculator;
import com.turborilla.mule.ai.adam.SearchPlanManager;
import com.turborilla.mule.controller.WampusMenu;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Phase;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetTile;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdamAI
extends AbstractAI {
    private static final long serialVersionUID = 1L;
    private Player myPlayer;
    private DevelopmentActionControl developmentControl;
    private LandRushActuator landRushActuator;
    private DevelopmentActuator developmentActuator;
    private FastDevelopmentActuator fastDevelopmentActuator;
    private AuctionActuator auctionActuator;
    private LandAuctionActuator landAuctionActuator;
    private DevelopmentPlanner developmentPlanner;
    private SearchPlanManager planManager;
    private PlayerLP playerLP;
    private float summaryContinueTimer;
    private boolean pressedContinue = false;
    LandGrantActuator landGrantActuator;
    private CrystiteDeduction crystiteDeduction;
    private Random random;
    private PriceCalculator priceCalculator;

    public AdamAI(AISystem aISystem, Player player, GameModel gameModel) {
        super(aISystem);
        this.myPlayer = player;
        PlanetMap planetMap = gameModel.getMap();
        this.random = Properties.mule.debugRandomSeed ? new Random(Properties.mule.debugRandomSeedValue * this.myPlayer.getUserNumber()) : new Random();
        int n = 2;
        this.crystiteDeduction = new CrystiteDeduction(planetMap.getXSize(), planetMap.getYSize());
        this.priceCalculator = new PriceCalculator(gameModel.getShop(), this.crystiteDeduction);
        this.playerLP = new PlayerLP(this);
        this.developmentControl = new DevelopmentActionControl(this.myPlayer, this.buttonState, aISystem.getPathFindingGraph());
        this.planManager = new SearchPlanManager(this, this.myPlayer, planetMap, n);
        this.developmentPlanner = new DevelopmentPlanner(this, this.developmentControl, planetMap, this.planManager);
        this.landGrantActuator = new LandGrantActuator(this, this.planManager, this.buttonState, this.myPlayer, aISystem);
        this.landRushActuator = new LandRushActuator(this, this.developmentControl, this.planManager);
        this.developmentActuator = new DevelopmentActuator(this.developmentControl, this.developmentPlanner, this);
        this.fastDevelopmentActuator = new FastDevelopmentActuator(this.developmentActuator);
        this.auctionActuator = new AuctionActuator(this, this.buttonState);
        this.landAuctionActuator = new LandAuctionActuator(this, this.buttonState);
    }

    @Override
    public void beginPhase(Phase phase, GameModel gameModel) {
        switch (gameModel.getPhase()) {
            case LAND_GRANT: {
                this.landGrantActuator.begin(gameModel, this.playerLP);
                break;
            }
            case LAND_RUSH: {
                if (!this.isMyTurnInLandRush(gameModel)) break;
                this.landRushActuator.begin(gameModel);
                break;
            }
            case DEVELOPMENT: {
                if (!this.isMyTurnInDevelopment(gameModel)) break;
                this.priceCalculator.calculatePrices(gameModel);
                this.developmentActuator.beginThreaded(gameModel, this.playerLP);
                break;
            }
            case FAST_DEVELOPMENT: {
                if (!this.isMyTurnInDevelopment(gameModel)) break;
                this.priceCalculator.calculatePrices(gameModel);
                this.fastDevelopmentActuator.begin(gameModel, this.playerLP);
                break;
            }
            case AUCTION_CRYSTITE: 
            case AUCTION_SMITHORE: 
            case AUCTION_ENERGY: 
            case AUCTION_FOOD: {
                this.priceCalculator.setPrices();
                this.auctionActuator.begin(gameModel);
                break;
            }
            case SUMMARY: {
                this.summaryContinueTimer = 8.5f + this.random.nextFloat() * 4.0f;
            }
        }
    }

    @Override
    public void update(GameModel gameModel, long l) {
        block0 : switch (gameModel.getPhase()) {
            case GAME_LOBBY: {
                if (this.pressedContinue) break;
                this.buttonState.setActionButtonPressed(true);
                this.pressedContinue = true;
                break;
            }
            case LAND_GRANT: {
                this.landGrantActuator.update(gameModel, l);
                break;
            }
            case LAND_RUSH: {
                this.landRushActuator.update(gameModel, l);
                break;
            }
            case DEVELOPMENT: {
                this.developmentActuator.update(gameModel, l);
                break;
            }
            case FAST_DEVELOPMENT: {
                this.developmentActuator.update(gameModel, l);
                this.fastDevelopmentActuator.update(gameModel);
                break;
            }
            case AUCTION_CRYSTITE: 
            case AUCTION_SMITHORE: 
            case AUCTION_ENERGY: 
            case AUCTION_FOOD: {
                this.auctionActuator.update(gameModel, l);
                break;
            }
            case LAND_AUCTION: {
                this.landAuctionActuator.update(gameModel, l);
                break;
            }
            case SUMMARY: {
                this.crystiteDeduction.updateKnown(gameModel.getMap());
                if (this.summaryContinueTimer > 0.0f) {
                    this.summaryContinueTimer -= Properties.mule.delta;
                    break;
                }
                if (this.myPlayer.isContinue() || gameModel.isLastRound()) break;
                this.buttonState.setActionButtonPressed(true);
                break;
            }
            default: {
                if (!this.myPlayer.isContinue()) {
                    this.buttonState.setActionButtonPressed(true);
                }
                switch ((int)(l % 4L)) {
                    case 0: {
                        this.buttonState.setUpPressed(true);
                        break block0;
                    }
                    case 1: {
                        this.buttonState.setDownPressed(true);
                        break block0;
                    }
                    case 2: {
                        this.buttonState.setLeftPressed(true);
                        break block0;
                    }
                    case 3: {
                        this.buttonState.setRightPressed(true);
                    }
                }
            }
        }
    }

    private boolean isMyTurnInLandRush(GameModel gameModel) {
        Player player = gameModel.getDevelopment().getCurrentPlayer();
        return this.myPlayer == player;
    }

    private boolean isMyTurnInDevelopment(GameModel gameModel) {
        Player player;
        return !gameModel.getGameInfo().isSingleDevelopment() || this.myPlayer == (player = gameModel.getDevelopment().getCurrentPlayer());
    }

    public PathWalker getPathWalker() {
        return this.developmentControl.getPathWalker();
    }

    @Override
    public void landClaimed(PlanetTile planetTile, GameModel gameModel) {
        if (gameModel.getPhase() == Phase.LAND_GRANT) {
            this.landGrantActuator.landClaimed(planetTile, gameModel);
        } else if (gameModel.getPhase() == Phase.DEVELOPMENT) {
            this.developmentActuator.landClaimed(planetTile, gameModel);
        }
    }

    @Override
    public void mulesChanged(Player player, GameModel gameModel) {
        this.developmentActuator.mulesChanged(player, gameModel);
    }

    @Override
    public void wampusCaught(Player player, GameModel gameModel, WampusMenu wampusMenu) {
        this.developmentActuator.wampusCaught(player, gameModel, wampusMenu);
    }

    @Override
    public void assay(Player player, PlanetTile planetTile, GameModel gameModel) {
        this.crystiteDeduction.setKnown(planetTile.getPosX(), planetTile.getPosY(), planetTile.getCrystite());
        this.developmentActuator.assay(player, planetTile, gameModel);
    }

    @Override
    public void meteoriteStrike(PlanetTile planetTile) {
        this.crystiteDeduction.setKnown(planetTile.getPosX(), planetTile.getPosY(), 4);
    }

    @Override
    public void beginLandAuction(GameModel gameModel) {
        this.landAuctionActuator.beginLandAuction(gameModel, this.playerLP);
    }

    @Override
    public void beginAuction(GameModel gameModel) {
        this.auctionActuator.beginAuction(gameModel);
    }

    @Override
    public void transaction(GameModel gameModel, ArrayList<Integer> arrayList, ArrayList<Integer> arrayList2) {
        this.auctionActuator.transaction(gameModel, arrayList, arrayList2);
    }

    @Override
    public boolean isThinking() {
        return this.developmentPlanner.isSearching();
    }

    @Override
    public DevelopmentAction nextDevelopmentAction(GameModel gameModel) {
        return this.fastDevelopmentActuator.nextDevelopmentAction(gameModel);
    }

    @Override
    public void developmentActionCompleted(GameModel gameModel, DevelopmentAction developmentAction) {
        this.fastDevelopmentActuator.developmentActionCompleted(gameModel, developmentAction);
    }

    public PriceCalculator getPriceCalculator() {
        return this.priceCalculator;
    }

    public Random getRandom() {
        return this.random;
    }

    public CrystiteDeduction getCrystiteDeduction() {
        return this.crystiteDeduction;
    }

    public Player getMyPlayer() {
        return this.myPlayer;
    }
}

