/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai;

import com.turborilla.mule.ai.simulator.DevelopmentPlan;
import com.turborilla.mule.model.Shop;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetTile;
import com.turborilla.mule.view.ActorSprite;
import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartDirectionChooser {
    public static ArrayList<ActorSprite.Direction> testDirections() {
        ArrayList<ActorSprite.Direction> arrayList = new ArrayList<ActorSprite.Direction>();
        arrayList.add(ActorSprite.Direction.East);
        arrayList.add(ActorSprite.Direction.South);
        arrayList.add(ActorSprite.Direction.North);
        arrayList.add(ActorSprite.Direction.West);
        return arrayList;
    }

    public static ArrayList<ActorSprite.Direction> findDirections(DevelopmentPlan developmentPlan, PlanetMap planetMap, Shop shop, int n) {
        if (shop.numMules() < n || developmentPlan == null || developmentPlan.numTiles() == 0) {
            ArrayList<ActorSprite.Direction> arrayList = new ArrayList<ActorSprite.Direction>();
            arrayList.add(ActorSprite.Direction.East);
            arrayList.add(ActorSprite.Direction.South);
            arrayList.add(ActorSprite.Direction.North);
            arrayList.add(ActorSprite.Direction.West);
            return arrayList;
        }
        PlanetTile planetTile = planetMap.getShopTile();
        PlanetTile planetTile2 = developmentPlan.getClaimedTile();
        if (planetTile2 == null) {
            planetTile2 = developmentPlan.getTile(0);
        }
        int n2 = planetTile2.getPosX() - planetTile.getPosX();
        int n3 = planetTile2.getPosY() - planetTile.getPosY();
        ArrayList<WeightedDirection> arrayList = new ArrayList<WeightedDirection>();
        arrayList.add(new WeightedDirection(ActorSprite.Direction.North, -n3));
        arrayList.add(new WeightedDirection(ActorSprite.Direction.South, n3));
        arrayList.add(new WeightedDirection(ActorSprite.Direction.East, n2));
        arrayList.add(new WeightedDirection(ActorSprite.Direction.West, -n2));
        Collections.sort(arrayList);
        ArrayList<ActorSprite.Direction> arrayList2 = new ArrayList<ActorSprite.Direction>();
        for (int i = 0; i < 4; ++i) {
            arrayList2.add(((WeightedDirection)arrayList.get((int)i)).direction);
        }
        return arrayList2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeightedDirection
    implements Comparable<WeightedDirection> {
        public ActorSprite.Direction direction;
        public int weight;

        public WeightedDirection(ActorSprite.Direction direction, int n) {
            this.direction = direction;
            this.weight = n;
        }

        @Override
        public int compareTo(WeightedDirection weightedDirection) {
            if (this.weight > weightedDirection.weight) {
                return -1;
            }
            if (this.weight < weightedDirection.weight) {
                return 1;
            }
            if (this.direction.ordinal() < weightedDirection.direction.ordinal()) {
                return -1;
            }
            if (this.direction.ordinal() > weightedDirection.direction.ordinal()) {
                return 1;
            }
            return 0;
        }
    }
}

