/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai;

import com.turborilla.mule.ai.PathFinder;
import com.turborilla.mule.controller.PlayerControllerState;
import com.turborilla.mule.controller.TargetPlayerController;
import com.turborilla.mule.model.Avatar;
import com.turborilla.mule.model.Shop;
import com.turborilla.mule.model.map.PlanetMap;

public class PathWalker {
    private Avatar avatar;
    private PathFinder.Path path;
    private int pathIndex;
    private boolean completed;
    private PlayerControllerState state;
    private TargetPlayerController targetController;

    public PathWalker(Avatar avatar, PlayerControllerState playerControllerState) {
        this.avatar = avatar;
        this.state = playerControllerState;
        this.targetController = new TargetPlayerController(avatar, playerControllerState);
        this.targetController.setTargetRadius(1.0f);
    }

    public void setPath(PathFinder.Path path) {
        this.path = path;
        this.pathIndex = 0;
        this.targetController.clearTargets();
        if (path == null) {
            this.completed = true;
        } else {
            this.completed = false;
            this.addTargetsFromPath();
        }
    }

    public PathFinder.Path getPath() {
        return this.path;
    }

    public void update(PlanetMap planetMap, Shop shop) {
        this.targetController.update();
        if (this.targetController.numTargets() == 0) {
            if (this.pathIndex == this.path.size()) {
                this.completed = true;
                return;
            }
            PathFinder.PathNode pathNode = (PathFinder.PathNode)this.path.get(this.pathIndex);
            if (this.avatar.isInShop() && !pathNode.inShop) {
                float f = this.avatar.getPosition().x - (float)(shop.getWidth() / 2);
                float f2 = this.avatar.getPosition().y - (float)(shop.getHeight() / 2);
                if (Math.abs(f) > Math.abs(f2)) {
                    if (f < 0.0f) {
                        this.state.setLeft(true);
                    } else {
                        this.state.setRight(true);
                    }
                } else if (f2 < 0.0f) {
                    this.state.setUp(true);
                } else {
                    this.state.setDown(true);
                }
            } else if (!this.avatar.isInShop() && pathNode.inShop) {
                float f = planetMap.getShopCenter().x - this.avatar.getPosition().x;
                float f3 = planetMap.getShopCenter().y - this.avatar.getPosition().y;
                if (Math.abs(f) > Math.abs(f3)) {
                    if (f < 0.0f) {
                        this.state.setLeft(true);
                    } else {
                        this.state.setRight(true);
                    }
                } else if (f3 < 0.0f) {
                    this.state.setUp(true);
                } else {
                    this.state.setDown(true);
                }
            } else {
                this.addTargetsFromPath();
            }
        }
    }

    private void addTargetsFromPath() {
        while (this.pathIndex < this.path.size()) {
            PathFinder.PathNode pathNode = (PathFinder.PathNode)this.path.get(this.pathIndex);
            if (this.avatar.isInShop() != pathNode.inShop) break;
            this.targetController.addTarget(pathNode.pos);
            ++this.pathIndex;
        }
    }

    public boolean isCompleted() {
        return this.completed;
    }
}

