/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai;

import com.turborilla.mule.ai.PathFindingGraph;
import com.turborilla.mule.model.util.Vec2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.PriorityQueue;

public final class PathFinder {
    private PriorityQueue<PathFindingGraph.Node> openSet;
    private NodeComparator nodeComparator = new NodeComparator();
    private boolean[] inOpenSet;
    private boolean[] inClosedSet;
    private float[] scoreG;
    private float[] scoreF;
    private PathFindingGraph.Node[] cameFrom;
    private int[] openedNodes;
    private int numOpenedNodes;

    public PathFinder() {
        this.openSet = new PriorityQueue<PathFindingGraph.Node>(150, this.nodeComparator);
    }

    public Path findPath(Vec2 vec2, boolean bl, Vec2 vec22, boolean bl2, PathFindingGraph pathFindingGraph) {
        Path path = new Path();
        PathFindingGraph.Node node = pathFindingGraph.getNodeAtPosition(vec2, bl);
        PathFindingGraph.Node node2 = pathFindingGraph.getNodeAtPosition(vec22, bl2);
        if (!node.isReachable() || !node2.isReachable()) {
            return path;
        }
        this.nodeComparator.goal = node2;
        if (this.inOpenSet == null || this.inOpenSet.length < pathFindingGraph.numNodes()) {
            int n = pathFindingGraph.numNodes();
            this.inOpenSet = new boolean[n];
            this.inClosedSet = new boolean[n];
            this.scoreG = new float[n];
            this.scoreF = new float[n];
            this.cameFrom = new PathFindingGraph.Node[n];
            this.openedNodes = new int[n];
            Arrays.fill(this.inOpenSet, false);
            Arrays.fill(this.inClosedSet, false);
            Arrays.fill(this.scoreG, 0.0f);
            Arrays.fill(this.scoreF, 0.0f);
            Arrays.fill(this.cameFrom, null);
        }
        this.numOpenedNodes = 0;
        this.scoreG[node.getIndex()] = 0.0f;
        this.scoreF[node.getIndex()] = pathFindingGraph.getHeuristic(node.getIndex(), node2.getIndex());
        this.inOpenSet[node.getIndex()] = true;
        this.openSet.add(node);
        this.openedNodes[this.numOpenedNodes++] = node.getIndex();
        while (!this.openSet.isEmpty()) {
            PathFindingGraph.Node node3 = this.openSet.poll();
            int n = node3.getIndex();
            if (node3 == node2) {
                this.constructPath(path, node2, vec2, bl, vec22, bl2);
                this.cleanup();
                return path;
            }
            this.inClosedSet[n] = true;
            for (PathFindingGraph.Edge edge : node3.getEdges()) {
                PathFindingGraph.Node node4 = edge.getNeighbor();
                int n2 = node4.getIndex();
                if (this.inClosedSet[n2]) continue;
                float f = this.scoreG[n] + edge.weight;
                if (!this.inOpenSet[n2]) {
                    this.cameFrom[n2] = node3;
                    this.scoreG[n2] = f;
                    this.scoreF[n2] = f + pathFindingGraph.getHeuristic(n2, node2.getIndex());
                    this.inOpenSet[n2] = true;
                    this.openSet.add(node4);
                    this.openedNodes[this.numOpenedNodes++] = n2;
                    continue;
                }
                if (!(f <= this.scoreG[n2])) continue;
                this.cameFrom[n2] = node3;
                this.scoreG[n2] = f;
                this.scoreF[n2] = f + pathFindingGraph.getHeuristic(n2, node2.getIndex());
                this.openSet.remove(node4);
                this.openSet.add(node4);
            }
        }
        this.cleanup();
        return path;
    }

    private void constructPath(Path path, PathFindingGraph.Node node, Vec2 vec2, boolean bl, Vec2 vec22, boolean bl2) {
        path.add(new PathNode(vec22, bl2));
        PathFindingGraph.Node node2 = this.cameFrom[node.getIndex()];
        while (node2 != null) {
            PathFindingGraph.Node node3 = this.cameFrom[node2.getIndex()];
            if (node3 != null) {
                path.add(new PathNode(node2));
            }
            node2 = node3;
        }
        path.add(new PathNode(vec2, bl));
        Collections.reverse(path);
    }

    private void cleanup() {
        this.openSet.clear();
        for (int i = 0; i < this.numOpenedNodes; ++i) {
            int n = this.openedNodes[i];
            this.inClosedSet[n] = false;
            this.inOpenSet[n] = false;
            this.cameFrom[n] = null;
        }
        this.numOpenedNodes = 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class NodeComparator
    implements Comparator<PathFindingGraph.Node> {
        public PathFindingGraph.Node goal;

        private NodeComparator() {
        }

        @Override
        public int compare(PathFindingGraph.Node node, PathFindingGraph.Node node2) {
            float f;
            float f2 = PathFinder.this.scoreF[node.getIndex()];
            if (f2 < (f = PathFinder.this.scoreF[node2.getIndex()])) {
                return -1;
            }
            if (f2 > f) {
                return 1;
            }
            if (node.getIndex() < node2.getIndex()) {
                return -1;
            }
            if (node.getIndex() > node2.getIndex()) {
                return 1;
            }
            return 0;
        }
    }

    public static final class PathNode {
        public final Vec2 pos;
        public final boolean inShop;

        protected PathNode(PathFindingGraph.Node node) {
            this.pos = node.getPos();
            this.inShop = node.isInShop();
        }

        protected PathNode(Vec2 vec2, boolean bl) {
            this.pos = new Vec2(vec2);
            this.inShop = bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Path
    extends ArrayList<PathNode> {
        private static final long serialVersionUID = 1L;

        protected Path() {
        }
    }
}

