/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai;

import com.turborilla.mule.ai.PathFinder;
import com.turborilla.mule.ai.PathFindingGraph;
import com.turborilla.mule.ai.PathWalker;
import com.turborilla.mule.controller.PlayerControllerState;
import com.turborilla.mule.model.Avatar;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.util.Vec2;

public class DevelopmentActionControl {
    private final Player myPlayer;
    private final Avatar avatar;
    private final PlayerControllerState buttonState;
    private final PathFindingGraph pathFindingGraph;
    private final PathFinder pathFinder;
    private final PathWalker pathWalker;

    public DevelopmentActionControl(Player player, PlayerControllerState playerControllerState, PathFindingGraph pathFindingGraph) {
        this.myPlayer = player;
        this.avatar = player.getAvatar();
        this.buttonState = playerControllerState;
        this.pathFindingGraph = pathFindingGraph;
        this.pathFinder = new PathFinder();
        this.pathWalker = new PathWalker(this.avatar, playerControllerState);
    }

    public PathFinder.Path findLocation(Vec2 vec2, boolean bl) {
        PathFinder.Path path = this.pathFinder.findPath(this.avatar.getPosition(), this.avatar.isInShop(), vec2, bl, this.pathFindingGraph);
        return path;
    }

    public PathFinder.Path findLocation(PathFindingGraph.Node node) {
        PathFinder.Path path = this.pathFinder.findPath(this.avatar.getPosition(), this.avatar.isInShop(), node.getPos(), node.isInShop(), this.pathFindingGraph);
        return path;
    }

    public Player getMyPlayer() {
        return this.myPlayer;
    }

    public Avatar getAvatar() {
        return this.avatar;
    }

    public PlayerControllerState getButtonState() {
        return this.buttonState;
    }

    public PathFindingGraph getPathFindingGraph() {
        return this.pathFindingGraph;
    }

    public PathFinder getPathFinder() {
        return this.pathFinder;
    }

    public PathWalker getPathWalker() {
        return this.pathWalker;
    }
}

