/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.ai;

import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetTile;

public class CrystiteDeduction {
    private boolean[][] known;
    private int[][] crystite;
    private int numX;
    private int numY;
    private int numCenters;
    private boolean allKnown;

    public CrystiteDeduction(int n, int n2) {
        this.numX = n;
        this.numY = n2;
        this.allKnown = false;
        this.crystite = new int[this.numX][this.numY];
        this.known = new boolean[this.numX][this.numY];
        this.numCenters = 0;
        for (int i = 0; i < this.numX; ++i) {
            for (int j = 0; j < this.numY; ++j) {
                this.crystite[i][j] = 0;
                this.known[i][j] = false;
            }
        }
    }

    public CrystiteDeduction(CrystiteDeduction crystiteDeduction) {
        this.numX = crystiteDeduction.numX;
        this.numY = crystiteDeduction.numY;
        this.crystite = new int[this.numX][this.numY];
        this.known = new boolean[this.numX][this.numY];
        this.copy(crystiteDeduction);
    }

    public void copy(CrystiteDeduction crystiteDeduction) {
        this.allKnown = crystiteDeduction.allKnown;
        for (int i = 0; i < this.numX; ++i) {
            for (int j = 0; j < this.numY; ++j) {
                this.crystite[i][j] = crystiteDeduction.crystite[i][j];
                this.known[i][j] = crystiteDeduction.known[i][j];
            }
        }
    }

    public boolean isKnown(int n, int n2) {
        return this.known[n][n2];
    }

    public boolean isKnown(PlanetTile planetTile) {
        return this.known[planetTile.getPosX()][planetTile.getPosY()];
    }

    public boolean hasMeteor(PlanetTile planetTile) {
        return this.crystite[planetTile.getPosX()][planetTile.getPosY()] == 4;
    }

    public int getDeduction(PlanetTile planetTile) {
        return this.crystite[planetTile.getPosX()][planetTile.getPosY()];
    }

    public boolean isAllKnown() {
        return this.allKnown;
    }

    public boolean setKnown(int n, int n2, int n3) {
        if (this.known[n][n2] && n3 != 4) {
            return false;
        }
        this.crystite[n][n2] = n3;
        this.known[n][n2] = true;
        this.propagateLocally(n, n2);
        if (n3 == 3) {
            ++this.numCenters;
        }
        return true;
    }

    public boolean setKnown(PlanetTile planetTile, int n) {
        return this.setKnown(planetTile.getPosX(), planetTile.getPosY(), n);
    }

    public void propagateLocally(int n, int n2) {
        if (!this.known[n][n2] || this.crystite[n][n2] == 4) {
            return;
        }
        for (int i = Math.max(0, n - 2); i < Math.min(this.numX, n + 3); ++i) {
            for (int j = Math.max(0, n2 - 2); j < Math.min(this.numY, n2 + 3); ++j) {
                int n3 = Math.abs(n - i) + Math.abs(n2 - j);
                this.crystite[i][j] = Math.max(this.crystite[n][n2] - n3, this.crystite[i][j]);
            }
        }
    }

    public void updateKnown(PlanetMap planetMap) {
        if (this.allKnown) {
            return;
        }
        if (this.numCenters == 4) {
            this.setAllKnown(planetMap);
        }
        for (int i = 0; i < this.numX; ++i) {
            for (int j = 0; j < this.numY; ++j) {
                if (PlanetTile.getResourceFromTile((PlanetTile)planetMap.getTile(i, j)) != Resource.Crystite) continue;
                this.setKnown(i, j, ((PlanetTile)planetMap.getTile(i, j)).getCrystite());
            }
        }
        while (this.extraDeduction(planetMap)) {
        }
    }

    private boolean extraDeduction(PlanetMap planetMap) {
        if (this.allKnown) {
            return false;
        }
        for (int i = 0; i < this.numX; ++i) {
            for (int j = 0; j < this.numY; ++j) {
                if (this.known[i][j]) continue;
                int n = 0;
                int n2 = 3;
                if (j != 0 && this.known[i][j - 1] && this.crystite[i][j - 1] != 4) {
                    n = Math.max(n, this.crystite[i][j - 1]);
                    n2 = Math.min(n2, this.crystite[i][j - 1]);
                }
                if (j != this.numY - 1 && this.known[i][j + 1] && this.crystite[i][j + 1] != 4) {
                    n = Math.max(n, this.crystite[i][j + 1]);
                    n2 = Math.min(n2, this.crystite[i][j + 1]);
                }
                if (i != 0 && this.known[i - 1][j] && this.crystite[i - 1][j] != 4) {
                    n = Math.max(n, this.crystite[i - 1][j]);
                    n2 = Math.min(n2, this.crystite[i - 1][j]);
                }
                if (i != this.numX - 1 && this.known[i + 1][j] && this.crystite[i + 1][j] != 4) {
                    n = Math.max(n, this.crystite[i + 1][j]);
                    n2 = Math.min(n2, this.crystite[i + 1][j]);
                }
                if (n <= this.crystite[i][j] || n2 >= this.crystite[i][j]) continue;
                this.setKnown(i, j, this.crystite[i][j]);
                return true;
            }
        }
        return false;
    }

    public void setAllKnown(PlanetMap planetMap) {
        for (int i = 0; i < planetMap.getXSize(); ++i) {
            for (int j = 0; j < planetMap.getYSize(); ++j) {
                this.crystite[i][j] = ((PlanetTile)planetMap.getTile(i, j)).getCrystite();
                this.known[i][j] = true;
            }
        }
        this.allKnown = true;
    }
}

