/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class PropertiesBase {
    private static Logger logger = Logger.getLogger("mule");
    private final boolean ignoreOldVersions;
    private final String VERSION_TAG = "VERSION";

    public PropertiesBase(boolean bl) {
        this.ignoreOldVersions = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readFromFile(String string) throws FileNotFoundException {
        String string2;
        Scanner scanner;
        String string3;
        BufferedReader bufferedReader;
        Class<?> clazz = this.getClass();
        logger.info("Reading " + clazz.getSimpleName() + " from file " + string);
        File file = new File(string);
        if (this.ignoreOldVersions) {
            bufferedReader = new BufferedReader(new FileReader(file));
            try {
                string3 = bufferedReader.readLine();
                if (string3 == null) {
                    logger.info("Ignoring properties file without version " + string);
                    return;
                }
                if (string3.contains("VERSION")) {
                    bufferedReader.close();
                    scanner = new Scanner(string3);
                    scanner.next();
                    string2 = scanner.next();
                    if (!"1.3.4".equals(string2)) {
                        logger.info("Ignoring outdated properties file " + string + " version " + string2);
                        return;
                    }
                }
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, iOException.toString(), iOException);
            }
        }
        bufferedReader = new BufferedReader(new FileReader(file));
        block15: while (true) {
            string3 = null;
            try {
                string3 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                logger.severe(iOException.toString());
            }
            finally {
                if (string3 == null) break;
            }
            if ((string2 = (scanner = new Scanner(string3)).next()) == null || "VERSION".equals(string2) || !scanner.hasNext()) continue;
            try {
                int n;
                Object[] objectArray;
                Object object;
                Field field = clazz.getField(string2);
                Class<?> clazz2 = field.getType();
                if (clazz2 == Integer.TYPE) {
                    field.set(this, Integer.parseInt(scanner.next()));
                    continue;
                }
                if (clazz2 == Long.TYPE) {
                    field.set(this, Long.parseLong(scanner.next()));
                    continue;
                }
                if (clazz2 == Boolean.TYPE) {
                    field.set(this, Boolean.parseBoolean(scanner.next()));
                    continue;
                }
                if (clazz2 == Float.TYPE) {
                    field.set(this, Float.valueOf(Float.parseFloat(scanner.next())));
                    continue;
                }
                if (clazz2 == Double.TYPE) {
                    field.set(this, Double.parseDouble(scanner.next()));
                    continue;
                }
                if (clazz2 == Short.TYPE) {
                    field.set(this, Short.parseShort(scanner.next()));
                    continue;
                }
                if (clazz2 == Byte.TYPE) {
                    field.set(this, Byte.parseByte(scanner.next()));
                    continue;
                }
                if (clazz2 == String.class) {
                    object = scanner.next();
                    while (scanner.hasNext()) {
                        object = (String)object + " " + scanner.next();
                    }
                    field.set(this, object);
                    continue;
                }
                if (clazz2 == int[].class) {
                    object = (int[])field.get(this);
                    objectArray = new int[((Object)object).length];
                    for (n = 0; n < ((String[])object).length; ++n) {
                        objectArray[n] = Integer.parseInt(scanner.next());
                    }
                    if (scanner.hasNext()) {
                        throw new IllegalArgumentException("Too many values");
                    }
                    n = 0;
                    while (true) {
                        if (n >= ((String[])object).length) continue block15;
                        object[n] = (String)objectArray[n];
                        ++n;
                    }
                }
                if (clazz2 == float[].class) {
                    object = (float[])field.get(this);
                    objectArray = new float[((Object)object).length];
                    for (n = 0; n < ((String[])object).length; ++n) {
                        objectArray[n] = (int)Float.parseFloat(scanner.next());
                    }
                    if (scanner.hasNext()) {
                        throw new IllegalArgumentException("Too many values");
                    }
                    n = 0;
                    while (true) {
                        if (n >= ((String[])object).length) continue block15;
                        object[n] = (String)objectArray[n];
                        ++n;
                    }
                }
                if (clazz2 == String[].class) {
                    object = (String[])field.get(this);
                    objectArray = new String[((String[])object).length];
                    for (n = 0; n < ((String[])object).length; ++n) {
                        objectArray[n] = (int)scanner.next();
                    }
                    if (scanner.hasNext()) {
                        throw new IllegalArgumentException("Too many values");
                    }
                    n = 0;
                    while (true) {
                        if (n >= ((String[])object).length) continue block15;
                        object[n] = (String)objectArray[n];
                        ++n;
                    }
                }
                logger.severe("Unknown type for field " + string2);
            }
            catch (SecurityException securityException) {
                logger.severe("Security exception for property " + string2 + " (" + securityException.getMessage() + ")");
            }
            catch (NoSuchFieldException noSuchFieldException) {
                logger.warning("No such property: " + string2 + " (" + noSuchFieldException.getMessage() + ")");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.severe("Illegal argument: " + string2 + " (" + illegalArgumentException.getMessage() + ")");
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.severe("Illegal access: " + string2 + " (" + illegalAccessException.getMessage() + ")");
            }
            catch (NoSuchElementException noSuchElementException) {
                logger.severe("Value missing for: " + string2 + " (" + noSuchElementException.getMessage() + ")");
            }
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, iOException.toString(), iOException);
        }
    }

    protected void writeToFile(String string) throws IOException, IllegalArgumentException, IllegalAccessException {
        Field[] fieldArray;
        Class<?> clazz = this.getClass();
        logger.info("Writing " + clazz.getSimpleName() + " to file " + string);
        File file = new File(string);
        FileWriter fileWriter = new FileWriter(file);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        printWriter.println("VERSION 1.3.4");
        for (Field field : fieldArray = clazz.getFields()) {
            int n;
            Object[] objectArray;
            if (Modifier.isFinal(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            if (field.getType() == int[].class) {
                printWriter.print(field.getName());
                objectArray = (int[])field.get(this);
                for (n = 0; n < objectArray.length; ++n) {
                    printWriter.print(" " + objectArray[n]);
                }
                printWriter.println();
                continue;
            }
            if (field.getType() == float[].class) {
                printWriter.print(field.getName());
                objectArray = (float[])field.get(this);
                for (n = 0; n < objectArray.length; ++n) {
                    printWriter.print(" " + objectArray[n]);
                }
                printWriter.println();
                continue;
            }
            if (field.getType() == String[].class) {
                printWriter.print(field.getName());
                objectArray = (String[])field.get(this);
                for (n = 0; n < objectArray.length; ++n) {
                    printWriter.print(" " + (String)objectArray[n]);
                }
                printWriter.println();
                continue;
            }
            printWriter.println(field.getName() + " " + field.get(this).toString());
        }
        printWriter.flush();
    }
}

