/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule;

import com.turborilla.mule.model.map.PlanetTile;
import java.util.Random;

public strictfp final class MuleMath {
    public static int closest(int n, int n2) {
        int n3 = n % n2;
        if (n3 <= n2 / 2) {
            return n - n3;
        }
        return n + n2 - n3;
    }

    public static int clamp(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    public static float clamp(float f, float f2, float f3) {
        if (f < f2) {
            return f2;
        }
        if (f > f3) {
            return f3;
        }
        return f;
    }

    public static float progress(float f, float f2, float f3) {
        return (f3 - f) / (f2 - f);
    }

    public static float interpolate(float f, float f2, float f3) {
        return f * f3 + (1.0f - f3) * f2;
    }

    public static float normalDistributed(Random random) {
        float f = 0.0f;
        for (int i = 0; i < 12; ++i) {
            f += random.nextFloat();
        }
        return f -= 6.0f;
    }

    public static boolean equals(float f, float f2, float f3) {
        return Math.abs(f - f2) < f3;
    }

    public static int pow(int n, int n2) {
        int n3 = 1;
        while (n2 != 0) {
            if ((n2 & 1) != 0) {
                n3 *= n;
            }
            n2 >>= 1;
            n *= n;
        }
        return n3;
    }

    public static float distanceSquare(float f, float f2, float f3, float f4) {
        float f5 = f - f3;
        float f6 = f2 - f4;
        return f5 * f5 + f6 * f6;
    }

    public static int tileDistance(PlanetTile planetTile, PlanetTile planetTile2) {
        return Math.abs(planetTile.getPosX() - planetTile2.getPosX()) + Math.abs(planetTile.getPosY() - planetTile2.getPosY());
    }
}

