/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule;

import com.turborilla.mule.MuleMath;
import com.turborilla.mule.Properties;
import com.turborilla.mule.ai.CrystiteDeduction;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.map.PlanetTile;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import lpsolve.LpSolve;
import lpsolve.LpSolveException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MuleLP {
    public static int maxLength = 2048;
    public static int[] IdentityMask = new int[maxLength];
    public static double[] ConstantOneConstraint = new double[maxLength];
    protected LpSolve lp;
    protected TreeMap<PlanetTile, Integer> tileIndex;
    protected int status = -1;
    protected double[] row = new double[maxLength];
    protected int[] colMask = new int[maxLength];
    protected boolean[] Bvars = new boolean[maxLength];
    protected double[] Dvars = new double[maxLength];
    private boolean doIuseEOS = false;
    private boolean doIuseLCT = false;

    public MuleLP() {
        this.tileIndex = new TreeMap();
    }

    public boolean useEOS() {
        return this.doIuseEOS;
    }

    public boolean useLCT() {
        return this.doIuseLCT;
    }

    protected int numTiles() {
        return this.tileIndex.size();
    }

    protected Set<PlanetTile> getTiles() {
        return this.tileIndex.keySet();
    }

    protected int numVariables() {
        int n = 4 * this.numTiles();
        if (this.doIuseEOS) {
            n += 4 * this.numTiles();
        }
        if (this.doIuseLCT) {
            n += 4 * (this.numTiles() / 3);
        }
        return n;
    }

    protected boolean makeNewLP(Collection<PlanetTile> collection, boolean bl, boolean bl2) {
        this.tileIndex.clear();
        int n = 0;
        for (PlanetTile planetTile : collection) {
            this.tileIndex.put(planetTile, n++);
        }
        this.doIuseEOS = bl;
        this.doIuseLCT = bl2;
        int n2 = this.numVariables();
        try {
            if (this.lp != null) {
                this.lp.deleteLp();
            }
            this.lp = LpSolve.makeLp(0, n2);
            if (Properties.mule.debugLP) {
                this.makeNames();
            } else {
                this.lp.setVerbose(3);
            }
        }
        catch (LpSolveException lpSolveException) {
            System.err.println("Error in MuleLP.makeNewLP: " + lpSolveException.toString());
            return false;
        }
        return true;
    }

    protected int solveLP(int n) throws LpSolveException {
        int n2 = 259;
        if (!Properties.mule.debugLP) {
            this.lp.setPresolve(n2 | this.lp.getPresolve(), 0);
        }
        this.lp.setTimeout(n);
        return this.lp.solve();
    }

    protected int getColIndex(PlanetTile planetTile, Resource resource) {
        return 4 * this.tileIndex.get(planetTile) + resource.ordinal() + 1;
    }

    protected int getEOSIndex(PlanetTile planetTile, Resource resource) {
        return 4 * this.numTiles() + this.getColIndex(planetTile, resource);
    }

    protected int getLCTIndex(Resource resource, int n) {
        return (this.doIuseEOS ? 8 : 4) * this.numTiles() + 4 * (n - 1) + resource.ordinal() + 1;
    }

    public boolean[] getSolutionVector(int n) throws LpSolveException {
        int n2;
        for (n2 = 0; n2 < maxLength; ++n2) {
            this.Bvars[n2] = false;
            this.Dvars[n2] = 0.0;
        }
        this.lp.getVariables(this.Dvars);
        n2 = this.lp.getNrows();
        int n3 = 1;
        int n4 = this.lp.getOrigIndex(n2 + n3);
        while (n4 > 0 && n3 <= this.lp.getNcolumns()) {
            this.Bvars[n4 - 1] = this.Dvars[n3 - 1] > 0.0;
            n4 = this.lp.getOrigIndex(n2 + ++n3);
        }
        return this.Bvars;
    }

    protected boolean isFeasible(double[] dArray) throws LpSolveException {
        int n = this.lp.getNcolumns();
        int n2 = this.lp.getNrows();
        boolean bl = true;
        block5: for (int i = 1; bl && i <= n2; ++i) {
            switch (this.lp.getConstrType(i)) {
                case 1: {
                    bl = this.lp.getConstrValue(i, n, dArray, IdentityMask) <= this.lp.getRh(i);
                    continue block5;
                }
                case 2: {
                    bl = this.lp.getConstrValue(i, n, dArray, IdentityMask) >= this.lp.getRh(i);
                    continue block5;
                }
                case 3: {
                    bl = this.lp.getConstrValue(i, n, dArray, IdentityMask) == this.lp.getRh(i);
                }
            }
        }
        return bl;
    }

    public double[] getVectorFromMap(Collection<PlanetTile> collection, Map<PlanetTile, Resource> map) throws LpSolveException {
        for (int i = 0; i < maxLength; ++i) {
            this.Dvars[i] = 0.0;
        }
        for (PlanetTile planetTile : collection) {
            Object object = map.get(planetTile);
            if (object == null) continue;
            this.Dvars[this.getColIndex((PlanetTile)planetTile, (Resource)((Object)object)) - 1] = 1.0;
        }
        if (this.doIuseEOS) {
            for (PlanetTile planetTile : collection) {
                for (PlanetTile planetTile2 : collection) {
                    Resource resource = map.get(planetTile);
                    Resource resource2 = map.get(planetTile2);
                    if (resource == null || resource2 == null || MuleMath.tileDistance(planetTile, planetTile2) != 1 || resource != resource2) continue;
                    this.Dvars[this.getEOSIndex((PlanetTile)planetTile, (Resource)resource) - 1] = 1.0;
                }
            }
        }
        if (this.doIuseLCT) {
            int n;
            Object object = new int[4];
            for (n = 0; n < 4; ++n) {
                object[n] = false;
            }
            for (n = 0; n < this.numTiles(); ++n) {
                for (int i = 0; i < 4; ++i) {
                    if (!(this.Dvars[4 * n + i] > 0.0)) continue;
                    Object object2 = object;
                    int n2 = i;
                    object2[n2] = object2[n2] + true;
                }
            }
            for (Resource resource : Resource.values()) {
                reference var8_15 = object[resource.ordinal()] / 3;
                if (var8_15 <= 0) continue;
                this.Dvars[this.getLCTIndex((Resource)resource, (int)var8_15) - 1] = 1.0;
            }
        }
        return this.Dvars;
    }

    protected void makeNames() throws LpSolveException {
        int n;
        Resource resource;
        int n2;
        int n3;
        Resource[] resourceArray;
        for (PlanetTile resourceArray2 : this.getTiles()) {
            resourceArray = Resource.values();
            n3 = resourceArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                resource = resourceArray[n2];
                n = this.getColIndex(resourceArray2, resource);
                this.lp.setColName(n, resource.name().substring(0, 1) + (int)Math.ceil(0.25 * (double)n));
            }
        }
        if (this.doIuseEOS) {
            for (PlanetTile planetTile : this.getTiles()) {
                resourceArray = Resource.values();
                n3 = resourceArray.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    resource = resourceArray[n2];
                    n = this.getColIndex(planetTile, resource);
                    this.lp.setColName(n + 4 * this.numTiles(), resource.name().substring(0, 1) + "B" + (int)Math.ceil(0.25 * (double)n));
                }
            }
        }
        if (this.doIuseLCT) {
            for (int i = 0; i < this.numTiles() / 3; ++i) {
                for (Resource resource2 : Resource.values()) {
                    this.lp.setColName(this.getLCTIndex(resource2, i + 1), resource2.name().substring(0, 1) + "L" + (i + 1));
                }
            }
        }
    }

    protected void makeIP() throws LpSolveException {
        int n;
        for (n = 0; n < 4 * this.numTiles(); ++n) {
            this.lp.setInt(n + 1, true);
        }
        for (n = 8 * this.numTiles(); n < this.lp.getNcolumns(); ++n) {
            this.lp.setInt(n + 1, true);
        }
    }

    protected void makeTimeConstraints(int n, int n2, int n3) throws LpSolveException {
        int n4 = 0;
        for (PlanetTile planetTile : this.getTiles()) {
            if (planetTile.isEmpty()) continue;
            this.colMask[n4++] = this.getColIndex(planetTile, planetTile.getFactory().getResource());
        }
        this.lp.addConstraintex(n4, ConstantOneConstraint, this.colMask, 2, n4 - n);
        n4 = 0;
        for (PlanetTile planetTile : this.getTiles()) {
            if (!planetTile.isEmpty()) continue;
            for (Resource resource : Resource.values()) {
                this.colMask[n4++] = this.getColIndex(planetTile, resource);
            }
        }
        this.lp.addConstraintex(n4, ConstantOneConstraint, this.colMask, 1, n2);
        n4 = 0;
        for (PlanetTile planetTile : this.getTiles()) {
            for (Resource resource : Resource.values()) {
                if (PlanetTile.getResourceFromTile(planetTile) == resource) continue;
                this.colMask[n4++] = this.getColIndex(planetTile, resource);
            }
        }
        this.lp.addConstraintex(n4, ConstantOneConstraint, this.colMask, 1, n3);
    }

    protected void makeTileConstraints() throws LpSolveException {
        for (PlanetTile planetTile : this.getTiles()) {
            for (Resource resource : Resource.values()) {
                this.colMask[resource.ordinal()] = this.getColIndex(planetTile, resource);
            }
            this.lp.addConstraintex(4, ConstantOneConstraint, this.colMask, 1, 1.0);
        }
        if (this.doIuseEOS) {
            this.makeEOSConstraints();
        }
        if (this.doIuseLCT) {
            this.makeLCTConstraints();
        }
    }

    protected void makeResourceThresholdConstraint(Resource resource, int n, CrystiteDeduction crystiteDeduction, boolean bl) throws LpSolveException {
        for (int i = 0; i < maxLength; ++i) {
            this.row[i] = 0.0;
        }
        for (PlanetTile planetTile : this.getTiles()) {
            this.row[this.getColIndex((PlanetTile)planetTile, (Resource)resource) - 1] = resource == Resource.Crystite ? crystiteDeduction.getDeduction(planetTile) : planetTile.getYieldPotential(resource);
            if (!this.doIuseEOS) continue;
            this.row[this.getEOSIndex((PlanetTile)planetTile, (Resource)resource) - 1] = 1.0;
        }
        if (this.doIuseLCT) {
            for (int i = 0; i < this.numTiles() / 3; ++i) {
                this.row[this.getLCTIndex((Resource)resource, (int)(i + 1)) - 1] = 3 * (i + 1) * (i + 1);
            }
        }
        this.lp.addConstraintex(this.numVariables(), this.row, IdentityMask, bl ? 2 : 1, n);
    }

    protected void makeEnergyConstraint(int n) throws LpSolveException {
        int n2 = 0;
        for (PlanetTile planetTile : this.getTiles()) {
            for (Resource resource : Resource.values()) {
                if (resource == Resource.Energy) continue;
                this.colMask[n2++] = this.getColIndex(planetTile, resource);
            }
        }
        this.lp.addConstraintex(n2, ConstantOneConstraint, this.colMask, 1, n);
    }

    protected void makeRiverConstraints() throws LpSolveException {
        for (PlanetTile planetTile : this.getTiles()) {
            if (planetTile.getYieldPotential(Resource.Food) != 4) continue;
            this.colMask[0] = this.getColIndex(planetTile, Resource.Crystite);
            this.lp.addConstraintex(1, ConstantOneConstraint, this.colMask, 3, 0.0);
            this.colMask[0] = this.getEOSIndex(planetTile, Resource.Crystite);
            this.lp.addConstraintex(1, ConstantOneConstraint, this.colMask, 3, 0.0);
            this.colMask[0] = this.getColIndex(planetTile, Resource.Smithore);
            this.lp.addConstraintex(1, ConstantOneConstraint, this.colMask, 3, 0.0);
            this.colMask[0] = this.getEOSIndex(planetTile, Resource.Smithore);
            this.lp.addConstraintex(1, ConstantOneConstraint, this.colMask, 3, 0.0);
        }
    }

    protected void makeFutureEnergyConstraint(int n) throws LpSolveException {
        for (int i = 0; i < maxLength; ++i) {
            this.row[i] = i < 4 * this.numTiles() ? -1 : 0;
        }
        for (PlanetTile planetTile : this.getTiles()) {
            this.row[this.getColIndex((PlanetTile)planetTile, (Resource)Resource.Energy) - 1] = planetTile.getYieldPotential(Resource.Energy);
            if (!this.doIuseEOS) continue;
            this.row[this.getEOSIndex((PlanetTile)planetTile, (Resource)Resource.Energy) - 1] = 1.0;
        }
        if (this.doIuseLCT) {
            for (int i = 0; i < this.numTiles() / 3; ++i) {
                this.row[this.getLCTIndex((Resource)Resource.Energy, (int)(i + 1)) - 1] = 3 * (i + 1) * (i + 1);
            }
        }
        this.lp.addConstraintex(this.numVariables(), this.row, IdentityMask, 2, n);
    }

    protected void makeMuleConstraint(int n) throws LpSolveException {
        int n2 = 0;
        for (PlanetTile planetTile : this.getTiles()) {
            if (planetTile.isEmpty()) continue;
            ++n2;
        }
        this.lp.addConstraintex(4 * this.numTiles(), ConstantOneConstraint, IdentityMask, 1, n2 + n);
    }

    protected void makeMoneyConstraint(int n, int n2) throws LpSolveException {
        int n3 = 0;
        for (PlanetTile planetTile : this.getTiles()) {
            if (!planetTile.isEmpty()) {
                n3 += planetTile.getFactory().getResource().equipmentCost + n;
            }
            for (Resource resource : Resource.values()) {
                this.row[this.getColIndex((PlanetTile)planetTile, (Resource)resource) - 1] = resource.equipmentCost + n;
            }
        }
        this.lp.addConstraintex(4 * this.numTiles(), this.row, IdentityMask, 1, n3 + n2);
    }

    private void makeEOSConstraints() throws LpSolveException {
        for (PlanetTile planetTile : this.getTiles()) {
            for (Resource resource : Resource.values()) {
                this.row[0] = 1.0;
                this.row[1] = -1.0;
                this.colMask[0] = this.getColIndex(planetTile, resource);
                this.colMask[1] = this.getEOSIndex(planetTile, resource);
                this.lp.addConstraintex(2, this.row, this.colMask, 2, 0.0);
            }
        }
        for (PlanetTile planetTile : this.getTiles()) {
            for (Resource resource : Resource.values()) {
                int n = 0;
                for (PlanetTile planetTile2 : this.getTiles()) {
                    if (MuleMath.tileDistance(planetTile, planetTile2) != 1) continue;
                    this.row[n] = 1.0;
                    this.colMask[n++] = this.getColIndex(planetTile2, resource);
                }
                this.row[n] = -1.0;
                this.colMask[n++] = this.getEOSIndex(planetTile, resource);
                this.lp.addConstraintex(n, this.row, this.colMask, 2, 0.0);
            }
        }
    }

    private void makeLCTConstraints() throws LpSolveException {
        int n = 0;
        for (int i = 0; i < this.numTiles() / 3; ++i) {
            Resource[] resourceArray = Resource.values();
            int n2 = resourceArray.length;
            for (int j = 0; j < n2; ++j) {
                Resource resource = resourceArray[j];
                n = 0;
                for (PlanetTile planetTile : this.getTiles()) {
                    this.row[n] = 1.0;
                    this.colMask[n++] = this.getColIndex(planetTile, resource);
                }
                this.row[n] = -3 * (i + 1);
                this.colMask[n++] = this.getLCTIndex(resource, i + 1);
                this.lp.addConstraintex(n, this.row, this.colMask, 2, 0.0);
            }
        }
        for (Resource resource : Resource.values()) {
            n = 0;
            for (int i = 0; i < this.numTiles() / 3; ++i) {
                this.colMask[n++] = this.getLCTIndex(resource, i + 1);
            }
            this.lp.addConstraintex(n, ConstantOneConstraint, this.colMask, 1, 1.0);
        }
    }

    static {
        for (int i = 0; i < maxLength; ++i) {
            MuleLP.IdentityMask[i] = i + 1;
            MuleLP.ConstantOneConstraint[i] = 1.0;
        }
    }
}

