/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule;

import com.turborilla.mule.LogHandler;
import com.turborilla.mule.MuleException;
import com.turborilla.mule.Properties;
import com.turborilla.mule.Settings;
import com.turborilla.mule.Updater;
import com.turborilla.mule.frame.Login;
import com.turborilla.mule.frame.MetaFrame;
import com.turborilla.mule.frame.MuleSecurityManager;
import com.turborilla.mule.frame.SubstanceLoader;
import com.turborilla.mule.model.GameInfo;
import com.turborilla.mule.model.GameMode;
import com.turborilla.mule.model.UserInfo;
import com.turborilla.mule.network.MasterClient;
import com.turborilla.mule.sound.SoundPlayer;
import com.turborilla.mule.view.MuleGameContainer;
import com.turborilla.mule.view.SlickLogSystem;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import lpsolve.LpSolve;
import lpsolve.VersionInfo;
import org.lwjgl.Sys;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.util.Log;

public class Main {
    private static Login login = null;
    private static MetaFrame metaFrame = null;
    private static boolean errorDone;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(final String[] stringArray) {
        String string;
        Object object;
        String string2;
        Object object2;
        Object object3;
        try {
            LogHandler.setLogFile("log_init.txt", null);
            Properties.create();
            Settings.create();
            Updater.updateLauncher();
            Main.init();
            Main.initLWJGL();
        }
        catch (Throwable throwable) {
            object3 = Logger.getLogger("mule");
            object2 = Main.logError(throwable, (Logger)object3);
            Main.showErrorAndWait(null, (String)object2);
            System.exit(-1);
        }
        Logger logger = Logger.getLogger("mule");
        Log.setLogSystem(new SlickLogSystem());
        try {
            object3 = LpSolve.lpSolveVersion();
            logger.info("lpSolve: " + ((VersionInfo)object3).getMajorversion() + "." + ((VersionInfo)object3).getMinorversion() + " Release " + ((VersionInfo)object3).getRelease() + " Build " + ((VersionInfo)object3).getBuild());
            LpSolve.makeLp(0, 0);
        }
        catch (Throwable throwable) {
            Main.logError(throwable, logger);
            logger.warning("Disabling Adam's AI");
            Properties.mule.useAdamAI = false;
        }
        object3 = new MasterClient();
        object2 = null;
        if (stringArray.length == 0) {
            try {
                SwingUtilities.invokeAndWait(new Runnable((MasterClient)object3, logger){
                    final /* synthetic */ MasterClient val$masterClient;
                    final /* synthetic */ Logger val$logger;
                    {
                        this.val$masterClient = masterClient;
                        this.val$logger = logger;
                    }

                    public void run() {
                        try {
                            Main.login = new Login(this.val$masterClient);
                        }
                        catch (Throwable throwable) {
                            Main.logError(throwable, this.val$logger);
                            throw new RuntimeException(throwable);
                        }
                    }
                });
                try {
                    SoundPlayer.initialize(Settings.get().soundOn);
                    if (Settings.get().playLoginMusic) {
                        SoundPlayer.get().playIntoTheme();
                    }
                }
                catch (SlickException slickException) {
                    string2 = Main.logError(slickException, logger);
                    Main.showErrorAndWait(null, string2);
                    System.exit(-1);
                }
                login.run();
                if (Settings.get().playLoginMusic) {
                    SoundPlayer.get().stopIntroTheme();
                }
                if (login.isClosed()) {
                    logger.info("Login was closed. Exiting program.");
                    SoundPlayer.get().shutdown();
                    ((MasterClient)object3).close();
                    Updater.updateLauncher();
                    login.dispose();
                    return;
                }
                object2 = login.getUserInfo();
            }
            catch (Throwable throwable) {
                string2 = Main.logError(throwable, logger);
                Main.showErrorAndWait(null, string2);
                System.exit(-1);
            }
        } else {
            try {
                SoundPlayer.initialize(Settings.get().soundOn);
            }
            catch (SlickException slickException) {
                string2 = Main.logError(slickException, logger);
                Main.showErrorAndWait(null, string2);
                System.exit(-1);
            }
            ((MasterClient)object3).close();
            object2 = new UserInfo(stringArray[2], stringArray[2], "", 0L, Properties.mule.debugRace);
        }
        try {
            object = object2;
            SwingUtilities.invokeAndWait(new Runnable((MasterClient)object3, (UserInfo)object){
                final /* synthetic */ MasterClient val$masterClient;
                final /* synthetic */ UserInfo val$finalUserInfo;
                {
                    this.val$masterClient = masterClient;
                    this.val$finalUserInfo = userInfo;
                }

                public void run() {
                    Main.metaFrame = new MetaFrame(this.val$masterClient, this.val$finalUserInfo);
                }
            });
        }
        catch (Throwable throwable) {
            string2 = Main.logError(throwable, logger);
            SoundPlayer.get().shutdown();
            Main.showErrorAndWait(null, string2);
            System.exit(-1);
        }
        if (login != null) {
            login.dispose();
        }
        Updater.updateLauncher();
        System.gc();
        object = null;
        try {
            logger.info("Creating game container");
            object = new MuleGameContainer("Planet M.U.L.E.", metaFrame);
        }
        catch (Throwable throwable) {
            string = Main.logError(throwable, logger);
            Main.showErrorAndWait(metaFrame.getFrame(), string);
            System.exit(-1);
        }
        metaFrame.setMuleContainer((MuleGameContainer)object);
        logger.info("Entering game loop");
        LogHandler.setLogFile("log.txt", "log_init.txt");
        if (stringArray.length > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String string = stringArray[0];
                    boolean bl = string.equals("server");
                    if (bl) {
                        string = "localhost";
                    }
                    boolean bl2 = Boolean.parseBoolean(stringArray[1]);
                    boolean bl3 = true;
                    Properties.mule.debugAutoJoin = !bl2;
                    String string2 = bl ? Settings.get().mapSkin : null;
                    GameInfo gameInfo = new GameInfo(string, "Auto-0001", "AutoGame", GameMode.TRAINING, Properties.mule.debugSingleDevelopment, Properties.mule.debugRiver, Properties.mule.debugDeserts, Properties.mule.debugLastRound, bl3, string2);
                    metaFrame.debugStartGame(bl, gameInfo);
                }
            });
        }
        while (!metaFrame.isDone()) {
            if (metaFrame.isStartGame()) {
                try {
                    ((MuleGameContainer)object).init((MasterClient)object3);
                    ((MuleGameContainer)object).run();
                    ((MuleGameContainer)object).release();
                    metaFrame.finishGame();
                    continue;
                }
                catch (Throwable throwable) {
                    string = Main.logError(throwable, logger);
                    ((MasterClient)object3).sendLog(0L, "error", "log.txt");
                    throwable.printStackTrace();
                    try {
                        if (!((MuleGameContainer)object).hasStopped()) {
                            metaFrame.stopGame();
                            ((MuleGameContainer)object).release();
                        }
                    }
                    catch (Throwable throwable2) {
                        Main.logError(throwable2, logger);
                    }
                    try {
                        metaFrame.finishGame();
                    }
                    catch (Throwable throwable3) {
                        Main.logError(throwable3, logger);
                    }
                    try {
                        ((MuleGameContainer)object).destroy();
                    }
                    catch (Throwable throwable4) {
                        Main.logError(throwable4, logger);
                    }
                    Main.showErrorAndWait(metaFrame.getFrame(), string);
                    ((MasterClient)object3).close();
                    logger.info("Exiting program after error");
                    System.exit(-1);
                    continue;
                }
                finally {
                    string2 = ((MuleGameContainer)object).getCloseString();
                    if (string2 == null) continue;
                    Main.showWarningLater(metaFrame.getFrame(), string2, "Game Closed");
                    continue;
                }
            }
            try {
                ((MuleGameContainer)object).standBy();
                metaFrame.refreshLobby();
                ((MasterClient)object3).receiveResponses();
                Thread.sleep(15L);
            }
            catch (InterruptedException interruptedException) {
                logger.log(Level.SEVERE, interruptedException.toString(), interruptedException);
            }
        }
        logger.info("Leaving game loop");
        ((MasterClient)object3).sendLogout();
        SoundPlayer.get().shutdown();
        ((MuleGameContainer)object).destroy();
        ((MasterClient)object3).close();
        metaFrame.dispose();
        Settings.get().saveToFile();
        logger.info("Main thread finished");
        System.exit(0);
    }

    private static void init() throws MuleException {
        try {
            Locale.setDefault(Locale.UK);
            MuleSecurityManager.use();
            SubstanceLoader.initLookAndFeel(Settings.get().windowSkin);
        }
        catch (Exception exception) {
            throw new MuleException(exception);
        }
    }

    private static void initLWJGL() throws MuleException {
        try {
            Sys.initialize();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            String string = "mule";
            String string2 = unsatisfiedLinkError.getMessage() + "\n";
            string2 = Properties.mule.os == 2 ? string2 + "Please start the game's application bundle " + string + ".app\n" : (Properties.mule.os == 3 ? string2 + "Please run " + string + ".sh to start the game.\n" : string2 + "Please use " + string + ".exe to start the game.\n");
            string2 = string2 + "If the problem persists, please reinstall the program.";
            throw new MuleException(string2);
        }
        catch (Throwable throwable) {
            throw new MuleException("Failed to initialize the display.\nPlease reinstall the program.\n" + throwable.toString());
        }
    }

    private static void showErrorAndWait(JFrame jFrame, String string) {
        try {
            errorDone = false;
            SwingUtilities.invokeLater(Main.errorRunnable(jFrame, string));
            while (!errorDone) {
                Thread.sleep(10L);
            }
        }
        catch (Throwable throwable) {
            Logger logger = Logger.getLogger("mule");
            logger.log(Level.SEVERE, throwable.toString(), throwable);
        }
    }

    private static Runnable errorRunnable(final JFrame jFrame, final String string) {
        return new Runnable(){

            public void run() {
                if (jFrame != null) {
                    jFrame.validate();
                }
                JOptionPane.showMessageDialog(jFrame, string, "Planet M.U.L.E. Error", 0);
                errorDone = true;
            }
        };
    }

    private static void showWarningLater(final JFrame jFrame, final String string, final String string2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (jFrame != null) {
                    jFrame.validate();
                }
                JOptionPane.showMessageDialog(jFrame, string, string2, 2);
            }
        });
    }

    private static String logError(Throwable throwable, Logger logger) {
        if (throwable instanceof InvocationTargetException) {
            InvocationTargetException invocationTargetException = (InvocationTargetException)throwable;
            Throwable throwable2 = invocationTargetException.getTargetException();
            logger.log(Level.SEVERE, throwable2.toString(), throwable2);
            logger.log(Level.SEVERE, invocationTargetException.toString(), invocationTargetException);
            return throwable2.getClass().getSimpleName() + "\n" + throwable2.getMessage();
        }
        logger.log(Level.SEVERE, throwable.toString(), throwable);
        return throwable.getClass().getSimpleName() + "\n" + throwable.getMessage();
    }
}

