/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogHandler
extends Handler {
    private ArrayList<PrintStream> outputs = new ArrayList();
    private ArrayList<PrintStream> errors = new ArrayList();

    public static void setLogFile(String string, String string2) {
        Handler[] handlerArray;
        Logger logger = Logger.getLogger("mule");
        for (Handler handler : handlerArray = logger.getHandlers()) {
            logger.removeHandler(handler);
            handler.close();
        }
        logger.setUseParentHandlers(false);
        logger.addHandler(new LogHandler(string, string2));
    }

    public LogHandler(String string, String string2) {
        try {
            PrintStream printStream = new PrintStream(string);
            this.outputs.add(printStream);
            this.errors.add(printStream);
            try {
                int n;
                File file = new File(string2);
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray = new byte[1024];
                while ((n = fileInputStream.read(byArray)) > 0) {
                    printStream.write(byArray, 0, n);
                }
                fileInputStream.close();
                printStream.println("++++++++ END OF INITIALIZATION +++++++++++++++++++++++++++++++++++++++++++");
            }
            catch (Exception exception) {
                Logger logger = Logger.getLogger("mule");
                logger.severe("Failed to copy log file " + exception.toString());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    @Override
    public void close() throws SecurityException {
        for (PrintStream printStream : this.outputs) {
            if (printStream == System.out) continue;
            printStream.close();
        }
        for (PrintStream printStream : this.errors) {
            if (printStream == System.err) continue;
            printStream.close();
        }
        this.outputs.clear();
        this.errors.clear();
    }

    @Override
    public void flush() {
        for (PrintStream printStream : this.outputs) {
            printStream.flush();
        }
        for (PrintStream printStream : this.errors) {
            printStream.flush();
        }
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (logRecord.getLevel() == Level.SEVERE) {
            for (PrintStream printStream : this.outputs) {
                printStream.flush();
            }
            this.printRecord(this.errors, logRecord);
            this.printThrowable(this.errors, logRecord.getThrown());
        } else if (logRecord.getLevel() == Level.WARNING) {
            this.printRecord(this.errors, logRecord);
            this.printThrowable(this.errors, logRecord.getThrown());
        } else {
            this.printRecord(this.outputs, logRecord);
            this.printThrowable(this.outputs, logRecord.getThrown());
        }
    }

    private void printRecord(ArrayList<PrintStream> arrayList, LogRecord logRecord) {
        for (PrintStream printStream : arrayList) {
            String string = logRecord.getSourceClassName();
            string = string.substring(string.lastIndexOf(46) + 1);
            printStream.printf("  %-50s %s\n", logRecord.getLevel().getName() + " [" + string + "." + logRecord.getSourceMethodName() + "]", logRecord.getMessage());
        }
    }

    private void printThrowable(ArrayList<PrintStream> arrayList, Throwable throwable) {
        if (throwable != null) {
            for (PrintStream printStream : arrayList) {
                for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                    printStream.printf("\t at %s\n", stackTraceElement.toString());
                }
                printStream.flush();
            }
        }
    }
}

