﻿# TASK CLASSES

init -30:

    python:
    
        def bubble(text):
        
            ui.frame(xpos=0.62, ypos=0.15, yanchor=0.0, style="bullepointe")
            ui.text(text, style="bulle", slow=True)
            ui.saybehavior()
            ui.interact()
        
        #
        
        def bubbleni(text): # no interruption
        
            ui.frame(xpos=0.62, ypos=0.15, yanchor=0.0, style="bullepointe")
            ui.text(text, style="bulle", slow=True, text_align=0.5)
            
#             ui.saybehavior()
#             ui.interact()
        
        #
        
        
        def showname(name):
            nbanner = renpy.display.layout.Window(Text(name, style="parch", size=25), style="banner")
            renpy.show("namebanner", [Position(xpos=.22, ypos=.85, xanchor=0.5, yanchor=0.5)], what=nbanner)
        #
        
        def movein(chara):
            renpy.show(chara.fbpic, [MoveEase((-.3, 1.0), (.22, 1.0), 0.5, mode="out", xanchor=.5, yanchor="bottom")])
            showname(chara.name)
#             renpy.pause(0.5)
            renpy.with(dissolve)
#             renpy.with(Pause(0.5))
        #
        def moveout(chara):
            renpy.show(chara.fbpic, [MoveEase((.22, 1.0), (-.3, 1.0), 0.5, mode="out", xanchor=.5, yanchor="bottom")])
            renpy.hide("namebanner")
#             renpy.pause(0.5)
            renpy.with(Pause(0.5))
        #
    
        class Task(object):
        
            def __init__(self, chara, name, xpfactor=5, xpcurve=1.5, xpreward=1, priority=1):
                self.chara = chara      # le personnage auquel cette tâche appartient (pour faire référence à son nom)
                self.name = name
#                 self.progress = 0       # sur un total de 100 ?   à moins qu'on compte en nombre de tours ?
                self.talent = 1
                self.exp = 0        # les points d'expérience pour cette tâche. Quand on atteint un montant déterminé, le talent augmente de 1 et le compteur exp repart de 0, avec un nouveau montant à atteindre plus élevé.
                self.texp = 0   # expérience temporaire pour les tests
                self.level = 1  # niveau de ce talent
                
                self.xpfactor = xpfactor    # valeur du facteur de la courbe de progression (voir nextLevel()). Si =5, il faut faire 5x la tâche avant de passer son premier niveau. xpcurve détermine ensuite à quel vitesse l'évolution ralentit.
                self.xpcurve = xpcurve      # valeur de puissance de la courbe de progression (voir nextLevel())
                self.xpreward = xpreward    # nombre de pts à rajouter au talent à chaque levelup
                
                self.priority = priority    # Permet de déterminer l'ordre de résolution des tâches dans la même journée (brew avant gather pour éviter de faire des potions avec des ingrédients qui ne sont censés être arrivés que le soir!)
                                            # Une priorité haute indique une tâche qui sera résolue avant les autres
                
                self.verrou = False     # si True, on ne peut pas éditer cette tâche
            #
            
            def sayTask(self):  # renvoie un text représentant la tâche en cours
                return "..."
            #
            
            def setBaseTalent(self, talent):
                self.talent = talent
                self.basetalent = talent    # référence pour connaître le niveau atteint
                                            # conséquence : un perso qui commence à 50 au lieu de 20 va quand même progresser aussi vite (mais ça représente bien un "don" inné)
            #
            
            #
            #
            def nextLevel(self, level=None):
                if debug==1 and expsystem==2:
                    if level==None:
                        level = self.level
                    return int(pow(level, self.xpcurve) * self.xpfactor)
                #
                else:
                    return int(pow((self.talent - self.basetalent + 1),self.xpcurve) * self.xpfactor - pow((self.talent - self.basetalent), self.xpcurve) * self.xpfactor)
                #
            #
            
            #   Rajoute les points d'expérience et fait éventuellement passer un niveau
            #   Renvoie true s'il y a eu une gain de niveau
            #
            def xpup(self, value=1):
                if debug==1 and expsystem==2:
                    self.exp += value
                    nextlevel = self.nextLevel()
                    renpy.log(self.chara.name+" next level : "+str(nextlevel))
                    if self.exp >= nextlevel:
                        self.talent += self.xpreward
                        self.level += 1
                        return True
                    #
                    return False
                else:
                    self.exp += value
                    nextlevel = self.nextLevel()
                    renpy.log(self.chara.name+" next level : "+str(nextlevel))
                    if self.exp >= nextlevel:
                        self.talent += self.xpreward
                        self.exp = 0
                        return True
                    #
                    return False
                #
            #
            
            # Only with the new EXP system : allows you to directly set a level of talent. The actual value of the talent will be computed
            # according to curve values and reward points.
            #
            def setLevel(self, level):
                self.level = level
                self.talent = self.basetalent + self.xpreward * (level-1)
            #
            
            #   Affiche la fenêtre du level up (talent + nouvelle valeur)
            #
            def showlevelup(self, amount=None):
                if amount == None:
                    amount = self.xpreward    
            
                renpy.sound.play(levelupm)
                renpy.transition(dissolve)
                ui.window()
                ui.vbox(box_spacing=10, box_first_spacing=15, xpos=.5, xanchor=.5)
                ui.text(self.name+ " level up !", xpos=.5, xanchor=.5)
                ui.text(str(self.talent)+" (+"+str(amount)+")", xpos=.5, xanchor=.5)
                ui.close()
                
                ui.saybehavior()
                ui.interact()
            #
            
            #   Calcule la hausse ou baisse de morale par rapport au talent utilisé.
            #   On utilise en fait une valeur associée au talent pour ce personnage.
            #   (peut-être à décliner pour chaque tâche afin de prendre en compte des choses
            #   comme le lieu où on cueille)
            #
            def workmorale(self):
                weekend = day%7 == 6 or day%7 == 0
                if weekend:
                    self.chara.moraledown(5)
                else:
                    self.chara.moraledown(2)
            #
            
            #   Renvoie le montant du salaire pour cette tâche
            #
            def getSalary(self):
                return int(self.chara.salaryfact * self.talent)
            #   
            
            #   Calcule le salaire par rapport au talent utilisé et tente de l'enlever aux fonds du magasin
            #   S'il n'y a pas assez, le pourcentage manquant détermine la perte de morale.
            #   S'il y a assez, petit boost au moral
            #   factor représente généralement le nombre de tours passés à une tâche (et donc multiplication du salaire)
            #
            def salary(self, factor=1):
                pay = self.getSalary()*factor
                realpay = magasin.forceUseMoney(pay)
                
                if realpay == pay:
                    self.chara.moraleup(1)
                #
                else:
                    self.chara.moraledown(int((pay-realpay)/pay*10))
                #
                
                return realpay
            #
            
            #   Affiche le salaire du jour et les éventuelles remarques.
            #   Ajoute éventuellement du contenu au message de la bulle. Renvoie l'éventuel ajout.
            #
            def displaySalary(self, salary):
                salarymsg = "Salary : "+str(salary)
                color = "#fff"
                res = ""
                if salary < self.getSalary():
                    salarymsg += " (couldn't pay "+str(self.getSalary())+")"
                    color = "#f00"
                    if salary == 0:
                        res += "\n\n" + self.chara.speak("salaryno")
                    #
                    else:
                        res += "\n\n" + self.chara.speak("salaryne")
                    #
                #
                ui.window(xpos=0.68, ypos=1.0, yanchor="bottom")
                ui.hbox(box_spacing=3)
                ui.text(salarymsg, size=14, color=color)
                ui.image("money.png")
                ui.close()
            
                return res
            #
            
            # Returns the current ability for the character, in this task.
            # Morale is used as a bonus or malus.
            def getAbility(self):
                return self.talent + ((self.talent * self.chara.morale) // 100)
            #
            
        
        #
        
        class DoNothing(Task):
            def __init__(self, chara):
                Task.__init__(self, chara, "None")
            #
            
            def sayTask(self):
                return "Nothing"
            #
            
            def solve(self):
            
                self.chara.moraleup(3)
            
                weekend = day%7 == 6 or day%7 == 0 
            
                if not weekend:
#                     renpy.transition(dissolve)
                    renpy.scene()
                    renpy.show("shop out")
                    movein(self.chara)
                    
                    ui.window(xpos=.68, ypos=1.0, yanchor="bottom")
                    ui.text("Morale +3", size=14)
                    
                    bubble(self.chara.speak("rest"))
                    moveout(self.chara)
                #
                
                    
            #
            
            def edit(self):
                return self
            #
        #
        
        
        class Occupied(Task):
            def __init__(self, chara, description):
                Task.__init__(self, chara, "Busy")
                self.desc = description
                self.verrou = True
            #
            
            def sayTask(self):
                return self.desc
            #
            
            def solve(self):
            
                pass
                    
            #
            
            def edit(self):
                return self
            #
        #
        
        
        #   panier des cueilleurs. Lot de IngQty.
        #
        class Panier(object):
        
            def __init__(self):
            
                self.content = []   # liste de IngQty
                self.capacity = 9999    # à limiter plus tard
            
            #
            
            # Renvoie la place actuellement occupée dans le panier
            #
            def getOccupation(self):
                occupied = 0
                for p in self.content:
                    occupied += p.qty
                #
                
                return occupied
            #
            
            def sort(self):
                self.content.sort(lambda x, y: cmp(x.ingredient.rarity, y.ingredient.rarity))
                self.content.reverse()
            #
            
            def clear(self):
                self.content = []
            #
            
            # ajoute l'ingrédient dans cette quantitée au panier
            # ingredient : un Ingredient
            #
            def add(self, ingredient, qty=1):
            
                surplus = self.getOccupation() + qty - self.capacity
                if surplus < 0:
                    surplus = 0
                realadd = qty - surplus
                
                found = -1
                
                renpy.log("Panier add "+ingredient.name+"... len content : "+str(len(self.content))+"  range : "+str(range(len(self.content))) )
                
                for i in range(len(self.content)):
                    if self.content[i].ingredient == ingredient:  # found it
                        renpy.log("Found "+ingredient.name)
                        found = i
                        break
                    #
                #
                
                if found == -1:
                    self.content.append(IngQty(ingredient, realadd))
                #
                else:
                    self.content[found].qty += realadd
                #
                
                return realadd
            
            #
            
            
            # enlève cette qté de l'ingrédient. Si la quantité n'est pas
            # précisée, tout le stock de cet ingrédient est enlevé.
            #
            # Renvoie True si l'opération s'est déroulée correctement.
            # Renvoie False s'il n'y a pas assez d'ingrédients (et n'effectue pas leur retrait!)
            #
            def remove(self, ingredient, qty=-1):   
                
                res = True
                
                renpy.log("Looking for "+ingredient.name+" in panier.")
                for i in self.content:
                    if i.ingredient == ingredient:
                        renpy.log(ingredient.name+" found.")
                        if i.qty >= qty:
                            i.qty -= qty
                        #
                        else:
                            res = False
                        #
                        break
                    #
                #
            
                return res
            
            #
            
        
        #
        
        class GatherCategory(object):
            
            def __init__(self, category, factor):
            
                self.category = category    # un objet IngCategory (pris de la structure ingcateg)
                self.factor = factor        # 2.0 : 2x meilleur que la moyenne dans cette catégorie
                                            # 0.0 : incapable de récolter ce type d'ingrédient
            
            #
        #
        
        class Gather(Task):
            def __init__(self, chara, talent, **properties):
                Task.__init__(self, chara, "Gather", priority=25, **properties)
                self.setBaseTalent(talent)    # la valeur d'aptitude à cette tâche
                self.location = None    # l'endroit où on va cueillir
                self.focus = None       # l'ingrédient sur lequel on focalise (None si pas de focus)
                self.parcouru = 0
                #self.going = True       # True = sens de l'aller; False = sens du retour
                self.panier = Panier()  # contient les ingrédients récupérés
                self.factors = []       # tableau des facteurs de récolte pour chaque catégorie d'ingrédient
            #
            
            #   Ajoute (ou modifie, si elle existe) le facteur de récolte d'une catégorie
            #   Plus le facteur est grand, plus le perso est fort dans ce domaine
            #
            def setFactor(self, category, factor):
                found = False
                for i in self.factors:
                    if i.category == category:
                        found = True
                        break
                    #
                #
                if not found:
                    self.factors.append(GatherCategory(category, factor))
                #
                else:
                    i.factor = factor
                #
            #
            
            def getFactor(self, category):
                found = False
                for i in self.factors:
                    if i.category == category:
                        found = True
                        break
                    #
                #
                if found:
                    return i.factor
                #
                else:
                    return 0.0
                #
            #
            
            def edit(self):     # fonction qui affiche l'interface nécessaire l'édition de la tâche. Renvoie self (ou False pour annuler l'édition).
                
                renpy.log("edit "+self.name)
            
                res = chooseGather(self)
                #res = showMap()
                
                if res <> False:
                    #self.location = res
                    return self
                #
                else:
                    return False
                #
            
                
            #
            
            def sayTask(self):
#                 if self.location == None:
#                     return "Nothing"
#                 #
                res = "Gathering at "+self.location.name
                if self.focus <> None:
                    res += " focusing on "+self.focus.name
                #
                if self.verrou:
                    if self.daysLeft() <= self.chara.vehicle.speed:
                        res += "\n(coming back today)"
                    #
                    else:
                        res += "\n("+str(self.daysLeft())+" day"+tern(self.daysLeft()>1,"s","")+" left)"
                    #
                #
                return res
            #
            
            def sayGathered(self, addedlist, lostlist, salary):
            
                if type(addedlist)==type(None) and type(lostlist)==type(None):
                    res = self.chara.speak("gatherno")
                #
                elif len(addedlist)==0 and len(lostlist)==0:
                    res = self.chara.speak("gatherhard")
                #
                else:
            
                    gatheredsum = sum([x.qty for x in addedlist])
                    lostsum = sum([x.qty for x in lostlist])
    
                    if gatheredsum > 0 and lostsum == 0:
                        res = self.chara.speak("gatherok")
                    #
                    elif gatheredsum > 0:
                        res = self.chara.speak("gatherneroom")
                    #
                    else:
                        res = self.chara.speak("gathernoroom")
                    #
                    
                    
                    if lostsum > 0:
                        res += " "+self.chara.speak("gatherlostqty", [("qty",str(lostsum))])
                    #
    
                    addedlist.sort(lambda x, y: cmp(x.ingredient.rarity, y.ingredient.rarity))
                    
                    rows = len(addedlist)//2 + len(addedlist)%2
                    ui.window(xpos=1.0, ypos=.65, xanchor="right")
                    ui.grid(2,rows, padding=15)
                    for i in addedlist:
                        ui.hbox(box_spacing=5)
                        ui.text(str(i.qty)+"x", ypos=.5, yanchor=.5)
                        ui.image(i.ingredient.picture)
                        ui.text("  "+i.ingredient.name, ypos=.5, yanchor=.5)
                        ui.close()
                    #
                    for i in range(2*rows - len(addedlist)):
                        ui.null()
                    #
                    ui.close()
                    
                    xpbonus = 0
                    for i in addedlist:
                        xpbonus += i.ingredient.rarity * i.qty
                    #
#                     ui.text(str(xpbonus), ypos=50)
#                     self.texp += xpbonus
#                     ui.text(str(self.texp), ypos=75)
                    
                #
                
                res += self.displaySalary(salary)                
                                
                bubble(res)
                
#                 renpy.checkpoint()
                
                return res
            #
            
            def daysLeft(self):
                left = (self.location.distance*2-self.parcouru)//self.chara.vehicle.speed
                if (self.location.distance*2-self.parcouru)%self.chara.vehicle.speed <> 0:
                    left = left+1
                return int(left)
            #
            
            def daysTotal(self):
                total = self.location.distance*2//self.chara.vehicle.speed
                if self.location.distance*2%self.chara.vehicle.speed <> 0:
                    total += 1
                return int(total)
            #
            
            def computeRarity(self, ability):
                raretotal = 0
                rarelist = []
                accessible = []
                for x in self.location.nests:
                    factor = self.getFactor(x.ingredient.category)
                    if factor == 0.0:
                        continue
                    val = x.getRarity()
                    val = val * (1/factor)
                    if self.focus <> None and x.ingredient == self.focus:
                        val = val/2
                    #
                    if debug==1:
                        renpy.log("Analyzing "+x.ingredient.name+" (val="+str(val)+" > "+str(ability))                    
                    if val > ability:
                        if debug==1:
                            renpy.log("Excluding "+x.ingredient.name)
                        continue
                    
                    raretotal += val
                    rarelist.append(val)
                    accessible.append(x.ingredient)
                #
                
                if len(rarelist) > 0:  # le cueilleur est incapable de récupérer les ingrédients de cet endroit
                    rarelist2 = [raretotal / x for x in rarelist]
                    
                    newtotal = sum(rarelist2)
                    
                    coef = 100.0/newtotal
                    
                    rarelist3 = [coef * x for x in rarelist2]
                    
                    raremeter = []
                    raresum = 0
                    
                    for i in rarelist3:
                        raremeter.append(i+raresum)
                        raresum += i
                    #
                    
                    if debug==1:
                        renpy.log("Rarevalue list:")
                        for index in range(len(rarelist)):
                            renpy.log(accessible[index].name+" : "+str(rarelist[index]))
                        #
                        renpy.log("Raremeter:")
                        for index in range(len(raremeter)):
                            renpy.log(accessible[index].name+" : "+str(raremeter[index]))
                        #
                    #
                #
                else:
                    raremeter = []
                #
                
                return (raretotal, rarelist, accessible, raremeter)
            #
            
            def solve(self):
            
#                 renpy.transition(dissolve)
                renpy.scene()
                renpy.show(self.location.bg)
                
                movein(self.chara) 
                
                self.workmorale()
                
                self.parcouru += self.chara.vehicle.speed
                
                if not self.parcouru >= self.location.distance*2:    # pas encore revenu
                    self.verrou = True
                    self.chara.loc = self.location
                    ui.window(xpos=.68, ypos=.5, xmaximum=300)
#                     stilltravel = self.location.distance*2-self.parcouru/float(self.chara.vehicle.speed)
#                     if stilltravel < 1:
#                         stilltravel=1
                    stilltravel = self.daysLeft()
                    ui.text(self.chara.name+" must still travel for "+str(stilltravel)+" day"+tern(stilltravel>1,"s","")+".", xalign=0.5, text_align=0.5)
                    ui.saybehavior()
                    ui.interact()
                    
                #
                else:   # jour du retour, calcul du Panier puis remise à zéro
                    renpy.log("Gathering results from "+self.location.name)
#                     raretotal = 0
#                     rarelist = []
#                     accessible = []
#                     for x in self.location.nests:
#                         factor = self.getFactor(x.ingredient.category)
#                         if factor == 0.0:
#                             continue
#                         val = x.getRarity()
#                         val = val * (1/factor)
#                         if self.focus <> None and x.ingredient == self.focus:
#                             val = val/2
#                         #
#                         if val > self.talent + self.chara.morale:
#                             continue
#                         
#                         raretotal += val
#                         rarelist.append(val)
#                         accessible.append(x.ingredient)
#                     #

                    ability = self.getAbility()
                    if ability < 0:
                        ability = 0
                    #

                    raretotal, rarelist, accessible, raremeter = self.computeRarity(ability)
                    
                    didgather = False
                    
                    if len(rarelist) == 0:  # le cueilleur est incapable de récupérer les ingrédients de cet endroit
                        addedlist = None
                        lostlist = None
                    #
                    else:
                    
                        didgather = True
                
                        renpy.random.seed()
                        
                        while ability > 0 and len(rarelist) > 0:
                            rn = renpy.random.random()*100.0
                            renpy.log("rn = "+str(rn))
                            for index in range(len(raremeter)):
                                if rn < raremeter[index]:
                                    renpy.log("gathered "+accessible[index].name)
                                    break
                                #
                            #
                            if self.focus == None or accessible[index] == self.focus:
                                self.panier.add(accessible[index], 1)
                            #
                            
                            ability -= rarelist[index]
                            
                            raretotal, rarelist, accessible, raremeter = self.computeRarity(ability)
                            
                            # eventuellement faire qu'on ne puisse plus récupérer que des ingrédients avec une rareté < à l'ability restante
                            # mais il faut également arrêter de boucler quand il n'y a plus d'ability suffisante pour quelque ingrédient que ce soit et quand il ne reste qu'un ingrédient encore choppable.
                        #
                        
        #                 fetched = int( ability // self.location.nests[0].getRarity() )
        
                        self.panier.sort()  # range les ingrédients les plus rares en premier
                        
                        addedlist = []
                        lostlist = []
                        
                        for i in self.panier.content:
                        
                            realadd = stock.add(i.ingredient, i.qty)
                            addedlist.append(IngQty(i.ingredient, realadd))
                            lostlist.append(IngQty(i.ingredient, i.qty - realadd))
                            
                        for i in addedlist: # rajoute les ingrédients ramenés dans la liste des ing connus
                            self.location.addKnown(i.ingredient)
                        #
                    #
                    
                    nturns = self.daysTotal()    # turns spent on the task according to distance and speed
                    salary = self.salary(nturns)

                                    
                    self.sayGathered(addedlist, lostlist, salary)
    
                    
                    self.panier.clear() # vide le panier
                    self.parcouru = 0   # on est de retour à la maison :)
                    self.verrou = False
                    self.chara.loc = home
                    
                    if didgather:
                        if debug==1 and expsystem==2:
                            xpbonus = 0
                            for i in addedlist:
                                xpbonus += i.ingredient.rarity * i.qty
                            #
                        #
                        else:
                            xpbonus=1
                        levelup = self.xpup(xpbonus)
                        if levelup:
                            self.showlevelup()
                    #
                #

                    
                #
                               
                
                
                moveout(self.chara)

            
            #
        #
        
        class Brew(Task):
            def __init__(self, chara, talent, **properties):
                Task.__init__(self, chara, "Brew", priority=50, **properties)
                self.setBaseTalent(talent)    # la valeur d'aptitude à cette tâche
                self.recette = None
                self.qty = 1
                
            #
            
            def edit(self):
                renpy.log("edit "+self.name)
                
                res = chooseRecipe(self.chara, self.talent)
                
                if res <> False:
                    self.recette = res
                    return self
                #
                else:
                    return False    # annule l'action
                #
                
                
            #
            
            def sayTask(self):
                if self.recette == None:
                    return "Brewing nothing (BUG)"    # cas normalement impossible
                #
                else:
                    return "Brewing "+self.recette.potion.name
                #
            #
            
            def solve(self):
            
#                 renpy.transition(dissolve)
                renpy.scene()
                renpy.show("alchemy")
                
                movein(self.chara)
                
                ability = self.getAbility()
                if ability < 0:
                    ability = 0
                #
                
                potionsmade = ability // self.recette.difficulty
                
                brewresult = self.recette.tryMaking(potionsmade, etalage.getFree(), self)
                
                state = brewresult[1]
                realmade = brewresult[0]
                
                renpy.log("state="+str(state))
                
                realadd = etalage.add(self.recette.potion, realmade)
                
                talk = "--Speech error--\nPlease report to the author"
                
                if realmade == 0:
                    if state==1:
#                         talk = "I couldn't brew any "+self.recette.potion.name+ " because we don't have enough ingredients. We should make sure to gather some more !"
                        talk = self.chara.speak("brewnoing", [('name',self.recette.potion.name)])
                    elif state==2:
#                         talk = "I would have made some "+self.recette.potion.name+" but there is no room left in the shelves!"
                        talk = self.chara.speak("brewnoroom", ['name', self.recette.potion.name])
                    elif state==3:  # not enough ability
                        # HOTFIX... Will need to add speech tokens for this
                        talk = "I just... can't do this. I may need some rest."
                    #
                #
#                 elif realmade <> potionsmade and realadd <> realmade: # not enough ingr. and not enough room
#                     talk = "I could only brew "+ str(realmade)+ " " +self.recette.potion.name+ " because we don't have enough ingredients and I could only put "+str(realadd)+" of them on the shelves : they're full. What a waste !"
#                 #
                elif state==1:   # not enough ingr.
#                     talk = "I could only brew "+ str(realmade)+ " " +self.recette.potion.name+ " because we don't have enough ingredients."
                    talk = self.chara.speak("brewneing", [('qty', str(realmade)), ('name', self.recette.potion.name)])
                #
                elif state==2:   # not enough room
#                     talk = "I could have done more potions but there was only room left for "+str(realadd)+" of them on the shelves. What a waste of time !"
                    talk = self.chara.speak("brewneroom", [('qty', str(realmade)), ('name', self.recette.potion.name)])
                #
                
                else:   # everything's okay
                    talk = self.chara.speak("brewok")
                #
                
                renpy.log("speech:"+talk)
                
                ui.window(xpos=0.68, ypos=.45)
                if realadd > 0:
                    ui.hbox(box_spacing=5)
                    ui.text(str(realadd)+"x", ypos=.5, yanchor=.5)
                    ui.image(self.recette.potion.pic, ypos=.5, yanchor=.5)
                    ui.text(self.recette.potion.name, ypos=.5, yanchor=.5)
                    ui.close()
                else:
                    ui.text("Nothing", color=(255,75,75,255))
                #
                
                if realmade > 0:
                    ui.window(xpos=0.68, ypos=.70)
                    ui.vbox(box_first_spacing=15, box_spacing=10)
                    
                    ui.hbox(box_spacing=10, xpos=.5, xanchor=.5)
                    ui.text("Used : ", ypos=.5, yanchor=.5)
                    for i in self.recette.needed:
                        ui.hbox(box_spacing=5)
                        ui.text(str(i.qty*realmade), ypos=.5, yanchor=.5)
                        ui.image(i.ingredient.picture, ypos=.5, yanchor=.5)
                        ui.close()
                    #
                    ui.close()
                    
                    ui.hbox(box_spacing=10, xpos=.5, xanchor=.5)
                    ui.text("Left : ", ypos=.5, yanchor=.5)
                    for i in self.recette.needed:
                        ui.hbox(box_spacing=5)
                        leftqty = stock.getQty(i.ingredient)
                        if leftqty > 0:
                            ui.text(str(leftqty), ypos=.5, yanchor=.5)
                        else:
                            ui.text(str(leftqty), ypos=.5, yanchor=.5, color="#f33")
                        #
                        ui.image(i.ingredient.picture, ypos=.5, yanchor=.5)
                        ui.close()
                    #
                    ui.close()
                    
                    canbemade = self.recette.canBeMade()
                    if canbemade > 0:
                        ui.text(str(canbemade)+" more potions can be made (~"+str((canbemade*self.recette.difficulty)//ability + 1)+" days)", size=15)
                    else:
                        ui.text("No more potions can be made!", size=15, color="#f33")
                    #
                    
                    ui.close()
                #
                
                self.workmorale()
                
                salary = self.salary()
                
                talk += self.displaySalary(salary)
                
#                 ui.text(str(realmade * self.recette.difficulty)+" exp", ypos=50)
                
#                 self.texp += realmade * self.recette.difficulty
#                 ui.text(str(self.texp), ypos=75)
                
                bubble(talk)
                
#                 renpy.checkpoint()
                
                if realmade > 0:
                    if debug==1 and expsystem==2:
                        xpbonus = realmade * self.recette.difficulty
                    #
                    else:
                        xpbonus = 1
                    levelup = self.xpup(xpbonus)
                    if levelup:
                        self.showlevelup()
                    #
                #
                
                moveout(self.chara)
            #
        #
        
        class Learn(Task):
            def __init__(self, chara):
                Task.__init__(self, chara, "Learn")
            #
        #
        
        class Vacation(Task):
            def __init__(self, chara):
                Task.__init__(self, chara, "Vacation")
            #
        #
        
        class Sell(Task):
            def __init__(self, chara):
                Task.__init__(self, chara, "Sell")
            #
        #
    
    #

#
