﻿init -1000:
    $ debug=0       # 1 ou 0 : affiche le temps de chaque scene
    $ debugsound=1
    if debug == 1:
        $ config.developer = True    
    
        # Default debug values (for release)
    $ nointro=False     # Default False
    $ alwaystown=False   # Default False
    $ moneycheat=False  # Default False
    $ allitems=False
    $ alllocs=False
    $ allcharas=False
    $ expsystem=1
    
        # Custom debug values (for development)  (also requires 'debug', above, to be set to 1)
#     $ nointro=True
#     $ alwaystown=True
#     $ moneycheat=True
#     $ allitems=True
#     $ alllocs=True
#     $ allcharas=True
#     $ expsystem=2
    
    
    $ game_version = "1.3.1"

############################ START LABEL #################################

# The start label marks the place where the main menu jumps to to
# begin the actual game.

label start:

    $ renpy.clear_game_runtime()
    $ renpy.music.stop()
    
    $renpy.transition(longdissolve)
    $ renpy.pause(2)
   
    
    call inititem from _call_inititem_1
    call initlocations from _call_initlocations_1
    call initchara from _call_initchara_1
    call initmagasin from _call_initmagasin_1
    call initmerchant from _call_initmerchant_1
    call initquest from _call_initquest_1
    call initcustom from _call_initcustom_1
    
#     jump theend_end
    
    jump gameloop
    
#



######################## SPLASH SCREEN ##############################

label splashscreen:

    scene black with None
    
    with Pause(1.5)

#     scene mainmenu with None
#     
#     $ ui.frame(style="bulle")
#     $ ui.text("Voici un petit texte\npour la bulle...", style="bulle")
#     
#     $ ui.frame(xpos=500, ypos=90, style="bulle")
#     $ ui.text("Voici un plus long texte qui part plutot a la verticale, histoire de voir ce que ca donne.", style="bulle")
#     
#     $ ui.frame(xpos=300, ypos=350, style="bulle")
#     $ ui.text("Et allons-y avec encore un autre. With a little bit of english this time!", style="bulle")
#     
#     $ ui.frame(xpos=100, ypos=200, style="bulle")
#     $ ui.text("WHAT THE ?!", style="bulle", size=20)

#     
#     $ ui.saybehavior()
#     $ ui.interact()
        
#     if not persistent.set_language:
#         call f_language from _call_f_language_1

    $ persistent.language=='EN'
    
    play sound "chime2.ogg"
    show renpy at Position(xpos=0.5, ypos=0.40, xanchor=0.5, yanchor=0.5)
    
    python hide:    # python hide to avoid keeping the two temporary objects
        nbanner = renpy.display.layout.Window(Text("Powered by Ren'Py", style="banner"), style="banner")
        vtext = Text("v"+game_version, size=14)
    
        renpy.show("nbanner", [Position(ypos=0.75, yanchor=0.5)], what=nbanner) # what=nbanner : displayable name (the one created above)
        renpy.show("vtext", [Position(xpos=3, ypos=3, xanchor=0, yanchor=0)], what=vtext)
    #
    
    with dissolve
    with Pause(2.5)
    
    hide renpy
    hide nbanner
    hide vtext
    with dissolve
    with Pause(0.5)
    
#     $ renpy.transition(dissolve)
    
#     jump imgtest

    return
#

######################## TEST SCENES ##############################



label ingtest:

    scene mainmenu with dissolve
    
    python:
#         displayIngredient(inglist[0])
        displayIngList()
        ui.saybehavior()
        ui.interact()
#         renpy.display_say("Loli", "I really love "+inglist[0].name+" which is a "+inglist[0].category.name+" !")
    #

    return
#

label imgtest:

    scene black with None

    menu m_img:
        "Pick a protagonist."
        
        "The red one.":
            $ prota = im.Image("fb_framboise.png")
            $ pname = "Framboise"
        #
        "The blue one.":
            $ prota = im.Image("fb_other.png")
            $ pname = "Cassis"
        #
    #
    
    $ clear()
    
    show black with dissolve
    
    "Vous avez choisi %(pname)s..."
    "Les aventures de votre protagoniste commencent maintenant !"
    "Essayez de sauvegarder un peu pour voir..."
    "Ça y est ? Vous avez sauvegardé la partie ?"
    "Bien, faisons disparaître %(pname)s."
    
    hide black with dissolve
    
    "Et faisons la réapparaitre."
    
    show expression prota with dissolve
    
    "Est-ce que ça a fonctionné ?"
    "Espérons que oui..."

    return
#

###################################################################


    


########################### FUNCTIONS ################################


# MAIN GAME SCRIPT DISPATCHED IN OTHER FILES

# FUNCTIONS BELOW

#

label f_language:
    $ persistent.set_language = True
    menu m_langue_persist:
        "Choisissez votre langue / Pick your language"
        "Francais":
            $ persistent.language = "FR"
        "English":
            $ persistent.language = "EN"
    #
    return
#

# A placer au debut d'une scene, avant le "$save_name =" pour connaitre la duree de la scene precedente
label f_getTime:

#     $ minutes, seconds = divmod(int(renpy.get_game_runtime()), 60)
#     "%(save_name)s : %(minutes)dm%(seconds)ds"
    
    $ lastm = divmod(int(renpy.get_game_runtime()-starts), 60)[0]
    $ lasts = divmod(int(renpy.get_game_runtime()-starts), 60)[1]
    $ lastsc = save_name
    $ starts = int(renpy.get_game_runtime())
    #$ renpy.clear_game_runtime()
    return
#


label ending:
    jump restart
#

label restart:

    if debug==1:
        call f_getTime from _call_f_getTime_1
        if int(renpy.get_game_runtime()) > persistent.t_total:
            $ persistent.t_total = int(renpy.get_game_runtime())
            $ totaltime = persistent.t_total
    #

    $ clear()
    
    $ minutes, seconds = divmod(int(renpy.get_game_runtime()), 60)
    "It took you %(minutes)d minutes and %(seconds)d seconds to
    finish this demo."
    
    $ renpy.full_restart()
#


label developer:

    scene black

    # It's bad form to change a config variable outside of an init
    # block. We're only doing this to help test the game. Don't do
    # it in your own game.
    $ config.developer = True

    "Developer mode enabled."
    
#     "Developer mode enabled. You can now use '>' to warp to the next
#      menu."

    $ config.log = "log.txt"
    $ renpy.log("=========================================")

#     "Logging enabled. You can now find a log of this game in log.txt."

    return
#

label gatherfix:
    $ charapool['framb'].getTask(Gather).talent = 90
    return
#

label showversion:
    $ ui.window()
    $ ui.text("Current version : "+game_version)
    $ ui.saybehavior()
    $ ui.interact()
    return
#

    
# Setup the secret keys for the developer mode.
init:
    python:
#         config.keymap['developer'] = [ 'D' ]
#         config.underlay.append(renpy.Keymap(
#             developer=renpy.curried_call_in_new_context('developer')))
#         config.keymap['f_language'] = [ 'L' ]
#         config.underlay.append(renpy.Keymap(
#             f_language=renpy.curried_call_in_new_context('f_language')))
        config.keymap['gatherfix'] = [ 'C' ]
        config.underlay.append(renpy.Keymap(
            gatherfix=renpy.curried_call_in_new_context('gatherfix')))
#         config.keymap['gatherfix'] = [ 'V' ]
#         config.underlay.append(renpy.Keymap(
#             showversion=renpy.curried_call_in_new_context('showversion')))
            
#


init:
    python:
        # Test ternaire : test doit être une expression booléenne. A est renvoyé si elle est vraie. Sinon, B.
        def tern(test, a, b):
            if test:
                return a
            else:
                return b
        #
    #
#



################################################################

