﻿# RESOLVE PHASE

label resolve:

    $ solve()
    if magasin.opened:
        $ solvesales()
        $ solvereputation()
    #
        
    return

#


init:

    $ goodrep = 0.4     # how much rep is added for a sold potion
    $ badrep = 1.0      # how much rep is removed for a potion you couldn't sell
    
    $ repdivider = 10.0 # divider of the total reputation of all recipes. The result is the shop's reputation
    

    python:
    
        #   Ensemble de potions achetées dans la journée.
        #
        class Chariot(object):
        
            def __init__(self):
            
                self.content = []   # liste de PotStock
                #self.capacity = 9999
            #
            
            # Renvoie la place actuellement occupée dans le panier
            #
            def getOccupation(self):
                occupied = 0
                for p in self.content:
                    occupied += p.qty
                #
                
                return occupied
            #
            
            def sort(self):
                self.content.sort(lambda x, y: cmp(x.reputation, y.reputation))
                self.content.reverse()
            #
            
            def clear(self):
                self.content = []
            #
            
            # ajoute la potion dans cette quantitée au panier
            # ingredient : un Ingredient
            #
            def add(self, potion, qty=1):
            
                found = -1
                
                renpy.log("Chariot add "+potion.name+"... len content : "+str(len(self.content))+"  range : "+str(range(len(self.content))) )
                
                for i in range(len(self.content)):
                    if self.content[i].potion == potion:  # found it
                        renpy.log("Found "+potion.name)
                        found = i
                        break
                    #
                #
                
                if found == -1:
                    self.content.append(PotStock(potion))
                #
                else:
                    self.content[found].qty += 1
                #
                
                return 1
            
            #
            
            #   Calcule le chiffre d'affaire total
            #
            def getTotal(self):
                total = 0
                for i in self.content:
                    letaux = (grimoire.getRecipeFrom(i.potion).reputation-50)/100.0
                    leprix = int(i.potion.price + i.potion.price * letaux)
                    total += leprix * i.qty
                    # price of the potion is the base price and a variation of -50 to +50% for recipe reputation from 0 to 100
                #
                return total
            #
            
            
        #
    
        def solve():
        
            sortstaff = staff[:]
            
            def sorttasks(x, y):    # give tasks as arguments
                if x.task.priority == y.task.priority:
                    return cmp(x.task.talent, y.task.talent)
                #
                else:
                    return cmp(x.task.priority, y.task.priority)
                #
            #
            
#             sortstaff.sort(lambda x, y: cmp(x.task.priority, y.task.priority))
            sortstaff.sort(sorttasks)
            sortstaff.reverse()
        
            for c in sortstaff:
            
                task = c.task
                renpy.block_rollback()
                task.solve()
                
            #
        
        #
        
        
        
        def solvesales():
        
            renpy.transition(dissolve)
            renpy.scene()
            renpy.show("shop out")
            
            movein(chero)   
            
            isSaturday = day%7 == 6
            isSunday = day%7 == 0
            
            if isSaturday:
                bubble(chero.speak("sat"))
                moveout(chero)
                return
            #
            elif isSunday:
                bubble(chero.speak("sun"))
                moveout(chero)
                return
            #
        
            recipes = grimoire.content[:]
            recipes.sort(lambda x, y: cmp(x.potion.price, y.potion.price))
            recipes.reverse()
            
            for i in recipes[:]:
                if i.reputation == 0:       # cas particulier, une réputation de 0 n'agit pas seulement sur le prix mais indique qu'une potion est absolument inconnue et ne sera jamais demandée par un client
                    recipes.remove(i)
            #
        
            propcoeff = sum([1.0/x.potion.price for x in recipes])
            
            pricelist = [1.0/x.potion.price for x in recipes]
            
            problist = [(1.0/propcoeff) * x for x in pricelist]
            # probability list based on prices
            
            repmeter = []
            repsum = 0
            
            # creating probability table, based on recipe prices (computed above)
            renpy.log("probability list:")
            for i in problist:
                repmeter.append(i+repsum)
                renpy.log(str(i+repsum))
                repsum += i
            #
            
            #renpy.random.seed()
            
            rnd = renpy.random.random()
            halfrep = 0.5*(magasin.reputation)
            if isSaturday:
                clients = int(magasin.reputation + rnd*halfrep)
            else:
                clients = int(magasin.reputation + rnd*halfrep - (magasin.reputation*0.25))
            #
            
            
            #narrator(str(magasin.reputation)+"+"+str(rnd)+"*"+str(halfrep)+"-"+str(magasin.reputation*0.25)+" = "+str(clients))
            
            chariot = Chariot()
            failed = Chariot()
            
            if clients > 0:
            
                for i in range(clients):
                    rn = renpy.random.random()
                    renpy.log("rn = "+str(rn))
                    bought = None
                    for index in range(len(repmeter)):
                        if rn < repmeter[index]:
#                             narrator("buys "+recipes[index].potion.name)
                            bought = recipes[index].potion
                            break
                        #
                    #
                    realdel = etalage.remove(bought)
                    if realdel == 1:    # on a assez
                        #magasin.repup(0.2)
                        recipes[index].repup(goodrep)
                        
                        chariot.add(bought)
                        salestats.add(bought)
                    #
                    else:
#                         narrator("Nous n'avons plus de potion de ce type.")
                        #magasin.repdown(0.1)    # pour que même si la potion est déjà à 1 de réputation (et ne peut donc plus aller plus bas), ça dissuade quand même
                        # L'effet n'est pas celui escompté : le calcul de rep basé sur les potions annule immédiatement le malus (ou pas loin en tout cas)
                        # il faudrait presque une autre variable qui soit additionné à la rep totale des potions et qui puisse être négatif (dans une certaine limite peut-être?)
                        # Ne pas réussir à vendre une certaine potion serait alors effectivement mauvais.
                        # Cette variable remonterait (lentement) au fur et à mesure qu'on satisfait les clients
                        
                        recipes[index].repdown(badrep)
                        failed.add(bought)
                    #
                    clients -= 1
                    
                #
                
                magasin.money += chariot.getTotal()
                
#                 narrator("Nous avons gagné "+str(chariot.getTotal())+" pièces d'or aujourd'hui.")

                showSales(chariot, failed)
                

                
            
            else:
            
#                 bubble("We didn't see any client today...")
                bubble(chero.speak("salesno"))
            
            #
            
            moveout(chero)
        
        #
        
        def showSales(chariot, failed):
        
            ui.window(xpos=640, xanchor=1.0, ypos=.6)
            ui.vbox(box_spacing=4)
            
            sales = chariot.content[:]
            sales.sort(lambda x, y: cmp(x.potion.price, y.potion.price))
            
            ui.text (str(chariot.getOccupation())+" clients today", xpos=.5, xanchor=.5)
            ui.null()
            
            # vendus
            if len(sales) > 0:
                ui.text("Sold", xpos=.5, xanchor=.5)
                
                rows = len(sales)//2 + len(sales)%2
                
                ui.grid(2,rows, padding=15, xpos=.5, xanchor=.5)
                for i in sales:
                    ui.hbox(box_spacing=5, xmaximum=250)
                    ui.text(str(i.qty)+"x", ypos=.5, yanchor=.5)
                    ui.image(i.potion.pic)
                    ui.text(i.potion.name, ypos=.5, yanchor=.5)
                    ui.close()
                #
                for i in range(2*rows - len(sales)):
                    ui.null()
                #
                ui.close()
            #
            # manques
            if len(failed.content) > 0:
                ui.null()
                ui.text("Unfulfilled requests", xpos=.5, xanchor=.5)
                
                rows = len(failed.content)//2 + len(failed.content)%2
                
                ui.grid(2,rows, padding=15, xpos=.5, xanchor=.5)
                for i in failed.content:
                    ui.hbox(box_spacing=5, xmaximum=250)
                    ui.text(str(i.qty)+"x", color="#f00", ypos=.5, yanchor=.5)
                    ui.image(i.potion.pic)
                    ui.text(i.potion.name, ypos=.5, yanchor=.5)
                    ui.close()
                #
                for i in range(2*rows - len(failed.content)):
                    ui.null()
                #
                ui.close()
            #
            # total
            
            ui.null()
            ui.text("Money earned today :")
            
            ui.hbox(xpos=.5, xanchor=.5)
            # image des pièces
            ui.text("+"+str(chariot.getTotal()), ypos=.5, yanchor=.5)
            ui.image("money32.png", ypos=.5, yanchor=.5)
            ui.close()
            
            ui.close()
            
            if failed.getOccupation() > chariot.getOccupation():
                bubble(chero.speak("salesne"))
            #
            elif chariot.getTotal() > 200:
#                 bubble("Wow, look at all these coins !")
                bubble(chero.speak("saleslots"))
            #
            else:
#                 bubble("Things went well today.")
                bubble(chero.speak("salesok"))
            #
        
        #
        
        def solvereputation():
            
            diff = (grimoire.getTotalRep()/repdivider - magasin.reputation)
            
            if diff > 0 and diff < 0.1:
                diff = 0.1
            #
            elif diff < 0 and diff > -0.1:
                diff = -0.1
            #
            diff = round(diff,1)
            
            #narrator("rep="+str(magasin.reputation)+"  totalrep="+str(grimoire.getTotalRep()/10.0)+"  Difference="+str(diff))
            
            magasin.reputation += diff
        
        #
    
    #

#

