﻿# RECETTE INTERFACE

init -35:

    python:
    
    
        def displayRecette(item, style="default"):    # affiche une recette (pas de déco)
            ui.vbox(box_spacing=10)
            
            ui.hbox(box_spacing=10, xpos=0.5, xanchor=0.5)
            ui.image(item.potion.pic, ypos=0.5, yanchor=0.5)
            ui.text(item.potion.name, style="title")
            ui.close()
            
            ui.hbox()
            ui.text("Difficulty : ", style=style)
            ui.bar(80, 20, 40, item.difficulty)
            ui.text("("+str(item.difficulty)+")", style=style)
            ui.close()
            ui.hbox()
            ui.text("Reputation : ", style=style)
            ui.bar(100, 25, 100, item.reputation, ypos=0.35, yanchor=0.5)
            ui.text("("+str(item.reputation)+")", style=style)
            ui.close()

            
            ui.text("Needed ingredients : "+item.sayNeeded(), style=style, xpos=0.0, xanchor=0.0)
            
            ui.text(item.desc, style=style)
            
            ui.close()
        #
        
        def displayRecInfo(item):   # affiche la fiche d'info d'une recette
            ui.window(style="parch")
            displayRecette(item, style="parch")
        #
    
    
        #   Affiche une recette dans la liste (image et nom)
        #
        def displayGrimoireItem(item, withthumb=False, brewer=None, talent=0, hovered=None, unhovered=None):
            if brewer <> None:
                ability = brewer.getTask(Brew).getAbility()
                
            ui.hbox()
            if brewer <> None and ability // item.difficulty < 1:  #inactif (pas assez de talent)
                ui.button(style="marqueur", hovered=hovered, unhovered=unhovered)
            #
            else:
                ui.button(clicked=ui.returns(item), style="marqueur", hovered=hovered, unhovered=unhovered)
            #
            ui.hbox(box_spacing=10)
            if withthumb:
                ui.image(item.potion.pic)
            #
            else:
                ui.null()
            #
            if brewer <> None and ability // item.difficulty < 1:  # ne peut pas faire au moins 1 potion de ce type par tour
                ui.text(item.potion.name, ypos=0.5, yanchor="center", minwidth=120, style="parch", color=(255,0,0,255))
            else:
                ui.text(item.potion.name, ypos=0.5, yanchor="center", minwidth=120, style="parch")
            #
            ui.close()
            ui.text("("+str(etalage.getQty(item.potion))+")", ypos=.5, yanchor=.5, style="parch")
            ui.close()
        #
    
    
        def displayGrimoire():     # affiche la liste des recettes connues
        
            ui.window(style="parch")
            ui.vbox(box_spacing=5, box_first_spacing=30)
            
            ui.text("Grimoire", style="title", bottom_margin=50)
            
            rows = len(grimoire.content)//2 + len(grimoire.content)%2
            
            c = grimoire.content[:]
            c.sort(lambda x,y: cmp(x.potion.price, y.potion.price))
            
            ui.grid(2,rows)
            for item in c:
                displayGrimoireItem(item, True)
            #
            for i in range(2*rows - len(grimoire.content)):
                ui.null()
            #
            ui.close()
            
            ui.null()
            ui.button(clicked=ui.returns(""), style="marqueur")
            ui.text("Go back", style="parch")
            ui.close()
        
        #
        
        
        ###################################################


        def chooseRecipe(brewer, talent):       # affiche la liste des recettes et renvoie celle sélectionnée
        
            def hoverButton(hovervalue, item, brewer, talent):
            
                def hovered(hovervalue=hovervalue):
                    renpy.log("hovered("+hovervalue.potion.name+")")
                    if store.hovervalue <> hovervalue:
                        renpy.log("* Setting hover")
    
                        store.hovervalue = hovervalue
                        showRecipes(brewer, talent)
#                         renpy.transition(Dissolve(0.2))
                        renpy.restart_interaction()
                    return None
                #
                
                def clearText(hovervalue=hovervalue):
                    renpy.log("clearText("+hovervalue.potion.name+")")
                    if store.hovervalue == hovervalue:
                        renpy.log("* No hover anymore")
                        store.ishover = False
                        store.hovervalue = ""
                        showRecipes(brewer, talent)
#                         renpy.transition(Dissolve(0.2))
                        renpy.restart_interaction()
    
                #                
                
                #ui.imagebutton(idle, active, clicked=clicked, hovered=hovered, unhovered=clearText, **properties)
                displayGrimoireItem(item, withthumb=True, brewer=brewer, talent=talent, hovered=hovered, unhovered=clearText)
            #
            
            def showRecipes(brewer, talent):
            
                ui.clear()
            
                ui.frame(style="parch", ypos=0.4)
                ui.vbox(box_spacing=10)
                
                ui.text("Brew...", style="title")
                
                c = grimoire.content[:]
                c.sort(lambda x,y: cmp(x.potion.price, y.potion.price))
                
                rows = len(c)//2 + len(c)%2
                
                ui.grid(2, rows)
                for item in c:
#                     displayGrimoireItem(item, withthumb=True, brewer=brewer, talent=talent)
                    hoverButton(item, item, brewer, talent)
                #
                for i in range(2*rows - len(c)):
                    ui.null()
                #
                ui.close()
                
                ui.button(clicked=ui.returns(False), style="marqueur")
                ui.text("Cancel", style="banner")
                
                ui.close()
                
                if store.hovervalue <> "":
                    ui.frame(style="banner", ypos=0.85)
                    ui.vbox(box_spacing=10)
                    ui.hbox(box_spacing=10, xpos=0.5, xanchor=0.5)
                    
                    for i in store.hovervalue.needed:
                        ui.hbox(box_spacing=5)
                        ui.text(str(i.qty)+"x", style="parch", ypos=.5, yanchor=.5)
                        ui.image(i.ingredient.picture, ypos=.5, yanchor=.5)
                        stocked = stock.getQty(i.ingredient)
                        if i.qty > stocked: # pas assez en stock
                            ui.text("("+str(stocked)+")", ypos=.5, yanchor=.5, style="parch", color="#f00")
                        #
                        else:
                            ui.text("("+str(stocked)+")", ypos=.5, yanchor=.5, style="parch")
                        #
                        ui.close()
                    #
                    ui.close()
                    
                    canbemade = store.hovervalue.canBeMade()
                    if canbemade == 0:
                        ui.text("No potion can be made.", style="parch", color="#f00")
                    #
                    else:
                        ui.text(str(canbemade)+" potions can be made ("+str(store.hovervalue.canMake(brewer,talent))+" per day).", style="parch")
                    #
                    
                    ui.close()
                #
            
            #
                
            store.hovervalue = ""
            
            while True:
        
                showRecipes(brewer, talent)
                
                res = ui.interact()
                
                if res <> "hover":
                    break
                #
            #
            
            return res
        #
        
        ################################################
        
        def newRecette(recette):
            grimoire.add(recette)
            
            renpy.transition(dissolve)
            
            ui.window(style="parch")
            ui.vbox(box_first_spacing=15)
            ui.text("New recipe !", style="title")
            
            ui.hbox(box_spacing=10)
            ui.image(recette.potion.pic, ypos=.5, yanchor=.5)
            ui.text(recette.potion.name, style="parch", ypos=.5, yanchor=.5)
            ui.close()
            
            ui.close()
            
            ui.saybehavior()
            ui.interact()
        #
        
    #       
#
