﻿# QUESTS

init:

    python:
    
        # activates a quest
        def actquest(quest):
            magasin.quests.append(quest)
            magasin.quests = magasin.quests
            quests.content.remove(quest)
            quests.content = quests.content
        #
        
        # clears a quest (move to "donequests")
        def clearquest(quest):
            magasin.donequests.append(quest)
            magasin.donequests = magasin.donequests
            magasin.quests.remove(quest)
            magasin.quests = magasin.quests
        #
    
    #

    $ woman = NVLCharacter("Woman :", color=(255, 230, 230, 255))
    $ man = NVLCharacter("Man :")
    $ taxc = NVLCharacter("T. Collector :")
    $ kagent = NVLCharacter("Kingdom Agent :")
    $ pi = NVLCharacter("Pierre :")

#

label initquest:

    python:
    
        sickchildren = Quest("The sick children", "sickchildren", "")
        taxcollect = Quest("The tax collector", "taxcollect")
        sickguard = Quest("Guard sickness", "sickguard")
        theend = Quest("The end", "theend")
    
    
        quests = QuestPool()
        quests.content = [sickchildren, taxcollect, sickguard]
    
    #

    return
#

label sickchildren:

    #"The sick children"

    if magasin.hasQuest(sickchildren) and sickchildren.state == 2 and day - sickchildren.endday >= 7:
        $ clearquest(sickchildren)
        $ grimoire.getRecipeFrom(potions['wcure']).reputation += 10
    
        nvl clear
        
        $ renpy.music.play(eventm)
        
        scene shop with fade
        
        "Ding-a-ling!" with dissolve
        
        "The bell rings as a customer enters the shop."
        "Wait, it's not any customer!"
        
        woman "Good morning sir!"
        
        "It's the woman whose kids were sick!"
        
        da "Ah... good morning!"
        
        woman "I came here to thank you once again."
        
        da "Are they...?"
        
        woman "Yes, they're doing a lot better. As if nothing had happened, eheh."
        
        da "Oh, I'm glad!"
        
        woman "Not as much as I am, really."
        
        da "Haha..."
        
        nvl clear
        
        woman "Well ah... I'll be going now. Have a good day, sir!"
        
        da "Thank you, you too."
        
        woman "I'll be sure to talk about you around the town. Goodbye!"
        
        "She leaves and I stay there with a smile."
        with dissolve
        
        scene black with longdissolve
        
        
        return
    #
    elif magasin.hasQuest(sickchildren) and sickchildren.state == 1:
    
#         $ narrator("Potions : "+str(etalage.getQty(potions['wcure'])))
    
        if etalage.getQty(potions['wcure']) >= 10:
            nvl clear
            
            $ etalage.remove(potions['wcure'], 10)
            $ sickchildren.endday = day
            $ sickchildren.state = 2
        
            $ renpy.music.play(eventm)
            
            scene shop with fade
            
            "The door opens, making the bells ring. Quietly though..." with dissolve
            
            woman "..."
            
            "It's that woman again. She looks as sad as ever."
            
            woman "Good morning sir, I... do... you have...?"
            
            da "The potions?... Yes I do."
            
            "I say with a smile."
            
            "The woman's eyes immediately light up and a huge smile takes shape all across her face."
            
            woman "Oh thank you, thank you! I'm so in debt to you!"
            
            nvl clear
            
            woman "Here, that's all I have..."
            
            "She takes a pouch from her belt and puts it on the table, making a few coins spill."
            "There's not much, but it's still all she has..."

            nvl clear
                        
            menu sickchildrenend:
                "Take the money.":
                    $ magasin.money += potions['wcure'].price * 10
                    
                    da "Thank you ma'am. I hope the children will get better soon enough with this."
                    
                    "I put the potions in her basket."
                    
                    "She nods, smiling."
                    
                    woman "Thank you! Really..."
                #
                "Let her keep the money.":
                    $ grimoire.getRecipeFrom(potions['wcure']).reputation += 5
                    
                    da "It's okay ma'am..."
                    
                    "I push the pouch back to her."
                    
                    da "Keep it safe. I hope the children will get better soon enough."
                    
                    "I start putting the potions in her basket but she protests."
                    
                    woman "But... I..."
                    
                    da "What? You don't want the potions?"
                    
                    woman "Uh... Of course I do!... But..."
                    
                    nvl clear
                    
                    "I look at her with a smile and she ends up smiling back."
                    
                    woman "I don't know what to say, I..."
                    woman "... Thank you sir... Thank you very much!"
                    
                    da "Now, now... Go tend to your children. They're waiting for you I'm sure."
                #
            #
            
            "The woman goes to the door and waves her hand as she leaves."
            "Well... I sure hope it goes well for her."
            with dissolve
            
            scene black with longdissolve
            
            
            return
        #
        elif etalage.getQty(potions['wcure']) < 10:
            scene shop with fade
            
            nvl clear
            
            if day - sickchildren.day > 3:
                $ grimoire.getRecipeFrom(potions['wcure']).reputation -= 5
            
                "The woman is here again and she looks desperate." with dissolve
                
                woman "Do... do you have the potions today?"
                
                da "I'm sorry ma'am..."
                
                woman "I... I see... Forget about my request, I'll go see elsewhere..."
                
                da "I understand. Good luck."
                
                "The woman doesn't reply and leaves the shop."
                "I wonder if she will be alright..."
                
                $ clearquest(sickchildren)
            #
            elif day - sickchildren.day > 2:
                "The woman, quite desperate now, looks very disappointed when I tell her
                I still don't have enough of the potions she requested." with dissolve
            #
            elif day - sickchildren.day > 1:
                "The woman is back again and eager to know if the potions are in." with dissolve
                "I tell her there has been a lot of demand on it lately and I still don't have
                enough of them for her."
            #
            elif day - sickchildren.day > 0:
                "The woman wants to know if the potions are here but I tell her it's a bit
                too soon." with dissolve
            #
        
            scene black with longdissolve
        #
        
        return
    #
    elif day >= 3 and sickchildren.state == 0:
        $ renpy.music.play(eventm)
    
        scene shop with fade
        nvl clear
        
        nvl show dissolve
        
        "I barely notice the person entering the shop this morning."
        "I'm pretty sure the bell rang, though..."
        
        woman "I... um..."
        
        "It's a young woman, not far from reaching her thirties I'd say, who reaches
        the counter and starts talking."
        
        woman "I need your help, sir."
        
        "Her eyes lock onto mine and I can see so much fatigue in them that it pains me."
        "Waiting for my answer, she rubs her hands against each other. They're callous
        and strong."
        "And according to her clothing, I can guess that she is part of the hard-working
        folks living in the nearby suburbs."
        
        nvl clear
        
        da "Well, how can I help you madam?"
        
        "She sighs and looks around, fidgeting, suddenly hesitant to answer."
        
        woman "Um... this was Edrenor's shop, wasn't it?"
        
        da "Oh, yes! I'm his grandson, see? Sadly, he is... um... he..."
        
        "She lowers her eyes, not needing any more words to understand."
        
        woman "But you do still sell potions, yes?"
        
        "I nod with a smile."
        
        da "We sure do. Just tell me what you need."
        
        woman "Well, see... it's for my children..."
        
        nvl clear
        
        "She explains how they apparently caught some illness only a few days ago."
        "It seemed benign at first but it then spread through the family and,
        miraculously, she avoided it."
        "All her children are bedded and the sickness holds, though."
        
        da "Well madam, do not worry: we do offer curative potions. How many will you need?"
        
        "She fidgets again and I sense her more hesitant than ever."
        
        da "...?"
        
        woman "I'll... I'll need ten bottles, sir..."
        
        da "Ten?!... My... That's quite the family you have here!"
        
        "She gazes at the ground again and I feel sorry for taking it so lightly."
        
        nvl clear
        
        da "Well, ten is a large quantity but it should be all right."
        
        woman "Really?!"
        
        da "Let me take a look..."
        
        woman "Oh, no, it's... I mean... I don't have money right now..."
        woman "But I'll come back! Tomorrow! Thank you very much, really!"
        
        "She bows a few times on her way out, thanking me profusingly and leaving me a bit
        dumbfounded."
        
        nvl hide dissolve
        $ renpy.pause(1.5)
        
        nvl clear
        nvl show dissolve
        
        "And I find myself alone in the shop again."
        
        da "I suppose I'll have to check the stocks and see if I can have ten bottles of
        Weak Cure ready for tomorrow... or soon enough at least."
        
        nvl hide dissolve
        
        scene black with longdissolve
        
        $ actquest(sickchildren)
        $ sickchildren.day = day
        $ sickchildren.state = 1
        return
    #
    

    return
#

################################## TAX COLLECT #######################################

label taxcollect:

    $ weekend = day%7 == 6 or day%7 == 0

    if taxcollect.state == 0 and magasin.reputation >= 16 and cpom.isAvailable() and cframb.isAvailable() and not weekend:  # initial condition for the quest to begin
#     if taxcollect.state == 0 and day==1:
        $ actquest(taxcollect)
        $ taxcollect.day = day
        $ taxcollect.state = 1  # quest started
        $ save_name = "The tax collector"

        jump taxcollect_intro
    #
    
    if taxcollect.state == 2 and day >= taxcollect.day + 2 and cframb.isAvailable():
        $ taxcollect.state = 3
        $ save_name = "Worries"
        jump taxcollect_worry
    #
    
    if taxcollect.state == 3 and day >= taxcollect.day + 4 and cframb.isAvailable():
        $ clearquest(taxcollect)
        $ cpom.task = cpom.abletasks[len(cpom.abletasks)-1] # back to DoNothing
        $ save_name = "Time to pay"
        jump taxcollect_end
    #
    
    if taxcollect.state == 4 and day >= taxcollect.day + 12 and cframb.isAvailable() and cpom.isAvailable():
        $ clearquest(taxcollect)
        $ cframb.morale += 5
        $ cpom.morale += 5
        $ chero.morale += 5
        
        $save_name = "Karma"
        
        jump taxcollect_karma
    #

    return
#

label taxcollect_intro:
    
    nvl clear
    
    $ renpy.music.play(eventm)
    
    scene shop with fade
    
    "Dling-a-ling!"
    
    da "Ah! Welcome, welcome! What can I do for... uh..."
    
    "The man that just entered is already looking around... but doesn't seem to intend any
    kind of purchase."
    "He is holding a bunch of parchments, and although he looks a bit shaggy, his costume
    and demeanor seem to indicate he is of some important stature."
    
    da "Sir?..."
    
    man "Hm? Ah, yes... Allow me to introduce myself : Mr. Darnand, tax collector."
    
    "He holds out a large hand and I shake it without much conviction."
    
    nvl clear
    
    da "And you're here for...?"
    
    taxc "... tax collecting, of course."
    
    da "Uh... but, you see, this shop is rather new... I mean, I have been its owner only for
    a month or so..."
    
    "The man looks at his papers with a serious look and nods."
    
    taxc "Yes, yes, I know that, but in the case of a shop being sold, tax collection
    follows the previously established schedule. This is from the new regulations validated
    three months from now."
    taxc "And as of today... you are actually a bit late for payment. But I won't hold it
    against you."
    
    da "Ehh......"
    
    nvl clear
    
    "I hear Framboise and Pom coming in the room."
    
    show framboise
    show pom at right
    with dissolve
    
    fr "What's going on, %(name)s?"
    
    da "Um, this... uh... Mr. Darnand is here to collect taxes. It's a bit early and..."
    
    "I pause. The tax collector is looking strangely at Framboise... No wait, it's Pom!"
    
    pom "...!"
    
    show pom shade
    
    $ renpy.music.play(badm)
    
    "Pom puts on his hood but I have a feeling it's too late."
    
    nvl clear
    
    taxc "Well, well... what have we here?"
    
    da "N... nothing... just one of my assistants..."
    
    "The man is grinning... An ominous grin..."
    
    taxc "I see why you were reluctant to let me in..."
    
    da "What? I... I wasn't reluctant! I only asked you what you wanted!"
    
    taxc "You are employing a demon from the West Lands, sir."
    
    da "......"
    da "And?... It's not illegal as far as I know."
    
    "He is taken aback."
    
    taxc "Hmf... No, no... it is not indeed."

    nvl clear
        
    "I can see Pom getting more and more angry. I'd better end this before he snaps..."
   
    taxc "Nothing illegal... But I wonder what people would say if they knew..."
    
    "His grin has gotten bigger..."
    
    nvl clear
    
    da "... I think we were talking about some tax collecting... sir."
    
    taxc "Yes... yes... Let me see..."
    
    "He looks through his papers and coughs."
    
    $ taxt = int(magasin.money * 0.80)
    taxc "The tax will amount to... %(taxt)d gold pieces."
    
    da "Wh... what?!"
    
    "This is an insanely large amount! He is abusing the situation as much as he can..."
    
    pom "Sir! Don't pay him a cent!"
    
    fr "...... %(name)s..."
    
    "Darn... What shall I do?... He is an official representative of the kingdom after all..."
    
    menu:
        "Pay the money right away.":
            $ taxcollect.state = 4
#             $ clearquest(taxcollect)
            $ magasin.money -= taxt
            $ cpom.morale -= 20
            
            nvl clear
        
            "I sigh loudly."
            
            da "I... I understand... I'll pay you..."
            
            hide framboise
            show pom at center
            with dissolve
            
            "I go to get the money but Pom gets in my way."
            
            pom "S... sir! Let me...!"
            
            "Pom has a hand on one of his daggers and looks ready to use it."
            
            "I lay my hand on his shoulder and shake my head."
            
            da "No Pom, please... This is enough trouble as it is. And I don't want you
            to get into something worse because of this."
            
            "Pom grates his teeth in anger and then lets his shoulders slump with a heavy sigh."
            
            pom "..........."
            
            da "It's okay Pom..."
            
            hide pom with dissolve
            $ renpy.pause(1.5)
            nvl clear
            
            "I come back with the money and hand the bag to the collector."
            
            taxc "Thank you sir."
            
            "He starts looking in the bag to check but my eyes convince him not to."
            
            taxc "Err... I... I will be going now, then..."
            taxc "The King is proud of his subjects!"
            
            "And with this, he leaves, rather in a hurry."
            "A good thing too... I was about to... not be myself for a moment."
            
            $ renpy.pause(1)
            
            nvl clear
            
            "SLAM!"
            
            "Someone has punched the counter violently."
            
            pom "@#&!!... Why..."
            
            da "I... I'm sorry guys... But hey, it's just money... we'll make twice more
            in the coming days!"
            
            fr "But... this man was so... so... dishonest!"
            
            da "I... I know... But I'd rather pay money than bring trouble upon our heads."
            da "This guy could probably have closed the boutique for any reason if we
            had insisted on not paying..."
            
            nvl clear
            
            "Framboise looks down... and clenches her fists."
            
            fr "We will work twice harder to make up for this!"
            
            da "Eh... but... this is not your fault..."
            
            fr "It doesn't matter!"
            
            "I blink, surprised..."
            
            da "... Thank you, Framboise."
            
            nvl clear
            
            "Pom suddenly grunts and goes into the stocks, slamming the door behind him."
            
            da "........."
            
            fr "........."
            
            "Framboise smiles and tries a joyful tone:"
            
            fr "It's okay! He'll be fine!... I'll go talk to him."
            
            "And she goes into the stocks too."
            
            $ renpy.pause(1.5)
            nvl clear
            
            da "*sigh*..."
            
            "Way to start the day, really... But we'd better get ready: customers will soon be there..."
            
        #
        "Try to buy some time.":
            $ taxcollect.state = 2
            $ cpom.task = Occupied(cpom, "Spying")
        
            nvl clear
            
            da "Sir, you can't ask for so much money on such a short notice. It's against regulations."
            
            "He seems to hesitate."
            
            taxc "Yes... yes... I know that!"
            
            "He is clearly angry that I'm right on this."
            
            taxc "Well I'll give you 4 days, not one more!"
            
            $ willbeweekend = (day+4)%7 == 6 or (day+4)%7 == 0
            
            if willbeweekend:
                da "But... it would be during the weekend!"
                
                taxc "... You do live here, right?"
                
                da "... Yes..."
                
                taxc "So you will be present for tax collecting."
            #
            
            "I wish I had a potion of pig metamorphosis for him right now..."
            
            "Seemingly satisfied, the tax collector turns around and goes out."
            
            taxc "Don't forget! Four days!"
            
            nvl hide dissolve
            
            $ renpy.pause(1.5)
            
            show framboise at left
            show pom at right
            with dissolve
            
            nvl clear
            
            pom "Grrrr!... That rotten ~#@&! bastard!"
            
            da "........."
            
            "Pom sighs in frustration and walks around the room, fuming."
            
            show framboise at center
            hide pom 
            with dissolve
            
            fr "... %(name)s...?"
            
            da "Something's... fishy..."
            
            fr "Uh? What do you mean?"
            
            nvl clear
            
            da "Well... first, the shop was not sold but inherited..."
            da "Second, I think I would have heard about those new regulations if they're so recent."
            da "... Sure, the man was well spoken, but he didn't look fine enough to wear a costume."
            
            fr "He did look... unshaved. And there's his slightly long hair..."
            fr "And he didn't even have glasses!"
            
            da "Well... I don't think a tax collector has to wear glasses for the job... but
            there's definitely a lot of suspect elements here."
            
            nvl clear
            
            "I hear someone ruffle through clothes behind me."
            
            show pom at right with dissolve
            
            da "Pom?... What are you...?"
            
            pom "I'm going to check."
            
            da "Eh? No, wait, you can't..."
            
            pom "This clearly happened because I was here, so I'm going to find out who the
            guy really is!"
            
            fr "But, Pom... what if he really is a tax collector?"
            
            pom "No... %(name)s is right, it's too fishy..."
            
            fr "But... but..."
            
            pom "You won't prevent me from going, you know?..."
            
            fr "...... But %(name)s can!"
            
            nvl clear
            
            "Framboise turns to me, a worried look on her face."
            
            da "........."
            
            da "Don't do anything rash, Pom..."
            
            pom "........."
            
            "Pom nods and leaves the shop through the backdoor."
            
            fr "... Uhyuh..."
            
            da "Framboise, you'd better get ready... We should already be working."
            
            fr "Ahh... uh... yes..."
            
            "Though reluctant, Framboise focuses on the day of work ahead of us."
            
            
        #
    #
    
    scene black with longdissolve
    
    return
#

label taxcollect_worry:

    # where framb worries about Pom... It's been two days already!
    # Did the tax collector get him killed by the guard??

    nvl clear
    
    $ renpy.music.play(introm)
    
    scene shop with fade
    
    "Framboise goes down the stairs as I finish my jam covered bread slice."
    
    show framboise with dissolve
    
    "She pauses once she reaches the floor, rubs her eyes and looks at me with a pout:"
    
    fr "... He still hasn't returned?..."
    
    "I wince a bit and shake my head."
    
    fr "%(name)s... I'm worried. What if this tax collector spotted him and called the guards? They probably killed him!
    They would just do that! Just because he is different..."
    
    da "There, there... calm down Framboise."
    
    fr "How could I? You're just staying here, not doing a thing to help him!"
    
    da "........."
    
    nvl clear
    
    da "And what should we do, really?"
    
    fr "Well, uh... call the guards and..."
    
    da "... tell them to save our {b}demon{/b} friend...? Didn't you just say they would kill him anyway?"
    
    fr "Uhyuh... But..."
    
    da "See, it's not that I don't want to do something, but I just can't really do anything."
    da "I have no idea where he is and no one would help us find him. If they did, they would turn against us once they know he is a demon."
    da "I think...... I think we'll have to trust him."
    
    "Framboise seems crushed. She must hate not being able to do anything to help."
    
    nvl clear
    
    da "Come on, get something to eat. You will need strength for the day."
    
    fr "......"
    
    da "And if he's not back tomorrow, we will........."
    da "I don't know what we'll do, but we'll find something. Okay?"
    
    "Framboise nods and gives me a small smile."
    "I smile back and try to concentrate on the upcoming tasks."
    
    scene black with longdissolve
    
    return

#

label taxcollect_end:

    # where Pom returns with good news : the tax collector is a scam...
    # It's one of the villagers that persecuted him back at the Crevice of Angst.
    # He did all this to pain Pom and those who protected him.
    
    # The next day, the fake tax collector meets... a real tax collector.
    # No more laughing for the bad guy.
    # Everyone's happy that things ended up well and that money stayed in the house.
    
    nvl clear
    
    $ renpy.music.stop()
    
    scene shop outnight with fade
    
    $ renpy.pause(1.5)
    
    "CRASH!!" with hpunch
    
    $ renpy.pause(1.5)
    
    $ renpy.music.play(badm)
    
    fr "%(name)s, %(name)s!"
    
    da "I know, I heard it too... Someone's on the first floor..."
    da "Right in the middle of the night..."
    
    fr "Do... you think it's a... burglar?..."
    
    da "*sigh*... Might well be... There's enough stuff down there to give someone the incentive to steal it."
    
    nvl clear
    
    "Framboise hides behind me, clinging at my shirt."
    
    da "Eh... Well uh... at least hold the lamp for me, please?"
    
    "Framboise nods, not averting her eyes from the staircase."
    
    da "I'll get uh... uh....... this. Yeah..."
    
    "I pick up a large book. I think it's an encyclopedia from my grand-father's youth. Probably not relevant anymore."
    "At least it doesn't crumble into dust, and it's pretty heavy."
    "Yeah... I'm deadly now!"
    
    da "............ Who am I kidding?..."
    
    nvl clear
    
    scene shop night with longdissolve
    
    "We're both trying to be as silent as possible but the wood is creaking constantly under our weight."
    "I look around, expecting to spot the burglar searching around... but I see nothing..."
    "I get ready to hit anything that would jump at us with the book and keep moving forward..."
    
    man "So... you think that would kill me on the spot?"
    
    "Both Framboise and I jump and scream in surprise. The voice is behind us!"
    
    show pom with dissolve
    
    nvl clear
    
    $ renpy.music.stop(fadeout=3)
    
    pom "Man... this shop will never get robbed... nope, never..."
    
    fr "Aah!!"
    
    da "Pom!"
    
    $ renpy.music.play(eventm)
    
    pom "Yeah... sorry for barging in at this time but... I just got back and wanted some sleep."
    
    da "More importantly, you're safe!"
    
    "Pom looks at us with suspicious eyes."
    
    pom "You really don't trust me much, do you?..."
    
    $ howlong = day - taxcollect.day
    
    fr "It's been %(howlong)d days! We were worried!"
    
    pom "Well, yeah! I expected the guy to stay in town but he went back to his village. 
    I got a hunch and I had to check if I was right."
    
    nvl clear
    
    da "Wait... what do you mean, {b}village{/b}? Tax collectors live near the castle, right?"
    
    "Pom nods and smirks."
    
    pom "As you guessed the first time, something was fishy. This guy's no tax collector. 
    He's one of the thugs who chased me around, back when I was at the Crevice of Angst!"
    
    fr "Aah!..."
    
    da "... I see... So it was not just bad luck that he spotted you... That's what he came here for."
    
    pom "I heard him: he planned to get the money from us and still reveal my presence in hope of having the shop go down."
    
    da "That sneaky knave!"
    
    show pom at left
    show framboise at right
    with dissolve
    
    nvl clear
    
    if day > taxcollect.day + 4:
        fr "Didn't he say he would be back after four days only?"
        da "... Yes..."
        pom "Hm... he did lose time while traveling through a dangerous path."
        pom "But he's back now and will certainly be here by tomorrow morning."
    #
    else:
        fr "He is still supposed to come back tomorrow, though..."
    #
    

    
    da "... Yes... and we'll be waiting for him eagerly."
    
    pom "...?"
    
    $ renpy.music.stop()
    scene shop out with longfade
    
    $ renpy.pause(2)
    
    scene shop with dissolve
    
    $ renpy.pause(1)
    
    nvl clear
    
    $ renpy.music.play(introm)
    
    taxc "Sir %(name)s, it's time to pay your taxes."
    
    da "Oh, yes, yes. I was waiting for you!"
    
    taxc "Ah?... Um... so, are you ready to abide by the law?"
    
    da "Oh yes, of course. I don't want any trouble, sir. 
    But first, I would like to introduce you to an acquaintance of mine."
    
    taxc "What?... I don't have time for your..."
    
    kagent "Nice to meet you, sir Darnand. Or should I say, Pierre Latrompe?"
    
    pi "Ah!!..."
    
    nvl clear
    
    "As soon as Pierre is done gasping, he turns around and starts running towards the exit..."
    show pom with hpunch
    
    "... only to bump into Pom."
    
    pom "Hey, be careful, sir... You don't want to fall onto these pointy daggers."
    
    pi "Uuh!!.... Aah!... A... agent! This... this thing is threatening me!"
    
    kagent "Um?... Oh I haven't heard, I'm sorry. But instead, I'd like us to discuss your attempt to steal money from an honest shopkeeper
    by impersonating an agent of the kingdom."
    
    pi "......!!......"
    
    "The look on the thug's face is priceless, really."
    
    kagent "Well now... if you'll follow me outside. I'll have you escorted by the guards."
    
    "Pierre doesn't say another word and walks to the exit."
    
    hide pom with dissolve
    
    nvl clear
    
    pi "........."
    
    "He glares at Pom with hate as he passes by."
    "Pom only returns a disdainful glare... and sighs once he's out."
    
    nvl clear
    
    "The agent comes back with a smile."
    
    da "Thank you so much for helping us."
    
    kagent "It's all right m'boy! I've known your grand father for some time... He's been a great help to this city, y'know?"
    
    da "Still, you have our thanks."
    
    "He nods with a jovial smile."
    
    kagent "Don't hesitate to call if someone else bothers you."
    
    "I smile back:"
    
    da "I won't forget."
    
    show framboise at right with dissolve
    
    fr "Thank you Mr. Agent!"
    
    kagent "Haha, you're welcome young lady, really!"
    
    hide framboise
    show pom at left
    with dissolve
    
    nvl clear
    
    "The agent turns to Pom and looks at him seriously."
    
    kagent "And you, m'boy..."
    kagent "Don't let anyone refuse you the right to live happily!"
    
    pom "Uh... uh... yes, sir!"
    
    "The agent gives a hearty laugh."
    
    kagent "That's what the previous owner of this shop told me once. Not sure what he meant, really..."
    
    "Saying so, he scratches his head under his hat... revealing pointy shaped ears."
    
    pom "...!..."
    
    nvl clear
    
    kagent "Well, then! I'm off to bring this thug to justice. Have a good day, friends!"
    
    da "Come back anytime."
    
    pom "Th... thank you..."
    
    $ renpy.pause(1.5)
    
    nvl clear
    
    "I clap my hands."
    
    da "Well, time to work!"
    
    fr "Ah!... yes!"
    
    "Pom goes back to the lab."
    
    "... I think I saw him smile."
    
    scene black with longdissolve
    
    
    return

#

label taxcollect_karma:
    
    nvl clear
    
    $ renpy.music.play(eventm)
    
    scene shop with fade
    
    fr "%(name)s!"
    
    show framboise with dissolve
    
    nvl show dissolve
    
    da "What is it Framboise? You seem all excited for some reason..."
    
    fr "You remember this guy? Mr. Darnand!"
    
    "Bad memories resurface."
    
    da "Not the kind of person I could forget, unfortunately..."
    
    fr "Well he got caught by the Guard!"
    
    da "Really? So..."
    
    nvl clear
    
    "Framboise nods vigorously."
    
    fr "He was indeed a bad guy, that one! A fake collector they said!"
    
    da "That rotten..."
    
    "Framboise explains to me how he got caught by trying the same stunt on other people,
    forcing them to cough up money in exchange of staying quiet about various things."
    
    nvl clear
    
    da "Blackmailing people to make a fortune, uh?..."
    da "Eh... He had it coming."
    
    da "By the way, uh... our money?..."
    
    "Framboise looks down."
    
    fr "I... They said he spent everything as quickly as possible. It's actually
    the reason they spotted him easily once enough people complained."
    
    da "Ehh... *sigh*... it figures... Can't have it all..."
    
    da "Well... at least I know someone who will be overjoyed by the news."
    
    "Framboise smiles. So do I."
    
    scene black with longdissolve
    
    return

#


################################## SICK GUARD #######################################

init:
    $ geo = NVLCharacter("Geoffroy :")
    $ guard = NVLCharacter("Guard :")
    
#

label sickguard:

#     $ renpy.log("sickguard.state = "+str(sickguard.state)+" day="+str(day)+", sickday="+str(sickguard.day))

    # initial condition for the quest to begin
    if sickguard.state == 0 and magasin.reputation >= 23 and cpom.isAvailable() and cframb.isAvailable():  
#     if sickguard.state == 0 and day==1:
        $ actquest(sickguard)
        $ sickguard.day = day
        $ sickguard.state = 1  # quest started
        $ magasin.opened = False    # closing the shop
        $ bgm = "ourdesperation.ogg"
        
        $ save_name = "The threat within"
        jump sickguard_intro
    #
    
    elif sickguard.state == 1 and stock.getQty(ingredients['orpiment']) >= 1 and stock.getQty(ingredients['amber']) >= 1:
        $ sickguard.state = 2
        $ stock.remove(ingredients['amber'])
        $ stock.remove(ingredients['orpiment'])
        $ save_name = "Analyze"
        jump sickguard_analyze
    #
    
    elif sickguard.state == 2 and stock.getQty(ingredients['orpiment']) >= 5 and stock.getQty(ingredients['amber']) >= 20:
        $ save_name = "Prototype"
        $ sickguard.day = day
        
        $ stock.remove(ingredients['amber'], 12)
        $ stock.remove(ingredients['orpiment'], 2)
        
        # add recipe to the Grimoire (with rep=0)
        $ grimoire.add(r_guard)
        
        
        jump sickguard_prototype    # sets state to 3 or 4
    #
    elif sickguard.state == "research" and day - sickguard.day >= 3 :    # we tried research and it's done
        $ sickguard.state = "researchdone"   # research done
#         $ clearquest(sickguard)
        $ save_name = "A miraculous find!"
        
        # $ r_guard.desc = "New description with cinnamon"
        $ r_guard.needed = r_guard_needed2  # new recipe using cinnamon
        
        $ chero.task = chero.abletasks[len(chero.abletasks)-1]   # Dalma is back to doing nothing
        
        jump sickguard_found
    #
    
    elif (sickguard.state == "potions" or sickguard.state == "researchdone") and day - sickguard.day == 6 :    # captain reporting
        $ save_name = "Sickness report"
        
        jump sickguard_report
    #
    
    elif (sickguard.state == "potions" or sickguard.state == "researchdone") and (day - sickguard.day >= 10 or etalage.getQty(p_guard) >= 20) :   # It's time! whether we tried for potions or research
        # the guards can't wait anymore, come what may, we have to heal them *now*
        # if there isn't enough potions by then... it's bad
        # otherwise, yay!
        $ sickguard.state = "end"
        $ clearquest(sickguard)
        $ quests.add(theend)
        $ save_name = "No more time"
        
        jump sickguard_end
    #

    return
#

label sickguard_intro:

    nvl clear
    
    $ renpy.music.play(eventm)
    
    scene shop with fade
    
    
    "DLILILING!"
    
    "?... The bell sounded like it was shaked all around. What's going on?"
    
    man "Where is the owner of this shop? I must talk with him!"
    
    "It's a loud and brutal voice... I'm kinda scared actually..."
    
    da "Uhh... yes?... What is--"
    
    "The man appears in front of me. He is *large* and wears an armour. Oh boy!"
    
    man "Are you the owner of this shop, sir?"
    
    da "I... ah... *gulp*... who asks him?"
    
    nvl clear
    
    man "Geoffroy Delalande! Captain of the local Guard!"
    
    "He is saluting with enthusiasm."
    
    da "Ahh, err..."
    
    "I salute as best as I can..."
    
    geo "As you were."
    
    da "Uhh... wha... what is required of me?"
    
    geo "So you are the owner? The famed %(name)s?"
    
    da "... Famed?... I don't know if..."
    
    geo "My sources say you have already made a good job of helping people in this town. 
    You seem to be a talented alchemist."
    
    nvl clear
    
    da "I... ah..."
    
    geo "Listen, we need your help. The Guard needs your help!"
    geo "There is this sickness... It's spread quickly through our ranks and has most of our boys staying the bed."
    geo "If we can't heal them up, no one will be there to protect the town, were it needed!"
    
    da "I... I understand, but... I'm no doctor."
    
    geo "No need to be! Look, here's something we have been given by a reputed healer."
    
    nvl clear
    
    "The Captain gives me a parchment on which is written a bunch of instructions to make a remedy."
    
    da "... O... orpiment? It's quite rare."
    
    geo "But you know where to find some?"
    
    da "Hmm, yes... some can be found at the Crevice of Angst it seems. Still not easy to come by."
    
    geo "Sir, we really need your help."
    
    nvl clear
    
    da "But what about this healer your mentioned?"
    
    geo "He went back to his laboratory, far from here, in hope of bringing back a cure in time..."
    geo "But he told us it was unlikely we would hold for that long..."
    geo "So he gave us this parchment with ingredients which should be able to replace the usual ones he uses."
    geo "That's why we need you. Find a cure with these ingredients and we will be safe."
    geo "Don't... and we might all die before that healer comes back."
    
    geo "Sir... Understand that I have twenty men under my command and I want them to be safe."
    
    nvl clear
    
    "I sigh and read the parchment one more time."
    
    "It says Orpiment and Amber should be used. I'm pretty sure both can be found at the
    Crevice of Angst... but it won't come in large quantities."
    
    da "I... I don't know if I can... And what about my regular clients? I can't deal with all this at once."
    
    "The Captain gives me a broad smile and holds up a paper."
    
    geo "We thought of this. Here's an order to close down the shop until further notice."
    
    da "WH... WHAT?! Hey!"
    
    geo "Don't worry sir. If everything goes well, you will be largely compensated for this forced... vacation."
    
    da "Uhh... Talk about a vacation..."
    
    geo "Please sir..."
    
    da "It's not like you're giving me a choice..."
    
    nvl clear
    
    $ renpy.pause(1.5)
    
    da "All right... I'll have to fetch the ingredients and analyze them to find their curative property."
    
    "The Captain nods, hope in his eyes."
    
    da "I will call you when I have the ingredients ready."
    
    geo "All right! Thank you sir! We have faith in you!"
    
    "He salutes again and turns around to leave."
    
    $ renpy.pause(2)
    
    nvl clear
    
    "... Arg......"
    "So... the shop is closed it seems. That means we won't have to deal with everyday customers for the time being, at least."
    "Now for this parchment..."
    "It says I will need both {b}Amber{/b} and {b}Orpiment{/b}. I should send {b}Pom{/b} to get some fresh samples I suppose."
    
    if cframb.vehicle.name == "Chariot" and cpom.vehicle.name <> "Chariot":
        "Right now, Framboise is using the chariot for her gathering, but Pom will be needing it. The Crevice of Angst is quite far."
        
        python:
            cpom.vehicle = vehicles['chariot']
            cframb.vehicle = vehicles['foot']
        
            renpy.transition(dissolve)
            renpy.sound.play(levelupm)
            ui.window()
            ui.text("Gave the chariot to Pom", text_align=0.5)
            ui.saybehavior()
            ui.interact()
        #
    #
    elif cpom.vehicle.name == "Chariot":
        "Pom has a chariot to move around quickly. Good. He will be needing it."
    #
    else:
        "We don't have any chariot... But the Crevice of Angst is quite far."
        if magasin.money < furnitures['chariot'].price:
            "Sadly, we don't have enough money to buy a chariot..."
            "It won't be a problem for the first samples, but once it's time to mass produce the potion for all the guards..."
        #
        else:
            "We have money to buy one and we should, as soon as possible!"
        #
    #
    
    if stock.getQty(ingredients['orpiment']) >= 1 and stock.getQty(ingredients['amber']) >= 1:
        "As for the ingredients, we already have enough to make some tests... but we will need more soon. I'd better send Pom on this."
    #
    else:
        "As for the ingredients, we will have to get one sample of {b}Orpiment{/b} and one of {b}Amber{/b}."
        "All this should be found at the {b}Crevice of Angst{/b}."
    #
    
    scene black with longdissolve
    
    jump sickguard
    
    
    return
#

label sickguard_analyze:

    nvl clear
    
    $ renpy.music.play(badm)
    
    scene alchemy with fade
    
    "I've been at this for hours..."
    "The samples we have found are sitting on the table..."
    "... and have finally delivered their secret to me."
    
    da "I never thought..."
    
    "The paper was right! I don't know where this healer got the information but
    he has trustworthy sources, it seems."
    
    nvl clear
    
    "Now that I know how to process these ingredients the right way, I'll have
    to start working on the actual potion!"
    
    "We will need 5 pieces of Orpiment and 20 of Amber."
    
    "This should be enough to make a test potion by trial and error."
    "Balancing both ingredients will certainly prove difficult... but I must succeed."
    
    nvl clear
    
    "Sorry Pom, but there's more work for you it seems."
    
    "Orpiment being quite difficult to find, we have to make sure Pom is
    well rested before gathering."
    "If he happened to come back without Orpiment too often, 
    we should let him rest for a few days."
    
    "And until then, I think Framboise and I should rest as well. We will need all our strength
    when the time to mass produce this potion comes."
    
    scene black with longdissolve
    
    return

#

label sickguard_prototype:

    nvl clear
    
    $ renpy.music.play(eventm)
    
    scene alchemy with fade
    
    
    "With all these samples, I should be able to make a prototype!"
    
    scene black with longdissolve
    
    $ renpy.pause(2)
    
    scene shop with longdissolve
    
    nvl clear
    
    "After hours of work, it's finally done!"
    "I've called the Captain and his men for the first testing."
    "Someone will have to try the very first potion... and while everything seems okay,
    there is still a risk."
    
    nvl hide dissolve
    
    $ renpy.pause(2)
    
    nvl clear
    nvl show dissolve
    
    da "A... are you sure?"
    
    guard "C... Captain! Let me try instead!"
    
    geo "No, boys... It's the duty of a Captain to protect the life of his men."
    geo "I know the risks, but I must do this!"
    
    "Geoffroy is really willing to try out the new potion, despite the risks."
    
    "Either he is really brave or just unconscious... or he really wants to heal first?"
    "Nah... his eyes tell me he cares about his men."
    
    nvl clear
    
    da "Well then... Here it is."
    
    "I hand Geoffroy the potion."
    "The liquid moves around, sticking slightly to the glass..."
    "I admit it's not the prettiest potion I've ever done."
    "If I didn't make it myself, I could almost think it's poison..."
    
    "But, hey! Cures tend to have a bad taste or smell, don't they?"
    
    nvl hide dissolve
    
    $ renpy.pause(1.5)
    
    nvl clear
    
    nvl show dissolve
    
    "The Captain looks at the potion, a bit uncertain."
    "He then removes the cork with a loud pop."
    "........."
    
    guard "Captain..."
    
    "Geoffroy gestures his guard to stop."
    "He brings the bottle to his mouth and... drinks the content in one go."
    
    nvl clear
    
    da "Aah... uh..."
    
    "Geoffroy seems to take it...... well?"
    
    geo "Cough!"
    
    "Everyone freezes as the Captain starts coughing."
    
    da "Is everything... okay?"
    
    geo "Cough, cough!"
    
    "Geoffroy holds a thumb up as he keeps coughing."
    
    nvl clear
    
    "He finally stops and wipes a tear off his left eye."
    
    geo "Brrrouah!... That's the worst thing I've ever drunk in my life! Haha!"
    
    da "... I'm sorry."
    
    geo "It's all right, lad! At least this one won't have me wake up under a bridge!"
    
    geo "Ah... um... You didn't hear this, boys..."
    
    "His men don't know whether to laugh or stay quiet..."
    
    nvl clear
    
    geo "Anyway, this seems to work! I'm feeling better already!"
    
    da "Hmm... not so fast. It could just be a temporary feeling."
    da "I want to make sure this is the right one before I start making more."
    
    geo "Hm... Yeah... so... what, now?"
    
    da "Well, as hard as it is... we wait."
    
    geo "Oh, hum... I see... For how long?"
    
    da "I can't say... A few hours at least?"
    da "I'm no doctor, but if you really feel a positive result by then, I'll consider
    the parchment was right and the potion a success."
    
    geo "So be it then."
    
    $ renpy.music.stop()
    scene black with longdissolve
    
    $ renpy.pause(1.5)
    
    nvl clear
    
    "Time passes..."
    "Slowly..."
    
    $ renpy.pause(1.5)
    
    nvl clear
    
    "Three hours have passed now... and the Captain seems to be doing good."
    
    scene shop with dissolve
    
    nvl clear
    
    nvl show dissolve
    
    geo "I'm bored."
    
    da "How are you feeling Captain?"
    
    geo "As I said, I'm bored."
    
    da "No, no... I mean... your health... your body."
    
    geo "Oh?... uh...... hey..."
    
    geo "I'm fine."
    
    "The guards look at him."
    
    geo "I'm... I'm fine!"
    
    "He stands up, surprised at his own words."
    
    nvl clear
    
    geo "No more headache... and my mouth doesn't feel like it's stuffed with straw anymore!"
    
    geo "My back still hurts a bit but..."
    
    da "This should go away in a few days, I think."
    
    geo "So... does this mean it worked?"
    
    da "I'm pretty sure it's safe to assume, now."
    
    geo "Great! Now we should get enough potions ready to cure everyone!"
    
    nvl clear
    
    "The guards look relieved."
    
    da "Well I'm glad we are on the right path."
    da "Another good news is that I managed to lower the requirements to 1 Orpiment and 1 Amber."
    
    geo "Amazing... We will make it in time now!"
    
    nvl clear
    
    da "... I don't know... It's still a lot. And we don't have much time...
    We spent an eternity on this prototype..."
    
    geo "You look like you have an idea..."
    
    da "Yes... I might."
    
    da "But it's risky."
    
    geo "What do you mean?"
    
    da "I think I could make the requirements even lower... but I'm not absolutely certain. 
    It might fail."
    
    da "And if it does, we will have lost precious time again."
    
    geo "Hm..."
    
    da "On the other hand... if it works, we will make the needed potions in much less time, which would allow us
    to cure everyone in time with certainty."
    
    nvl clear
    
    geo "So... What you're saying is that we can either start making potions now but risk losing men if it takes too much time..."
    geo "Or make some research first in hope of making the potion easier to brew, which would ensure we cure everyone in time..."
    geo "... but doom them all if it fails..."
    
    da "That's... right, Captain."
    
    "Geoffroy scratches his head with a worried look."
    
    geo "While I understand where the dilemma lies... I think we'll have to trust your judgment on that one, sir."
    
    da "........."
    
    "Which path shall I take? Shall I gamble the lives of these men in hope of saving them all?... Or start working right away, well knowing
    they won't all make it if not for a miracle?"
    
    nvl clear
    
    # HOTFIX : allows player to make this quest potion even if they don't have enough
    # shelf room.
    
    $ r_guard.highpriority = True
    
    
    # HOTFIX : making the recipe less difficult since the new morale system makes it harder...
    
    $ r_guard.difficulty = 30
    
    
    # HOTFIX for Dolarmak savegame
    #
    $ chero = charapool['hero']
    $ cframb = charapool['framb']
    $ cpom = charapool['pom']
    
    menu:
        "Let's start making potions.":
        
            $ sickguard.state = "potions"
            
            da "I don't want to rely on luck when men's lives are at stake. 
            We will start brewing potions and will work hard to make it in time."
            
            geo "Sounds like a wise decision. We're counting on you."
            geo "I'll keep you updated on the state of our men."
            
            da "Hm... Thanks."
            
            geo "Oh no, thank {b}you{/b}, sir!"
            
            da "I'll deserve thanks when all your men are safe, Captain. And I'm going to make sure I'll deserve them."
            
            "The Captain salutes and leaves, leaving me with this heavy burden of a task."
        
        #
        "Let's try research.":
        
            $ sickguard.state = "research"
            
            $ chero.task = Occupied(chero, "Researching")   # Dalma is locked on Research for 3 days
            
            da "Let's try it..."
            
            "The guards look perplexed and Geoffroy scrutinizes me."
            
            geo "I trust you. If you think it's the right decision, let's do this."
            
            "I nod."
            
            da "I know I'm not the one taking the risk so I'm glad you trust me through this."
            
            guard "If it can save us all..."
            
            "I nod once more."
            
            da "I'll do my best."
            
            nvl clear
            
            "Geoffroy and his guards salute before leaving, seemingly rejoiced by
            our first success."
            
            "Okay... This is going to be tough. I'll have to study what's left of the
            tests and ingredients... and find a way to speed up the process."
            
            "This will probably take days..."
            
            "In the mean time, I think it's better to have Pom keep gathering while
            Framboise brews with our current recipe."
            
            "At least, I hope she can brew it properly... it's quite difficult."
            
            nvl clear
            
            "Pom might have to do it, otherwise, and alternate with gathering."
            
            "Hm... We won't be sleeping much these next days..."
        
        #
        
    #
    
    
    
    scene black with longdissolve
    
    return

#

label sickguard_found:
    nvl clear
    
    $ renpy.music.stop(fadeout=1)
    
    scene alchemy with fade
    
    nvl show dissolve
    
    "I found it!"
    
    $ renpy.music.play(eventm)
    
    "I knew I had seen a similar reaction from another ingredient..."
    
    "{b}Cinnamon{/b}!"
    
    
    "The only difference with Orpiment is that the required components are
    found in fewer quantities within the Cinnamon."
    
    "This means Framboise must get as much of it as possible."
    
    da "Yes... now I'm sure we can do it!"
    
    nvl hide dissolve
    
    scene black with longdissolve    
    
    return
    
#

label sickguard_report:
    nvl clear
    
    $ renpy.music.play(badm)
    
    scene shop with fade
    
    nvl show dissolve
    
    "Geoffroy enters the shop this morning, a grave expression on his face."
    
    geo "Sir %(name)s... How is it proceeding?"
    
    if etalage.getQty(p_guard) > 8:
        da "I don't want to sound too optimistic, but... it's going rather well."
        da "If we can keep up at this rate, we should have everything ready within a week."
        
        geo "A week?... Hm..."
        geo "This might be too long..."
        
        da "But... it might just as well be enough, Captain."
        da "You can already bring what we have to your men."
        
        nvl clear
        
        "Geoffroy nods, packing the potions."
        
        geo "Sir... It's obvious now that the healer won't be back in time..."
        "............"
        geo "We're counting on you, sir..."
        
        nvl hide dissolve
    #
    else:
        da "Hum... well..."
        
        da "We are having a few difficulties, really..."
        
        geo "Sir, you don't have to tell me... I can see my men writhing in pain."
        geo "What I want to know is whether you're trying your best or not..."
        
        da "Wh... what a thing to say! Captain, who do you think I am?!"
        da "You must realize it's a very difficult potion to brew and that the ingredients
        are not easy to come by."
        
        if sickguard.state == "researchdone":
            nvl clear
            
            geo "Didn't you tell me you found a replacement ingredient? One that
            would make things easier?"
            
            da "Um... yes, it's true... But it happens that this new ingredient
            is needed in larger quantities than Orpiment."
            
            geo "So... all that research was for nothing?"
            
            da "No, no. Cinnamon is still easier to come by, even though we need more
            of it. It's still a blessing."
            
            geo "Well, then... I guess what we're asking for is a miracle."
            
            da "I...... I understand..."
            
        #
        
        nvl clear
        
        "The Captain frowns and shakes his head... then sighs and goes on with a shaky voice."
        
        geo "Sir %(name)s..."
        
        "He tries to regain his composure."
        
        geo "Cough... I'm sorry if I sound harsh, but you must understand that
        I treat my men as family."
        geo "Therefore, I'm really begging you... Do whatever's in your capacities
        to save them..."
        geo "We {b}will{/b} be grateful, have no doubt about it."
        
        da "............ Understood, Captain..."
        
    #
    
    scene black with longdissolve
    
    return
#

label sickguard_end:
    nvl clear
    
    $ sickguard.died = 20 - etalage.remove(p_guard, qty=20)
    
    
    if sickguard.died == 0: # great! no one died!
        $ renpy.music.play(eventm)
        
        scene shop out with fade
        
        nvl show dissolve
        
        fr "Come on, %(name)s! They're waiting for you!"
        
        "Framboise pulls me out of the shop with a large smile."
        
        nvl hide dissolve
        
        $ renpy.pause(1.5)
        nvl clear
        
        nvl show dissolve
        
        "In front of me... twenty guards, accompanied by their Captain."
        "They all salute together."
        
        da "........."
        
        "I nod back, embarrassed..."
        
        geo "As you were!"
        
        "Everyone relaxes and smiles start appearing on their faces."
        
        guard "Thank you sir!"
        
        nvl clear
        
        "They all come to me, shaking my hands, giving me pats on the back."
        "Laughters can be heard as more people join the party."
        
        geo "Let's all have fun now!"
        
        "I don't think I have ever seen Geoffroy with such a broad smile."
        "He looks like a whole new man now that this burden has been lifted off."
        
        nvl hide dissolve
        
        nvl clear
        
        show framboise with dissolve
        
        nvl show dissolve
        
        fr "So... aren't you going to enjoy the party? You'd rather stay there?"
        
        da "Um...? Oh, haha, sorry... I was just... thinking."
        
        fr "Don't you think we deserve a little rest after all this?"
        
        "Framboise gives me her best smile. Truly an angel."
        
        fr "Aah! Apple pie!"
        
        nvl hide dissolve
        
        hide framboise with dissolve
        
        "And there she goes..."
        
        nvl hide dissolve
        
        $ renpy.pause(2)
        
        nvl clear
        
        nvl show dissolve
        
        da "So... having fun?"
        
        nvl hide dissolve
        
        show pom shade at right with dissolve
        
        pom "Hm....... Just looking at the sunset."
        
        "Pom is staying in the door frame, wearing his hood."
        
        da "Here, I brought you this."
        
        "I hand Pom a basket of cookies."
        
        da "They're pretty good."
        
        nvl clear
        
        "Pom doesn't take them."
        
        da "........... Hm... oh well..."
        
        "I walk away until I feel the basket swinging."
        "I look back and see that Pom is munching on the cookies and nothing's left in the
        basket I'm holding."
        
        da "Eheh... Quick little brat..."
        
        "I can see Pom grinning as he gives a bite into the next cookie."
        
        nvl clear
        
        "............."
        "The air is pure... and the birds are singing."
        
        "It really feels good..."
        "I think I'll go enjoy the party some more."
        
        nvl hide dissolve
        
        scene black with longdissolve
        
        $ renpy.pause(4)
        
    #
    elif sickguard.died < 10:   # up to half of them passed away :(
        $ renpy.music.stop()
        
        scene shop out with longfade
        
        nvl show dissolve
        
        guard "Thank you sir."
        
        "Geoffroy salutes, without a smile, but with evident relief."
        
        geo "Sir..."
        
        "I nod back"
        
        geo "In the name of all of us, I want to say... Thank you."
        geo "If not for your help, who knows what would have happened..."
        
        da "It's... nothing, really... I did what I had to do. I tried..."
        
        nvl clear
        
        "Geoffroy walks up to me and lays a hand on my shoulder."
        
        geo "Don't worry %(name)s, sir. We know you did everything you could."
        geo "And we will make sure the families of our friends who stayed behind will know it too."
        geo "By all means, don't... don't think too much about it."
        
        da "........."
        da "You know I will always have this thought tugging at my mind."
        da "I could have..."
        
        nvl clear
        
        "Geoffroy tightens his hold on my shoulder, making me stop."
        "He looks at me with his strong eyes and nods one last time."
        
        nvl hide dissolve
        
        $ renpy.pause(2)
        
        nvl clear
        
        nvl show dissolve
        
        "Sure... most of them made it, thanks to our work..."
        "But it will always feel like a bitter victory. One where some
        never reached the finish line..."
        
        nvl clear
        
        "Geoffroy and his men leave after a last salute, filled with emotions."
        "............"
        
        show framboise at left with dissolve
        
        fr "........"
        
        da "Hey..."
        
        "Framboise waves back, a soft smile on her lips."
        "And I can see Pom, in the frame of the door, looking at the sky."
        
        nvl clear
        
        "Framboise tugs at my sleeve."
        
        fr "Let's go home, %(name)s."
        
        "I nod and follow her in as the sun sets."
        
        scene black with longdissolve
        
        $ renpy.pause(1)
    #
    elif sickguard.died < 20:   # more than half of them!! :((
        $ renpy.music.play(badm)
        
        scene black with fade
        
        "We did try... we did..."
        
        fr "This is so horrible..."
        
        "We just didn't make it in time... The odds were against us..."
        
        pom "More than half of them..."
        
        "The odds..."
        
        nvl hide dissolve
        
        $ renpy.pause(2)
        
        nvl clear
        
        scene shop out with longdissolve
        
        guard "Thank you, sir..."
        
        geo "........."
        
        "Silence reigns..."
        
        "Geoffroy simply salutes... but I have a feeling he doesn't really mean it."
        "I know he expected more of me."
        
        nvl clear
        
        "I simply give a half-hearted smile back at the guard, avoiding the Captain's eyes."
        
        geo "Goodbye, sir..."
        
        "Where did I go wrong?... I'm not sure..."
        "But I know, deep inside, that we had the time and capacity to save them."
        "Maybe not all of them, but more than that..."
        
        nvl clear
        
        "I'm glad that the people in town think it was a really foul sickness."
        "I'm glad for Framboise and Pom... for the shop... At least they won't suffer from
        this too much..."
        "But I know I will..."
        "This will weigh on my heart for a long time... To remind me that I can do better than that."
        
        nvl hide dissolve
        
        scene black with longdissolve
        
        $ renpy.pause(2)
        
    #
    else:   # ouch... everyone died ;o;
        $ renpy.music.play(badm)
        
        scene black with fade
        
        ".........................."
        "What the hell did I do?... How could I screw up so bad?!"
        "Everyone... everyone of them is..."
        
        da "Dammit!!"
        
        "All I had to do was send Pom on a gathering mission... while Framboise and
        I would brew potions..."
        "Why... why did I do nothing?"
        
        nvl clear
        
        da "COUGH!"
        
        $ renpy.pause(2)
        nvl clear
        
        "Blood."
        
        da "What the...?"
        
        "I wipe my mouth off and stare at the stream of blood."
        "Did I... stay too much around them?..."
        
        "I thought... it wasn't... contagious..."
        
        "SLAM..."
        
        $ renpy.pause(2)
        
        nvl clear
        
        fr "%(name)s?..."
        
        fr "%(name)s!!!"
        
        nvl hide dissolve
        
        show text "Game Over" at truecenter with longdissolve
        $ renpy.pause(3)
        hide text with longdissolve
        $ renpy.pause(1)
        $ renpy.music.stop(fadeout=5)
        $ renpy.pause(5)
        $ renpy.full_restart()
    #
    
   
    
    jump theend     #directly jump to the end "quest"
    
    return
#


################################## THE END #######################################

label theend:

    # initial condition for the quest to begin
    if theend.state == 0:  
#     if theend.state == 0 and day==1:
#         $ clearquest(theend)
        $ save_name = "See you soon!"
        
        jump theend_end
    #

    return
#

label theend_end:

    nvl clear
    
    $ renpy.music.play(introm)
    
    scene shop with fade
    
    show framboise with dissolve
    
    nvl show dissolve
    
    fr "%(name)s?... What is it you want to tell us about?"
    
    nvl clear
    
    "It's been a few weeks since the sickness incident and things have returned
    back to normal."
    "The shop is running well, ingredients abound and potions fill the shelves."
    "Everyone seems to be content with the current situation..."
    "... but something is nagging at me."
    
    nvl hide dissolve
    
    show framboise at left
    show pom at right
    with dissolve
    
    nvl clear
    
    nvl show dissolve
    
    pom "So... what's up?"
    
    da "Okay... Listen..."
    
    da "I think that we have reached an important point in the life of the shop... 
    A milestone if you will."
    
    "They both look at me, uncertain of what's coming up."
    
    da "I'd... like to go in a slightly different direction with the shop."
    
    fr "Aah?..."
    
    nvl clear
    
    da "Yes..."
    da "With these last events, I have... realized that we had the power to help people."
    da "While not easy, it is something we can do."
    
    "I mark a pause and take my breath."
    
    da "I would like to do more."
    da "As of now, we are only selling very regular potions... Potions that other
    apothecaries can offer."
    da "We can do better... I'm sure we can find more... Make bigger things."
    
    nvl clear
    
    fr "More potions...?"
    
    da "Other potions! Unique potions... Ones that the world hasn't even seen yet!"
    da "That's what my grand-father, the previous owner of this shop, did!"
    da "I remember staying with him while he studied his books and parchments..."
    da "I remember him trying incredible things in his lab."
    da "He was..."
    da "... creating!"
    
    pom "Hm......"
    
    nvl clear
    
    "It seems I have sparked some interest in these two young people."
    
    fr "So... you want to make something new."
    da "Yes."
    fr "........."
    fr "For that, we will need to make research... and... we will need to find new ingredients."
    
    "I nod with a smile."
    
    pom "... We might even have to steer away from regular ingredients..."
    
    da "I... I suppose, yes!"
    
    nvl clear
    
    fr "%(name)s...?"
    
    da "Yes?"
    
    fr "Actually, I... I've been willing to ask something for some time now."
    
    da "What is it?"
    
    fr "Do you remember how you took me for a Cueilleur when I first came here?"
    
    da "Haha, yes... I... I remember that."
    
    fr "Well......"
    fr "I would like to try to become one, for real."
    
    $ renpy.pause(1.5)
    
    nvl clear
    
    pom "Are you serious, Fram?"
    
    fr "Quite."
    
    "Pom seems as surprised as I am."
    
    da "Wow... It's quite a quest on its own!"
    
    fr "I... I know... I don't even know if I can succeed but... I'm positive I want to try!"
    
    "My... I don't think I've ever seen so much determination in her eyes."
    
    nvl clear
    
    da "I understand... I respect that choice."
    
    pom "A... ACTUALLY!"
    
    da "???... Wh... what is it, Pom?"
    
    pom "Ah, um... sorry... Uh... I..."
    
    da ".............. Do you...?"
    
    "Pom seems hesitant."
    
    nvl clear
    
    pom "I'd like to learn more about alchemy."
    pom "I want to learn how to brew potions faster and... become better than you!"
    
    da "Eh...!..."
    
    pom "Aah... I mean...!"
    
    da "Hahahaha... No, no... it's all right."
    
    pom "........."
    
    da "That's quite a strong will you are showing today, both of you!"
    
    da "So... you both want to become better at your trade, hm?"
    
    fr "Y... yes..."
    
    "Pom answers me with a serious look."
    
    nvl clear
    
    $ renpy.music.stop(fadeout=1)
    
    da "Well, so be it then. I'm closing the shop."
    
    fr "EEH?!"
    
    pom "What the--?!"
    
    $ renpy.music.play(introm, fadein=3)
    
    "I burst out laughing."
    
    da "Tem-po-ra-ri-ly..."
    da "Haha, guys... you should have seen your faces!"
    
    "I keep laughing while both of them start pouting."
    
    da "Eheh... look at you..."
    
    "They realize how similarly they act and start blushing furiously."
    
    nvl clear
    
    da "Anyway... What I meant to say is..."
    da "... that I plan to close the shop for the time of a vacation."
    
    da "This will leave you time, Framboise, to study the trade of a Cueilleur."
    da "You, Pom, the intricate rules of alchemy..."
    da "... and me... I still have quite a few things to discover about this shop."
    da "I don't believe my grand-father hasn't left anything about his work around here."
    da "So I'll look for it."
    da "And once I find it... I know it will help us start this new business."
    
    "............."
    
    da "... So!... What do you say?"
    
    nvl hide dissolve
    
    scene black with Dissolve(1.5)
    
    nvl clear
    
    $ renpy.pause(1.5)
    
    show text "YEAH!" at truecenter
    with None
    
    $ renpy.pause(2)
    
    hide text with longdissolve
    
    $ renpy.pause(3)
    
    scene bedroom with dissolve
    
    nvl show dissolve
    
    fr "Nnnnng!"
    
    da "Want some help?"
    
    nvl hide dissolve
    
    show framboise with dissolve
    
    nvl show dissolve
    
    fr "Ah!... Yes, I guess... This suitcase just won't close itself!"
    
    da "You are asking it a bit too much maybe?..."
    
    fr "But... I will need that much where I'm going!"
    
    da "I thought you said that school was close to your parents'... and that you would live there?"
    
    "Framboise blushes and frowns with a cute little pout."
    
    da "So... um... That's how you close it right?"
    
    fr "Eh... Um, yes, yes."
    
    nvl hide dissolve
    
    scene black with longdissolve
    $ renpy.pause(1)
    
    scene shop with dissolve
    
    nvl clear
    
    nvl show dissolve
    
    da "... And you will stay there for a few months?"
    
    nvl hide dissolve
    
    show pom with dissolve
    
    nvl show dissolve
    
    pom "Yes... I know the old man... He won't mind teaching me a few tricks."
    
    da "It's a good thing you already have such a mentor. I'm eager to see what
    you will learn."
    
    pom "I will show you... So don't slack off on your side!"
    
    da "Tsk... No worries... I'll be sure to have some tricks up my sleeves when you come back!"
    
    pom ".........."
    
    "Pom smiles and holds out his hand."
    
    "I reach for it and shake it sincerely."
    
    nvl hide dissolve
    
    show pom shade with dissolve
    
    nvl clear
    
    nvl show dissolve
    
    "Pom puts on his hood, checks his daggers and heaves his bag on his shoulder."
    
    pom ".............."
    
    pom "See you soon..."
    pom "... old man!"
    
    da "Gh!... Why, you... little!"
    
    "Pom sticks out his tongue as he starts running away."
    
    scene shop out with dissolve
    
    nvl clear
    
    da "I... I'm still barely in my twenties!!"
    
    "I sigh, looking at him run through the street, waving his arm without looking back."
    
    da "See you soon, kiddo..."
    
    "He jumps into a dark alley, not to be seen again..."
    
    da "Ehh... I guess it's time to get back in."
    
    nvl hide dissolve
    
    scene black with longdissolve
    
    $ renpy.pause(2)
    
    nvl clear
    
    show framboise at left with longdissolve
    
    "Framboise..."
    
    show pom at right with longdissolve
    
    "Pom..."
    
    "I will be waiting for your return."
    "... For the renewal of our shop!"
    
    nvl hide dissolve
    
    nvl clear
    
    $ renpy.pause(3)
    
    hide pom
    hide framboise
    $ ui.window(style="banner")
    $ ui.text("THE END", style="banner")
#     show text "THE END" at truecenter
    with longdissolve
    
    $ ui.window(style="banner")
    $ ui.text("THE END", style="banner")
    $ renpy.pause(3)
    
    with longdissolve
    
    $ renpy.pause(1.5)
    
    $ ui.window(style="banner")
    $ ui.text("?", style="banner")
    $ renpy.pause(1.5)
    
    with dissolve
    
    $ renpy.pause(1.5)
    
label credits:
    
    scene bg_plain with dissolve
    $ movein(cframb)
    $ bubbleni("Original Concept and Game Design :\n\nMonele")
    with Pause(4)
    $ moveout(cframb)
    
    scene bg_crevice with dissolve
    $ movein(cpom)
    $ bubbleni("Original Music :\n\nDaFool")
    with Pause(4)
    $ moveout(cpom)
    
    scene alchemy with dissolve
    $ movein(chero)
    $ bubbleni("Scenario and Story :\n\nMonele")
    with Pause(4)
    $ moveout(chero)
    
    scene bedroom with dissolve
    $ movein(cframb)
    $ bubbleni("Drawn Backgrounds :\n\nDaFool")
    with Pause(4)
    $ moveout(cframb)
    
    scene bg_lake with dissolve
    $ movein(cpom)
    $ bubbleni("Programming and Resources :\n\nMonele")
    with Pause(4)
    $ moveout(cpom)
    
    scene town with dissolve
    $ movein(chero)
    $ bubbleni("Beta-testing :\n\nDaFool")
    with Pause(4)
    $ moveout(chero)
    
    scene bg_forest with dissolve
    $ movein(cframb)
    $ bubbleni("Character Design :\n\nMonele")
    with Pause(4)
    $ moveout(cframb)
    
    scene bedroom night with dissolve
    $ movein(cpom)
    $ bubbleni("Sprite Coloring :\n\nDaFool")
    with Pause(4)
    $ moveout(cpom)
    
    scene shop with dissolve
    $ movein(chero)
    $ bubbleni("Custom Quest\n'Framboise is sick' :\n\nJake")
    with Pause(4)
    $ moveout(chero)
    
    scene shop out with dissolve
    $ ui.window(style="banner")
    $ ui.text("Photo sources from\nstock.xchng\n(www.sxc.hu)", style="banner", text_align=0.5)
    with dissolve
    $ ui.window(style="banner")
    $ ui.text("Photo sources from\nstock.xchng\n(www.sxc.hu)", style="banner", text_align=0.5)
    with Pause(4)
    with dissolve
    
    $ ui.window(style="parch")
    $ ui.text(
        "Thanks to\n\n"+
        "DaFool for resurrecting the project\n"+
        "PyTom for creating Ren'Py\n"+
        "Blue Lemma for hosting the Lemma Soft forums\n"+
        "My parents for bearing with my game ravings\n"+
        "Everyone at the forums\n"+
        "Mat Job for 'Myranni's Magic' which sparked the idea\n"+
        "\n"+
        "... And those I forgot...\n"+
        "... because you always forget someone...",
        style="parch", ypos=.5, yanchor=.5, text_align=0.5
    )
    with dissolve
    $ ui.window(style="parch")
    $ ui.text(
        "Thanks to\n\n"+
        "DaFool for resurrecting the project\n"+
        "PyTom for creating Ren'Py\n"+
        "Blue Lemma for hosting the Lemma Soft forums\n"+
        "My parents for bearing with my game ravings\n"+
        "Everyone at the forums\n"+
        "Mat Job for 'Myranni's Magic' which sparked the idea\n"+
        "\n"+
        "... And those I forgot...\n"+
        "... because you always forget someone...",
        style="parch", ypos=.5, yanchor=.5, text_align=0.5
    )
    
    with Pause(14)
    with dissolve

    $ renpy.pause(1)
    
    $ renpy.music.stop(fadeout=16)
    
    scene shop outnight with Dissolve(10)
    $ renpy.pause(1)
    
    scene black with longdissolve
    
    $ renpy.pause(4)
    
    $ renpy.full_restart()
    
#


