﻿# MERCHANT INTERFACE

init -35:

    python:
    
    
        def displayProduct(item, style="default"):    # affiche un produit (pas de déco)
            ui.vbox(box_spacing=10)
            
            ui.hbox(box_spacing=10, xpos=0.5, xanchor=0.5)
            if item.pic <> None:
                ui.image(item.pic, ypos=0.5, yanchor=0.5)
            ui.text(item.name, size=20, text_align=0.5)
            ui.close()
            
            ui.hbox()
            ui.text("Price : ", style=style)
            ui.text(str(item.price), style=style)
            ui.close()
            
#             ui.text("Needed ingredients : "+item.sayNeeded(), style=style, xpos=0.0, xanchor=0.0)
            
            ui.text(item.desc, style=style)
            
            ui.hbox(box_spacing=10, xpos=.5, xanchor=.5)
            ui.textbutton("Buy", clicked=item.buy)
            ui.textbutton("Cancel", clicked=ui.returns(""))
            ui.close()
            
            ui.close()
        #
        
        def displayProdInfo(item):   # affiche la fiche d'info d'une recette
            ui.window()
            displayProduct(item)
        #
    
    
        #   Affiche une recette dans la liste (image et nom)
        #
        def displayMerchantItem(merchant, item, withthumb=False, talent=0, hovered=None, unhovered=None):
            ui.hbox()
            if merchant <> None and magasin.money < item.product.price:  #inactif (pas assez d'argent)
                ui.button(hovered=hovered, unhovered=unhovered)
            #
            else:
                ui.button(clicked=ui.returns(item), hovered=hovered, unhovered=unhovered)
            #
            ui.vbox(box_spacing=5)
            
            ui.hbox(box_spacing=10, xalign=0.5)
            if withthumb and item.product.pic <> None:
                ui.image(item.product.pic)
            #
#             else:
#                 ui.null()
#             #
            if merchant <> None and magasin.money < item.product.price:  # ne peut pas acheter
                ui.text(item.product.name, ypos=0.5, yanchor="center", minwidth=120, color=(255,0,0,255), size=16, text_align=0.5)
            else:
                ui.text(item.product.name, ypos=0.5, yanchor="center", minwidth=120, size=16, text_align=0.5)
            #
            ui.close()  #hbox
            
            ui.text("Quantity: x"+str(merchant.getQty(item.product)), size=12, xalign=0.5)
            ui.text("Price: "+str(item.product.price)+"g", size=12, xalign=0.5)
            
            ui.close()  #vbox
            
#             ui.text("("+str(merchant.getQty(item.product))+")", ypos=.5, yanchor=.5)
            ui.close()
        #
    
    
        def displayMerchant(merchant):     # affiche la liste des recettes connues
        
            ui.window()
            ui.vbox(box_spacing=5, box_first_spacing=30)
            
            ui.text(merchant.name, size=20, bottom_margin=50, xalign=0.5)
            
            rows = len(merchant.content)//2 + len(merchant.content)%2
            
            c = merchant.content[:]
            c.sort(lambda x,y: cmp(x.product.price, y.product.price))
            
            ui.grid(2,rows)
            for item in c:
                displayMerchantItem(merchant, item, True)
            #
            for i in range(2*rows - len(merchant.content)):
                ui.null()
            #
            ui.close()
            
            ui.null()
            ui.button(clicked=ui.returns(""), xpos=0.5, xanchor=0.5)
            ui.text("Go back")
            ui.close()
        
        #
        
        
        ###################################################


        def chooseProduct(merchant):       # affiche la liste produits vendus par le marchand
        
            def hoverButton(hovervalue, item, merchant, talent):
            
                def hovered(hovervalue=hovervalue):
                    renpy.log("hovered("+hovervalue.product.name+")")
                    if store.hovervalue <> hovervalue:
                        renpy.log("* Setting hover")
    
                        store.hovervalue = hovervalue
                        showRecipes(merchant, talent)
#                         renpy.transition(Dissolve(0.2))
                        renpy.restart_interaction()
                    return None
                #
                
                def clearText(hovervalue=hovervalue):
                    renpy.log("clearText("+hovervalue.product.name+")")
                    if store.hovervalue == hovervalue:
                        renpy.log("* No hover anymore")
                        store.ishover = False
                        store.hovervalue = ""
                        showRecipes(merchant, talent)
#                         renpy.transition(Dissolve(0.2))
                        renpy.restart_interaction()
    
                #                
                
                #ui.imagebutton(idle, active, clicked=clicked, hovered=hovered, unhovered=clearText, **properties)
                displaymerchantItem(item, withthumb=True, merchant=merchant, talent=talent, hovered=hovered, unhovered=clearText)
            #
            
            def showProducts(merchant, talent):
            
                ui.clear()
            
                ui.window(ypos=0.4)
                ui.vbox(box_spacing=10)
                
                ui.text("Brew...", style="title")
                
                c = merchant.content[:]
                c.sort(lambda x,y: cmp(x.product.price, y.product.price))
                
                rows = len(c)//2 + len(c)%2
                
                ui.grid(2, rows)
                for item in c:
#                     displaymerchantItem(item, withthumb=True, merchant=merchant, talent=talent)
                    hoverButton(item, item, merchant, talent)
                #
                for i in range(2*rows - len(c)):
                    ui.null()
                #
                ui.close()
                
                ui.button(clicked=ui.returns(False), style="marqueur")
                ui.text("Cancel", style="banner")
                
                ui.close()
                
                if store.hovervalue <> "":
                    ui.frame(style="banner", ypos=0.85)
                    ui.vbox(box_spacing=10)
                    ui.hbox(box_spacing=10, xpos=0.5, xanchor=0.5)
                    
                    for i in store.hovervalue.needed:
                        ui.hbox(box_spacing=5)
                        ui.text(str(i.qty)+"x", style="parch", ypos=.5, yanchor=.5)
                        ui.image(i.ingredient.picture, ypos=.5, yanchor=.5)
                        stocked = stock.getQty(i.ingredient)
                        if i.qty > stocked: # pas assez en stock
                            ui.text("("+str(stocked)+")", ypos=.5, yanchor=.5, style="parch", color="#f00")
                        #
                        else:
                            ui.text("("+str(stocked)+")", ypos=.5, yanchor=.5, style="parch")
                        #
                        ui.close()
                    #
                    ui.close()
                    
                    canbemade = store.hovervalue.canBeMade()
                    if canbemade == 0:
                        ui.text("No product can be made.", style="parch", color="#f00")
                    #
                    else:
                        ui.text(str(canbemade)+" products can be made ("+str(store.hovervalue.canMake(merchant,talent))+" per day).", style="parch")
                    #
                    
                    ui.close()
                #
            
            #
                
            store.hovervalue = ""
            
            while True:
        
                showRecipes(merchant, talent)
                
                res = ui.interact()
                
                if res <> "hover":
                    break
                #
            #
            
            return res
        #
        
    #       
#

