﻿# MERCHANT CLASSES

init -30:

    python:
 
        
        # ************ SELLABLE OBJECT (PRODUCT) *************
        # pic:  picture, l'image représentant la potion
        #
        class Product(object):
        
            def __init__(self, name, pic=None, price=10, function="", desc="No description"):
            
                self.name = name
                self.pic = pic      # image
                self.price = price
                self.function = function    # le nom de la fonction à appeler quand cet objet est acheté
                self.desc = desc    # description
            
            #

            def buy(self):
                res = self.function()
                if res == True:
                    magasin.money -= self.price
                return res
            #            
            
        #
        
        # ************ ETALAGE **************
        
        class ProdStock(object):
            "Objet représentant un lot de produits du même type."
            def __init__(self, product, qty=1):
                self.product = product
                self.qty = qty
            #
        #
        
        class Merchant(object):
        
            def __init__(self, capacity=-1, name="Merchant"):
                self.content = []
                self.capacity = capacity
                self.name = name
            #
            
            # Ajoute une potion dans cette quantité à l'étalage
            # (sous réserve de place disponible)
            # Renvoie le nombre de potions qui ont réellement pu être ajoutées
            # potion : une Potion
            #
            def add(self, product, qty=1):
            
                if self.capacity == -1:
                    realadd = qty
                #
                else:
                    surplus = self.getOccupation() + qty - self.capacity
                    if surplus < 0:
                        surplus = 0
                    realadd = qty - surplus
                #
                
                found = -1
                
                renpy.log("Merchant.add "+product.name+" x"+str(qty)+"... len content : "+str(len(self.content))+"  range : "+str(range(len(self.content))) )
                
                for i in range(len(self.content)):
                    renpy.log("loop")
                    if self.content[i].product == product:  # found it
                        renpy.log("found "+product.name)
                        found = i
                        break
                    #
                #
                
                if found == -1:
                    self.content.append(ProdStock(product, realadd))
                #
                else:
                    self.content[found].qty += realadd
                #
                
                return realadd
            
            #
            
            #   Tente d'enlever 'qty' produits du type donné. Renvoie le nombre de produits réellement enlevées.
            #
            def remove(self, product, qty=1):
                renpy.log("remove "+product.name+" from merchant.")
                found = False
                for i in self.content:
                    if i.product == product:
                        renpy.log("found "+product.name)
                        found = True
                        break
                #
                
                if found:
                    if i.qty < qty:
                        renpy.log("not enough products : "+str(i.qty)+" < "+str(qty))
                        realdel = i.qty
                        i.qty = 0
                    #
                    else:
                        renpy.log("enough products : "+str(i.qty)+" >= "+str(qty))
                        realdel = qty
                        i.qty -= qty
                    #
                    renpy.log("realdel : "+str(realdel))
                #
                else:
                    renpy.log("Couldn't find "+product.name)
                    realdel = 0
                #
                return realdel
            
            #
            
            #
            #
            def getQty(self, product):
                res = 0
                for i in self.content:
                    if i.product == product:
                        res = i.qty
                        break
                    #
                #
                return res
            #
            
            
            # Renvoie la place actuellement occupée chez le marchand
            #
            def getOccupation(self):
                occupied = 0
                for p in self.content:
                    occupied += p.qty
                #
                
                return occupied
            #
        
        #

    
    #
    
#


