﻿# MAP INTERFACE

init -35:

    python:
    
    
        def hoverImage(idle, active, hovervalue, clicked, **properties):
            def hovered(hovervalue=hovervalue):
                renpy.log("hovered("+hovervalue.name+")")
                if store.hovervalue <> hovervalue:
                    renpy.log("* Setting hover")

                    store.hovervalue = hovervalue
                    displayLocs()
                    renpy.transition(Dissolve(0.2))
                    renpy.restart_interaction()
                return None
            #
            
            def clearText(hovervalue=hovervalue):
                renpy.log("clearText("+hovervalue.name+")")
                if store.hovervalue == hovervalue:
                    renpy.log("* No hover anymore")
                    store.ishover = False
                    store.hovervalue = ""
                    displayLocs()
                    renpy.transition(Dissolve(0.2))
                    renpy.restart_interaction()

            #                
            
            ui.imagebutton(idle, active, clicked=clicked, hovered=hovered, unhovered=clearText, **properties)
        #
        
        
        def displayLocs():     # affiche les lieux (faire "scene carte" avant)
            ui.clear()
            
            for item in carte.locs:
                hoverImage(item.picture, item.picture_sel, item, clicked=ui.returns(item), xanchor="center", yanchor="center", xpos=item.x, ypos=item.y)
                #ui.imagebutton(item.picture, item.picture_sel, clicked=ui.returns(item.name), hovered=lochover, xanchor="center", yanchor="center", xpos=item.x, ypos=item.y)
            #
            
            ui.image("home.png", xpos=home.x, ypos=home.y, xanchor=0.5, yanchor=0.5)
            
            if store.hovervalue <> "":
                ui.window(ypos=0.90, style="banner", top_padding=20, bottom_padding=25)
                ui.vbox(box_spacing=3)
                dist = ""
                if store.hovervalue.distance*2 > store.currentchara.vehicle.speed:
                    total = store.hovervalue.distance*2//store.currentchara.vehicle.speed
                    if store.hovervalue.distance*2%store.currentchara.vehicle.speed <> 0:
                        total += 1
                    dist = " ("+str(int(total))+" days trip)"
                ui.text(store.hovervalue.name+dist, style="banner")
                if store.hovervalue.lenKnown() > 0:
                    ui.hbox(box_spacing=5, xpos=0.5, xanchor=0.5)
#                     ui.text("(", style="parch")
                    for i in store.hovervalue.known:
                        ui.image(i.picture)
                    #
#                     ui.text(")", style="parch")
                    ui.close()
                #
                ui.close()
            #    
            
            ui.frame(xpos=640, ypos=480, xanchor="right", yanchor="bottom")
            ui.textbutton("Cancel", clicked=ui.returns(False))
        #
        


        def showMap():       # affiche la carte et permet de sélectionner un lieu. Renvoie le lieu sélectionné
        
            renpy.log("showMap()")
        
            store.hovervalue = ""
            store.ishover = False
            
            renpy.transition(dissolve)
            renpy.show("carte")
            
            displayLocs()
                
            res = ui.interact()
            
            renpy.hide("carte")
            return res
        #
        
        def chooseGather(gathertask): # affiche la sélection du lieu et des ingrédients sur lesquels on peut focaliser
        
            store.currentchara = gathertask.chara
            
            renpy.log("chooseGather()")
            
            while True:
                ui.clear()
                ui.window()
                ui.vbox(box_spacing=10)
                ui.text("Gather at...", xpos=.5, xanchor=.5)
                if gathertask.location <> None:
                    ui.textbutton(gathertask.location.name, clicked=showMap)
                else:
                    ui.textbutton("Pick a location", clicked=showMap)
                #
                if gathertask.location <> None:
                    ui.null()
                    ui.text("Focus on...", xpos=.5, xanchor=.5)
                    
                    ui.hbox(box_spacing=1, xpos=.5, xanchor=.5)
                    ui.button(clicked=ui.returns(ingall), style="minibutton", role=role(gathertask.focus==None))
                    ui.image("any.png", )
                    for i in gathertask.location.known:
                        if gathertask.chara.getTask(Gather).getFactor(i.category) > 0:  # n'afficher que les ingrédients récoltables par ce perso
                            ui.button(clicked=ui.returns(i), style="minibutton", role=role(gathertask.focus==i))
                            ui.image(i.picture)
                        #
                    #
                    ui.close()
#                     if gathertask.focus <> None:
#                         ui.text(gathertask.focus.name, xpos=.5, xanchor=.5)
#                     #
                #
                if gathertask.location <> None:
                    ui.null()
                    ui.textbutton("OK", clicked=ui.returns(gathertask))
                #            
                ui.close()
                
                res = ui.interact()
                
                renpy.log("chooseGather interact")
                
                if res <> "":
                    renpy.log("res type : "+str(type(res)))
                    if isinstance(res, Location):
                        renpy.log("res is location")
                        gathertask.location = res
                        gathertask.focus = None
                    #
                    elif isinstance(res, Ingredient):
                        renpy.log("res is ingredient")
                        if res <> ingall:
                            gathertask.focus = res
                        #
                        else:
                            gathertask.focus = None
                        #
                    #
                    elif isinstance(res, Gather):
                        renpy.log("res is task")
                        break
                    #
                #
                else:
                    break
                #
                
            #
            
            if res == "":
                res = False
            return res
        
        #
        
        
    #
#

