﻿# LOCATION CLASSES


init -30:
    python:
    
    
        # Représente la présence d'un ingrédient dans un lieu
        #
        # rarefactor : le facteur de rareté dans ce lieu, pour cet ingrédient.
        # Pour rendre un ingrédient plus courant, utiliser 1, 2, 3, etc...
        # Pour rendre un ingrédient plus rare, utiliser 0.5, 0.25, 0.1, etc...
        #
        class IngNest(object):
            
            def __init__(self, ingredient, rarefactor=1.0):
                self.ingredient = ingredient
                self.factor = 1.0/rarefactor
            #
            
            def getRarity(self):
                return self.ingredient.rarity * self.factor # voir ci-dessus, self.factor = 1.0/rarefactor
            #
        
        #
        
        class Location(object):
        
            def __init__(self, name, x, y, bg=Solid((0,0,0,255)), picture="loc.png", picture_sel="loc_sel.png", distance=1):
                self.name = name
                self.x = x      # position sur la carte
                self.y = y
                self.picture = picture      # image représentant le lieu
                self.picture_sel = picture_sel
                self.bg = bg
                self.distance = distance    # distance de la boutique en unités de déplacement (vu que dépendant de la vitesse) (0.5 au minimum, équivalent à une demi-journée pour un aller)
                self.nests = [] # lot d'ingrédients trouvable dans ce lieu
                self.known = [] # ingrédients découverts dans cet endroit
            #
            
            # Définit les ingrédients trouvables dans ce lieu
            #
            # nests : tableau de IngNest  (ingrédient+facteur de rareté)
            #
            def setNests(self, nests):
                self.nests = nests
                
                self.sortNests()
            #
            
            # Ajoute un ingrédient trouvable dans ce lieu
            #
            # nest : un ou plusieurs objets IngNest (ingrédient + facteur de rareté) séparés par une virgule
            #
            def addNest(self, *args):
                for i in  args:
                    self.nests.append(i)
                #
                
                self.sortNests()
            #
            
            # Range les nids par ordre décroissant de rareté
            #
            def sortNests(self):
                self.nests.sort(lambda x, y: cmp(x.getRarity(), y.getRarity()))
                self.nests.reverse()
            #
            
            #   Ajoute l'ingrédient à la liste des ingrédients connus de cet endroit
            #   à condition qu'il ne se trouve pas déjà dans la liste
            #
            def addKnown(self, ingredient):
                found = False
                for i in self.known:
                    if i == ingredient:
                        found = True
                        break
                    #
                #
                
                if not found:
                    self.known.append(ingredient)
                #
            #
            
            def lenKnown(self):
                return len(self.known)
            #
        #
        
        
        class Map(object):
            def __init__(self):
                self.locs = []
            #
            
            def add(self, location):
                self.locs.append(location)
            #
            
            def remove(self, location):
                self.locs.remove(location)
            #
        #
        
        
        def newLocation(location):
        
            carte.add(location)
            
            renpy.transition(dissolve)
            
            ui.window()
            ui.vbox(box_first_spacing=15)
            ui.text("New location !", xpos=.5, xanchor=.5)
            
            ui.hbox(box_spacing=10, xpos=.5, xanchor=.5)
#             ui.image(recette.potion.pic, ypos=.5, yanchor=.5)
            ui.text(location.name, ypos=.5, yanchor=.5)
            ui.close()
            
            ui.close()
            
            ui.saybehavior()
            ui.interact()
        
        #
        
    #
#
