﻿
label inititem:

    python:
    
        
        ####################### INGREDIENTS + STOCK #####################

        # INGREDIENT CATEGORY LIST
        
        ingcateg = {'herb': IngCategory("Herb"),
                    'plant': IngCategory("Plant"),
                    'fruit': IngCategory("Fruit"),
                    'mineral': IngCategory("Mineral"),
                    'mammal': IngCategory("Mammal"),
                    'bird': IngCategory("Bird"),
                    'fish': IngCategory("Fish")
                    }
        
        
        # INGREDIENT LIST

        ingall = Ingredient("All")
        
        ingredients = {'cinnamon': Ingredient("Cinnamon", ingcateg['herb'], 10, 28, "Bark; flavoring, anti-microbial", "ing_cinnamon.png", "cinnamon.png"),
                'fennel': Ingredient("Fennel", ingcateg['herb'], 5, 8, "Medicinal and culinary uses", "ing_fennel.png", "fennel.png"),
                'clover': Ingredient("Clover", ingcateg['plant'], 3, 3, "Flower used for tea, dye", "ing_clover.png", "clover.png"),
                'resin': Ingredient("Resin", ingcateg['mineral'], 16, 75, "Varnish, incense, flammable", "ing_resin.png", "resin_illust.png"),
                'amber': Ingredient("Amber", ingcateg['mineral'], 20, 360, "Fossilized resin; decorative", "ing_amber.png", "amber_illust.png"),
                'orpiment': Ingredient("Orpiment", ingcateg['mineral'], 35, 280, "Strong yellow pigment, toxic", "ing_orpiment.png", "orpiment_illust.png"),
                'bberry': Ingredient("Blue Berries", ingcateg['fruit'], 11, 12, "Berries for food use only", "ing_blueberry.png", "blueberry_illust.png"),
                'nut': Ingredient("Hazelnuts", ingcateg['fruit'], 7, 0, "Found in those big trees... guarded by squirrels.", "ing_hazelnut.png", "illust_hazelnut.png"),
                'feather': Ingredient("Feathers", ingcateg['bird'], 10, 1, "Fallen or plucked from a bird. They are said to have levitating properties.", "ing_feather.png", "illust_feather.png"),
                'fur': Ingredient("Animal Fur", ingcateg['mammal'], 10, 1, "Sometimes found stuck on branches or on trees bark."),
                'scales': Ingredient("Fish Scales", ingcateg['fish'], 10, 1, "First, you have to catch a fish. Then, you have to get the scales off it. Mirror armors, the scales are often used in protective magic.")
                }
        
        # INITIAL STOCKS
        
        stock = Stock(1000)
        
        stock.add(ingredients['cinnamon'], 20)
        stock.add(ingredients['fennel'], 80)
        stock.add(ingredients['clover'], 80)
#         stock.add(ingredients['resin'], 3)
#         stock.add(ingredients['bberry'], 1)
                
          
        # POTION LIST #############################################
        
        potions = {'wcure': Potion("Weak Cure", "potion_weakcure.png", price=8, desc="Cures simple poisons and sicknesses.\nA favorite of scholar's mothers."),
                    'scure': Potion("Strong Cure"),
                    'wheal': Potion("Weak Heal", "potion_weakheal.png", price=4, desc="Heals very light bruises.\nWho needs band-aid anyway?"),
                    'eheal': Potion("Extreme Heal", "potionhealf.gif", price=100, desc="Heals even fallen limbs."),
                    'bullstr': Potion("Ram's Strength", "potion_bulls.png", price=15, desc="Temporarily gives the strength of the ram. Just don't run into doors, please."),
                    'foxcunn': Potion("Fox's Wit", "potion_fox.png", price=22, desc="A drink of this and you will be as cunning as a fox!\nTaking advantage of crows is forbidden, though..."),
                    'gbreath': Potion("Breath of the Just", "potion_breath.png", price=35, desc="A sip of it and you will kill flies with your breath no more.\nFor all dandies with an odorant problem.")
                    }
                
                      
        ########################## RECETTES + GRIMOIRE #######################
        
        # RECETTE LIST
        
        recettes = {'wcure': Recette(potions['wcure'], 3, [IngQty(ingredients['cinnamon'],1)], reputation=10, desc="Using crushed cinnamon and simple water, one can obtain a curative ailment.", maxrep=80),
                    'wheal': Recette(potions['wheal'], 4, [IngQty(ingredients['fennel'],1)], reputation=10, desc="Heated fennel mixed with water gives a healing solution.", maxrep=80),
                    'eheal': Recette(potions['eheal'], 35, [IngQty(ingredients['clover'], 50)], reputation=0, desc="This is an extremely complex recipe.", maxrep=40),
                    'bullstr': Recette(potions['bullstr'], 8, [IngQty(ingredients['clover'],3), IngQty(ingredients['fennel'],1)], reputation=10, desc="Using macerated clover leaves mixed with crushed fennel, one can make a potion providing extraordinary strength.", maxrep=50),
                    'foxcunn': Recette(potions['foxcunn'], 15, [IngQty(ingredients['clover'],5)], reputation=10, desc="Lots of fresh clover leaves are needed for this potion but it makes you very smart for a short while.", maxrep=40),
                    'gbreath': Recette(potions['gbreath'], 20, [IngQty(ingredients['bberry'],1), IngQty(ingredients['fennel'],5)], reputation=0, desc="Blue berries freshen your mouth. Combined with fennel to empower this property, they even freshen your breath!", maxrep=30)
                    }
                    
        # GRIMOIRE
        
        grimoire = Grimoire()
        
        grimoire.add(recettes['wcure'])
        grimoire.add(recettes['wheal'])
#         grimoire.add(recettes['eheal'])
        grimoire.add(recettes['bullstr'])
        grimoire.add(recettes['foxcunn'])
                
                
                
                    
     
        

        
        ########################## ETALAGE #########################        
        
        # ETALAGE
        
        etalage = Etalage()
        
        etalage.add(potions['wcure'], 10)
        etalage.add(potions['bullstr'], 3)
        etalage.add(potions['foxcunn'], 2)
        etalage.add(potions['wheal'], 10)
        
        
        # STATS
        
        salestats = Etalage(-1)
        
        
        
        # QUEST STUFF
        
        
        p_guard = Potion("??? Cure", "potion_guard.png", 70, desc="This potion is meant to cure the local guard from their strange sickness.")
        r_guard_needed1 = [IngQty(ingredients['orpiment'],1), IngQty(ingredients['amber'],1)]
        r_guard_needed2 = [IngQty(ingredients['cinnamon'],5), IngQty(ingredients['amber'],1)]
        r_guard = Recette(p_guard, 30, r_guard_needed1, reputation=0, desc="")

    #
    
    return
#
