﻿# ITEM CLASSES (ingredient, recipe, etc...)

init -30:

    python:
    
        #********* INGREDIENTS ************
    
        class Ingredient(object):
            "Un simple ingredient"
            def __init__(self, name, category=None, rarity=10, weight=0, description="No description", picture="any.png", illust="spacer.gif"):
                self.name = name
                self.category = category
                self.rarity = rarity        # 10 = common / < 10 = very common / > 10 = rarer
                self.weight = weight         # en gramme, par unité
                self.description = description     # description libre
                self.picture = picture      # nom de l'image représentant l'ingrédient
                self.illust = illust        # grande image d'illustration (façon dessin crayonné)
            #           
            
        #
        
        class IngCategory(object):
            "Une catégorie d'ingrédient."
            def __init__(self, name):
                self.name = name
            #
        #
        
        #************* STOCKS ************
        
        class IngQty(object):
            "..."
            def __init__(self, ingredient, qty=0):
                self.ingredient = ingredient
                self.qty = qty
            #
        #
        
        class Stock(object):
            "..."
            
            def __init__(self, capacity=500):
                self.content = []
                self.capacity = capacity
            #
            
            # Renvoie la place actuellement occupée dans les stocks
            #
            def getOccupation(self):
                occupied = 0
                for p in self.content:
                    occupied += p.qty
                #
                
                return occupied
            #
            
            #
            #
            def getQty(self, ingredient):
                res = 0
                for i in self.content:
                    if i.ingredient == ingredient:
                        res = i.qty
                        break
                    #
                #
                return res
            #
            
            
            # ajoute l'ingrédient dans cette quantitée aux stocks
            # ingredient : un Ingredient
            #
            def add(self, ingredient, qty=1):
            
                surplus = self.getOccupation() + qty - self.capacity
                if surplus < 0:
                    surplus = 0
                realadd = qty - surplus
                
                found = -1
                
                renpy.log("Stock add "+ingredient.name+"... len content : "+str(len(self.content))+"  range : "+str(range(len(self.content))) )
                
                for i in range(len(self.content)):
                    if self.content[i].ingredient == ingredient:  # found it
                        renpy.log("Found "+ingredient.name)
                        found = i
                        break
                    #
                #
                
                if found == -1:
                    self.content.append(IngQty(ingredient, realadd))
                #
                else:
                    self.content[found].qty += realadd
                #
                
                return realadd
            
            #
            
            
            # enlève cette qté de l'ingrédient. Si la quantité n'est pas
            # précisée, tout le stock de cet ingrédient est enlevé.
            #
            # Renvoie True si l'opération s'est déroulée correctement.
            # Renvoie False s'il n'y a pas assez d'ingrédients (et n'effectue pas leur retrait!)
            #
            def remove(self, ingredient, qty=-1):   
                
                res = True
                
                renpy.log("Looking for "+ingredient.name+" in stocks.")
                for i in self.content:
                    if i.ingredient == ingredient:
                        renpy.log(ingredient.name+" found.")
                        if i.qty >= qty:
                            i.qty -= qty
                        #
                        else:
                            res = False
                        #
                        break
                    #
                #
            
                return res
            
            #
            
        #
        
        
        # ************ RECETTES ***************
        
        # 
        #
        class Recette(object):
        
            def __init__(self, potion=None, difficulty=5, needed=[], reputation=0, desc="No description", maxrep=100, highpriority=False):
            
                self.potion = potion    # la potion que cette recette génère
                self.difficulty = difficulty    # difficulté à faire cette potion (1 à infini)
                
                self.needed = needed    # list of needed ingredients (IngQty objects)
                
                self.desc = desc
                
                self.reputation = reputation
                self.maxrep = maxrep
                
                self.highpriority = highpriority
            
            #
            
            def sayNeeded(self):
                res = ""
                for i in self.needed:
                    res += i.ingredient.name+" ("+str(i.qty)+")"+", "
                #
                
                res = res[:len(res)-2]
                
                return res
            #
            
            # Returns the number of potions that can be made with the current ingredients
            #
            def canBeMade(self):
                res = -1
                
                for i in self.needed:
                    available = stock.getQty(i.ingredient)
                    canbemade = available // i.qty
                    if res == -1 or canbemade < res:
                        res = canbemade
                    #
                #
                
                return res
            #
            
            # Tries making the asked number of potions based on the recipe.
            #
            # Returns the actual number of potions that could be made depending on available ingredients.
            # Removes the ingredients for all the potions that could be made!
            #
            # maxqty : based on room left on the shelves, how many potions we can *store*, independantly of how many we *can* make.
            #
            def tryMaking(self, qty, maxqty, task=None):
                res = 0
                state = 0   # 0=everything's ok ; 1=not enough ingredients; 2=not enough storage room; 3=not enough ability
                
                if task <> None and task.getAbility() < self.difficulty:
                    renpy.log("Not enough ability!")
                    state = 3
                #
                else:
                
                    for t in range(qty):    # tries t times (one per wanted potion)
                        could = True
                        for i in self.needed:   # tries to remove each needed ingredient
                            could = stock.remove(i.ingredient, i.qty)
                            if not could:   # one ingredient wasn't found in sufficient quantities
                                break
                            #
                        #
                        if not could:   # the current potion couldn't be made (not enough ingr.), we stop here
                            state = 1
                            break
                        #
                        res += 1
                        
                        if not self.highpriority and res == maxqty:   # we can't store anymore potions, we stop here
                            state = 2
                            break
                    #
                #
                                
                return (res,state)
            #
            
            # Returns the number of potions than can be brewed by this character at this time.
            # Based on talent and current morale.
            #
            def canMake(self, brewer, talent):
                return (talent+(brewer.morale*talent//100)) // self.difficulty
            #
            
            #   Diminie la réputation du magasin par la valeur donnée. Minimum 0.
            #
            def repdown(self, value):
                self.reputation -= value
                if self.reputation < 1:
                    self.reputation = 1.0
            #
            
            #   Augmente la réputation. Limité par défaut à 100 (voir maxrep)
            #
            def repup(self, value):
                self.reputation += value
                if self.reputation > self.maxrep:
                    self.reputation = self.maxrep
                #
            #
            
        
        #
        
        
        # ************** GRIMOIRE *************
        
        class Grimoire(object):
            def __init__(self):
                self.content = []   # contient des objets Recette
            #
            
            def add(self, recette):
            
                self.content.append(recette)
            
            #
            
            def sort(self):
                self.content.sort(lambda x, y: cmp(x.potion.price, y.potion.price))
                self.content.reverse()
            #
            
            #   Renvoie la somme de réputation de toutes les recettes connues
            #
            def getTotalRep(self):
                return sum([x.reputation for x in self.content])
            #
            
            #   Renvoie la recette permettant de faire la potion donnée
            #
            def getRecipeFrom(self, potion):
                for i in self.content:
                    if i.potion == potion:
                        return i
                    #
                #
                return False    # cas où on n'a pas trouvé la recette (ne devrait jamais arriver o_o...)
            #
        #
        
        
        
        # ************ POTIONS *************
        # pic:  picture, l'image représentant la potion
        #
        class Potion(object):
        
            def __init__(self, name, pic="spacer.gif", price=10, desc="No description"):
            
                self.name = name
                self.pic = pic      # image
                self.price = price
                self.desc = desc    # description
            
            #
        
        #
        
        # ************ ETALAGE **************
        
        class PotStock(object):
            "Objet représentant un lot de potions de même type, à des fins de stockage."
            def __init__(self, potion, qty=1):
                self.potion = potion
                self.qty = qty
            #
        #
        
        class Etalage(object):
        
            def __init__(self, capacity=100):
                self.content = []
                self.capacity = capacity
            #
            
            # Ajoute une potion dans cette quantité à l'étalage
            # (sous réserve de place disponible)
            # Renvoie le nombre de potions qui ont réellement pu être ajoutées
            # potion : une Potion
            #
            def add(self, potion, qty=1):
            
                if self.capacity == -1 or grimoire.getRecipeFrom(potion).highpriority:
                    renpy.log("Adding everything (special shelves or special potion)")
                    realadd = qty
                #
                else:
                    surplus = self.getOccupation() + qty - self.capacity
                    if surplus < 0:
                        surplus = 0
                    realadd = qty - surplus
                #
                
                found = -1
                
                renpy.log("Etalage.add "+potion.name+" x"+str(qty)+"... len content : "+str(len(self.content))+"  range : "+str(range(len(self.content))) )
                
                for i in range(len(self.content)):
                    renpy.log("loop")
                    if self.content[i].potion == potion:  # found it
                        renpy.log("found "+potion.name)
                        found = i
                        break
                    #
                #
                
                if found == -1:
                    self.content.append(PotStock(potion, realadd))
                #
                else:
                    self.content[found].qty += realadd
                #
                
                return realadd
            
            #
            
            #   Tente d'enlever 'qty' potions du type donné. Renvoie le nombre de potions réellement enlevées.
            #
            def remove(self, potion, qty=1):
                renpy.log("remove "+potion.name+" from shelves.")
                found = False
                for i in self.content:
                    if i.potion == potion:
                        renpy.log("found "+potion.name)
                        found = True
                        break
                #
                
                if found:
                    if i.qty < qty:
                        renpy.log("not enough potions : "+str(i.qty)+" < "+str(qty))
                        realdel = i.qty
                        i.qty = 0
                    #
                    else:
                        renpy.log("enough potions : "+str(i.qty)+" >= "+str(qty))
                        realdel = qty
                        i.qty -= qty
                    #
                    renpy.log("realdel : "+str(realdel))
                #
                else:
                    renpy.log("Couldn't find "+potion.name)
                    realdel = 0
                #
                return realdel
            
            #
            
            #
            #
            def getQty(self, potion):
                res = 0
                for i in self.content:
                    if i.potion == potion:
                        res = i.qty
                        break
                    #
                #
                return res
            #
            
            
            # Renvoie la place actuellement occupée dans les étagères
            #
            def getOccupation(self):
                occupied = 0
                for p in self.content:
                    occupied += p.qty
                #
                
                return occupied
            #
            
            def getFree(self):
                return self.capacity - self.getOccupation()
            #
        
        #
    
    #

#
