﻿# INTERFACE FUNCTIONS

# Pour afficher des statistiques et autres informations par exemple...


init -1:

    python:
    
        # FONCTION GLOBALE POUR LES BOUTONS
        
        #
        #
        def role(selected):
            if selected:
                return "selected_"
            #
            else:
                return ""
            #
        #
    
        # FONCTIONS POUR LES INGREDIENTS
    
        #   Fiche info d'un ingrédient (grande image et description)
        #
        def displayIngredient(item, style="default"):    # affiche un ingrédient unique (sans décoration)
            ui.hbox(box_spacing=10)
            ui.image(item.illust, ypos=0.5, yanchor="center")
            ui.vbox()
            ui.text(item.name+" ("+item.category.name+")", style="title")
            ui.text("Weight: "+str(item.weight)+"g", style=style, xpos=0.0, xanchor=0.0)
            ui.hbox()
            ui.text("Rarity: ", style=style)
            ui.bar(150, 25, 150, item.rarity, ypos=0.35, yanchor=0.5)
            ui.text("("+str(item.rarity)+")", style=style)
            ui.close()
            ui.null(ymargin=10)
            ui.text(item.description, style=style)
            ui.close()
            ui.close()
        #
        
        def displayIngInfo(item):   # affiche la fiche d'info d'un ingrédient
            ui.window(style="parch")
            displayIngredient(item, style="parch")
        #
    
        def displayIngList():       # affiche la liste des ingrédients (tous!) (avec décoration)
            
            ui.window()
            ui.vbox(box_spacing=5)
            for item in inglist:
                displayIngredient(item)
            #
            ui.close()
        #
        
        # FONCTIONS POUR LE STOCK
        
        #   Affiche un ingredient dans la liste (petite image et qté)
        #
        def displayStockItem(item, withthumb=False):
            ui.button(clicked=ui.returns(item.ingredient))
            ui.hbox(box_spacing=10)
            if withthumb:
                ui.image(item.ingredient.picture)
            #
            else:
                ui.null()
            #
            ui.text(item.ingredient.name, ypos=0.5, yanchor="center", minwidth=120)
            if item.qty > 0:
                ui.text("x"+str(item.qty), ypos=0.5, yanchor="center", minwidth=30)
            #
            else:
                ui.text("x"+str(item.qty), ypos=0.5, yanchor="center", minwidth=30, color=(255,0,0,255))
            #
            ui.close()
        #
        
        def displayStock():     # affiche la liste des ingrédients dans les stocks, ainsi que leur quantité
        
            ui.window()
            ui.vbox(box_spacing=5, box_first_spacing=10)
            
            ui.text("Stocks", xpos=0.5, xanchor=0.5)
            
            ui.null()
            ui.text("Room left : "+str(stock.capacity-stock.getOccupation())+" / "+str(stock.capacity), xpos=.5, xanchor=.5)
            ui.null()
            
            c = stock.content[:]
            c.sort(lambda x,y: cmp(x.ingredient.rarity, y.ingredient.rarity))
            
            rows = len(stock.content)//2 + len(stock.content)%2
            
            ui.grid(2, rows, xpos=0.5, xanchor=0.5)
            for item in c:
                displayStockItem(item, True)
            #
            for i in range(2*rows - len(stock.content)):
                ui.null()
            #
            ui.close()
            
            ui.null()
            ui.textbutton("Go back", clicked=ui.returns(""))
            ui.close()
        
        #
        
        
        
        # FONCTIONS POUR LES INGREDIENTS
    
        def displayPotion(item, style="default"):    # affiche une potion unique (sans décoration)
            ui.vbox(box_spacing=10)
            
            ui.hbox(box_spacing=10, xpos=0.5, xanchor="center")
            ui.image(item.pic, ypos=0.5, yanchor=0.5)
            ui.text(item.name, style="title")
            ui.close()
            ui.null()
            ui.text(item.desc, style=style, xmaximum=400)
            ui.null()
            
            ui.hbox(box_spacing=3, xpos=.5, xanchor=.5)
            ui.text("Base price : "+str(item.price), style=style, ypos=.5, yanchor=.5, size=20)
            ui.image("money.png", ypos=.6, yanchor=.5)
            ui.close()
            
            ui.hbox(box_spacing=3, xpos=.5, xanchor=.5)
            letaux = (grimoire.getRecipeFrom(item).reputation-50)/100.0
            leprix = int(item.price+item.price*letaux)
            if debug==1:
                renpy.log("le taux : "+str(letaux))
                renpy.log("prix de "+item.name+" : "+str(leprix))
            ui.text("Current price : "+str(leprix), style=style, ypos=.5, yanchor=.5, size=25)
            ui.image("money.png", ypos=.6, yanchor=.5)
            ui.close()
           
            
            ui.close()
        #
        
        def displayPotInfo(item):   # affiche la fiche d'info d'une potion
            ui.window(style="parch")
            displayPotion(item, "parch")
        #
        
    
        def displayPotList():       # affiche la liste des potions (toutes!) (avec décoration)
            
            ui.window()
            ui.vbox(box_spacing=5)
            for item in potions:
                displayPotion(item)
            #
            ui.close()
        #
        
        # FONCTIONS POUR L'ETALAGE (SHELVES)
        
        def displayEtalageItem(item, withthumb=False):
            ui.button(clicked=ui.returns(item.potion))
            ui.hbox(box_spacing=10)
            if withthumb:
                ui.image(item.potion.pic)
            #
            else:
                ui.null()
            #
            ui.text(item.potion.name, ypos=0.5, yanchor="center", minwidth=150)
            if item.qty > 0:
                ui.text("x"+str(item.qty), ypos=0.5, yanchor="center", minwidth=35)
            #
            else:
                ui.text("x"+str(item.qty), ypos=0.5, yanchor="center", minwidth=35, color="#f00")
            #
#             ui.imagebutton("info.png", "info_sel.png", , ypos=0.5, yanchor="center")
            ui.close()
        #
        
        def displayEtalage():     # affiche la liste des potions de l'étalage, avec leur quantité
            ui.window()
            ui.vbox(box_spacing=5, box_first_spacing=10)
            
            ui.text("Shelves", xpos=0.5, xanchor=0.5)
            ui.null()
            ui.text("Room left : "+str(etalage.capacity-etalage.getOccupation())+" / "+str(etalage.capacity), xpos=.5, xanchor=.5)
            
            ui.null()
            
            c = etalage.content[:]
            c.sort(lambda x,y: cmp(x.potion.price,y.potion.price))
            
            ui.grid(2,3)
            for item in c:
                displayEtalageItem(item, True)
            #
            for i in range(6 - len(c)):
                ui.null()
            #
            ui.close()
            
            ui.null()
            ui.textbutton("Go back", clicked=ui.returns(""))
            ui.close()
        #

        def displaySaleStats():     # affiche la liste des potions vendues depuis le début du jeu
            ui.window()
            ui.vbox(box_spacing=5, box_first_spacing=10)
            
            ui.text("Sale Stats", xpos=0.5, xanchor=0.5)
            ui.null()
            ui.text("Sales total : "+str(salestats.getOccupation()), xpos=.5, xanchor=.5)
            
            ui.null()
            
            c = salestats.content[:]
            c.sort(lambda x,y: cmp(x.potion.price,y.potion.price))
            
            ui.grid(2,3)
            for item in c:
                displayEtalageItem(item, True)
            #
            for i in range(6 - len(c)):
                ui.null()
            #
            ui.close()
            
            ui.null()
            ui.textbutton("Go back", clicked=ui.returns(""))
            ui.close()
        #
        
        
        
        # FONCTIONS POUR LE STAFF
        
        # Fiche du perso
        #
        def displayPerso(item):
            ui.hbox(box_spacing=10)
            ui.image(item.illust)
            
            ui.vbox(box_spacing=10)
            ui.text(item.name, style="title")
            ui.text(item.desc, xmaximum=300, style="parch", size=20)
            ui.null()
            if item.vehicle <> None:
                ui.text("Transport : "+item.vehicle.name+", speed: "+str(item.vehicle.speed), style="parch", xalign=0.0)
                ui.null()
            #
            ui.text("Talents", style="parch", xpos=0.5, xanchor=0.5, size=25)
            
            for task in item.abletasks:
                if task.name <> "None":
                    ui.hbox()
                    
                    if debug==1 and expsystem==2:
                        ui.text(task.name+" L"+str(task.level)+" ("+str(task.talent)+"). Next level : ", style="parch", ypos=.5, yanchor=.5)
                        ui.bar(120, 25, task.nextLevel()-task.nextLevel(task.level-1), task.exp-task.nextLevel(task.level-1), ypos=.35, yanchor=.5)
                    #
                    else:
                        ui.text(task.name+" ("+str(task.talent)+"). Next level : ", style="parch", ypos=.5, yanchor=.5)
                        ui.bar(120, 25, task.nextLevel(), task.exp, ypos=.35, yanchor=.5)
                    #
                    
                    ui.close()
                    if debug==1 and expsystem==2:
                        ui.text("("+str(task.exp)+">"+str(task.nextLevel())+")", size=12)
                    #
                #
            #
            
            ui.close()
            
            ui.close()
        #
        
        def displayPersoInfo(item):   # affiche la fiche d'info d'un ingrédient
            ui.window(style="parch")
            displayPerso(item)
        #
        
        
        # Perso dans une liste
        #
        def displayStaffItem(item, withthumb=False, valid=True):
            if valid:
                ui.button(clicked=ui.returns(item), xminimum=280, xmaximum=280)
            else:
                ui.button(background=selectedbg, xminimum=280, xmaximum=280)
            ui.hbox(box_spacing=10)
            if withthumb:
                ui.image(item.picture)
            #
            else:
                ui.null(xminimum=64)
            #
            ui.vbox(ymaximum=70, background=Solid((255,255,255,255)))
            ui.text(item.name, ypos=0.5, yanchor="center", minwidth=120)
            ui.null()
            ui.text("Morale :", size=12)
            ui.hbox(box_spacing=5)
#             ui.bar(100, 25, 200, item.morale+100, yalign=0.0, ypos=0.0, ymargin=0)
            ui.bar(200, item.morale+100, xmaximum=100, ymaximum=25, yalign=0.5, ypos=0.5)
            ui.text("("+tern(item.morale >= 0, "+", "")+str(item.morale)+"%)", size=12, yalign=1.0, ypos=1.0)
            ui.close()
            ui.close()
            
            ui.close()
        #
        
        
        
        def displayStaff():
        
            ui.window()
            ui.vbox(box_spacing=5, box_first_spacing=10)
            
            ui.text("Staff", xpos=0.5, xanchor=0.5)
            
            ui.grid(2,3, padding=0)
            for item in staff:
                displayStaffItem(item, withthumb=True)
            #
            for i in range(6 - len(staff)):
                ui.null()
            #
            ui.close()
            
            ui.null()
            ui.textbutton("Go back", clicked=ui.returns(""))
            ui.close()
        #
    #


    

