### EASE SYSTEM FOR ANIMATION ###

init -100:
    python:
    
    
#         class InterpolateSquare(object):

#             anchors = {
#                 'top' : 0.0,
#                 'center' : 0.5,
#                 'bottom' : 1.0,
#                 'left' : 0.0,
#                 'right' : 1.0,
#                 }
#         
#             def __init__(self, start, end):
#         
#                 if len(start) != len(end):
#                     raise Exception("The start and end must have the same number of arguments.")
#         
#                 self.start = [ self.anchors.get(i, i) for i in start ]
#                 self.end = [ self.anchors.get(i, i) for i in end ]
#         
#             def __call__(self, t):
#         
#                 def interp(a, b):
#         
#                     rv = (1.0 - t**2) * a + t**2 * b
#                     
#                     if isinstance(a, int) and isinstance(b, int):
#                         return int(rv)
#                     else:
#                         return rv
#         
#                 return [ interp(a, b) for a, b in zip(self.start, self.end) ]
#         #
        
        class InterpolatePower(object):

            anchors = {
                'top' : 0.0,
                'center' : 0.5,
                'bottom' : 1.0,
                'left' : 0.0,
                'right' : 1.0,
                }
        
            def __init__(self, start, end, mode, power):
        
                if len(start) != len(end):
                    raise Exception("The start and end must have the same number of arguments.")
        
                self.start = [ self.anchors.get(i, i) for i in start ]
                self.end = [ self.anchors.get(i, i) for i in end ]
                self.power = power
                self.mode = mode
        
            def __call__(self, t):
        
                def interp(a, b):
                
                    if self.mode == 'in':
                        rv = (1.0 - t**self.power) * a + t**self.power * b
                    elif self.mode == 'out':
                        if self.power%2 == 0:
                            fact = -1
                        else:
                            fact = 1
                        #
                        
                        rv = (1.0 - (fact*((t-1)**self.power+fact))) * a + (fact*((t-1)**self.power+fact)) * b
                    elif self.mode == 'full':
                        if self.power%2 == 0:
                            fact = -1
                        else:
                            fact = 1
                        #
                        
                        if t<0.5:
                            rv = (1.0 - ((t*2)**self.power)/2.0) * a + ((t*2)**self.power/2.0) * b
                        else:        
                            rv = (1.0 - (((t-1)*2)**self.power+(2*fact))/(2.0*fact)) * a + (((t-1)*2)**self.power+(2*fact))/(2.0*fact) * b
                    #
                    
                    if isinstance(a, int) and isinstance(b, int):
                        return int(rv)
                    else:
                        return rv
        
                return [ interp(a, b) for a, b in zip(self.start, self.end) ]
        #
        
#         class InterpolateRoot(object):

#             anchors = {
#                 'top' : 0.0,
#                 'center' : 0.5,
#                 'bottom' : 1.0,
#                 'left' : 0.0,
#                 'right' : 1.0,
#                 }
#         
#             def __init__(self, start, end, mode, power):
#         
#                 if len(start) != len(end):
#                     raise Exception("The start and end must have the same number of arguments.")
#         
#                 self.start = [ self.anchors.get(i, i) for i in start ]
#                 self.end = [ self.anchors.get(i, i) for i in end ]
#                 self.power = power
#                 self.mode = mode
#         
#             def __call__(self, t):
#         
#                 def interp(a, b):
#                 
#                     if self.mode == 'in':
#                         
#                     elif self.mode == 'out':
#                         
#                     elif self.mode == 'full':        
#                         rv = (1.0 - t**(1.0/self.power)) * a + t**(1.0/self.power) * b
#                     #
#                     
#                     if isinstance(a, int) and isinstance(b, int):
#                         return int(rv)
#                     else:
#                         return rv
#         
#                 return [ interp(a, b) for a, b in zip(self.start, self.end) ]
#         #
        
        import math
        
        class InterpolateSin(object):  # basé sur la sinusoide

            anchors = {
                'top' : 0.0,
                'center' : 0.5,
                'bottom' : 1.0,
                'left' : 0.0,
                'right' : 1.0,
                }
        
            def __init__(self, start, end):
        
                if len(start) != len(end):
                    raise Exception("The start and end must have the same number of arguments.")
        
                self.start = [ self.anchors.get(i, i) for i in start ]
                self.end = [ self.anchors.get(i, i) for i in end ]
        
            def __call__(self, t):
        
                def interp(a, b):
                    rv = (1.0 - (math.sin(t*math.pi-math.pi/2.0)+1.0)/2.0) * a + ((math.sin(t*math.pi-math.pi/2.0)+1.0)/2.0) * b 
                    
                    if isinstance(a, int) and isinstance(b, int):
                        return int(rv)
                    else:
                        return rv
        
                return [ interp(a, b) for a, b in zip(self.start, self.end) ]
        #
        
        class InterpolateCircle(object):

            anchors = {
                'top' : 0.0,
                'center' : 0.5,
                'bottom' : 1.0,
                'left' : 0.0,
                'right' : 1.0,
                }
        
            def __init__(self, start, end, mode):
        
                if len(start) != len(end):
                    raise Exception("The start and end must have the same number of arguments.")
        
                self.start = [ self.anchors.get(i, i) for i in start ]
                self.end = [ self.anchors.get(i, i) for i in end ]
                self.mode = mode
        
            def __call__(self, t):
        
                def interp(a, b):
                    if self.mode == 'in':
                        rv = (1.0 - (-1*(math.sqrt(1.0-t**2)-1.0))) * a + ((-1*(math.sqrt(1.0-t**2)-1.0))) * b 
                    elif self.mode == 'out':
                        rv = (1.0 - (math.sqrt(1.0-(t-1.0)**2))) * a + (math.sqrt(1.0-(t-1.0)**2)) * b 
                    elif self.mode == 'full':
                        if t<0.5:
                            rv = (1.0 - (-0.5*(math.sqrt(1.0-(t*2.0)**2)-1.0))) * a + (-0.5*(math.sqrt(1.0-(t*2.0)**2)-1.0)) * b 
                        else:
                            rv = (1.0 - ((math.sqrt(1.0-((t-1.0)*2.0)**2)+1.0)/2.0)) * a + ((math.sqrt(1.0-((t-1.0)*2.0)**2)+1.0)/2.0) * b 
                    #
                    
                    if isinstance(a, int) and isinstance(b, int):
                        return int(rv)
                    else:
                        return rv
        
                return [ interp(a, b) for a, b in zip(self.start, self.end) ]
        #


        
#         def MovePower(startpos, endpos, power, time, mode='full', child=None, repeat=False, bounce=False,
#                  anim_timebase=False, style='default', **properties):
#         
#             return Motion(InterpolatePower(startpos, endpos, power, mode),
#                           time,
#                           child,
#                           repeat=repeat, 
#                           bounce=bounce,
#                           anim_timebase=anim_timebase,
#                           style=style,
#                           **properties)
#         #
#         
#         def MoveRoot(startpos, endpos, power, time, child=None, repeat=False, bounce=False,
#                  anim_timebase=False, style='default', **properties):
#         
#             return Motion(InterpolateRoot(startpos, endpos, power),
#                           time,
#                           child,
#                           repeat=repeat, 
#                           bounce=bounce,
#                           anim_timebase=anim_timebase,
#                           style=style,
#                           **properties)
#         #
#         
#         def MoveSin(startpos, endpos, time, child=None, repeat=False, bounce=False,
#                  anim_timebase=False, style='default', **properties):
#         
#             return Motion(InterpolateSin(startpos, endpos),
#                           time,
#                           child,
#                           repeat=repeat, 
#                           bounce=bounce,
#                           anim_timebase=anim_timebase,
#                           style=style,
#                           **properties)
#         #
#         
#         def MoveCircle(startpos, endpos, time, mode='full', child=None, repeat=False, bounce=False,
#                  anim_timebase=False, style='default', **properties):
#         
#             return Motion(InterpolateCircle(startpos, endpos, mode),
#                           time,
#                           child,
#                           repeat=repeat, 
#                           bounce=bounce,
#                           anim_timebase=anim_timebase,
#                           style=style,
#                           **properties)
#         #
        
        def MoveEase(startpos, endpos, time, child=None, type='pow', mode='full', power=2,  repeat=False, bounce=False,
                anim_timebase=False, style='default', **properties):
            if type == 'pow':
                return Motion(InterpolatePower(startpos, endpos, mode, power),
                          time,
                          child,
                          repeat=repeat, 
                          bounce=bounce,
                          anim_timebase=anim_timebase,
                          style=style,
                          **properties)
            elif type == 'sin':
                return Motion(InterpolateSin(startpos, endpos),
                          time,
                          child,
                          repeat=repeat, 
                          bounce=bounce,
                          anim_timebase=anim_timebase,
                          style=style,
                          **properties)
            elif type == 'circle':
                return Motion(InterpolateCircle(startpos, endpos, mode),
                          time,
                          child,
                          repeat=repeat, 
                          bounce=bounce,
                          anim_timebase=anim_timebase,
                          style=style,
                          **properties)
            #

        #
        
        #MoveEase = renpy.curry(_MoveEase)
        

        
        def _MoveEaseTransition(delay, old_widget=None, new_widget=None):
            """
            This transition attempts to find images that have changed
            position, and moves them from the old position to the new
            transition, taking delay seconds to complete the move and using
            a easing function to make the movement smoother.
        
            Images are considered to be the same if they have the same tag, in
            the same way that the tag is used to determine which image to
            replace or to hide.
        
            If you use this transition to slide an image off the side of the
            screen, remember to hide it when you are done.
            """
        
            def position(d):
        
                xpos, ypos, xanchor, yanchor = d.get_placement()
        
                if xpos is None:
                    xpos = 0
                if ypos is None:
                    ypos = 0
                if xanchor is None:
                    xanchor = 0
                if yanchor is None:
                    yanchor = 0
        
                if isinstance(xpos, float):
                    xpos = int(renpy.config.screen_width * xpos)
        
                if isinstance(ypos, float):
                    ypos = int(renpy.config.screen_height * ypos)
        
                return xpos, ypos, xanchor, yanchor
                
        
            def merge_slide(old, new):
        
                    
                # If new does not have .layers or .scene_list, then we simply
                # insert a move from the old position to the new position, if
                # a move occured.
        
                if not hasattr(new, 'layers') and not hasattr(new, 'scene_list'):
        
                    if position(old) != position(new):
        
                        return MoveEase(position(old),
                                                         position(new),
                                                         delay,
                                                         new,
                                                         )
                    else:
                        return new
        
                # If we're in the root widget, merge the child widgets for
                # each layer.
                if new.layers:
                    assert old.layers
        
                    rv = renpy.display.layout.Fixed()
                    rv.layers = { }
        
                    for layer in renpy.config.layers:
        
                        f = new.layers[layer]
        
                        if isinstance(f, renpy.display.layout.Fixed) and f.scene_list:
                            f = merge_slide(old.layers[layer], new.layers[layer])
        
                        rv.layers[layer] = f
                        rv.add(f)
        
                    return rv
        
                # Otherwise, we recompute the scene list for the two widgets, merging
                # as appropriate.
        
                tags = { }
        
                for tag, start, anim, d in old.scene_list:
        
                    if tag is None:
                        continue
        
                    tags[tag] = d
        
                newsl = [ ]
        
                for tag, time, anim, d in new.scene_list:
        
                    if tag is None or tag not in tags:
                        newsl.append((tag, time, anim, d))
                        continue
        
                    oldpos = position(tags[tag])
                    newpos = position(d)
        
                    if oldpos == newpos:
                        newsl.append((tag, time, anim, d))
                        continue
                        
                    move = MoveEase(position(tags[tag]),
                                                     position(d),
                                                     delay,
                                                     d,
                                                     )
                    move = move()
                    newsl.append((tag, None, anim, move))
        
                rv = renpy.display.layout.Fixed()
                rv.append_scene_list(newsl)
        
                return rv
        
        
            rv = merge_slide(old_widget, new_widget)
            rv.delay = delay
        
            return rv
        #
        
        MoveEaseTransition = renpy.curry(_MoveEaseTransition)
    #
    
#

