﻿# CUSTOMIZATION FILE

init 50:

    pass
    
    image dummynic = "fb_other.png" # fbpic for Dummynic

#

label initcustom:

    python:
    
        # CHARACTERS
    
        charapool['dum'] = Perso("Dummynic", "dummynic")
        # We add a new character, Dummynic, to the character pool. Its internal name is "dum". It uses the "dummynic" image declared in the init block above.
        # A lot of parameters were omitted, here's the complete list :
        # Perso(name, full body picture, picture="f_inc.jpg", illust="spacer.gif", category=None, desc="No description", salaryfact=.5):
        # picture : the thumbnail picture displayed in most windows
        # illust : the illustration found on the description page
        # category  : not used
        # desc : the description of this character
        # salaryfact : 1.0 means a normal salary. 0.5 would mean half the regular salary. 2.0 would mean double salary.
        # use this to have some characters ask for more money or less money. For example, the hero has 0.5
        
        
        charapool['dum'].addAbleTasks(Brew(charapool['dum'], 50, xpcurve=1.6, xpreward=4))
        # We add a talent to our new character.
        # Brew(character, talent level, xpfactor=5, xpcurve=1.5, xpreward=1)
        # talent level : really depends on the talent. Higher values are always better.
        # xpfactor : how much XP points before the first level up. 5 by default.
        # xpcurve : the power value of the XP curve. Higher values mean steeper curve means slower and slower evolution.
        # xpreward : number of gained levels per level up.
        #
        # Note that it means you can have different values for *each* character for *each* talent.
        # You can make someone very good at a task from the beginning but almost never evolving.
        # You can also make someone quite bad at something but being a quick learner.
        
        charapool['dum'].addAbleTasks(Gather(charapool['dum'],30, xpreward=5, xpcurve=1.3))
        # We add the Gather talent... same stuff, different values.
        
        charapool['dum'].getTask(Gather).setFactor(ingcateg['herb'], 1.0)
        charapool['dum'].getTask(Gather).setFactor(ingcateg['plant'], 1.5)
        # The Gather talent requires you to indicate which category(ies) of ingredients
        # the character can harvest.
        # Dummynic will be able to gather herbs and plants, with a preference for plants (1.5 > 1.0)
        
#         staff.append(charapool['dum'])
        # Finally, we add Dummynic to the staff.
        # If you want to add Dummynic later in the game instead,
        # just remove this line from the initcustom and put it
        # in a quest/event
        
        
        
        # INGREDIENTS
        
        ingcateg['energy'] = IngCategory("Energy")
        # Here, we create a new ingredient category meant for energies.
        # 'energy' is its internal name. "Energy" is its public name.
        # Categories don't have any attribute except for their name.
        
        ingredients['soul'] = Ingredient("Soul", ingcateg['energy'], rarity=40, weight=21, description="Mostly found in haunted forests, they're rather hard to capture.")
        # A category wouldn't be useful without ingredients.
        # We add a new ingredient, soul, of the 'energy' category.
        # Ingredient(name, category, rarity, weight, description)
        #
        # rarity : higher values mean harder to find. For an idea of how much would be found by
        # a character, divide its Gather talent * Category factor by this value.
        # Someone with a talent of 40 and a factor of 1.0 can find *one* soul unit only per turn.
        
        
        ingredients['snut'] = Ingredient("Special Nuts", ingcateg['fruit'], rarity=15, weight=0, description="Found in trees.", picture="ing_hazelnut.png", illust="illust_hazelnut.png")
        # Adding another ingredient into an existing category, 'fruit'.
        # Note that we give more attributes this time, since we have pictures for it!
        # Ingredient(name, category, rarity, weight, description, picture, illust)
        #
        # picture : the icon
        # illust : the parchament illustration
        
#         stock.add(ingredients['snut'], 5)
        # And for kicks, we add 5 special nuts to the starting stocks.
        # Use the same command to add ingredients during quests and events.
        
        
        
        # LOCATIONS
        
        locs['hforest'] = Location("Haunted forest", 405, 60, "bg_forest", distance=0.5)
        # We add a new location, the Hentai f... no wait, the Haunted forest.
        # Location(name, x Position on the map, Y position, background picture, distance)
        #
        # distance : 0 means the character returns during the same turn
        # 0.5 means it will take one day
        # 1 means it will take two days...
        # Basically, the value is multiplied by 2 to get the total number of travel days.
        
        locs['hforest'].setNests([ IngNest(ingredients['soul'], 1.5),
                                    IngNest(ingredients['snut'], 1.2) 
                                    ])
        #
        # Here, we add ingredients that can be found in this location.
        # IngNest(ingredient, factor)
        # 
        # factor : 1.0 would mean the ingredient retains its regular rarity in this location
        # 2.0 would mean the ingredient can be found twice as much as usual (halves the rarity)
        # 0.5 would mean it's twice harder to find
        
        
#         carte.add(locs['hforest'])
        # For kicks, we add the location to the starting map.
        # If you want the player to discover the location during the game, use this
        # command in one of your quests/events
        
        
        # POTIONS
        
        potions['climb'] = Potion("Tree Climber", "potionblues.gif", price=39, desc="Enjoy climbing trees like a squirrel with this potion. Really, just go nuts!")
        # Since we created new ingredients, let's also make a new potion made with them!
        # Potion(name, icon picture, price, description)
        #
        # price : base price. The current reputation (1-100%) determines the *actual* price.
        
        
#         etalage.add(potions['climb'], 2)
        # Let's add 2 of this potion to the shelves
        
        
        # RECIPES
        
        recettes['climb'] = Recette(potions['climb'], difficulty=20, needed=[IngQty(ingredients['snut'],1)], reputation=1, desc="Ever wondered how squirrel could climb trees so easily? It just happens that the nuts they eat enhance their climbing abilities!")
        # Now that the potion is created, we need to make a recipe so the player can brew it himself.
        # Recette(potion, difficulty, needed, reputation, desc)
        #
        # difficulty : Brew talent divided by this value = number of potions per day
        # needed : a list of the ingredients needed and in which quantities
        #   [IngQty(ingredient, quantity), IngQty(ingredient2, qty2), IngQty(ingredient3, qty3)]
        # reputation : the starting reputation of the potion. 1 is the minimum if you want it to be sold right away.
        # 0 would mean it can be brewed, but won't ever be bought by anyone.
        # You could make a recipe start at 0 and change the value later after a quest has been done.
        # recettes['climb'].reputation = 5     for example
        
        
#         grimoire.add(recettes['climb'])
        # We add the recipe to the grimoire
        
        
        
        # QUESTS
    
        simplequest = Quest("Simple Test Quest", "simplequest", "")
        # Here's a new quest.
        # Quest(name, label to call for tests, unused)
        #
        # label : you will need to create a Ren'Py label that will be called at each turn for this quest.
        # Inside it, you will put tests, dialogues, and so on...
        # unused : just leave it with the "" value for now.
        
        quests.add(simplequest)
        # This makes the quest "available". It will be tested at each turn.
        #
        # If you want to create a bunch of sequential quests (first help the jester, then help the prince, then help the queen)
        # you should add only the first quest of the lot and when the first quest is completed, add the next one.
    
    #
    
    return

#


# Here's the label that will be called for the Simple Quest
# Inside it, you can do pretty much anything allowed by Ren'Py.

# The intended way to use it, though, is to put a bunch of tests that will trigger events.

# Also note that the way things are scripted reverses the regular order of things.
# If you're looking for the beginning of this quest, look at the very bottom of the label ^^;

label simplequest:
    
    #"Simple Test Quest"
    
    # If the quest is active, and it's in the 'in progress' state, and the day is three days after it started, and Framboise is home
    if magasin.hasQuest(simplequest) and simplequest.state == 1 and day - simplequest.day >= 3 and cframb.loc == home:
    
        nvl clear
        nvl clear
        $ renpy.music.play(eventm)
        
        scene shop with fade
        
        show framboise with dissolve
        
        "Framboise wanders in." with dissolve
        
        "She looks a lot better than she has done of late."
        
        da "Hey, how are you doing?"
        
        fr "I'm feeling better now."
        
        fr "... no thanks to you!"
        
        fr "I had to buy a cure from that little shop across town - Das Magisches Geschäft?"
        
        $ magasin.money -= potions['wcure'].price * 2
        
        fr "It was expensive, and everyone saw me..."
        
        $ cframb.morale -= 15
        
        fr "I was so embarrassed..."
        
        "Thinking about it, it was pretty stupid of me to not cure my poor tireless employee."
        with dissolve
        
        scene black with longdissolve

        # Quest is over now, so clear it
        $ clearquest(simplequest)
        
        return
        
    # If the quest is active, and it's in the 'in progress' state, and the day is at least one day after it started
    elif magasin.hasQuest(simplequest) and simplequest.state == 1 and day - simplequest.day >= 1:
        
        nvl clear
        nvl clear
        $ renpy.music.play(eventm)
        
        # If Framboise isn't home...
        
        if cframb.loc != home:
            
            scene shop with fade
            
            "I wonder how Framboise is doing?" with dissolve
            
            "I bet it's hard for her, out on her own when she's ill."
            
            "I feel a little guilty sending her out, now..."
            with dissolve
            
            scene black with longdissolve
            
            $ cframb.morale -= 10
            
            return
        
        scene shop with fade
        
        show framboise with dissolve
        
        "Framboise wanders in." with dissolve
        
        "She's still looking under the weather."
        
        fr "Um... sir?"
        
        fr "Did you... make anything for me?"
        
        # If we have a weak cure to give her...
        if etalage.getQty(potions['wcure']) >= 1:
            
            menu:
                "Give Framboise a Weak Cure":
                    
                    nvl clear
                    
                    da "Of course!"
                    
                    da "I couldn't let you sit around ill, after all!"
                    
                    "I give Framboise a Weak Cure from the shelf..."
                    
                    # Remove one weak cure from the shelves
                    $ etalage.remove(potions["wcure"], 1)
                    
                    # Check if it's the last one
                    if etalage.getQty(potions['wcure']) == 0:
                        
                        "It's the last one."
                        
                    "Framboise perks up."
                    
                    fr "Really? Thank you, sir! Thank you!"
                    
                    "She drinks the potion quite elegantly, then and there."
                    
                    fr "Ah! I'm feeling better already."
                    
                    "She really does look better."
                    with dissolve
                    
                    scene black with longdissolve
                    
                    $ cframb.morale += 25
                    
                    # quest is over now, so clear it
                    $ clearquest(simplequest)
                    
                    return
                
                "Don't give Framboise a Weak Cure":
                    
                    nvl clear
                    nvl clear
                    
                    da "Sorry, Framboise, I can't really spare the potions right now."
                    
                    da "You understand, right?"
                    
                    "Framboise looks dejected."
                    
                    fr "Eheh... I suppose..."
                    
                    fr "I'll just be getting on with things, then."
                    with dissolve
                    
                    scene black with longdissolve
                    
                    $ cframb.morale -= 10
                    
                    return
        
        else:
        
            nvl clear
            nvl clear
            
            da "Sorry... I don't have a potion for you." with dissolve
            
            "Framboise looks disappointed."
            
            fr "Ah... it's OK."
            
            fr "I know you're working hard..."
            with dissolve
            
            scene black with longdissolve
            
            $ cframb.morale -= 5
            
        return
    
    # The quest is available but hasn't started yet.
    # Starting condition : on the second day (for quick testing ;p)
    #
    # "day" is a global variable couting the number of days passed since the beginning of the game.
    # nameofyourquest.state is always 0 by default. You can use it to keep track of things.
    # Here, 0 is meant to indicate the fact the quest hasn't started at all.
    elif simplequest.state ==  0 and day >= 12:
        
        nvl clear
        nvl clear
        $ renpy.music.play(eventm)
        
        scene shop with fade
        
        show framboise with dissolve
        
        "Framboise slowly comes in." with dissolve
        
        "She's looking a bit peaky."
        
        fr "Uh... sir?"
        
        da "What's up? Are you OK?"
        
        fr "To be honest, I'm... I'm feeling a little ill, really."
        
        fr "If it's not too much trouble, could you..."
        
        fr "...could you make something to make me better?"
        
        # Activate the quest
        $ actquest(simplequest)
        # This function activates the quest. You should use it when the player accepts the quest.
        # In our case, you just can't reject it, so it's activated anyway :)
        
        "Framboise runs out before I can say anything."
        with dissolve
        
        scene black with longdissolve
        
        # Framboise is sick. To represent her weak state, we lower her morale
        # (she will work less)
        $ cframb.morale -= 20
        
        # Set the start date, and change the state to signify 'in progress'
        $ simplequest.day = day
        $ simplequest.state = 1
        
        # Note that we use 'state' here.
        # We also use a new attribute, 'day', and make it equal to the current day.
        # This means we can refer to the day the quest started later on.
        #
        # Now a big freedom note for modders : you can add *anything* to the quest object.
        # $ simplequest.myVariable = "something"
        # This would work. So if you ever need to store information about the quest,
        # just add new variables to it or change their values.
        # This object is *yours*.
        
    
    return
#


