/*
 * Decompiled with CFR 0.152.
 */
package org.j5mclaunch.launcher.util;

import com.centerkey.utils.BareBonesBrowserLaunch;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.j5mclaunch.launcher.Main;
import org.j5mclaunch.launcher.http.HttpClient;
import org.j5mclaunch.launcher.util.Helper;
import org.j5mclaunch.launcher.util.LauncherProfile;
import org.j5mclaunch.launcher.util.MinecraftAuth;
import org.json.JSONObject;

public class MinecraftLauncher {
    public JSONObject urls = Helper.urls;
    public final String librariesBase = this.urls.getString("lwjglUrl");
    private final Map<String, String> clientUrls = Helper.getVersions();
    private String[] libraries = Helper.jsonArrayToStringArray(this.urls.getJSONArray("lwjgl"));
    private final Map<String, String> natives = new HashMap<String, String>();
    private static HttpClient http = Helper.getHttpClient();
    private String sessionId = "";
    public String plrUuid = "";
    public String userName = "";
    private String[] versions;

    public MinecraftLauncher() {
        Iterator<String> it = this.urls.getJSONObject("natives").keys();
        while (it.hasNext()) {
            String key = it.next();
            this.natives.put(key, this.urls.getJSONObject("natives").getString(key));
        }
    }

    public void downloadAssets() {
        String assetBase = MinecraftLauncher.getMinecraftFolder() + "/resources/";
        File a = new File(assetBase);
        if (!a.exists()) {
            Helper.printf("Downloading resources");
            a.mkdirs();
            String tmp = http.get(this.urls.getString("assetUrl"), "");
            String tmp1 = this.urls.getString("assetBase");
            JSONObject assets = new JSONObject(tmp).getJSONObject("objects");
            Iterator<String> keys = assets.keys();
            while (keys.hasNext()) {
                String key = keys.next();
                Helper.printf("Downloading " + key);
                String hash = assets.getJSONObject(key).getString("hash");
                String url = tmp1 + hash.substring(0, 2) + "/" + hash;
                http.download(url, assetBase + key);
            }
        }
    }

    public void refreshAuth() {
        block13: {
            String mcHome = MinecraftLauncher.getMinecraftFolder();
            File info = new File(mcHome + "/j5mclaunch.json");
            boolean online = Helper.isOnline();
            if (info.exists()) {
                Main.setStatus("Logging in...");
                MinecraftAuth.loadTokens(mcHome + "/j5mclaunch.json");
                if (!online && MinecraftAuth.username.length() != 0) {
                    this.userName = MinecraftAuth.username;
                    this.plrUuid = "NO INTERNET";
                    this.sessionId = "NO INTERNET";
                    Main.setStatus("Welcome " + this.userName + " *OFFLINE*");
                    Main.setPlayEnabled();
                } else if (!online) {
                    Helper.error("You need to be online to sign in and download the game!");
                    System.exit(1);
                } else {
                    try {
                        if (MinecraftAuth.getUsername()) {
                            this.userName = MinecraftAuth.username;
                            this.plrUuid = MinecraftAuth.uuid;
                            this.sessionId = MinecraftAuth.minecraft_token;
                            Main.setStatus("Welcome " + this.userName);
                            Main.setPlayEnabled();
                            break block13;
                        }
                        if (MinecraftAuth.getAccessToken()) {
                            MinecraftAuth.getXboxToken();
                            MinecraftAuth.getMinecraftToken();
                            MinecraftAuth.getUsername();
                            this.userName = MinecraftAuth.username;
                            this.plrUuid = MinecraftAuth.uuid;
                            this.sessionId = MinecraftAuth.minecraft_token;
                            if (this.plrUuid.length() != 0 && this.userName.length() != 0 && this.sessionId.length() != 0) {
                                Main.setStatus("Welcome " + this.userName);
                                MinecraftAuth.saveTokens(mcHome + "/j5mclaunch.json");
                                Main.setPlayEnabled();
                            } else {
                                Main.setStatus("Please log in to play.");
                                this.userName = "";
                                this.plrUuid = "";
                                this.sessionId = "";
                                Main.setPlayDisabled();
                            }
                            break block13;
                        }
                        Main.setPlayDisabled();
                    }
                    catch (Exception ex) {
                        Main.setStatus("Login expired.");
                        Main.setPlayDisabled();
                    }
                }
            } else {
                Main.setPlayDisabled();
                if (!online) {
                    Helper.error("You need to be online to sign in and download the game!");
                    System.exit(1);
                }
            }
        }
    }

    public void login() {
        final JFrame f = new JFrame();
        f.setLayout(null);
        f.setLocationRelativeTo(null);
        f.setSize(650, 75);
        f.getContentPane().setPreferredSize(new Dimension(650, 100));
        f.pack();
        f.setResizable(false);
        JLabel l = new JLabel("Go to the following URL and sign in. Copy the URL of the blank page afterwards and paste it into the other box");
        l.requestFocus();
        l.setBounds(5, 0, 645, 25);
        f.add(l);
        JTextField t = new JTextField(MinecraftAuth.manualUrl);
        t.setEditable(false);
        t.setBounds(0, 25, 650, 25);
        f.add(t);
        final JTextField t1 = new JTextField();
        t1.setBounds(0, 50, 650, 25);
        f.add(t1);
        JButton done = new JButton("Done");
        done.setBounds(325, 75, 100, 25);
        done.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String path = t1.getText();
                f.setVisible(false);
                f.dispose();
                MinecraftAuth.getMicrosoftTokens(path);
                MinecraftAuth.getXboxToken();
                MinecraftAuth.getMinecraftToken();
                if (MinecraftAuth.getUsername()) {
                    MinecraftLauncher.this.userName = MinecraftAuth.username;
                    MinecraftLauncher.this.plrUuid = MinecraftAuth.uuid;
                    MinecraftLauncher.this.sessionId = MinecraftAuth.minecraft_token;
                    Main.setStatus("Welcome " + MinecraftLauncher.this.userName);
                    MinecraftAuth.saveTokens(MinecraftLauncher.getMinecraftFolder() + "/j5mclaunch.json");
                    Main.setPlayEnabled();
                } else {
                    Main.login.setVisible(true);
                    Main.login.setEnabled(true);
                }
            }
        });
        f.add(done);
        JButton copy = new JButton("Open URL");
        copy.setBounds(225, 75, 100, 25);
        copy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BareBonesBrowserLaunch.openURL(MinecraftAuth.manualUrl);
            }
        });
        f.add(copy);
        f.setVisible(true);
    }

    public String[] getClientVersions() {
        if (this.versions == null) {
            this.versions = new String[this.clientUrls.size()];
            for (int i = 0; i < this.versions.length; ++i) {
                this.versions[i] = (String)this.clientUrls.keySet().toArray()[i];
            }
        }
        return this.versions;
    }

    public static String getMinecraftFolder() {
        String OS = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        if (OS.contains("mac") || OS.contains("darwin")) {
            return System.getProperty("user.home") + "/Library/Application Support/minecraft";
        }
        if (OS.contains("win")) {
            return System.getenv("APPDATA") + "/.minecraft";
        }
        return System.getProperty("user.home") + "/.minecraft";
    }

    public void downloadVersion(String s) {
        String mcHome = MinecraftLauncher.getMinecraftFolder();
        File a = new File(mcHome + "/versions/" + s + ".jar");
        if (!a.exists()) {
            Helper.printf("Downloading version " + s);
            http.download(this.clientUrls.get(s), mcHome + "/versions/" + s + ".jar");
        } else {
            Helper.printf("Version " + s + " already downloaded, skipping");
        }
    }

    public void downloadLibraries() {
        File n;
        String mcHome = MinecraftLauncher.getMinecraftFolder();
        Helper.printf("Downloading libraries");
        for (String s : this.libraries) {
            File a = new File(mcHome + "/bin/" + s);
            if (!a.exists()) {
                Helper.printf("Downloading library " + s);
                http.download(this.librariesBase + s, mcHome + "/bin/" + s);
                continue;
            }
            Helper.printf(s + " already downloaded, skipping");
        }
        if (Helper.getJavaVer() > 5.0) {
            Iterator<String> it = this.urls.getJSONObject("j6libraries").keys();
            while (it.hasNext()) {
                String key = it.next();
                String url = this.urls.getJSONObject("j6libraries").getString(key);
                File a = new File(mcHome + "/libraries/" + key);
                if (!a.exists()) {
                    Helper.printf("Downloading library " + key);
                    http.download(url, mcHome + "/libraries/" + key);
                    continue;
                }
                Helper.printf(key + " already downloaded, skipping");
            }
        }
        if (!(n = new File(mcHome + "/bin/natives")).exists()) {
            Helper.printf("Natives not found!");
            try {
                String sys = "";
                String tmp = System.getProperty("java.io.tmpdir");
                String OS = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
                sys = OS.contains("mac") || OS.contains("darwin") ? "macosx" : (OS.contains("win") ? "windows" : (OS.contains("nix") ? "linux" : "solaris"));
                Helper.printf("Downloading natives");
                http.download(this.librariesBase + this.natives.get(sys), tmp + "/mc_natives.zip");
                Helper.printf("Extracting natives");
                n.mkdirs();
                Helper.unzip(tmp + "/mc_natives.zip", n.getAbsolutePath());
            }
            catch (Exception ex) {
                System.out.println(ex);
                Helper.error(ex.getMessage());
            }
        }
        Helper.printf("Done!");
    }

    public void setupMinecraftFolder() {
        String mcHome = MinecraftLauncher.getMinecraftFolder();
        Helper.makeDir(mcHome);
        Helper.makeDir(mcHome + "/bin");
        Helper.makeDir(mcHome + "/versions");
        Helper.makeDir(mcHome + "/texturepacks");
    }

    public void launchGame(String v) {
        if (this.plrUuid.equals("") || this.userName.equals("") || this.sessionId.equals("")) {
            Helper.error("You need to sign in to play!");
            return;
        }
        LauncherProfile.saveProfile();
        String mcHome = MinecraftLauncher.getMinecraftFolder();
        ArrayList<String> args = new ArrayList<String>();
        File tmp = new File("/System/Library/Frameworks/JavaVM.framework/Versions/current/Commands/java");
        if (tmp.exists()) {
            args.add(tmp.getAbsolutePath());
        } else {
            args.add("java");
        }
        args.add("-Dsun.java2d.noddraw=true");
        args.add("-Dsun.java2d.d3d=false");
        args.add("-Dsun.java2d.opengl=false");
        args.add("-Dsun.java2d.pmoffscreen=false");
        if (Helper.isOSX()) {
            args.add("-Xdock:name=Minecraft " + v);
            args.add("-Xdock:icon=" + MinecraftLauncher.getMinecraftFolder() + "/resources/icons/minecraft.icns");
            args.add("-Dcom.apple.awt.CocoaComponent.CompatibilityMode=false");
        }
        if (LauncherProfile.betacraftProxy) {
            args.add("-Dhttp.proxyHost=" + this.urls.getString("betacraft"));
            args.add("-Djava.util.Arrays.useLegacyMergeSort=true");
        }
        int ramToUse = Helper.getRamAmount() / 2;
        if ((ramToUse = ramToUse - ramToUse % 128 + 128) > 4096) {
            ramToUse = 4096;
        } else if (ramToUse < 256) {
            ramToUse = 256;
        }
        args.add("-Xmx" + ramToUse + "M");
        if (Helper.getJavaVer() <= 11.0) {
            args.add("-XX:+UseConcMarkSweepGC");
            args.add("-XX:+UseTLAB");
            args.add("-XX:+CMSIncrementalMode");
        }
        args.add("-XX:-UseAdaptiveSizePolicy");
        args.add("-Xmn84M");
        args.add("-Djava.library.path=" + mcHome + "/bin/natives");
        String classPathStr = Helper.pathOfJar() + ";" + mcHome + "/versions/" + v + ".jar;" + mcHome + "/bin/lwjgl.jar;" + mcHome + "/bin/lwjgl_util.jar;" + mcHome + "/bin/jinput.jar;";
        if (Helper.getJavaVer() > 5.0) {
            Iterator<String> it = this.urls.getJSONObject("j6libraries").keys();
            while (it.hasNext()) {
                String key = it.next();
                classPathStr = classPathStr + mcHome + "/libraries/" + key + ";";
            }
        }
        args.add("-Dorg.j5mclaunch.mcver=" + v);
        args.add("-Dorg.j5mclaunch.uuid=" + this.plrUuid);
        args.add("-cp");
        if (Helper.isWindows()) {
            args.add(classPathStr);
        } else {
            args.add(classPathStr.replace(";", ":"));
        }
        args.add("org.j5mclaunch.shim.Launch");
        args.add(this.userName);
        args.add(this.sessionId);
        try {
            String s1;
            Main.frame.setEnabled(false);
            Main.frame.setFocusable(false);
            Main.frame.removeAll();
            Main.frame.dispose();
            ProcessBuilder proc1 = new ProcessBuilder(args);
            Process proc = proc1.directory(new File(MinecraftLauncher.getMinecraftFolder())).redirectErrorStream(true).start();
            BufferedReader out = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            BufferedReader err = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            while ((s1 = out.readLine()) != null) {
                System.out.println(s1.replace(this.sessionId, "<SESSION ID>"));
            }
            while ((s1 = err.readLine()) != null) {
                System.out.println(s1);
            }
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Helper.error(ex.getMessage());
        }
    }
}

