/*
 * Decompiled with CFR 0.152.
 */
package org.j5mclaunch.launcher.util;

import com.sun.management.OperatingSystemMXBean;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.net.ssl.SSLContext;
import javax.swing.JOptionPane;
import org.j5mclaunch.launcher.Main;
import org.j5mclaunch.launcher.http.CurlHttpClient;
import org.j5mclaunch.launcher.http.HttpClient;
import org.j5mclaunch.launcher.http.JavaHttpClient;
import org.j5mclaunch.launcher.util.MinecraftLauncher;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Helper {
    private static HttpClient http;
    public static JSONObject urls;

    public static void makeDir(String dir) {
        File dir1 = new File(dir);
        if (!dir1.exists()) {
            dir1.mkdirs();
        }
    }

    public static void printf(String str) {
        System.out.println(str);
        Main.setStatus(str);
    }

    public static void unzip(String zipFile, String destFolder) throws IOException {
        try {
            ZipEntry entry;
            ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
            byte[] buffer = new byte[1024];
            while ((entry = zis.getNextEntry()) != null) {
                File newFile = new File(destFolder + File.separator + entry.getName());
                if (entry.isDirectory()) {
                    newFile.mkdirs();
                    continue;
                }
                new File(newFile.getParent()).mkdirs();
                try {
                    int length;
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((length = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, length);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Helper.error(ex.getMessage());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Helper.error(ex.getMessage());
        }
    }

    public static double getJavaVer() {
        return Double.parseDouble(System.getProperty("java.specification.version"));
    }

    public static boolean javaClientSupported() {
        try {
            SSLContext supported = SSLContext.getInstance("TLSv1.3");
            return supported != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static double getOSXVer() {
        String ver = System.getProperty("os.version");
        String[] ver1 = ver.split(".");
        return Double.parseDouble(ver1[0] + "." + ver1[1]);
    }

    public static boolean isOSX() {
        String OS = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        return OS.contains("mac") || OS.contains("darwin");
    }

    public static boolean isWindows() {
        String OS = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        return OS.contains("win");
    }

    public static void popup(String str) {
        JOptionPane.showMessageDialog(null, str, "j5mclaunch", 1);
    }

    public static void error(String str) {
        JOptionPane.showMessageDialog(null, str, "Error: j5mclaunch", 0);
    }

    public static HttpClient getHttpClient() {
        if (http == null) {
            try {
                File f = new File("/usr/local/opt/curl/bin/curl");
                File f1 = new File("/opt/local/bin/curl");
                File f2 = new File(MinecraftLauncher.getMinecraftFolder() + "/curl");
                File f3 = new File(MinecraftLauncher.getMinecraftFolder() + "/curl.exe");
                if (f.exists()) {
                    http = new CurlHttpClient("/usr/local/opt/curl/bin/curl");
                } else if (f1.exists()) {
                    http = new CurlHttpClient("/opt/local/bin/curl");
                } else if (f2.exists()) {
                    http = new CurlHttpClient(MinecraftLauncher.getMinecraftFolder() + "/curl");
                } else if (f3.exists()) {
                    http = new CurlHttpClient(MinecraftLauncher.getMinecraftFolder() + "/curl.exe");
                } else {
                    String s1;
                    Runtime rt = Runtime.getRuntime();
                    Process proc = rt.exec("curl -V");
                    BufferedReader out = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    String s = "";
                    while ((s1 = out.readLine()) != null) {
                        s = s + s1 + "\n";
                    }
                    if (s.contains("libcurl")) {
                        String OS = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
                        if (OS.contains("mac") || OS.contains("darwin") && Helper.getOSXVer() < 10.15) {
                            if (Helper.getOSXVer() > 10.8) {
                                Helper.popup("cURL on OS X is as old as the version is. Your version of OS X is too old for TLSv1.3 to be in the bundled cURL. Falling back onto Java http...");
                                http = new JavaHttpClient();
                            } else {
                                Helper.error("cURL on OS X is as old as the version is. You need to install a new version with port or brew to play the game.");
                                System.exit(1);
                            }
                        } else if (s.contains("(Windows)") || s.contains("WinIDN")) {
                            Helper.popup("Micro soft's distribution of cURL does not work with this software. Falling back onto Java http...");
                            http = new JavaHttpClient();
                        } else {
                            http = new CurlHttpClient();
                        }
                    } else {
                        if (Helper.getJavaVer() < 11.0) {
                            Helper.popup("cURL was not found on your system! This is needed for TLS v1.3 on old systems.");
                        }
                        http = new JavaHttpClient();
                    }
                }
            }
            catch (Exception e) {
                if (Helper.getJavaVer() < 11.0) {
                    Helper.popup("cURL was not found on your system! This is needed for TLS v1.3 on old systems.");
                }
                http = new JavaHttpClient();
            }
        }
        return http;
    }

    public static int getRamAmount() {
        long memorySize = ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize();
        return Math.round((float)memorySize / 1048576.0f);
    }

    public static boolean isOnline() {
        try {
            URLConnection a = new URL("http://httpbin.org/get").openConnection();
            a.getContent().toString();
            return true;
        }
        catch (Exception ex) {
            System.out.println(ex);
            return false;
        }
    }

    public static String readFromClasspath(String path) {
        Scanner a = new Scanner(Helper.class.getResourceAsStream(path));
        String newStr = "";
        while (a.hasNext()) {
            newStr = newStr + a.next();
        }
        return newStr;
    }

    public static String[] jsonArrayToStringArray(JSONArray arr1) {
        String[] arr = new String[arr1.length()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = arr1.getString(i);
        }
        return arr;
    }

    public static String pathOfJar() {
        try {
            return new File(Helper.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static LinkedHashMap<String, String> getVersions() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        String raw = Helper.readFromClasspath("/clients.cfg");
        String[] split = raw.replace("\r", "").replace("\n", "").split(";");
        for (int i = 0; i < split.length; ++i) {
            String[] tmp = split[i].split(":", 2);
            result.put(tmp[0], tmp[1]);
        }
        return result;
    }

    static {
        urls = new JSONObject(Helper.readFromClasspath("/downloadUrls.json"));
    }
}

