/*
 * Decompiled with CFR 0.152.
 */
package org.j5mclaunch.launcher.http;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.j5mclaunch.launcher.http.HttpClient;
import org.j5mclaunch.launcher.util.Helper;

public class JavaHttpClient
extends HttpClient {
    public JavaHttpClient() {
        if (!Helper.javaClientSupported()) {
            Helper.error("Unable to fallback to Java HTTP client!");
            System.exit(1);
        }
    }

    public String get(String url1, String auth) {
        try {
            URL url = new URL(url1);
            URLConnection con = url.openConnection();
            con.setRequestProperty("Authorization", "Bearer " + auth);
            InputStream in = con.getInputStream();
            String encoding = con.getContentEncoding();
            encoding = encoding == null ? "UTF-8" : encoding;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            int len = 0;
            while ((len = in.read(buf)) != -1) {
                baos.write(buf, 0, len);
            }
            in.close();
            String body = new String(baos.toByteArray(), encoding);
            return body;
        }
        catch (Exception ex) {
            System.out.println(ex);
            throw new RuntimeException(ex);
        }
    }

    public void download(String url, String dest) {
        try {
            URL website = new URL(url);
            ReadableByteChannel rbc = Channels.newChannel(website.openStream());
            File tmp = new File(dest.replaceAll("[^\\\\/]+[\\\\/]?$", ""));
            try {
                tmp.mkdirs();
            }
            catch (Exception exception) {
                // empty catch block
            }
            FileOutputStream fos = new FileOutputStream(dest);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            fos.close();
            rbc.close();
        }
        catch (Exception ex) {
            System.out.println(ex);
            throw new RuntimeException(ex);
        }
    }

    public String post(String url1, String json1) {
        try {
            URL url = new URL(url1);
            URLConnection con = url.openConnection();
            HttpURLConnection http = (HttpURLConnection)con;
            try {
                http.setRequestMethod("POST");
                http.setDoOutput(true);
                byte[] out = json1.getBytes();
                int length = out.length;
                http.setFixedLengthStreamingMode(length);
                http.setRequestProperty("Content-Type", " application/json");
                http.connect();
                OutputStream os = http.getOutputStream();
                os.write(out);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InputStream in = http.getInputStream();
                byte[] buf = new byte[8192];
                int len = 0;
                while ((len = in.read(buf)) != -1) {
                    baos.write(buf, 0, len);
                }
                in.close();
                String body = new String(baos.toByteArray(), "UTF-8");
                return body;
            }
            catch (IOException ex) {
                Helper.error(ex.getMessage());
                System.out.println(http.getResponseMessage());
                System.out.println(ex.getCause());
                throw new RuntimeException(ex);
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
            throw new RuntimeException(ex);
        }
    }
}

