/*
 * Author: Andreas Linde <mail@andreaslinde.de>
 *         Kent Sutherland
 *
 * Copyright (c) 2011 Andreas Linde & Kent Sutherland.
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

#import <Cocoa/Cocoa.h>

#if FERAL_QUINCYKIT // marksatt 15-8-2012 We don't use the manager
#import "FeralQuincyKit.h"
#endif

@class BWQuincyManager;

@interface BWQuincyUI : NSWindowController {
  IBOutlet NSTextField  *descriptionTextField;
  IBOutlet NSTextView   *crashLogTextView;

  IBOutlet NSTextField  *noteText;
#if FERAL_QUINCYKIT // marksatt 15-8-2012
	IBOutlet NSTextField	*messageText;
	IBOutlet NSTextField	*commentLabelText;
	IBOutlet NSTextField	*detailsLabelText;
	IBOutlet NSTextField	*emailLabelText;
	IBOutlet NSTextField	*emailText;
	IBOutlet NSButton		*detailsButton;
#endif

#if !FERAL_QUINCYKIT // marksatt 6-3-13 Reduce translations
  IBOutlet NSButton   *showButton;
  IBOutlet NSButton   *hideButton;
#endif
  IBOutlet NSButton   *cancelButton;
  IBOutlet NSButton   *submitButton;
  
  BWQuincyManager   *_quincyManager;
#if FERAL_QUINCYKIT // marksatt 15-8-2012 We don't use the manager
  SendCrashReportFunc	_submitFunction;
  NSString		*_URL;
  NSString		*_machineDesc;
  NSString		*_userId;
  NSString		*_userContact;
#endif
  
  NSString      *_xml;
  
  NSString      *_crashFile;
  NSString      *_companyName;
  NSString      *_applicationName;
  
  NSMutableString   *_consoleContent;
  NSString      *_crashLogContent;
  
  BOOL showComments;
  BOOL showDetails;
}

- (id)initWithManager:(BWQuincyManager *)quincyManager crashFile:(NSString *)crashFile companyName:(NSString *)companyName applicationName:(NSString *)applicationName;
#if FERAL_QUINCYKIT // marksatt 15-8-2012 We don't use the manager
- (id)initWithSubmitFunction:(SendCrashReportFunc)submitFunc submitURL:(NSString*)submitURL crashFile:(NSString *)crashFile companyName:(NSString *)companyName applicationName:(NSString *)applicationName machineDesc:(NSString *)machineDesc userId:(NSString *)userId userContact:(NSString *)userContact;
#endif

- (void) askCrashReportDetails;

- (IBAction) cancelReport:(id)sender;
- (IBAction) submitReport:(id)sender;
- (IBAction) showDetails:(id)sender;
- (IBAction) hideDetails:(id)sender;
- (IBAction) showComments:(id)sender;

- (BOOL)showComments;
- (void)setShowComments:(BOOL)value;

- (BOOL)showDetails;
- (void)setShowDetails:(BOOL)value;

@end