#include <OpenGL/gl.h>
#include <OpenGL/OpenGL.h>
#include <OpenGL/glu.h>
#include <GLUT/glut.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <limits.h>
#include <math.h>

#include "FSGround.h"
#include "FSBall.h"
#include "FSPlayer.h"
#include "FSGoal.h"
#include "FSSound.h"
//#include "FSPhysics.cpp"
#include "ModelType.h"

#include "SDL.h"

#define SCREEN_WIDTH	800                                  // We want our screen width 800 pixels
#define SCREEN_HEIGHT   600                                  // We want our screen height 600 pixels
#define SCREEN_DEPTH	32                                


typedef struct FSPlayerStats
{
	int accuracy;
	int strength;
	int power;
	int aggressivity;
	int goalkeeping;
	int speed;
} FSPlayerStats;

typedef struct FSTeam
{
	char name[30];
	char shortName[4];
	char flagImage[25];
	char smallFlagImage[25];
	FSColor bodyColor;
	FSColor legsColor;
	FSPlayerStats players[5];
} FSTeam;

FSTeam *teams = NULL;
FSTexture *flagsTextures = NULL;
int teamsCount;

enum HighOrLow
{
	HIGH,
	LOW
} oneHOL, twoHOL;

typedef struct FSPlace
{
	int posX;
	int posZ;
	int pos2X;
	int pos2Z;
} FSPlace;

typedef FSPlace FSFormation[4];

typedef struct FSTactic
{
	FSFormation high[3];
	FSFormation low[3];
} FSTactic;

FSTactic *tacticsOne = NULL;
FSTactic *tacticsTwo = NULL;

FSPlayers tacticOne[4];
FSPlayers tacticTwo[4];


char credits[128][100];
int creditsCount;

FSTexture bluepixyTex;
FSTexture shadowTex;
FSTexture selectteamTex;
FSTexture extratimeTex;
FSTexture instructionsTex;
FSTexture screenTex;
FSTexture teamsTex;
FSTexture goalTex;
FSTexture winnerTex;
FSTexture gameoverTex;
FSTexture vsTex;
FSTexture turboTex;
FSTexture foulTex;
FSTexture pressanykeyTex;
FSTexture pauseTex;
FSTexture oneMinuteWarningTex;
FSTexture back1Tex;
FSTexture back2Tex;
FSTexture areyousureTex;
FSTexture yesTex;
FSTexture yesHTex;
FSTexture noTex;
FSTexture noHTex;
FSTexture resumeTex;
FSTexture resumeHTex;
FSTexture mainmenuTex;
FSTexture mainmenuHTex;
FSTexture logoTex;
FSTexture circleTex;
FSTexture menuItem[4];
FSTexture menuItemH[4];

float oneMinuteWarningTime;

short oneLevel, twoLevel;
short scoreOne, scoreTwo;
short teamOneCode, teamTwoCode;

bool AI = false;
bool tackle = false;
Uint32 oldTime;

bool audio = true;
bool goToMain;

bool beginningMatch;

float gameTime;

int		goalsOne[3][2] = {	{3500, -19000},
							{4000, -19000},
							{4500, -19000}	};

int		goalsTwo[3][2] = {	{3500, 0},
							{4000, 0},
							{4500, 0}	};

int currentTacticOne, currentTacticTwo;

typedef enum FSKickOff
{
	FS_ONE,
	FS_TWO,
	FS_NEUTRAL
} FSKickOff;

typedef enum FSMode
{
	FS_NORMAL,
	FS_EXTRA_TIME
} FSMode;

/*
float ambientLight[] = { 0.6f, 0.6f, 0.6f, 1.0f };     // ambient light
float diffuseLight[] = { 0.15f, 0.15f, 0.15f, 1.0f };     // diffuse light
float lightPosition[] = { 0.0f, 100.0f, 0.0f, 1.0f };   // spotlight position
float material[] = { 0.1f, 0.1f, 0.1f, 0.1 }; 
*/
float ambientLight[] = { 0.5f, 0.5f, 0.5f, 1.0f };     // ambient light
float diffuseLight[] = { 0.5f, 0.5f, 0.5f, 1.0f };     // diffuse light
float lightPosition[] = { 0.0f, -1.0f, 0.0f, 0.0f };   // spotlight position

int				mouseX, mouseY;									// mouse coordinates
float			cameraX, cameraY, cameraZ;						// camera coordinates
float			lookX, lookY, lookZ;							// camera look-at coordinates
float			cursorAngle;

bool gameDone;

FSGround	*ground			= NULL;
FSBall		*ball			= NULL;
FSPlayer	*teamOne[5];
FSPlayer	*teamTwo[5];
FSPlayer	*currentOne		= NULL;
FSPlayer	*currentTwo		= NULL;
//FSGoal		goalOne(FSVector(0,0,0));
FSGoal		goalTwo(FSVector(3000, 0, -19000));
FSGoal		goalOne(FSVector(5000, 0, 0.0));

float x, y, x2, y2;

//t3DModel quickModel;
ModelType quickModel[5];

short playersFollowing;

bool shooting, crossing;
float loadTime;
short modifier;

bool rightPressed = false;
bool leftPressed = false;
bool upPressed = false;
bool downPressed = false;

bool rightPressed2 = false;
bool leftPressed2 = false;
bool upPressed2 = false;
bool downPressed2 = false;

static int m_lo = 0, m_hi = ~0;

float distanceBetweenPoints(float x1, float y1, float x2, float y2);
FSVector ballVelocityToPoint(int x, int z, int h, int speed);
void render();
void mainLoop();
void runMatch(FSMode mode);
void CleanUp();
void runCredits();

static inline void sdrand(int seed)
{ 
	m_lo = seed; 
	m_hi = ~seed; 
}

static inline unsigned int uirand()
{
	m_hi = (m_hi<<16) + (m_hi>>16); 
	m_hi += m_lo; 
	m_lo += m_hi; 
	return m_hi & INT_MAX; 
}

void drawBar() 
{
    glDisable(GL_LIGHTING);
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	glOrtho(0.0, 800, 
            0.0, 600, -1.0, 1.0);
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();
	glColor3f(0.6,0.0,0.0);
	
	glBegin(GL_QUADS);
		glVertex2d(200 + 0.0,				100 + 0.0);
		glVertex2d(200 + 200.0 * loadTime,	100 + 0.0);
		glVertex2d(200 + 200.0 * loadTime,	100 + 15.0);
		glVertex2d(200 + 0.0,				100 + 15.0);
	glEnd();
	
	glPopMatrix();
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	//glEnable(GL_LIGHTING);
}

void drawGoal() 
{
    glDisable(GL_LIGHTING);
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	glOrtho(0.0, 800, 
            0.0, 600, -1.0, 1.0);
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();
	//glColor3f(1.0,1.0,1.0);
	
	glEnable(GL_TEXTURE_2D);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glColor4f(1.0, 1.0, 1.0, 1.0);
	
	glBindTexture(GL_TEXTURE_2D, goalTex.texID);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	
	glPushMatrix();
		glTranslatef(300.0, 400.0, 0.0);
		
		glBegin(GL_QUADS);
			glTexCoord2f(0.0, 0.0);
			glVertex2d(0, 0);
			glTexCoord2f(1.0, 0.0);
			glVertex2d(256, 0);
			glTexCoord2f(1.0, 1.0);
			glVertex2d(256, 64);
			glTexCoord2f(0.0, 1.0);
			glVertex2d(0, 64);
		glEnd();
	glPopMatrix();
	
	glDisable(GL_BLEND);
	
	glPopMatrix();
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	//glEnable(GL_LIGHTING);
}

void drawWinner() 
{
    glDisable(GL_LIGHTING);
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	glOrtho(0.0, 800, 
            0.0, 600, -1.0, 1.0);
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();
	//glColor3f(1.0,1.0,1.0);
	
	glEnable(GL_TEXTURE_2D);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glColor4f(1.0, 1.0, 1.0, 1.0);
	
	glBindTexture(GL_TEXTURE_2D, winnerTex.texID);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	
	glPushMatrix();
	glTranslatef(300.0, 400.0, 0.0);
	
	glBegin(GL_QUADS);
	glTexCoord2f(0.0, 0.0);
	glVertex2d(0, 0);
	glTexCoord2f(1.0, 0.0);
	glVertex2d(256, 0);
	glTexCoord2f(1.0, 1.0);
	glVertex2d(256, 64);
	glTexCoord2f(0.0, 1.0);
	glVertex2d(0, 64);
	glEnd();
	glPopMatrix();
	
	glDisable(GL_BLEND);
	
	glPopMatrix();
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	//glEnable(GL_LIGHTING);
}

void drawExtratime() 
{
    glDisable(GL_LIGHTING);
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	glOrtho(0.0, 800, 
            0.0, 600, -1.0, 1.0);
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();
	//glColor3f(1.0,1.0,1.0);
	
	glEnable(GL_TEXTURE_2D);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glColor4f(1.0, 1.0, 1.0, 1.0);
	
	glBindTexture(GL_TEXTURE_2D, extratimeTex.texID);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	
	glPushMatrix();
	glTranslatef(300.0, 400.0, 0.0);
	
	glBegin(GL_QUADS);
	glTexCoord2f(0.0, 0.0);
	glVertex2d(0, 0);
	glTexCoord2f(1.0, 0.0);
	glVertex2d(256, 0);
	glTexCoord2f(1.0, 1.0);
	glVertex2d(256, 64);
	glTexCoord2f(0.0, 1.0);
	glVertex2d(0, 64);
	glEnd();
	glPopMatrix();
	
	glDisable(GL_BLEND);
	
	glPopMatrix();
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	//glEnable(GL_LIGHTING);
}

void drawGameover() 
{
    glDisable(GL_LIGHTING);
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	glOrtho(0.0, 800, 
            0.0, 600, -1.0, 1.0);
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();
	//glColor3f(1.0,1.0,1.0);
	
	glEnable(GL_TEXTURE_2D);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glColor4f(1.0, 1.0, 1.0, 1.0);
	
	glBindTexture(GL_TEXTURE_2D, gameoverTex.texID);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	
	glPushMatrix();
	glTranslatef(300.0, 400.0, 0.0);
	
	glBegin(GL_QUADS);
	glTexCoord2f(0.0, 0.0);
	glVertex2d(0, 0);
	glTexCoord2f(1.0, 0.0);
	glVertex2d(256, 0);
	glTexCoord2f(1.0, 1.0);
	glVertex2d(256, 64);
	glTexCoord2f(0.0, 1.0);
	glVertex2d(0, 64);
	glEnd();
	glPopMatrix();
	
	glDisable(GL_BLEND);
	
	glPopMatrix();
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	//glEnable(GL_LIGHTING);
}

void drawOneMinuteWarning() 
{
    glDisable(GL_LIGHTING);
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	glOrtho(0.0, 800, 
            0.0, 600, -1.0, 1.0);
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();
	//glColor3f(1.0,1.0,1.0);
	
	glEnable(GL_TEXTURE_2D);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glColor4f(1.0, 1.0, 1.0, 0.8);
	
	glBindTexture(GL_TEXTURE_2D, oneMinuteWarningTex.texID);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	
	glPushMatrix();
	glTranslatef(150.0, 430.0, 0.0);
	
	glBegin(GL_QUADS);
	glTexCoord2f(0.0, 0.0);
	glVertex2d(0, 0);
	glTexCoord2f(1.0, 0.0);
	glVertex2d(512, 0);
	glTexCoord2f(1.0, 1.0);
	glVertex2d(512, 64);
	glTexCoord2f(0.0, 1.0);
	glVertex2d(0, 64);
	glEnd();
	glPopMatrix();
	
	glDisable(GL_BLEND);
	
	glPopMatrix();
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	//glEnable(GL_LIGHTING);
}

void drawstr2(int x, int y, char *string, ...) 
{
    glDisable(GL_LIGHTING);
	int lines;
    char* p;
	char text[50];
	
	va_list ap;                                    // Pointer To List Of Arguments
	
	va_start(ap, string);                             // Parses The String For Variables
	vsprintf(text, string, ap);                       // And Converts Symbols To Actual Numbers
	va_end(ap);                                    // Results Are Stored In Text
	
	
    glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	glOrtho(0.0, 800, 
            0.0, 600, -1.0, 1.0);
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();
	glColor3f(1.0,1.0,1.0);
	glRasterPos2i(x, y);
	for(p = text, lines = 0; *p; p++) {
		if (*p == '\n') {
			lines++;
			glRasterPos2i(x, y-(lines*18));
		}
		glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, *p);
	}
	glPopMatrix();
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	//glEnable(GL_LIGHTING);
}

void drawstr(int x, int y, char *string, ...) 
{
    glDisable(GL_LIGHTING);
	int lines;
    char* p;
	char text[50];
	
	va_list ap;                                    // Pointer To List Of Arguments
	
	va_start(ap, string);                             // Parses The String For Variables
	vsprintf(text, string, ap);                       // And Converts Symbols To Actual Numbers
	va_end(ap);                                    // Results Are Stored In Text
	
	
    glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	glOrtho(0.0, 800, 
            0.0, 600, -1.0, 1.0);
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();
	glColor3f(0,0,0);
	glRasterPos2i(x, y);
	for(p = text, lines = 0; *p; p++) {
		if (*p == '\n') {
			lines++;
			glRasterPos2i(x, y-(lines*18));
		}
		glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, *p);
	}
	glPopMatrix();
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	//glEnable(GL_LIGHTING);
}
/*
void drawFlags() 
{
    glDisable(GL_LIGHTING);
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glPushMatrix();
	glLoadIdentity();
	glOrtho(0.0, 800, 
            0.0, 600, -1.0, 1.0);
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();
	glColor3f(1.0,1.0,1.0);
	
	glEnable(GL_TEXTURE_2D);
	
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glColor4f(1.0, 1.0, 1.0, 0.7);
/*
	glBindTexture(GL_TEXTURE_2D, back2Tex.texID);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	
	
	glPushMatrix();*/
	//glTranslatef(300.0, 570.0, 0.0);
	/*glBegin(GL_QUADS);
		glTexCoord2f(0.0, 0.0);
		glVertex2d(-125.0, -30.0);
		glTexCoord2f(1.0, 0.0);
		glVertex2d(-10.0, -30.0);
		glTexCoord2f(1.0, 1.0);
		glVertex2d(-10.0, 30.0);
		glTexCoord2f(0.0, 1.0);
		glVertex2d(-125.0, 30.0);
		
		glTexCoord2f(0.0, 0.0);
		glVertex2d(220.0, -30.0);
		glTexCoord2f(1.0, 0.0);
		glVertex2d(335.0, -30.0);
		glTexCoord2f(1.0, 1.0);
		glVertex2d(335.0, 30.0);
		glTexCoord2f(0.0, 1.0);
		glVertex2d(220.0, 30.0);
	glEnd();
	
	glBindTexture(GL_TEXTURE_2D, turboTex.texID);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	
	glPushMatrix();
		glTranslatef(-5.0, 5.0, 0.0);
		
		for(int i = 0; i < 3; i++)
		{
			glTranslatef(-30.0, 0.0, 0.0);
			glBegin(GL_QUADS);
				glTexCoord2f(0.0, 0.0);
				glVertex2d(0.0, 0.0);
				glTexCoord2f(1.0, 0.0);
				glVertex2d(15.0, 0.0);
				glTexCoord2f(1.0, 1.0);
				glVertex2d(15.0, 15.0);
				glTexCoord2f(0.0, 1.0);
				glVertex2d(0.0, 15.0);
			glEnd();
		}
	glPopMatrix();
		
	glPushMatrix();	
		glTranslatef(200.0, 5.0, 0.0);
		
		for(int i = 0; i < 3; i++)
		{
			glTranslatef(30.0, 0.0, 0.0);
			glBegin(GL_QUADS);
			glTexCoord2f(0.0, 0.0);
			glVertex2d(0.0, 0.0);
			glTexCoord2f(1.0, 0.0);
			glVertex2d(15.0, 0.0);
			glTexCoord2f(1.0, 1.0);
			glVertex2d(15.0, 15.0);
			glTexCoord2f(0.0, 1.0);
			glVertex2d(0.0, 15.0);
			glEnd();
		}
	glPopMatrix();

	glBindTexture(GL_TEXTURE_2D, foulTex.texID);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		
	glPushMatrix();
		glTranslatef(-5.0, -20.0, 0.0);
		
		for(int i = 0; i < 3; i++)
		{
			glTranslatef(-30.0, 0.0, 0.0);
			glBegin(GL_QUADS);
			glTexCoord2f(0.0, 0.0);
			glVertex2d(0.0, 0.0);
			glTexCoord2f(1.0, 0.0);
			glVertex2d(15.0, 0.0);
			glTexCoord2f(1.0, 1.0);
			glVertex2d(15.0, 15.0);
			glTexCoord2f(0.0, 1.0);
			glVertex2d(0.0, 15.0);
			glEnd();
		}
	glPopMatrix();
		
	glPushMatrix();	
		glTranslatef(200.0, -20.0, 0.0);
		
		for(int i = 0; i < 3; i++)
		{
			glTranslatef(30.0, 0.0, 0.0);
			glBegin(GL_QUADS);
			glTexCoord2f(0.0, 0.0);
			glVertex2d(0.0, 0.0);
			glTexCoord2f(1.0, 0.0);
			glVertex2d(15.0, 0.0);
			glTexCoord2f(1.0, 1.0);
			glVertex2d(15.0, 15.0);
			glTexCoord2f(0.0, 1.0);
			glVertex2d(0.0, 15.0);
			glEnd();
		}
	glPopMatrix();
*/		/*
	glBindTexture(GL_TEXTURE_2D, back1Tex.texID);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	
	glBegin(GL_QUADS);
		glTexCoord2f(0.0, 0.0);
		glVertex2d(-10.0, -30.0);
		glTexCoord2f(1.0, 0.0);
		glVertex2d(220.0, -30.0);
		glTexCoord2f(1.0, 1.0);
		glVertex2d(220.0, 30.0);
		glTexCoord2f(0.0, 1.0);
		glVertex2d(-10.0, 30.0);
	glEnd();
	
	glBindTexture(GL_TEXTURE_2D, flagsTextures[teamOneCode].texID);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	
	glBegin(GL_QUADS);
		glTexCoord2f(0.0, 0.0);
		glVertex2d(0.0, 0.0);
		glTexCoord2f(1.0, 0.0);
		glVertex2d(30.0, 0.0);
		glTexCoord2f(1.0, 1.0);
		glVertex2d(30.0, 15.0);
		glTexCoord2f(0.0, 1.0);
		glVertex2d(0.0, 15.0);
	glEnd();
	
	glBindTexture(GL_TEXTURE_2D, flagsTextures[teamTwoCode].texID);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	
	glPushMatrix();
	glTranslatef(180.0, 0.0, 0.0);
	glBegin(GL_QUADS);
		glTexCoord2f(0.0, 0.0);
		glVertex2d(0.0, 0.0);
		glTexCoord2f(1.0, 0.0);
		glVertex2d(30.0, 0.0);
		glTexCoord2f(1.0, 1.0);
		glVertex2d(30.0, 15.0);
		glTexCoord2f(0.0, 1.0);
		glVertex2d(0.0, 15.0);
	glEnd();
	glPopMatrix();
	
	glDisable(GL_TEXTURE_2D);
	
	glPopMatrix();
	glColor3f(1.0, 1.0, 0.0);
	
	glPushMatrix();
	
	GLdouble modelview[16];
	glGetDoublev(GL_MODELVIEW_MATRIX, modelview);
	GLdouble projection[16];
	glGetDoublev(GL_PROJECTION_MATRIX, projection);
	GLint viewport[4];
	glGetIntegerv(GL_VIEWPORT, viewport);

	
	GLdouble wx, wy, wz;
	
	gluProject (currentOne->position.x, currentOne->position.y, currentOne->position.z,
					modelview, projection, viewport,
					&wx, &wy, &wz);
	
	
	if(wz < 3000.0)
	{
		if(currentOne->position.z >= (cameraZ + 3000.0) )
		{
			if(currentOne->position.x >= ball->position.x && currentOne->position.x <= (ball->position.x + 6000.0))
				glTranslatef(0.0, 400.0 - ((currentOne->position.x - ball->position.x) / 5.0), 0.0);
			else if(currentOne->position.x < ball->position.x)
				glTranslatef(0.0, 450.0, 0.0);
			else
				glTranslatef(0.0, 25.0, 0.0);
					
			glBegin(GL_TRIANGLES);
				glVertex2d(0.0, 0.0);
				glVertex2d(50.0, -25.0);
				glVertex2d(50.0, 25.0);
			glEnd();
		}
	}
	else if(currentOne->position.z <= (cameraZ - 3000.0) )
	{
		if(currentOne->position.x >= ball->position.x && currentOne->position.x <= (ball->position.x + 6000.0))
			glTranslatef(750.0, 400.0 - ((currentOne->position.x - ball->position.x) / 5.0), 0.0);
		else if(currentOne->position.x < ball->position.x)
			glTranslatef(750.0, 450.0, 0.0);
		else
			glTranslatef(750.0, 25.0, 0.0);
		
		glBegin(GL_TRIANGLES);
		glVertex2d(50.0, 0.0);
		glVertex2d(0.0, -25.0);
		glVertex2d(0.0, 25.0);
		glEnd();
	}
	else if(currentOne->position.z <= (cameraZ + 1500.0) && currentOne->position.z >= (cameraZ - 1500.0)
			&& currentOne->position.x >= ball->position.x + 2400.0)
	{
		glTranslatef((800.0/3000.0) * abs(currentOne->position.z-(cameraZ + 1500.0)), 50.0, 0.0);
		glBegin(GL_TRIANGLES);
		glVertex2d(-25.0, 0.0);
		glVertex2d(25.0, 0.0);
		glVertex2d(0.0, -50.0);
		glEnd();
	}
	
	glPopMatrix();
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	//glEnable(GL_LIGHTING);
	
	drawstr(342, 570, "%s  %d - %d  %s", teams[teamOneCode].shortName, scoreOne,
			scoreTwo, teams[teamTwoCode].shortName);
	
	drawstr(365, 550, "%d:%d", ((int)gameTime) / 60, ((int)gameTime) % 60);
}*/

void drawFlags() 
{
    glDisable(GL_LIGHTING);
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	glOrtho(0.0, 800, 
            0.0, 600, -1.0, 1.0);
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();
	glColor3f(1.0,1.0,1.0);
	
	glEnable(GL_TEXTURE_2D);
	
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glColor4f(1.0, 1.0, 1.0, 0.7);
/*
	glBindTexture(GL_TEXTURE_2D, back2Tex.texID);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	*/
	
	glPushMatrix();
	glTranslatef(300.0, 570.0, 0.0);
	/*glBegin(GL_QUADS);
		glTexCoord2f(0.0, 0.0);
		glVertex2d(-125.0, -30.0);
		glTexCoord2f(1.0, 0.0);
		glVertex2d(-10.0, -30.0);
		glTexCoord2f(1.0, 1.0);
		glVertex2d(-10.0, 30.0);
		glTexCoord2f(0.0, 1.0);
		glVertex2d(-125.0, 30.0);
		
		glTexCoord2f(0.0, 0.0);
		glVertex2d(220.0, -30.0);
		glTexCoord2f(1.0, 0.0);
		glVertex2d(335.0, -30.0);
		glTexCoord2f(1.0, 1.0);
		glVertex2d(335.0, 30.0);
		glTexCoord2f(0.0, 1.0);
		glVertex2d(220.0, 30.0);
	glEnd();
	
	glBindTexture(GL_TEXTURE_2D, turboTex.texID);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	
	glPushMatrix();
		glTranslatef(-5.0, 5.0, 0.0);
		
		for(int i = 0; i < 3; i++)
		{
			glTranslatef(-30.0, 0.0, 0.0);
			glBegin(GL_QUADS);
				glTexCoord2f(0.0, 0.0);
				glVertex2d(0.0, 0.0);
				glTexCoord2f(1.0, 0.0);
				glVertex2d(15.0, 0.0);
				glTexCoord2f(1.0, 1.0);
				glVertex2d(15.0, 15.0);
				glTexCoord2f(0.0, 1.0);
				glVertex2d(0.0, 15.0);
			glEnd();
		}
	glPopMatrix();
		
	glPushMatrix();	
		glTranslatef(200.0, 5.0, 0.0);
		
		for(int i = 0; i < 3; i++)
		{
			glTranslatef(30.0, 0.0, 0.0);
			glBegin(GL_QUADS);
			glTexCoord2f(0.0, 0.0);
			glVertex2d(0.0, 0.0);
			glTexCoord2f(1.0, 0.0);
			glVertex2d(15.0, 0.0);
			glTexCoord2f(1.0, 1.0);
			glVertex2d(15.0, 15.0);
			glTexCoord2f(0.0, 1.0);
			glVertex2d(0.0, 15.0);
			glEnd();
		}
	glPopMatrix();

	glBindTexture(GL_TEXTURE_2D, foulTex.texID);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		
	glPushMatrix();
		glTranslatef(-5.0, -20.0, 0.0);
		
		for(int i = 0; i < 3; i++)
		{
			glTranslatef(-30.0, 0.0, 0.0);
			glBegin(GL_QUADS);
			glTexCoord2f(0.0, 0.0);
			glVertex2d(0.0, 0.0);
			glTexCoord2f(1.0, 0.0);
			glVertex2d(15.0, 0.0);
			glTexCoord2f(1.0, 1.0);
			glVertex2d(15.0, 15.0);
			glTexCoord2f(0.0, 1.0);
			glVertex2d(0.0, 15.0);
			glEnd();
		}
	glPopMatrix();
		
	glPushMatrix();	
		glTranslatef(200.0, -20.0, 0.0);
		
		for(int i = 0; i < 3; i++)
		{
			glTranslatef(30.0, 0.0, 0.0);
			glBegin(GL_QUADS);
			glTexCoord2f(0.0, 0.0);
			glVertex2d(0.0, 0.0);
			glTexCoord2f(1.0, 0.0);
			glVertex2d(15.0, 0.0);
			glTexCoord2f(1.0, 1.0);
			glVertex2d(15.0, 15.0);
			glTexCoord2f(0.0, 1.0);
			glVertex2d(0.0, 15.0);
			glEnd();
		}
	glPopMatrix();
*/		
	glBindTexture(GL_TEXTURE_2D, back1Tex.texID);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	
	glBegin(GL_QUADS);
		glTexCoord2f(0.0, 0.0);
		glVertex2d(-10.0, -30.0);
		glTexCoord2f(1.0, 0.0);
		glVertex2d(220.0, -30.0);
		glTexCoord2f(1.0, 1.0);
		glVertex2d(220.0, 30.0);
		glTexCoord2f(0.0, 1.0);
		glVertex2d(-10.0, 30.0);
	glEnd();
	
	glBindTexture(GL_TEXTURE_2D, flagsTextures[teamOneCode].texID);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	
	glBegin(GL_QUADS);
		glTexCoord2f(0.0, 0.0);
		glVertex2d(0.0, 0.0);
		glTexCoord2f(1.0, 0.0);
		glVertex2d(30.0, 0.0);
		glTexCoord2f(1.0, 1.0);
		glVertex2d(30.0, 15.0);
		glTexCoord2f(0.0, 1.0);
		glVertex2d(0.0, 15.0);
	glEnd();
	
	glBindTexture(GL_TEXTURE_2D, flagsTextures[teamTwoCode].texID);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	
	glPushMatrix();
	glTranslatef(180.0, 0.0, 0.0);
	glBegin(GL_QUADS);
		glTexCoord2f(0.0, 0.0);
		glVertex2d(0.0, 0.0);
		glTexCoord2f(1.0, 0.0);
		glVertex2d(30.0, 0.0);
		glTexCoord2f(1.0, 1.0);
		glVertex2d(30.0, 15.0);
		glTexCoord2f(0.0, 1.0);
		glVertex2d(0.0, 15.0);
	glEnd();
	glPopMatrix();
	
	glDisable(GL_TEXTURE_2D);
	
	glPopMatrix();
	glColor3f(1.0, 1.0, 0.0);
	
	
	GLdouble modelview[16];
	glGetDoublev(GL_MODELVIEW_MATRIX, modelview);
	GLdouble projection[16];
	glGetDoublev(GL_PROJECTION_MATRIX, projection);
	GLint viewport[4];
	glGetIntegerv(GL_VIEWPORT, viewport);
	
	
	GLdouble wx, wy, wz;
	
	gluProject (currentOne->position.x, currentOne->position.y, currentOne->position.z,
				modelview, projection, viewport,
				&wx, &wy, &wz);
	
	
	if(wz < 3000.0)
	{
		if(currentOne->position.z >= (cameraZ + 3000.0) )
		{
			if(currentOne->position.x >= ball->position.x && currentOne->position.x <= (ball->position.x + 6000.0))
				glTranslatef(0.0, 400.0 - ((currentOne->position.x - ball->position.x) / 5.0), 0.0);
			else if(currentOne->position.x < ball->position.x)
				glTranslatef(0.0, 450.0, 0.0);
			else
				glTranslatef(0.0, 25.0, 0.0);
			
			glBegin(GL_TRIANGLES);
			glVertex2d(0.0, 0.0);
			glVertex2d(50.0, -25.0);
			glVertex2d(50.0, 25.0);
			glEnd();
		}
	}
	else if(currentOne->position.z <= (cameraZ - 3000.0) )
	{
		if(currentOne->position.x >= ball->position.x && currentOne->position.x <= (ball->position.x + 6000.0))
			glTranslatef(750.0, 400.0 - ((currentOne->position.x - ball->position.x) / 5.0), 0.0);
		else if(currentOne->position.x < ball->position.x)
			glTranslatef(750.0, 450.0, 0.0);
		else
			glTranslatef(750.0, 25.0, 0.0);
		
		glBegin(GL_TRIANGLES);
		glVertex2d(50.0, 0.0);
		glVertex2d(0.0, -25.0);
		glVertex2d(0.0, 25.0);
		glEnd();
	}
	else if(currentOne->position.z <= (cameraZ + 1500.0) && currentOne->position.z >= (cameraZ - 1500.0)
			&& currentOne->position.x >= ball->position.x + 2400.0)
	{
		glTranslatef((800.0/3000.0) * abs(currentOne->position.z-(cameraZ + 1500.0)), 50.0, 0.0);
		glBegin(GL_TRIANGLES);
		glVertex2d(-25.0, 0.0);
		glVertex2d(25.0, 0.0);
		glVertex2d(0.0, -50.0);
		glEnd();
	}
				
	
	glPopMatrix();
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	//glEnable(GL_LIGHTING);
	
	drawstr(342, 570, "%s  %d - %d  %s", teams[teamOneCode].shortName, scoreOne,
			scoreTwo, teams[teamTwoCode].shortName);
	
	drawstr(365, 550, "%d:%d", ((int)gameTime) / 60, ((int)gameTime) % 60);
}
void drawIntro() 
{
    glDisable(GL_LIGHTING);
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	glOrtho(0.0, 800, 
            0.0, 600, -1.0, 1.0);
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();
	glColor3f(1.0,1.0,1.0);
	
	glEnable(GL_TEXTURE_2D);
	
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glColor4f(1.0, 1.0, 1.0, 0.9);
	
	glBindTexture(GL_TEXTURE_2D, flagsTextures[teamOneCode].texID);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	
	glTranslatef(100.0, 380.0, 0.0);
	glBegin(GL_QUADS);
		glTexCoord2f(0.0, 0.0);
		glVertex2d(0.0, 0.0);
		glTexCoord2f(1.0, 0.0);
		glVertex2d(180.0, 0.0);
		glTexCoord2f(1.0, 1.0);
		glVertex2d(180.0, 90.0);
		glTexCoord2f(0.0, 1.0);
		glVertex2d(0.0, 90.0);
	glEnd();
	
	glBindTexture(GL_TEXTURE_2D, vsTex.texID);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	
	glTranslatef(240.0, 10.0, 0.0);
	glBegin(GL_QUADS);
		glTexCoord2f(0.0, 0.0);
		glVertex2d(0.0, 0.0);
		glTexCoord2f(1.0, 0.0);
		glVertex2d(80.0, 0.0);
		glTexCoord2f(1.0, 1.0);
		glVertex2d(80.0, 80.0);
		glTexCoord2f(0.0, 1.0);
		glVertex2d(0.0, 80.0);
	glEnd();
	
	
	glBindTexture(GL_TEXTURE_2D, flagsTextures[teamTwoCode].texID);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	
	glTranslatef(160.0, -10.0, 0.0);
	glBegin(GL_QUADS);
		glTexCoord2f(0.0, 0.0);
		glVertex2d(0.0, 0.0);
		glTexCoord2f(1.0, 0.0);
		glVertex2d(180.0, 0.0);
		glTexCoord2f(1.0, 1.0);
		glVertex2d(180.0, 90.0);
		glTexCoord2f(0.0, 1.0);
		glVertex2d(0.0, 90.0);
	glEnd();
	
	glPopMatrix();
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	//glEnable(GL_LIGHTING);
}

Uint32 FSTimePast(void) // in milliseconds
{
    Uint32 now = SDL_GetTicks();
    
	Uint32 time = now-oldTime;
	
	oldTime = now;
	
	return time;
}

void readLevel(FILE *tacticsFile, FSTactic *tacticOne, FSTactic *tacticTwo)
{
	char levelStr[10];
	char formationStr[10];
	FSFormation *formationOne = NULL;
	FSFormation *formationTwo = NULL;
	
	fscanf(tacticsFile, "%s", levelStr);
	
	if(!strcmp(levelStr, "high"))
	{
		formationOne = tacticOne->high;
		formationTwo = tacticTwo->high;
	}
	else if(!strcmp(levelStr, "low"))
	{
		formationOne = tacticOne->low;
		formationTwo = tacticTwo->low;
	}
	
	for(int i = 0; i < 3; i++)
	{
		int index;
		
		fscanf(tacticsFile, "%s", formationStr);
		
		if(!strcmp(formationStr, "center"))
			index = 0;
		else if(!strcmp(formationStr, "left"))
			index = 1;
		else if(!strcmp(formationStr, "right"))
			index = 2;
		
		for(int j = 0; j < 4; j++)
		{
			int placeNumber;
			fscanf(tacticsFile, "%d\n", &placeNumber);
			int x, z;
			fscanf(tacticsFile, "pos one %d %d\n", &x, &z);
			(formationOne[index])[placeNumber-1].posX = x;
			(formationOne[index])[placeNumber-1].posZ = z;
			(formationTwo[index])[placeNumber-1].posX = 8000 - x;
			(formationTwo[index])[placeNumber-1].posZ = -19000 - z;
			fscanf(tacticsFile, "pos two %d %d\n", &x, &z);
			(formationOne[index])[placeNumber-1].pos2X = x;
			(formationOne[index])[placeNumber-1].pos2Z = z;
			(formationTwo[index])[placeNumber-1].pos2X = 8000 - x;
			(formationTwo[index])[placeNumber-1].pos2Z = -19000 - z;
			//printf("%s %s %d x: %d, y: %d\n", levelStr, formationStr, placeNumber, (formation[index])[placeNumber].posX, (formation[index])[placeNumber].posZ);
		}
	}
}

void loadTactics()
{
	FILE *tacticsFile = fopen("tactics.txt", "r");
	int count;
	int tacticNumber;
	
	if(!tacticsFile)
		; // ERROR
	
	fscanf(tacticsFile, "there are %d tactics", &count);
	tacticsOne = malloc(sizeof(FSTactic) * count);
	tacticsTwo = malloc(sizeof(FSTactic) * count);
	
	for(int i = 0; i < count; i++)
	{
		fscanf(tacticsFile, "%d", &tacticNumber);
		
		readLevel(tacticsFile, &(tacticsOne[i]), &(tacticsTwo[i]));
		readLevel(tacticsFile, &(tacticsOne[i]), &(tacticsTwo[i]));
	}
	
	fclose(tacticsFile);
	
	tacticOne[0] = FS_PLAYER_TWO;
	tacticOne[1] = FS_PLAYER_THREE;
	tacticOne[2] = FS_PLAYER_FOUR;
	tacticOne[3] = FS_PLAYER_FIVE;
	
	tacticTwo[0] = FS_PLAYER_SEVEN;
	tacticTwo[1] = FS_PLAYER_EIGHT;
	tacticTwo[2] = FS_PLAYER_NINE;
	tacticTwo[3] = FS_PLAYER_TEN;
	
	oneHOL = HIGH;
	twoHOL = HIGH;
	
	oneLevel = twoLevel = 0;
	
	currentTacticOne = 0;
	currentTacticTwo = 1;
	
	playersFollowing = 0;
}

void loadTeams()
{
	FILE *teamsFile = fopen("teams.txt", "r");
	int count;
	
	if(!teamsFile)
		; // ERROR
	
	fscanf(teamsFile, "there are %d teams\n", &count);
	teams = malloc(sizeof(FSTeam) * count);
	flagsTextures = malloc(sizeof(FSTexture) * count);
	
	teamsCount = count;
	
	fscanf(teamsFile, "\n");
	
	for(int i = 0; i < count; i++)
	{
		fscanf(teamsFile, "name = %s\n", teams[i].name);
		fscanf(teamsFile, "short name = %s\n", teams[i].shortName);
		fscanf(teamsFile, "flag = %s\n", teams[i].flagImage);
		fscanf(teamsFile, "small flag = %s\n", teams[i].smallFlagImage);

		int r, g, b;
		fscanf(teamsFile, "body color = %d, %d, %d\n", &r, &g, &b);
		teams[i].bodyColor.r = (float)r / 255.0;
		teams[i].bodyColor.g = (float)g / 255.0;
		teams[i].bodyColor.b = (float)b / 255.0;
		//printf("%d: %f, %f, %f\n", i, teams[i].bodyColor.r, teams[i].bodyColor.g, teams[i].bodyColor.b);
		
		
		fscanf(teamsFile, "legs color = %d, %d, %d\n", &r, &g, &b);
		teams[i].legsColor.r = (float)r / 255.0;
		teams[i].legsColor.g = (float)g / 255.0;
		teams[i].legsColor.b = (float)b / 255.0;
		
		fscanf(teamsFile, "\n");
		fscanf(teamsFile, "players\n");
		fscanf(teamsFile, "\n");
		
		for(int p = 0; p < 5; p++)
		{
			fscanf(teamsFile, "accuracy = %d\n", &((teams[i].players)[p].accuracy));
			fscanf(teamsFile, "strength = %d\n", &((teams[i].players)[p].strength));
			fscanf(teamsFile, "power = %d\n", &((teams[i].players)[p].power));
			fscanf(teamsFile, "aggressivity = %d\n", &((teams[i].players)[p].aggressivity));
			fscanf(teamsFile, "goalkeeping = %d\n", &((teams[i].players)[p].goalkeeping));
			fscanf(teamsFile, "speed = %d\n", &((teams[i].players)[p].speed));
			fscanf(teamsFile, "\n");
		}
		
		flagsTextures[i].LoadTexture(teams[i].flagImage);
		
		printf("team loaded: %s\n", teams[i].name);
	}
	
	fclose(teamsFile);
}

void resizeScreen(int width, int height)			
{
    if (height == 0)
        height = 1;
	
    glViewport(0, 0, width, height);
	
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
	
    //gluPerspective(45.0f,(GLfloat)width/(GLfloat)height, 1 ,150.0f);
	gluPerspective(45.0f,(GLfloat)width/(GLfloat)height,1.0f,15000.0f);
	
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
	
	return;
}

void shootAI()
{
	shooting = true;
	modifier = uirand() % 3;
	if(modifier == 2)
		modifier = -1;
	loadTime = 0.0;
}

void passAI()
{
	float minDistance = 999999999.0;
	float minX;
	float minZ;
	float dis;
	
	for(int i = 0; i < 5; i++)
	{
		if(ball->takenBy == teamTwo[i]->player)
		{
			currentTwo = teamTwo[i];
			break;
		}
	}	
	
	for(int i = 1; i < 5; i++)
	{
		if(teamTwo[i]->player != currentTwo->player)
		{
			float currentDistance = distanceBetweenPoints(teamTwo[i]->position.x, teamTwo[i]->position.z, currentTwo->position.x, currentTwo->position.z);
			
			if(currentDistance > 2500 && currentDistance < minDistance)
			{
				bool attacked =false;
				
				for(int j = 1; j < 5; j++)
				{
					if(distanceBetweenPoints(teamTwo[i]->position.x, teamTwo[i]->position.z, teamOne[i]->position.x, teamOne[i]->position.z) < 2000.0)
					{
						attacked = true;
						break;
					}
				}
				
				if(!attacked)
				{
					dis = currentDistance;
					minDistance = currentDistance;
					minX = teamTwo[i]->position.x;
					minZ = teamTwo[i]->position.z;
					break;
				}
			}
		}
	}
	
	if(minDistance != 999999999.0) // no players
	{
		float force = 7000.0;
		float h = 1000.0;
		
		if(dis >= 4000.0)
			force = 9000.0;
		else if(dis >= 5000.0)
		{
			h = 3500.0;
			force = 4200.0;
		}
		
		currentTwo->moveToPoint(minX, minZ, ball);
		ball->velocity = ballVelocityToPoint( minX, minZ, h, force);
		ball->takenBy = FS_NO_PLAYER;
		minDistance = 999999999.0;
		currentTwo->status = FS_WAIT;
	}
	
	else
	{
		for(int i = 1; i < 5; i++)
		{
			if(teamTwo[i]->player != currentTwo->player)
			{
				float currentDistance = distanceBetweenPoints(teamTwo[i]->position.x, teamTwo[i]->position.z, currentTwo->position.x, currentTwo->position.z);
				
				if(currentDistance > 2500 && currentDistance < minDistance)
				{
					dis = currentDistance;
					minDistance = currentDistance;
					minX = teamTwo[i]->position.x;
					minZ = teamTwo[i]->position.z;
				}
			}
		}
		
		if(minDistance != 999999999.0) // no players
		{
			float force = 7000.0;
			float h = 1000.0;
			
			if(dis >= 4000.0)
				force = 9000.0;
			else if(dis >= 5000.0)
			{
				h = 3500.0;
				force = 4200.0;
			}
			
			currentTwo->moveToPoint(minX, minZ, ball);
			ball->velocity = ballVelocityToPoint( minX, minZ, h, force);
			ball->takenBy = FS_NO_PLAYER;
			minDistance = 999999999.0;
			currentTwo->status = FS_WAIT;
		}
	}
}

void runShootAI()
{
	float minDistance = 999999999.0;
	int index = 0;
	shooting = false;
	
	for(int i = 0; i < 5; i++)
	{
		if(ball->takenBy == teamTwo[i]->player)
		{
			currentTwo = teamTwo[i];
			index = i;
			break;
		}
	}
	
	playBounceSound();
	
	int x = 4000, z = -19000, goalIndex = 0;
			
	{
		float currentDistance = abs( (goalsTwo[i][0] + 
									  (tan((currentTwo->angle * 6.28) / 360) * 
									   (currentTwo->position.z - goalsTwo[i][1])) - currentTwo->position.x) /
									 sqrt((1 + tan((currentTwo->angle * 6.28) / 360))*(1 + tan((currentTwo->angle * 6.28) / 360))));
		
		if(currentDistance < minDistance)
		{
			minDistance = currentDistance;
			goalIndex = i;
		}
	}
	
	goalIndex += modifier;
	
	if(goalIndex == -1)
		goalIndex = 0;
	else if(goalIndex == 3)
		goalIndex = 2;
	
	if(minDistance != 999999999.0)
	{
		minDistance = 999999999.0;
		x = goalsTwo[goalIndex][0];
		z = goalsTwo[goalIndex][1];
	}
	
	currentTwo->angle = (6.28 * atan( ( z - (currentTwo->position.z)) / ( x - (currentTwo->position.x))  )) / 360; // TO-DO: doesn't work
																												   //printf("angle: %d\n", (int)currentTwo->angle);
	if(currentTwo->position.z < z)
		currentTwo->angle = 180 + currentTwo->angle;
	
	ball->position = FSVector(currentTwo->position.x + -(500 * sin((6.28*currentTwo->angle)/360)), 100, currentTwo->position.z + -(500 * cos((6.28*currentTwo->angle)/360)));
	
	
	int factor = (uirand()%(10-teams[teamTwoCode].players[i].accuracy)) * 1000;
	
	if(uirand()%2 != 0)
		factor = -factor;
	
	ball->velocity = ballVelocityToPoint( x + factor, z + factor, 2000 * (1+loadTime*1.5), 9000 * (1+loadTime));
	ball->takenBy = FS_NO_PLAYER;
}

void runTactic()
{
	//FSPlayer **team = (isTeamOne) ? teamOne : teamTwo;
	
	if(ball->takenBy <= 5 && ball->takenBy != FS_NO_PLAYER) // team one
	{
		if(currentTacticOne != 0)
		{
			if(ball->position.z > -9500)
			{
				if(currentTacticOne != 2)
					for(int i = 1; i < 5; i++)
						teamOne[i]->status = FS_WAIT;
				
				currentTacticOne = 2;
			}
			else
			{
				for(int i = 1; i < 5; i++)
					teamOne[i]->status = FS_WAIT;
		
				currentTacticOne = 0;
			}
		}
		
		if(ball->position.z > -9500 && scoreOne > scoreTwo)
		{
			if(currentTacticTwo != 3)
			{
				for(int i = 1; i < 5; i++)
					teamTwo[i]->status = FS_WAIT;
				
				playersFollowing = 0;
				currentTacticTwo = 3;
			}
		}
		else if(currentTacticTwo != 1)
		{
			for(int i = 1; i < 5; i++)
				teamTwo[i]->status = FS_WAIT;
			
			playersFollowing = 0;
			currentTacticTwo = 1;
		}
		
		if(ball->position.z > -15000)
		{
			if(oneHOL != HIGH)
			{
				for(int i = 1; i < 5; i++)
					teamOne[i]->status = FS_WAIT;
				
				oneHOL = HIGH;
			}
			
			if(twoHOL != HIGH)
			{
				for(int i = 1; i < 5; i++)
					teamTwo[i]->status = FS_WAIT;
				
				twoHOL = HIGH;
			}
		}
		else
		{
			if(oneHOL != LOW)
			{
				for(int i = 1; i < 5; i++)
					teamOne[i]->status = FS_WAIT;
				
				oneHOL = LOW;
			}
			
			if(twoHOL != LOW)
			{
				for(int i = 1; i < 5; i++)
					teamTwo[i]->status = FS_WAIT;
				
				twoHOL = LOW;
			}
		}
		
		if(ball->position.x >= 0 && ball->position.x < 2666)
		{
			if(oneLevel != 1)
			{
				for(int i = 1; i < 5; i++)
					teamOne[i]->status = FS_WAIT;
				
				oneLevel = 1;
			}
			
			if(twoLevel != 2)
			{
				for(int i = 1; i < 5; i++)
					teamTwo[i]->status = FS_WAIT;
				
				twoLevel = 2;
			}
		}
		else if(ball->position.x >= 5332 && ball->position.x < 8000)
		{
			if(oneLevel != 2 )
			{
				for(int i = 1; i < 5; i++)
					teamOne[i]->status = FS_WAIT;
				
				oneLevel = 2;
			}
			
			if(twoLevel != 1)
			{
				for(int i = 1; i < 5; i++)
					teamTwo[i]->status = FS_WAIT;
				
				twoLevel = 1;
			}
		}
		else
		{
			if(oneLevel != 0)
			{
				for(int i = 1; i < 5; i++)
					teamOne[i]->status = FS_WAIT;
				
				oneLevel = 0;
			}
			
			if(twoLevel != 0)
			{
				for(int i = 1; i < 5; i++)
					teamTwo[i]->status = FS_WAIT;
				
				twoLevel = 0;
			}
		}
	}
	else if(ball->takenBy != FS_NO_PLAYER) // team two
	{
		if(currentTacticOne != 1)
		{
			for(int i = 1; i < 5; i++)
				teamOne[i]->status = FS_WAIT;
			
			currentTacticOne = 1;
		}
		
		if(currentTacticTwo != 0)
		{
			if(ball->position.z < -9500)
			{
				if(currentTacticTwo != 2)
					for(int i = 1; i < 5; i++)
						teamTwo[i]->status = FS_WAIT;
				
				currentTacticTwo = 2;
			}
			else
			{
				for(int i = 1; i < 5; i++)
					teamTwo[i]->status = FS_WAIT;
			
				currentTacticTwo = 0;
			}
		}
		
		if(ball->position.z < -4000)
		{
			if(oneHOL != HIGH)
			{
				for(int i = 1; i < 5; i++)
					teamOne[i]->status = FS_WAIT;
				
				oneHOL = HIGH;
			}
			
			if(twoHOL != HIGH)
			{
				for(int i = 1; i < 5; i++)
					teamTwo[i]->status = FS_WAIT;
				
				twoHOL = HIGH;
			}
		}
		else
		{
			if(oneHOL != LOW)
			{
				for(int i = 1; i < 5; i++)
					teamOne[i]->status = FS_WAIT;
				
				oneHOL = LOW;
			}
			
			if(twoHOL != LOW)
			{
				for(int i = 1; i < 5; i++)
					teamTwo[i]->status = FS_WAIT;
				
				twoHOL = LOW;
			}
		}
		
		
		if(ball->position.x >= 0 && ball->position.x < 2666)
		{
			if(oneLevel != 1)
			{
				for(int i = 1; i < 5; i++)
					teamOne[i]->status = FS_WAIT;
				
				oneLevel = 1;
			}
			
			if(twoLevel != 2)
			{
				for(int i = 1; i < 5; i++)
					teamTwo[i]->status = FS_WAIT;
				
				twoLevel = 2;
			}
		}
		else if(ball->position.x >= 5332 && ball->position.x < 8000)
		{
			if(oneLevel != 2 )
			{
				for(int i = 1; i < 5; i++)
					teamOne[i]->status = FS_WAIT;
				
				oneLevel = 2;
			}
			
			if(twoLevel != 1)
			{
				for(int i = 1; i < 5; i++)
					teamTwo[i]->status = FS_WAIT;
				
				twoLevel = 1;
			}
		}
		else
		{
			if(oneLevel != 0)
			{
				for(int i = 1; i < 5; i++)
					teamOne[i]->status = FS_WAIT;
				
				oneLevel = 0;
			}
			
			if(twoLevel != 0)
			{
				for(int i = 1; i < 5; i++)
					teamTwo[i]->status = FS_WAIT;
				
				twoLevel = 0;
			}
		}
		
	}
	
	FSPlace *formation;
	
	formation = (oneHOL == HIGH) ? tacticsOne[currentTacticOne].high[oneLevel] : tacticsOne[currentTacticOne].low[oneLevel];
	
	for(int i = 1; i < 5; i++)
	{
		if(distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, teamOne[0]->position.x, teamOne[0]->position.z) < 800)
		{
			FSVector newPosition = teamOne[i]->position + (teamOne[i]->velocity * 0.2 + teamOne[i]->acceleration * (0.2*0.2*0.5));
			
			if(distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, teamOne[0]->position.x, teamOne[0]->position.z) >
			   distanceBetweenPoints(newPosition.x, newPosition.z, teamOne[0]->position.x, teamOne[0]->position.z) )
				teamOne[i]->dontMove = true;
			
			newPosition = teamOne[0]->position + (teamOne[0]->velocity * 0.2 + teamOne[0]->acceleration * (0.2*0.2*0.5));
			
			if(distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, teamOne[0]->position.x, teamOne[0]->position.z) >
			   distanceBetweenPoints(newPosition.x, newPosition.z, teamOne[i]->position.x, teamOne[i]->position.z) )
				teamOne[0]->dontMove = true;
		}
		else if(distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, teamTwo[0]->position.x, teamTwo[0]->position.z) < 800)
		{
			FSVector newPosition = teamOne[i]->position + (teamOne[i]->velocity * 0.2 + teamOne[i]->acceleration * (0.2*0.2*0.5));
			
			if(distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, teamTwo[0]->position.x, teamTwo[0]->position.z) >
			   distanceBetweenPoints(newPosition.x, newPosition.z, teamTwo[0]->position.x, teamTwo[0]->position.z) )
				teamOne[i]->dontMove = true;
			
			newPosition = teamTwo[0]->position + (teamTwo[0]->velocity * 0.2 + teamTwo[0]->acceleration * (0.2*0.2*0.5));
			
			if(distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, teamTwo[0]->position.x, teamTwo[0]->position.z) >
			   distanceBetweenPoints(newPosition.x, newPosition.z, teamOne[i]->position.x, teamOne[i]->position.z) )
				teamTwo[0]->dontMove = true;
		}
		
		if(currentOne->player == teamOne[i]->player)
		{
			currentOne->status = FS_WAIT;
			
			tackle = false;
			
			for(int m = 1; m < 5; m++)
			{
				if(distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, teamTwo[m]->position.x, teamTwo[m]->position.z) < 500)
				{
					if(teamOne[i]->tackling && !teamOne[i]->falling)
					{
						teamTwo[m]->fallAngle = teamTwo[m]->angle;
						teamTwo[m]->falling = true;
						teamTwo[m]->tackling = false;
						teamTwo[m]->tacklingTime = 0;
						
						teamOne[i]->tackling = false;
						teamOne[i]->tacklingTime = 0;
						
						playTackleSound();
						
						if(ball->takenBy == teamTwo[m]->player)
							ball->takenBy = FS_NO_PLAYER;
					}
					else if(teamTwo[m]->tackling && !teamTwo[m]->falling)
					{
						teamOne[i]->fallAngle = teamOne[i]->angle;
						teamOne[i]->falling = true;
						teamOne[i]->tackling = false;
						teamOne[i]->tacklingTime = 0;
						
						teamTwo[m]->tackling = false;
						teamTwo[m]->tacklingTime = 0;
						
						playTackleSound();
						
						if(AI)
							tackle = false;
						
						if(ball->takenBy == teamOne[i]->player)
							ball->takenBy = FS_NO_PLAYER;
					}
					else
					{
						if(AI && teamOne[i]->falling)
						{
							FSVector newPosition = teamTwo[m]->position + (teamTwo[m]->velocity * 0.2 + teamTwo[m]->acceleration * (0.2*0.2*0.5));
							
							if(distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, teamTwo[m]->position.x, teamTwo[m]->position.z) >
							   distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, newPosition.x, newPosition.z) )
							{
								teamTwo[m]->jump();
								/*teamTwo[m]->velocity.x = -teamTwo[m]->velocity.x;
								teamTwo[m]->velocity.z = -teamTwo[m]->velocity.z;
								if(teamTwo[m]->status == FS_FOLLOWING_BALL)
									teamTwo[m]->nextStatus = FS_FOLLOWING_BALL;
								else
									teamTwo[m]->nextStatus = (teamTwo[m]->status == FS_MOVING_TO_TWO) ? FS_WAIT_FOR_TWO : FS_WAIT;
								
								teamTwo[m]->status = FS_DRIBBLING;
								teamTwo[m]->dribblingTime = 0.3;
								
								/*
								int xDistance = abs(teamOne[i]->position.x - teamTwo[m]->position.x);
								int zDistance = abs(teamOne[i]->position.z - teamTwo[m]->position.z);
								
								if(xDistance > zDistance)
								{
									if(teamOne[i]->position.x > teamTwo[m]->position.x) // one under
									{
										teamTwo[m]->move(1.0, 1.0, 1.0);
										
										if(teamTwo[m]->status == FS_FOLLOWING_BALL)
											teamTwo[m]->nextStatus = FS_FOLLOWING_BALL;
										else
											teamTwo[m]->nextStatus = (teamTwo[m]->status == FS_MOVING_TO_TWO) ? FS_WAIT_FOR_TWO : FS_WAIT;
										
										teamTwo[m]->status = FS_DRIBBLING;
										teamTwo[m]->dribblingTime = 0.3;
										
									}
									else
									{
										teamTwo[m]->move(-1.0, -1.0, 1.0);
										if(teamTwo[m]->status == FS_FOLLOWING_BALL)
											teamTwo[m]->nextStatus = FS_FOLLOWING_BALL;
										else
											teamTwo[m]->nextStatus = (teamTwo[m]->status == FS_MOVING_TO_TWO) ? FS_WAIT_FOR_TWO : FS_WAIT;
										teamTwo[m]->status = FS_DRIBBLING;
										teamTwo[m]->dribblingTime = 0.3;
										
									}
								}
								else
								{
									if(teamOne[i]->position.z > teamTwo[m]->position.z)
									{
										teamTwo[m]->move(1.0, 1.0, 1.0);
										if(teamTwo[m]->status == FS_FOLLOWING_BALL)
											teamTwo[m]->nextStatus = FS_FOLLOWING_BALL;
										else
											teamTwo[m]->nextStatus = (teamTwo[m]->status == FS_MOVING_TO_TWO) ? FS_WAIT_FOR_TWO : FS_WAIT;
										teamTwo[m]->status = FS_DRIBBLING;
										teamTwo[m]->dribblingTime = 0.3;
									}
									else
									{
										teamTwo[m]->move(-1.0, -1.0, 1.0);
										if(teamTwo[m]->status == FS_FOLLOWING_BALL)
											teamTwo[m]->nextStatus = FS_FOLLOWING_BALL;
										else
											teamTwo[m]->nextStatus = (teamTwo[m]->status == FS_MOVING_TO_TWO) ? FS_WAIT_FOR_TWO : FS_WAIT;
										teamTwo[m]->status = FS_DRIBBLING;
										teamTwo[m]->dribblingTime = 0.3;
									}
								}*/
							}
						}		 
						
						
						FSVector newPosition = teamTwo[m]->position + (teamTwo[m]->velocity * 0.2 + teamTwo[m]->acceleration * (0.2*0.2*0.5));
						
						if(distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, teamTwo[m]->position.x, teamTwo[m]->position.z) >
						   distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, newPosition.x, newPosition.z) && (!AI || !teamOne[i]->falling))
						{
							teamTwo[m]->dontMove = true;
							/*
							if(teamTwo[m]->status == FS_MOVING_TO_TWO)
							{
								teamTwo[m]->status =  FS_WAIT;
								
								float matrix[4][2] = { {1.0, 0.0}, {0.0, 1.0}, {-1.0, 0.0}, {0.0, -1.0}};
								
								for(int j = 0; j < 4; j++)
								{
									teamTwo[m]->move(matrix[i][0], matrix[i][1], 1.0);
									
									newPosition = teamTwo[m]->position + (teamTwo[m]->velocity * 0.2 + teamTwo[m]->acceleration * (0.2*0.2*0.5));
									
									if(distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, teamTwo[m]->position.x, teamTwo[m]->position.z) <
									   distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, newPosition.x, newPosition.z) )
										break;
									
								}
								
								
								//teamTwo[m]->move(-1.0, 1.0, 1.0);
								teamTwo[m]->nextStatus = teamTwo[m]->status;
								teamTwo[m]->status = FS_DRIBBLING;
								teamTwo[m]->dribblingTime = 0.5;
							}
							else if(teamTwo[m]->status == FS_MOVING_TO_ONE)
							{
								teamTwo[m]->status =  FS_WAIT_FOR_TWO;
								
								float matrix[4][2] = { {1.0, 0.0}, {0.0, 1.0}, {-1.0, 0.0}, {0.0, -1.0}};
								
								for(int j = 0; j < 4; j++)
								{
									teamTwo[m]->move(matrix[i][0], matrix[i][1], 1.0);
									
									newPosition = teamTwo[m]->position + (teamTwo[m]->velocity * 0.2 + teamTwo[m]->acceleration * (0.2*0.2*0.5));
									
									if(distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, teamTwo[m]->position.x, teamTwo[m]->position.z) <
									   distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, newPosition.x, newPosition.z) )
										break;
									
								}
								
								
								//teamTwo[m]->move(-1.0, 1.0, 1.0);
								teamTwo[m]->nextStatus = teamTwo[m]->status;
								teamTwo[m]->status = FS_DRIBBLING;
								teamTwo[m]->dribblingTime = 0.5;
							}
							else if(AI && teamTwo[m]->status == FS_FOLLOWING_BALL)
							{
								if(!tackle && ball->takenBy == teamOne[i]->player && !teamTwo[m]->tackling && !teamOne[i]->falling)
								{
									if(teamTwo[m]->timer == -1)
									{
										if(uirand() % 25 <= 10)
										{
											//printf("%d\n", r);
											teamTwo[m]->tackling = true;
											teamTwo[m]->tackleVelocity = teamTwo[m]->velocity * 1.1;
											teamTwo[m]->tackleAngle = teamTwo[m]->angle;
											tackle = true;
										}
										else
										{
											teamTwo[m]->timer = 0.3;
										}
									}
								}
								
								float matrix[4][2] = { {1.0, 0.0}, {0.0, 1.0}, {-1.0, 0.0}, {0.0, -1.0}};
								
								int pos = -1;
								float distance = distanceBetweenPoints(ball->position.x, ball->position.z, teamTwo[m]->position.x, teamTwo[m]->position.z);
								
								for(int j = 0; j < 4; j++)
								{
									teamTwo[m]->move(matrix[i][0], matrix[i][1], 1.0);
									
									newPosition = teamTwo[m]->position + (teamTwo[m]->velocity * 0.2 + teamTwo[m]->acceleration * (0.2*0.2*0.5));
									
									if(distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, teamTwo[m]->position.x, teamTwo[m]->position.z) <
									   distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, newPosition.x, newPosition.z) )
									{
										float curDis = distanceBetweenPoints(ball->position.x, ball->position.z, newPosition.x, newPosition.z);
										
										if(curDis < distance || pos == -1)
										{
											pos = j;
											distance = curDis;
										}
									}
										
								}
								
								
								//teamTwo[m]->move(-1.0, 1.0, 1.0);
								teamTwo[m]->nextStatus = teamTwo[m]->status;
								teamTwo[m]->status = FS_DRIBBLING;
								teamTwo[m]->dribblingTime = 0.5;
							}
							
							
								/*
								if(teamOne[i]->status == FS_MOVING_TO_TWO)
									teamOne[i]->status =  FS_WAIT;
								else if(teamOne[i]->status == FS_MOVING_TO_ONE)
									teamOne[i]->status =  FS_WAIT_FOR_TWO;*/
						}
						else
							 teamTwo[m]->dontMove = false;
						
						newPosition = teamOne[i]->position + (teamOne[i]->velocity * 0.2 + teamOne[i]->acceleration * (0.2*0.2*0.5));
						
						if(distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, teamTwo[m]->position.x, teamTwo[m]->position.z) >
						   distanceBetweenPoints(newPosition.x, newPosition.z, teamTwo[m]->position.x, teamTwo[m]->position.z) )
							teamOne[i]->dontMove = true;
						else
							teamOne[i]->dontMove = false;
					}
				}
				else if(AI && teamTwo[m]->player == ball->takenBy &&
						distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, teamTwo[m]->position.x, teamTwo[m]->position.z) < 3000)
				{
					//if(uirand()%10 >= 6)
					passAI();
				}
				else if((i != m) &&
				   (distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, teamOne[m]->position.x, teamOne[m]->position.z) < 2000))
				{
					if(teamOne[m]->status != FS_UPDATING_ROLE && 
					   teamOne[m]->status != FS_UPDATING_WAIT && !(distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, teamOne[m]->position.x, teamOne[m]->position.z) < 500))
					{
						int k;
						 
						for(k = 0; k < 4; k++)
						{
							if(tacticOne[k] == teamOne[i]->player)
								break;
						}
						
						int k2;
						
						for(k2 = 0; k2 < 4; k2++)
						{
							if(tacticOne[k2] == teamOne[m]->player)
								break;
						}
						 /*
						for(int k2 = 0; k2 < 4; k2++)
						{
						}*/
						
						FSPlayers temp = tacticOne[k2];
						tacticOne[k2] = tacticOne[k];
						tacticOne[k] = temp;
						
						teamOne[m]->status = FS_UPDATING_WAIT;
						teamOne[i]->status = FS_WAIT;
						
						//for(int m2 = 1; m2 < 5; m2++)
						//	team[m2]->status = FS_WAIT;
						
						//if(distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, teamOne[m]->position.x, teamOne[m]->position.z) < 1000)
						//	teamOne[m]->dontMove = true;
						
						break;
					}
					
					else if(distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, teamOne[m]->position.x, teamOne[m]->position.z) < 500)
					{
						/*teamOne[m]->add = true;
						teamOne[m]->addTemp = teamOne[i]->velocity;*/
						/*
						currentOne->velocity = FSVector(0,0,0);
						currentOne = teamOne[m];
						currentOne->status = FS_WAIT;
						currentOne->move(x, y, 1.0);*/
						
						FSVector newPosition = teamOne[m]->position + (teamOne[m]->velocity * 0.2 + teamOne[m]->acceleration * (0.2*0.2*0.5));
						
						if(distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, teamOne[m]->position.x, teamOne[m]->position.z) >
						   distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, newPosition.x, newPosition.z) )
							teamOne[m]->dontMove = true;
						
						newPosition = teamOne[i]->position + (teamOne[i]->velocity * 0.2 + teamOne[i]->acceleration * (0.2*0.2*0.5));
						
						if(distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, teamOne[m]->position.x, teamOne[m]->position.z) >
						   distanceBetweenPoints(newPosition.x, newPosition.z, teamOne[m]->position.x, teamOne[m]->position.z) )
							teamOne[i]->dontMove = true;
					}
				}
				
				if(AI && teamTwo[m]->tackling)
					tackle = true;
				
				/*
				if((i != m) && team[m]->status != FS_UPDATING_ROLE && 
				   (distanceBetweenPoints(team[i]->position.x, team[i]->position.z, team[m]->position.x, team[m]->position.z) < 1500))
				{
					
					int k;
					
					for(k = 0; k < 4; k++)
					{
						if(tacticOne[k] == team[m]->player)
							break;
					}
					
					int k2;
					
					for(k2 = 0; k2 < 4; k2++)
					{
						if(tacticOne[k2] == team[i]->player)
							break;
					}
					
					FSPlayers temp = tacticOne[k];
					tacticOne[k] = tacticOne[k2];
					tacticOne[k2] = temp;
					team[m]->status = FS_WAIT;
					team[i]->status = FS_WAIT;
					
					/*
					FSPlayers	newTacticOne[3];
					int mTactic, newTactic;
					
					for(int index = 0; index < 4; index++)
					{
						if(tacticOne[index] == team[m]->player)
							mTactic = index;
					}
					
					newTactic = mTactic;
					//mTactic = (mTactic == 3) ? 0 : mTactic+1;
					
					int count = 0;
					for(int k = 0; k < 4; k++)
					{
						if(team[mTactic]->player != team[i]->player)
						{
							newTacticOne[count] = team[mTactic]->player;
							count++;
							mTactic = (mTactic == 3) ? 0 : mTactic+1;
						}
					}
					
					mTactic = newTactic;
					tacticOne[mTactic] = team[i]->player;
					mTactic = (mTactic == 3) ? 0 : mTactic+1;
					tacticOne[mTactic] = newTacticOne[0];
					mTactic = (mTactic == 3) ? 0 : mTactic+1;
					tacticOne[mTactic] = newTacticOne[1];
					mTactic = (mTactic == 3) ? 0 : mTactic+1;
					tacticOne[mTactic] = newTacticOne[2];
					
					for(int l = 1; l < 5; l++)
					{
						team[l]->status = FS_WAIT;
					}
					 
					 */
					/*
					FSPlayers	newTacticOne[4];
					
					int iTactic, mTactic, newTactic;
					
					for(int index = 0; index < 4; index++)
					{
						if(tacticOne[index] == team[i]->player)
							iTactic = index;
						else if(tacticOne[index] == team[m]->player)
							mTactic = index;
						
						newTacticOne[index] = tacticOne[index];
					}
					
					int mTacticPlusOne;
					
					newTacticOne[mTactic] = team[i]->player;
					mTacticPlusOne = (mTactic == 3) ? 0 : mTactic+1;
					newTacticOne[mTacticPlusOne] = tacticOne[mTactic];
					mTactic = mTacticPlusOne;
					mTacticPlusOne = (mTactic == 3) ? 0 : mTactic+1;
					if(tacticOne[mTactic] != team[i]->player)
					{
						newTacticOne[mTacticPlusOne] = tacticOne[mTactic];
						mTactic = mTacticPlusOne;
						mTacticPlusOne = (mTactic == 3) ? 0 : mTactic+1;
						if(tacticOne[mTactic] != team[i]->player)
							newTacticOne[mTacticPlusOne] = tacticOne[mTactic];
					}
					
					for(int l = 0; l < 4; l++)
					{
						tacticOne[l] = newTacticOne[l];
						team[l+i]->status = FS_WAIT;
					}
					*/
					/*
					newTactic = mTactic;
						
					newTacticOne[newTactic] = team[i]->player;
					
					for(int l = 0; l < 3; l++)
					{
						newTactic = (newTactic == 3) ? 0 : newTactic+1;
						if(team[((newTactic == 0) ? 3 : newTactic-1)]->player == team[i]->player)
							break;
						newTacticOne[newTactic] = team[((newTactic == 0) ? 3 : newTactic-1)]->player;
					}
					
					for(int l = 0; l < 4; l++)
					{
						tacticOne[l] = newTacticOne[l];
						team[l+i]->status = FS_WAIT;
					}*/
				//}
			}
			
			continue;
		}
		else
		{
			for(int m = 1; m < 5; m++)
			{
				if(distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, teamTwo[m]->position.x, teamTwo[m]->position.z) < 500)
				{
					FSVector newPosition = teamTwo[m]->position + (teamTwo[m]->velocity * 0.2 + teamTwo[m]->acceleration * (0.2*0.2*0.5));
					
					if(distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, teamTwo[m]->position.x, teamTwo[m]->position.z) >
					   distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, newPosition.x, newPosition.z) )
					{
						teamTwo[m]->dontMove = true;
						
												
						
						/*
						if(teamTwo[m]->status == FS_MOVING_TO_TWO)
						{
							teamTwo[m]->status =  FS_WAIT;
							
							float matrix[4][2] = { {1.0, 0.0}, {0.0, 1.0}, {-1.0, 0.0}, {0.0, -1.0}};
							
							for(int j = 0; j < 4; j++)
							{
								teamTwo[m]->move(matrix[i][0], matrix[i][1], 1.0);
								
								newPosition = teamTwo[m]->position + (teamTwo[m]->velocity * 0.2 + teamTwo[m]->acceleration * (0.2*0.2*0.5));
								
								if(distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, teamTwo[m]->position.x, teamTwo[m]->position.z) <
								   distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, newPosition.x, newPosition.z) )
									break;
								
							}
							
							
							//teamTwo[m]->move(-1.0, 1.0, 1.0);
							teamTwo[m]->nextStatus = teamTwo[m]->status;
							teamTwo[m]->status = FS_DRIBBLING;
							teamTwo[m]->dribblingTime = 0.5;
						}
						else if(teamTwo[m]->status == FS_MOVING_TO_ONE)
						{
							teamTwo[m]->status =  FS_WAIT_FOR_TWO;
							
							float matrix[4][2] = { {1.0, 0.0}, {0.0, 1.0}, {-1.0, 0.0}, {0.0, -1.0}};
							
							for(int j = 0; j < 4; j++)
							{
								teamTwo[m]->move(matrix[i][0], matrix[i][1], 1.0);
								
								newPosition = teamTwo[m]->position + (teamTwo[m]->velocity * 0.2 + teamTwo[m]->acceleration * (0.2*0.2*0.5));
								
								if(distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, teamTwo[m]->position.x, teamTwo[m]->position.z) <
								   distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, newPosition.x, newPosition.z) )
									break;
								
							}
							
							
							//teamTwo[m]->move(-1.0, 1.0, 1.0);
							teamTwo[m]->nextStatus = teamTwo[m]->status;
							teamTwo[m]->status = FS_DRIBBLING;
							teamTwo[m]->dribblingTime = 0.5;
						}
						else if(AI && teamTwo[m]->status == FS_FOLLOWING_BALL)
						{
							if(!tackle && ball->takenBy == teamOne[i]->player && !teamOne[i]->falling)
							{
								teamTwo[m]->tackling = true;
								teamTwo[m]->tackleVelocity = teamTwo[m]->velocity * 1.1;
								teamTwo[m]->tackleAngle = teamTwo[m]->angle;
								tackle = true;
							}
							
							float matrix[4][2] = { {1.0, 0.0}, {0.0, 1.0}, {-1.0, 0.0}, {0.0, -1.0}};
							
							int pos = -1;
							float distance = distanceBetweenPoints(ball->position.x, ball->position.z, teamTwo[m]->position.x, teamTwo[m]->position.z);
							
							for(int j = 0; j < 4; j++)
							{
								teamTwo[m]->move(matrix[i][0], matrix[i][1], 1.0);
								
								newPosition = teamTwo[m]->position + (teamTwo[m]->velocity * 0.2 + teamTwo[m]->acceleration * (0.2*0.2*0.5));
								
								if(distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, teamTwo[m]->position.x, teamTwo[m]->position.z) <
								   distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, newPosition.x, newPosition.z) )
								{
									float curDis = distanceBetweenPoints(ball->position.x, ball->position.z, newPosition.x, newPosition.z);
									
									if(curDis < distance || pos == -1)
									{
										pos = j;
										distance = curDis;
									}
								}
								
							}
							
							
							//teamTwo[m]->move(-1.0, 1.0, 1.0);
							teamTwo[m]->nextStatus = teamTwo[m]->status;
							teamTwo[m]->status = FS_DRIBBLING;
							teamTwo[m]->dribblingTime = 0.5;
						}
						
					
						/*
						if(teamTwo[m]->status == FS_MOVING_TO_TWO)
							teamTwo[m]->status =  FS_WAIT;*/
					}
					
					newPosition = teamOne[i]->position + (teamOne[i]->velocity * 0.2 + teamOne[i]->acceleration * (0.2*0.2*0.5));
					
					if(distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, teamTwo[m]->position.x, teamTwo[m]->position.z) >
					   distanceBetweenPoints(newPosition.x, newPosition.z, teamTwo[m]->position.x, teamTwo[m]->position.z) )
					{
						teamOne[i]->dontMove = true;
						/*if(teamOne[i]->status == FS_MOVING_TO_TWO)
							teamOne[i]->status =  FS_WAIT;*/
					}
				}
				else if( (AI || teamTwo[m]->player != currentTwo->player) && distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, teamTwo[m]->position.x, teamTwo[m]->position.z) < 1000)
				{

						 int xDistance = abs(teamOne[i]->position.x - teamTwo[m]->position.x);
						 int zDistance = abs(teamOne[i]->position.z - teamTwo[m]->position.z);
						 
						 if(xDistance > zDistance)
						 {
							 if(teamOne[i]->position.x > teamTwo[m]->position.x) // one under
							 {
								 teamTwo[m]->move(1.0, 1.0, 1.0);
								 teamTwo[m]->nextStatus = (teamTwo[m]->status == FS_MOVING_TO_TWO) ? FS_WAIT_FOR_TWO : FS_WAIT;
								 teamTwo[m]->status = FS_DRIBBLING;
								 teamTwo[m]->dribblingTime = 0.3;
								 
								 teamOne[i]->move(-1.0, -1.0, 1.0);
								 teamOne[i]->nextStatus = (teamOne[i]->status == FS_MOVING_TO_TWO) ? FS_WAIT_FOR_TWO : FS_WAIT;
								 teamOne[i]->status = FS_DRIBBLING;
								 teamOne[i]->dribblingTime = 0.3;
							 }
							 else
							 {
								 teamTwo[m]->move(-1.0, -1.0, 1.0);
								 teamTwo[m]->nextStatus = (teamTwo[m]->status == FS_MOVING_TO_TWO) ? FS_WAIT_FOR_TWO : FS_WAIT;
								 teamTwo[m]->status = FS_DRIBBLING;
								 teamTwo[m]->dribblingTime = 0.3;
								 
								 teamOne[i]->move(1.0, 1.0, 1.0);
								 teamOne[i]->nextStatus = (teamOne[i]->status == FS_MOVING_TO_TWO) ? FS_WAIT_FOR_TWO : FS_WAIT;
								 teamOne[i]->status = FS_DRIBBLING;
								 teamOne[i]->dribblingTime = 0.3;
							 }
						 }
						 else
						 {
							 if(teamOne[i]->position.z > teamTwo[m]->position.z)
							 {
								 teamTwo[m]->move(1.0, 1.0, 1.0);
								 teamTwo[m]->nextStatus = (teamTwo[m]->status == FS_MOVING_TO_TWO) ? FS_WAIT_FOR_TWO : FS_WAIT;
								 teamTwo[m]->status = FS_DRIBBLING;
								 teamTwo[m]->dribblingTime = 0.3;
								 
								 teamOne[i]->move(-1.0, -1.0, 1.0);
								 teamOne[i]->nextStatus = (teamOne[i]->status == FS_MOVING_TO_TWO) ? FS_WAIT_FOR_TWO : FS_WAIT;
								 teamOne[i]->status = FS_DRIBBLING;
								 teamOne[i]->dribblingTime = 0.3;
							 }
							 else
							 {
								 teamTwo[m]->move(-1.0, -1.0, 1.0);
								 teamTwo[m]->nextStatus = (teamTwo[m]->status == FS_MOVING_TO_TWO) ? FS_WAIT_FOR_TWO : FS_WAIT;
								 teamTwo[m]->status = FS_DRIBBLING;
								 teamTwo[m]->dribblingTime = 0.3;
								 
								 teamOne[i]->move(1.0, 1.0, 1.0);
								 teamOne[i]->nextStatus = (teamOne[i]->status == FS_MOVING_TO_TWO) ? FS_WAIT_FOR_TWO : FS_WAIT;
								 teamOne[i]->status = FS_DRIBBLING;
								 teamOne[i]->dribblingTime = 0.3;
							 }
						 }
				}
			}
		}
		
		int k;
		
		for(k = 0; k < 4; k++)
		{
			if(tacticOne[k] == teamOne[i]->player)
				break;
		}
		
		if(teamOne[i]->status == FS_WAIT || teamOne[i]->status == FS_UPDATING_WAIT)
		{
			//printf("player: %d x: %d z: %d\n", k, formation[k].posX, formation[k].posZ);
			//printf("x: %d\n", (tactics[tactic].low[2])[4]
				   
			teamOne[i]->moveToPoint(formation[k].posX, formation[k].posZ, ball);
			teamOne[i]->status = (teamOne[i]->status == FS_WAIT) ? FS_MOVING_TO_ONE : FS_UPDATING_ROLE;
		}
		else if(teamOne[i]->status == FS_WAIT_FOR_TWO)
		{
			teamOne[i]->moveToPoint(formation[k].posX, formation[k].posZ, ball);
			teamOne[i]->status = FS_MOVING_TO_ONE;
		}
		else if(teamOne[i]->status == FS_MOVING_TO_ONE || teamOne[i]->status == FS_UPDATING_ROLE)
		{
			if(distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, formation[k].posX, formation[k].posZ) < 100)
			{
				//printf("player: %d x: %f z: %f\n", i, team[i]->position.x, team[i]->position.z);
				teamOne[i]->moveToPoint(formation[k].pos2X, formation[k].pos2Z, ball);
				teamOne[i]->status = FS_MOVING_TO_TWO;
			}
		}
		else if(teamOne[i]->status == FS_MOVING_TO_TWO)
		{
			if(distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, formation[k].pos2X, formation[k].pos2Z) < 100)
			{
				//printf("player: %d x: %f z: %f\n", i, team[i]->position.x, team[i]->position.z);
				teamOne[i]->moveToPoint(formation[k].posX, formation[k].posZ, ball);
				teamOne[i]->status = FS_MOVING_TO_ONE;
			}
		}
	}
					 
					 
					 
					 
	/* team two */
					 
	formation = (twoHOL == HIGH) ? tacticsTwo[currentTacticTwo].high[twoLevel] : tacticsTwo[currentTacticTwo].low[twoLevel];
	
	 if(AI && teamTwo[0]->player == ball->takenBy && teamTwo[0]->velocity.y == 0.0)
	 {
		 passAI();
	 }
						 
	for(int i = 1; i < 5; i++)
	{
		/*if(currentTwo->player == teamTwo[i]->player && !AI)
		{
			currentTwo->status = FS_WAIT;
		
			for(int m = 1; m < 5; m++)
			{
				if((i != m) && teamTwo[m]->status != FS_UPDATING_ROLE && 
				   teamTwo[m]->status != FS_UPDATING_WAIT &&
				   (distanceBetweenPoints(teamTwo[i]->position.x, teamTwo[i]->position.z, teamTwo[m]->position.x, teamTwo[m]->position.z) < 2000))
				{
					int k;
					 
					for(k = 0; k < 4; k++)
					{
						if(tacticTwo[k] == teamTwo[i]->player)
							break;
					}
					
					int k2;
					
					for(k2 = 0; k2 < 4; k2++)
					{
						if(tacticTwo[k2] == teamTwo[m]->player)
							break;
					}
					
					FSPlayers temp = tacticTwo[k2];
					tacticTwo[k2] = tacticTwo[k];
					tacticTwo[k] = temp;
					
					teamTwo[m]->status = FS_UPDATING_WAIT;
					teamTwo[i]->status = FS_WAIT;
					
					break;
				}
			}
			
			continue;
		}
		*/
		
		
		if(AI && teamTwo[i]->player == ball->takenBy && teamTwo[i]->status != FS_MOVING_TO_GOAL)
		{
			teamTwo[i]->status = FS_WAIT_FOR_GOAL;
		}
		
		int k;
		
		for(k = 0; k < 4; k++)
		{
			if(tacticTwo[k] == teamTwo[i]->player)
				break;
		}
		
		
		for(int m = 0; m < 5; m++)
		{
			if(!AI && teamTwo[i]->player == currentTwo->player &&
			   m != i && distanceBetweenPoints(teamTwo[i]->position.x, teamTwo[i]->position.z, teamTwo[m]->position.x, teamTwo[m]->position.z) < 2000.0)
			{
				if(teamTwo[m]->status != FS_UPDATING_ROLE && 
				   teamTwo[m]->status != FS_UPDATING_WAIT && !(distanceBetweenPoints(teamTwo[i]->position.x, teamTwo[i]->position.z, teamTwo[m]->position.x, teamTwo[m]->position.z) < 500))
				{
					int k;
					
					for(k = 0; k < 4; k++)
					{
						if(tacticTwo[k] == teamTwo[i]->player)
							break;
					}
					
					int k2;
					
					for(k2 = 0; k2 < 4; k2++)
					{
						if(tacticTwo[k2] == teamTwo[m]->player)
							break;
					}
					/*
					 for(int k2 = 0; k2 < 4; k2++)
					 {
					 }*/
					
					FSPlayers temp = tacticTwo[k2];
					tacticTwo[k2] = tacticTwo[k];
					tacticTwo[k] = temp;
					
					teamTwo[m]->status = FS_UPDATING_WAIT;
					teamTwo[i]->status = FS_WAIT;
					
					//for(int m2 = 1; m2 < 5; m2++)
					//	team[m2]->status = FS_WAIT;
					
					//if(distanceBetweenPoints(teamTwo[i]->position.x, teamTwo[i]->position.z, teamTwo[m]->position.x, teamTwo[m]->position.z) < 1000)
					//	teamTwo[m]->dontMove = true;
					
					break;
				}
			}
			
			if(m != i && distanceBetweenPoints(teamTwo[i]->position.x, teamTwo[i]->position.z, teamTwo[m]->position.x, teamTwo[m]->position.z) < 500)
			{
				/* mischia */
				
				teamTwo[m]->velocity.x = -teamTwo[m]->velocity.x;
				teamTwo[m]->velocity.z = -teamTwo[m]->velocity.z;
				if(teamTwo[m]->status == FS_FOLLOWING_BALL)
					teamTwo[m]->nextStatus = FS_FOLLOWING_BALL;
				else
					teamTwo[m]->nextStatus = (teamTwo[m]->status == FS_MOVING_TO_TWO) ? FS_WAIT_FOR_TWO : FS_WAIT;
				
				teamTwo[m]->status = FS_DRIBBLING;
				teamTwo[m]->dribblingTime = 0.3;
				
				FSVector newPosition = teamTwo[m]->position + (teamTwo[m]->velocity * 0.2 + teamTwo[m]->acceleration * (0.2*0.2*0.5));
				
				if(distanceBetweenPoints(teamTwo[i]->position.x, teamTwo[i]->position.z, teamTwo[m]->position.x, teamTwo[m]->position.z) >
				   distanceBetweenPoints(teamTwo[i]->position.x, teamTwo[i]->position.z, newPosition.x, newPosition.z) )
					teamTwo[m]->dontMove = true;
				
				newPosition = teamTwo[i]->position + (teamTwo[i]->velocity * 0.2 + teamTwo[i]->acceleration * (0.2*0.2*0.5));
				
				if(distanceBetweenPoints(teamTwo[i]->position.x, teamTwo[i]->position.z, teamTwo[m]->position.x, teamTwo[m]->position.z) >
				   distanceBetweenPoints(newPosition.x, newPosition.z, teamTwo[m]->position.x, teamTwo[m]->position.z) )
					teamTwo[i]->dontMove = true;
			}
		}
		
		if(AI /*&& teamTwo[i]->status != FS_DRIBBLING*/ &&
			ball->takenBy <= 5 && distanceBetweenPoints(teamTwo[i]->position.x, teamTwo[i]->position.z, ball->position.x, ball->position.z) < 2500)
		{
			if(distanceBetweenPoints(teamTwo[i]->position.x, teamTwo[i]->position.z, ball->position.x, ball->position.z) < 800 && ball->takenBy != FS_NO_PLAYER)
			{
				if(teamTwo[i]->timer == -1)
				{
					if(!tackle)
					{
						if(uirand() % (40-teams[teamTwoCode].players[i].aggressivity) <= 10)
						{
							//printf("%d\n", r);
							teamTwo[i]->tackling = true;
							teamTwo[i]->tackleVelocity = teamTwo[i]->velocity * 1.1;
							teamTwo[i]->tackleAngle = teamTwo[i]->angle;
							tackle = true;
						}
						else
						{
							teamTwo[i]->timer = 0.3;
						}
					}
				}
				
				/*if(!tackle)
				{
					teamTwo[i]->tackling = true;
					teamTwo[i]->tackleVelocity = teamTwo[i]->velocity * 1.1;
					teamTwo[i]->tackleAngle = teamTwo[i]->angle;
					tackle = true;
				}*/
			}/*
			else*/
			//if(playersFollowing < 3)
			else
			{
				if(teamTwo[i]->status != FS_FOLLOWING_BALL /*&& (playersFollowing < 2)*/ && ball->takenBy != teamOne[0]->player)
				{
					teamTwo[i]->status = FS_FOLLOWING_BALL;
					playersFollowing++;
				}
			}
		}
		else if(teamTwo[i]->status == FS_FOLLOWING_BALL)
		{
			teamTwo[i]->status = FS_WAIT;
			playersFollowing--;
		}
		
		
		if((currentTwo->player == teamTwo[i]->player) && !AI)
		{
			currentTwo->status = FS_WAIT;
			continue;
		}
		else if(teamTwo[i]->status == FS_WAIT || teamTwo[i]->status == FS_UPDATING_WAIT)
		{
			//printf("player: %d x: %d z: %d\n", k, formation[k].posX, formation[k].posZ);
			//printf("x: %d\n", (tactics[tactic].low[2])[4]
				   
			teamTwo[i]->moveToPoint(formation[k].posX, formation[k].posZ, ball);
			teamTwo[i]->status = (teamTwo[i]->status == FS_WAIT) ? FS_MOVING_TO_ONE : FS_UPDATING_ROLE;
		}
		else if(teamTwo[i]->status == FS_FOLLOWING_BALL)
		{
			if(teamTwo[i]->timer2 == -1)
			{
				if(uirand() % 25 <= 18)
					teamTwo[i]->moveToPoint(ball->position.x, ball->position.z, ball);
				else
					teamTwo[i]->timer2 = 0.1;
			}
		}
		else if(teamTwo[i]->status == FS_WAIT_FOR_GOAL)
		{
			teamTwo[i]->moveToPoint(4000, 0, ball);
			teamTwo[i]->status = FS_MOVING_TO_GOAL;
		}
		else if(teamTwo[i]->status == FS_MOVING_TO_GOAL)
		{
			if(teamTwo[i]->position.z > -6000 && !shooting)
				shootAI();
		}
		else if(teamTwo[i]->status == FS_WAIT_FOR_TWO)
		{
			teamTwo[i]->moveToPoint(formation[k].posX, formation[k].posZ, ball);
			teamTwo[i]->status = FS_MOVING_TO_ONE;
		}
		else if(teamTwo[i]->status == FS_MOVING_TO_ONE || teamTwo[i]->status == FS_UPDATING_ROLE)
		{
			if(distanceBetweenPoints(teamTwo[i]->position.x, teamTwo[i]->position.z, formation[k].posX, formation[k].posZ) < 100)
			{
				//printf("player: %d x: %f z: %f\n", i, team[i]->position.x, team[i]->position.z);
				teamTwo[i]->moveToPoint(formation[k].pos2X, formation[k].pos2Z, ball);
				teamTwo[i]->status = FS_MOVING_TO_TWO;
			}
		}
		else if(teamTwo[i]->status == FS_MOVING_TO_TWO)
		{
			if(distanceBetweenPoints(teamTwo[i]->position.x, teamTwo[i]->position.z, formation[k].pos2X, formation[k].pos2Z) < 100)
			{
				//printf("player: %d x: %f z: %f\n", i, team[i]->position.x, team[i]->position.z);
				teamTwo[i]->moveToPoint(formation[k].posX, formation[k].posZ, ball);
				teamTwo[i]->status = FS_MOVING_TO_ONE;
			}
		}
	}

}

void pauseGame()
{
	bool done = false;
	bool firstSelected = true;
	bool firstMenu = true;
	SDL_Event event;
	pauseMusicOne();
	   
	while(!done)
	{
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);         
		glLoadIdentity();
		
		gluLookAt(cameraX, cameraY, cameraZ, lookX, lookY, lookZ, 0.0, 1.0, 0.0);
		
		// draw objects
		ground->Draw();
		
		goalTwo.Draw();
		goalOne.Draw();
		
		glEnable(GL_TEXTURE_2D);
		
		glBindTexture(GL_TEXTURE_2D, shadowTex.texID);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
		
		
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glColor4f(1.0, 1.0, 1.0, 1.0);
		
		for(int i = 0; i < 5; i++)
		{
			glPushMatrix();
			glTranslatef(teamOne[i]->position.x-300.0, 0.0 ,teamOne[i]->position.z-300.0);
			glBegin(GL_QUADS);
			glTexCoord2f(0.0, 1.0);
			glVertex3d(0.0, 0.0, 0.0);
			glTexCoord2f(1.0, 1.0);
			glVertex3d(500.0, 0.0, 0.0);
			glTexCoord2f(1.0, 0.0);
			glVertex3d(500.0, 0.0, 500.0);
			glTexCoord2f(0.0, 0.0);
			glVertex3d(0.0, 0.0, 500.0);
			glEnd();
			glPopMatrix();
			
			glPushMatrix();
			glTranslatef(teamTwo[i]->position.x-300.0, 0.0 ,teamTwo[i]->position.z-300.0);
			glBegin(GL_QUADS);
			glTexCoord2f(0.0, 1.0);
			glVertex3d(0.0, 0.0, 0.0);
			glTexCoord2f(1.0, 1.0);
			glVertex3d(500.0, 0.0, 0.0);
			glTexCoord2f(1.0, 0.0);
			glVertex3d(500.0, 0.0, 500.0);
			glTexCoord2f(0.0, 0.0);
			glVertex3d(0.0, 0.0, 500.0);
			glEnd();
			glPopMatrix();
		}
		glPushMatrix();
		glTranslatef(ball->position.x-200.0, 0.0 ,ball->position.z-200.0);
		glBegin(GL_QUADS);
		glTexCoord2f(0.0, 1.0);
		glVertex3d(0.0, 0.0, 0.0);
		glTexCoord2f(1.0, 1.0);
		glVertex3d(400.0, 0.0, 0.0);
		glTexCoord2f(1.0, 0.0);
		glVertex3d(400.0, 0.0, 400.0);
		glTexCoord2f(0.0, 0.0);
		glVertex3d(0.0, 0.0, 400.0);
		glEnd();
		glPopMatrix();
		glDisable(GL_BLEND);
		glDisable(GL_TEXTURE_2D);
		
		struct
		{
			float x;
			short index;
		} xs[11], tmp;
		
		
		
		for(int i = 0; i < 5; i++)
		{
			xs[i].x = teamOne[i]->position.x;
			xs[i].index = i;
		}
		
		for(int i = 0; i < 5; i++)
		{
			int index = i + 5;
			xs[index].x = teamTwo[i]->position.x;
			xs[index].index = index;
		}
		
		xs[10].x = ball->position.x;
		xs[10].index = 10;
		
		for (int i = 0; i < 10; i++) 
		{
			for (int j = 0; j < 10-i; j++)
				if (xs[j+1].x < xs[j].x) 
				{
					tmp.x = xs[j].x;
					tmp.index = xs[j].index;
					xs[j].x = xs[j+1].x;
					xs[j].index = xs[j+1].index;
					xs[j+1].x = tmp.x;
					xs[j+1].index = tmp.index;
				}
		}
			
			glDisable(GL_LIGHTING);
			for(int i = 0; i < 11; i++)
			{
				if(xs[i].index < 5)
					teamOne[xs[i].index]->Draw();
				else if(xs[i].index < 10)
					teamTwo[(xs[i].index)-5]->Draw();
				else
					ball->Draw();
			}
			
		glColor3f(1.0f, 0.0, 0.0f);
		
		drawFlags();
		
		
		if(shooting || crossing)
		{
			drawBar();
		}
		
		glTranslatef(currentOne->position.x, 800.0, currentOne->position.z);
		glRotatef(180.0, 0.0, 0.0, 1.0);
		glColor3f(1.0, 1.0, 0.0);

		
		glBegin(GL_TRIANGLES);                                  // Start Drawing The Pyramid
		
			glVertex3f( 0.0f, 100.0f, 0.0f);                  // Top Of Triangle (Front)
			glVertex3f(-100.0f,-100.0f, 100.0f);                  // Left Of Triangle (Front)
			glVertex3f( 100.0f,-100.0f, 100.0f);                  // Right Of Triangle (Front)
			
			glVertex3f( 0.0f, 100.0f, 0.0f);                  // Top Of Triangle (Right)
			glVertex3f( 100.0f,-100.0f, 100.0f);                  // Left Of Triangle (Right)
			glVertex3f( 100.0f,-100.0f, -100.0f);                 // Right Of Triangle (Right)
			
			glVertex3f( 0.0f, 100.0f, 0.0f);                  // Top Of Triangle (Back)
			glVertex3f( 100.0f,-100.0f, -100.0f);                 // Left Of Triangle (Back)
			glVertex3f(-100.0f,-100.0f, -100.0f);                 // Right Of Triangle (Back)
			
			glVertex3f( 0.0f, 100.0f, 0.0f);                  // Top Of Triangle (Left)
			glVertex3f(-100.0f,-100.0f,-100.0f);                  // Left Of Triangle (Left)
			glVertex3f(-100.0f,-100.0f, 100.0f);                  // Right Of Triangle (Left)
		
		glEnd();
		
		
		glDisable(GL_LIGHTING);
		glMatrixMode(GL_PROJECTION);
		glPushMatrix();
		glLoadIdentity();
		glOrtho(0.0, 800, 
				0.0, 600, -1.0, 1.0);
		glMatrixMode(GL_MODELVIEW);
		glPushMatrix();
		glLoadIdentity();
		//glColor3f(1.0,1.0,1.0);
		
		glEnable(GL_TEXTURE_2D);
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		
		glColor4f(0.8, 0.8, 0.8, 0.3);
		glBegin(GL_QUADS);
			glVertex2d(0, 0);
			glVertex2d(800, 0);
			glVertex2d(800, 600);
			glVertex2d(0, 600);
		glEnd();
		
		glColor4f(1.0, 1.0, 1.0, 1.0);
		
		if(firstMenu)
			glBindTexture(GL_TEXTURE_2D, pauseTex.texID);
		else
			glBindTexture(GL_TEXTURE_2D, areyousureTex.texID);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		
		glPushMatrix();
		glTranslatef(100.0, 400.0, 0.0);
		
			glBegin(GL_QUADS);
			glTexCoord2f(0.0, 0.0);
			glVertex2d(0, 0);
			glTexCoord2f(1.0, 0.0);
			glVertex2d(512, 0);
			glTexCoord2f(1.0, 1.0);
			glVertex2d(512, 128);
			glTexCoord2f(0.0, 1.0);
			glVertex2d(0, 128);
		glEnd();
		glPopMatrix();
		
		
		if(firstMenu)
		{
			if(firstSelected)
				glBindTexture(GL_TEXTURE_2D, resumeHTex.texID);
			else
				glBindTexture(GL_TEXTURE_2D, resumeTex.texID);
		}
		else
		{
			if(firstSelected)
				glBindTexture(GL_TEXTURE_2D, yesHTex.texID);
			else
				glBindTexture(GL_TEXTURE_2D, yesTex.texID);
		}
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		
		glPushMatrix();
		glTranslatef(100.0, 300.0, 0.0);
		
		glBegin(GL_QUADS);
			glTexCoord2f(0.0, 0.0);
			glVertex2d(0, 0);
			glTexCoord2f(1.0, 0.0);
			glVertex2d(256, 0);
			glTexCoord2f(1.0, 1.0);
			glVertex2d(256, 64);
			glTexCoord2f(0.0, 1.0);
			glVertex2d(0, 64);
		glEnd();
		glPopMatrix();
		
		if(firstMenu)
		{
			if(firstSelected)
				glBindTexture(GL_TEXTURE_2D, mainmenuTex.texID);
			else
				glBindTexture(GL_TEXTURE_2D, mainmenuHTex.texID);
		}
		else
		{
			if(firstSelected)
				glBindTexture(GL_TEXTURE_2D, noTex.texID);
			else
				glBindTexture(GL_TEXTURE_2D, noHTex.texID);
		}
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		
		glPushMatrix();
		glTranslatef(100.0, 250.0, 0.0);
		
		glBegin(GL_QUADS);
			glTexCoord2f(0.0, 0.0);
			glVertex2d(0, 0);
			glTexCoord2f(1.0, 0.0);
			glVertex2d(256, 0);
			glTexCoord2f(1.0, 1.0);
			glVertex2d(256, 64);
			glTexCoord2f(0.0, 1.0);
			glVertex2d(0, 64);
		glEnd();
		glPopMatrix();
		
		glDisable(GL_BLEND);
		
		glPopMatrix();
		glMatrixMode(GL_PROJECTION);
		glPopMatrix();
		glMatrixMode(GL_MODELVIEW);
		//glEnable(GL_LIGHTING);
		
		
		glFlush();
		
		//int swapInterval = 1;
		//CGLSetParameter(CGLGetCurrentContext(), kCGLCPSwapInterval, &swapInterval);
		SDL_GL_SwapBuffers();
		
		
		while( SDL_PollEvent(& event) )
		{
			switch ( event.type )
			{  
				case SDL_KEYDOWN:
					
					switch(event.key.keysym.sym)
					{
						case SDLK_ESCAPE:
							done = true;
							break;
							
						case SDLK_q:
							if(event.key.keysym.mod & KMOD_META)
							{
								CleanUp();
								exit(0);
							}
							break;
							
						case SDLK_RIGHT:
							x = 1.0;
							rightPressed = true;
							break;
							
						case SDLK_LEFT:
							x = -1.0;
							leftPressed = true;
							break;
							
						case SDLK_UP:
							y = 1.0;
							upPressed = true;
							firstSelected = !firstSelected;
							playMoveSound();
							break;
							
						case SDLK_DOWN:
							y = -1.0;
							downPressed = true;
							firstSelected = !firstSelected;
							playMoveSound();
							break;
							
						case SDLK_SPACE:
						case SDLK_RETURN:
							if(firstMenu)
							{
								if(firstSelected)
									done = true;
								else
									firstMenu = false;
							}
							else
							{
								if(firstSelected)
								{
									done = true;
									gameDone = true;
									goToMain = true;
								}
								else
									firstMenu = true;
							}
							playSelectSound();
							break;
					}
					
					break;
					
				case SDL_KEYUP:
					
					switch(event.key.keysym.sym)
					{
						case SDLK_RIGHT:
							rightPressed = false;
							if(leftPressed)
								x = -1.0;
							else
								x = 0.0;
							break;
							
						case SDLK_LEFT:
							leftPressed = false;
							if(rightPressed)
								x = 1.0;
							else
								x = 0.0;
							break;
							
						case SDLK_UP:
							upPressed = false;
							if(downPressed)
								y = -1.0;
							else
								y = 0.0;
							break;
							
						case SDLK_DOWN:
							downPressed = false;
							if(upPressed)
								y = 1.0;
							else
								y = 0.0;
							
							break;	
					}
					
					break;
				}
			}
	}
	
	playMusicOne();
	currentOne->move(x, y, 1.0);
	
	oldTime = SDL_GetTicks();
}

void kickOff(FSKickOff what)
{
	//x = 0.0;
	//y = 0.0;
	
	shooting = crossing = false;
	
	FSPlace *formation;
	
	teamOne[0]->position = FSVector(3514.0, 300.0, -570.0);
	teamTwo[0]->position = FSVector(3514.0, 300.0, -18500.0);
	
	formation = tacticsOne[2].high[0];
	
	for(int i = 1; i < 5; i++)
	{
		teamOne[i]->position = FSVector(formation[i-1].posX, 300.0, formation[i-1].posZ);
		teamOne[i]->Init();
	}
	
	formation = tacticsTwo[2].high[0];
	
	for(int i = 1; i < 5; i++)
	{
		teamTwo[i]->position = FSVector(formation[i-1].posX, 300.0, formation[i-1].posZ);
		teamTwo[i]->Init();
		teamTwo[i]->angle = 180;
		teamTwo[i]->status = FS_IDLE;
	}
	
	ball->takenBy = FS_NO_PLAYER;
	ball->status = FS_GAME;
	currentOne = teamOne[2];
	currentTwo = teamTwo[2];
	
	tacticOne[0] = FS_PLAYER_TWO;
	tacticOne[1] = FS_PLAYER_THREE;
	tacticOne[2] = FS_PLAYER_FOUR;
	tacticOne[3] = FS_PLAYER_FIVE;
	
	tacticTwo[0] = FS_PLAYER_SEVEN;
	tacticTwo[1] = FS_PLAYER_EIGHT;
	tacticTwo[2] = FS_PLAYER_NINE;
	tacticTwo[3] = FS_PLAYER_TEN;
	
	oneHOL = HIGH;
	twoHOL = HIGH;
	
	oneLevel = twoLevel = 0;
	
	currentTacticOne = 0;
	currentTacticTwo = 1;
	
	playersFollowing = 0;

	float z;
	
	if(what == FS_ONE)
		z = -9000.0;
	else if(what == FS_TWO)
		z = -10000.0;
	else
	{
		//playKickOffSound();
		z = -9500.0;
	}
	playKickOffSound();
	
	playMusicOne();
	
	ball->position = FSVector(4000.0, 80.0, z);
	ball->acceleration = FSVector(0.0, -5050.0, 0.0); 
	ball->velocity = FSVector(0.0, 0.0, 0.0);
	
	cameraX = 7800.0f;
	cameraY = 4500.0f;
	cameraZ = -9500.0f;
	
	lookX = 3250.0f;
	lookY = 0.0f;
	lookZ = -9500.0;
	
	oldTime = SDL_GetTicks();
	render();
	
	for(int i = 1; i < 5; i++)
	{
		teamOne[i]->status = FS_WAIT;
		teamTwo[i]->status = FS_WAIT;
	}
	
	if(!AI || what != FS_TWO)
	{
		bool done = false;
		SDL_Event event;
		
		rightPressed = false;
		leftPressed = false;
		upPressed = false;
		downPressed = false;
		   
		while(!done)
		{
			glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);         
			glLoadIdentity();

			//gluLookAt(150.0, 150.0, 200.0, 150.0, 0.0, -300.0, 0.0, 1.0, 0.0);
			gluLookAt(cameraX, cameraY, cameraZ, lookX, lookY, lookZ, 0.0, 1.0, 0.0);
			
			
			// draw objects
			ground->Draw();
			
			goalTwo.Draw();
			goalOne.Draw();
			
			glEnable(GL_TEXTURE_2D);
			
			glBindTexture(GL_TEXTURE_2D, shadowTex.texID);
			glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
			glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
			
			
			glEnable(GL_BLEND);
			glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
			glColor4f(1.0, 1.0, 1.0, 1.0);
			
			for(int i = 0; i < 5; i++)
			{
				glPushMatrix();
				glTranslatef(teamOne[i]->position.x-300.0, 0.0 ,teamOne[i]->position.z-300.0);
				glBegin(GL_QUADS);
				glTexCoord2f(0.0, 1.0);
				glVertex3d(0.0, 0.0, 0.0);
				glTexCoord2f(1.0, 1.0);
				glVertex3d(500.0, 0.0, 0.0);
				glTexCoord2f(1.0, 0.0);
				glVertex3d(500.0, 0.0, 500.0);
				glTexCoord2f(0.0, 0.0);
				glVertex3d(0.0, 0.0, 500.0);
				glEnd();
				glPopMatrix();
				
				glPushMatrix();
				glTranslatef(teamTwo[i]->position.x-300.0, 0.0 ,teamTwo[i]->position.z-300.0);
				glBegin(GL_QUADS);
				glTexCoord2f(0.0, 1.0);
				glVertex3d(0.0, 0.0, 0.0);
				glTexCoord2f(1.0, 1.0);
				glVertex3d(500.0, 0.0, 0.0);
				glTexCoord2f(1.0, 0.0);
				glVertex3d(500.0, 0.0, 500.0);
				glTexCoord2f(0.0, 0.0);
				glVertex3d(0.0, 0.0, 500.0);
				glEnd();
				glPopMatrix();
			}
			glPushMatrix();
			glTranslatef(ball->position.x-200.0, 0.0 ,ball->position.z-200.0);
			glBegin(GL_QUADS);
			glTexCoord2f(0.0, 1.0);
			glVertex3d(0.0, 0.0, 0.0);
			glTexCoord2f(1.0, 1.0);
			glVertex3d(400.0, 0.0, 0.0);
			glTexCoord2f(1.0, 0.0);
			glVertex3d(400.0, 0.0, 400.0);
			glTexCoord2f(0.0, 0.0);
			glVertex3d(0.0, 0.0, 400.0);
			glEnd();
			glPopMatrix();
			glDisable(GL_BLEND);
			glDisable(GL_TEXTURE_2D);
			
			struct
			{
				float x;
				short index;
			} xs[11], tmp;
			
			
			
			for(int i = 0; i < 5; i++)
			{
				xs[i].x = teamOne[i]->position.x;
				xs[i].index = i;
			}
			
			for(int i = 0; i < 5; i++)
			{
				int index = i + 5;
				xs[index].x = teamTwo[i]->position.x;
				xs[index].index = index;
			}
			
			xs[10].x = ball->position.x;
			xs[10].index = 10;
			
			for (int i = 0; i < 10; i++) 
			{
				for (int j = 0; j < 10-i; j++)
					if (xs[j+1].x < xs[j].x) 
					{
						tmp.x = xs[j].x;
						tmp.index = xs[j].index;
						xs[j].x = xs[j+1].x;
						xs[j].index = xs[j+1].index;
						xs[j+1].x = tmp.x;
						xs[j+1].index = tmp.index;
					}
			}
				
				glDisable(GL_LIGHTING);
				for(int i = 0; i < 11; i++)
				{
					if(xs[i].index < 5)
						teamOne[xs[i].index]->Draw();
					else if(xs[i].index < 10)
						teamTwo[(xs[i].index)-5]->Draw();
					else
						ball->Draw();
				}
		
				glColor3f(1.0f, 0.0, 0.0f);
				
				//drawstr(620, 570, "FPS: %f", 1.0 / (deltaT/1000.0));
				drawFlags();
				if(what == FS_NEUTRAL)
					drawIntro();
				glFlush();
				
				//int swapInterval = 1;
				//CGLSetParameter(CGLGetCurrentContext(), kCGLCPSwapInterval, &swapInterval);
				SDL_GL_SwapBuffers();
				
			
			while( SDL_PollEvent(& event) )
		   {
			   switch ( event.type )
			   {  
				   case SDL_KEYDOWN:
					   
					   
					   switch(event.key.keysym.sym)
					   {
						   case SDLK_q:
							   if(event.key.keysym.mod & KMOD_META)
							   {
								   CleanUp();
								   exit(0);
							   }
							   break;
							   
						   case SDLK_RIGHT:
							   x = 1.0;
							   rightPressed = true;
							   currentOne->move(x, y, 1.0);
							   done = true;
							   break;
							   
						   case SDLK_LEFT:
							   x = -1.0;
							   leftPressed = true;
							   currentOne->move(x, y, 1.0);
							   done = true;
							   break;
							   
						   case SDLK_UP:
							   y = 1.0;
							   upPressed = true;
							   currentOne->move(x, y, 1.0);
							   done = true;
							   break;
							   
						   case SDLK_DOWN:
							   y = -1.0;
							   downPressed = true;
							   currentOne->move(x, y, 1.0);
							   done = true;
							   break;
					   }
			   }
		   }
		}
	}
	
	oldTime = SDL_GetTicks();
}

void init()
{
	glClearColor(1.0, 1.0, 1.0, 1.0);
	glShadeModel(GL_SMOOTH);
	//
	glDepthFunc(GL_LEQUAL);
	//glEnable(GL_CULL_FACE);
	//glFrontFace(GL_CCW);
	//glClearDepth(1.0f);
	//glEnable(GL_DEPTH_TEST);
	//glDepthMask(GL_TRUE);
	
	//glClearDepth(1.0f);  // not sure how this really works, grabbed it from NeHe tutorial
	//glDepthFunc(GL_GREATER); // have tried this both ways, enabling deptht test before/after depth func
	//glEnable(GL_DEPTH_TEST);
	//glDepthMask(GL_TRUE);  // I've tried this, and commented out the line. Same results.
	
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	
	//glMaterialfv(GL_FRONT, GL_DIFFUSE, material);
	
	/*// Now setup LIGHT0
	glLightfv(GL_LIGHT0, GL_AMBIENT, ambientLight);        // setup the ambient element
	glLightfv(GL_LIGHT0, GL_DIFFUSE, diffuseLight);        // the diffuse element
	glLightfv(GL_LIGHT0, GL_POSITION, lightPosition); // place the light in the world
	
	

	// Enable the light	
	glEnable(GL_LIGHT0);
	
	glEnable(GL_COLOR_MATERIAL);
	glColorMaterial(GL_FRONT, GL_AMBIENT_AND_DIFFUSE);*/
	
	glLightfv(GL_LIGHT0, GL_AMBIENT, ambientLight);        // setup the ambient element
	glLightfv(GL_LIGHT0, GL_DIFFUSE, ambientLight);        // the diffuse element
	glLightfv(GL_LIGHT0, GL_POSITION, lightPosition); // place the light in the world
	
	
	
	// Enable the light
	glEnable(GL_LIGHT0);
	glEnable(GL_COLOR_MATERIAL);
	glColorMaterial(GL_FRONT, GL_AMBIENT_AND_DIFFUSE);
	
	
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);       
	
	bluepixyTex.LoadTexture("menu/bluepixy.tga");
	/*
	if(audio)
	{
		logoSound = Mix_LoadWAV("sounds/logo.wav");
		Mix_PlayChannel(-1, logoSound, 0);
	}
	*/
	playLogoSound();
	
	glDisable(GL_LIGHTING);
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	glOrtho(0.0, 800, 
			0.0, 600, -1.0, 1.0);
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();
	glColor3f(1.0,1.0,1.0);
	
	glBegin(GL_QUADS);
		glVertex2d(0, 0);
		glVertex2d(800, 0);
		glVertex2d(800, 600);
		glVertex2d(0, 600);
	glEnd();
	
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, bluepixyTex.texID);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	
	glPushMatrix();
	glTranslatef(130.0, 230.0, 0.0);
	
	glBegin(GL_QUADS);
		glTexCoord2f(0.0, 0.0);
		glVertex2d(0, 0);
		glTexCoord2f(1.0, 0.0);
		glVertex2d(512.0, 0);
		glTexCoord2f(1.0, 1.0);
		glVertex2d(512.0, 256.0);
		glTexCoord2f(0.0, 1.0);
		glVertex2d(0, 256.0);
	glEnd();
	glPopMatrix();
	
	
	glPopMatrix();
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	
	glFlush();
	//int swapInterval = 1;
	//CGLSetParameter(CGLGetCurrentContext(), kCGLCPSwapInterval, &swapInterval);
	SDL_GL_SwapBuffers();
	
	//glEnable(GL_TEXTURE_2D);
	
	x = 0.0;
	y = 0.0;
	
	x2 = 0.0;
	y2 = 0.0;
	
	cursorAngle = 0.0;
	
	shooting = crossing = false;
	
	oldTime = SDL_GetTicks();
	float introTime = 0.0;
	//font.BuildFont("font.tga");
	loadTactics();
	loadTeams();
	loadSounds();
	
	FILE *creditsFile = fopen("credits.txt", "r");
	
	if(!creditsFile)
		; // ERROR
	
	int i = 0;
	
	while(!feof(creditsFile) && i < 100)
	{
		if(fgets(credits[i], 126, creditsFile))
			i++;
	}
	
	creditsCount = i;
	
	fclose(creditsFile);
	
	
	shadowTex.LoadTexture("shadow.tga");
	screenTex.LoadTexture("menu/screen.tga");
	teamsTex.LoadTexture("menu/teams.tga");
	logoTex.LoadTexture("menu/logo.tga");
	circleTex.LoadTexture("menu/circle.tga");
	goalTex.LoadTexture("menu/goal.tga");
	winnerTex.LoadTexture("menu/winner.tga");
	extratimeTex.LoadTexture("menu/extratime.tga");
	gameoverTex.LoadTexture("menu/gameover.tga");
	vsTex.LoadTexture("menu/vs.tga");
	instructionsTex.LoadTexture("menu/instructions.tga");
	turboTex.LoadTexture("menu/turbo.tga");
	foulTex.LoadTexture("menu/foul.tga");
	pressanykeyTex.LoadTexture("menu/pressanykey.tga");
	selectteamTex.LoadTexture("menu/selectteam.tga");
	oneMinuteWarningTex.LoadTexture("menu/oneminutewarning.tga");
	back1Tex.LoadTexture("menu/back_1.tga");
	back2Tex.LoadTexture("menu/back_2.tga");
	pauseTex.LoadTexture("menu/pause.tga");
	areyousureTex.LoadTexture("menu/areyousure.tga");
	yesTex.LoadTexture("menu/yes.tga");
	yesHTex.LoadTexture("menu/yes_h.tga");
	noTex.LoadTexture("menu/no.tga");
	noHTex.LoadTexture("menu/no_h.tga");
	resumeTex.LoadTexture("menu/resume.tga");
	resumeHTex.LoadTexture("menu/resume_h.tga");
	mainmenuTex.LoadTexture("menu/mainmenu.tga");
	mainmenuHTex.LoadTexture("menu/mainmenu_h.tga");
	
	menuItem[0].LoadTexture("arcade.tga");
	menuItem[1].LoadTexture("controls.tga");
	menuItem[2].LoadTexture("credits.tga");
	menuItem[3].LoadTexture("quit.tga");
	
	menuItemH[0].LoadTexture("arcade_h.tga");
	menuItemH[1].LoadTexture("controls_h.tga");
	menuItemH[2].LoadTexture("credits_h.tga");
	menuItemH[3].LoadTexture("quit_h.tga");
	
	ground = new FSGround;
	ground->Load();
	
	ball = new FSBall;
	ball->Load();

	sdrand(SDL_GetTicks());
	//loadObj.ImportObj(&quickModel, "quick.obj");         // Load our .Obj file into our model structure
	
    // Since the .obj file format doesn't hold material information like color
    // and image files, we need to manually do that in code (or add it to the .obj file yourself).
    // I created a couple functions in the CLoadObj to help us do that.
	/*
    // Here we create a material with a name, a bitmap name and RGB values.
    // If we didn't want to create a texture map material but a color, just pass in NULL
    // for the file name field.  Also, by default the color is (255, 255, 255) if you choose
    // not to set it.  I did so just to show you how and not to confuse anyone.
	loadObj.AddMaterial(&quickModel, "Bone", NULL, 255, 255, 255);
	
    // With this function we can assign a particular model to a material ID.
    // This is so the object can have a color OR texture map.  
    // Here we pass in our model, the index into the object list, and the material ID.
    loadObj.SetObjectMaterial(&quickModel, 0, 0);
	
    // Here we go through all of the materials and check if we need to make a texture map.
    // We obviously know there is just one material but we should set this up for future use.
    for(int i = 0; i < quickModel.numOfMaterials; i++)
    {
        // Check if the current material has a file name
        if(strlen(quickModel.pMaterials[i].strFile) > 0) {
			
            // Create a texture map from the material's file name
            //CreateTexture(g_Texture, quickModel.pMaterials[i].strFile, i);
        }
        
        // Assign the material ID to the current material
        quickModel.pMaterials[i].texureId = i;
    }
	*/
	//quickModel[0] = new ModelType();
	quickModel[0].LoadObj("quick.obj", 400.0);
	quickModel[1].LoadObj("quick_walk1.obj", 400.0);
	quickModel[2].LoadObj("quick_walk2.obj", 400.0);
	quickModel[3].LoadObj("quick_tackle.obj", 400.0);
	quickModel[4].LoadObj("quick_fall.obj", 400.0);
	
	goalTwo.Load();
	goalOne.Load();
	
	teamOneCode = 0;
	teamTwoCode = 1;
	
	teamOne[0] = new FSPlayer(quickModel, FS_PLAYER_ONE, teams[teamOneCode].bodyColor, teams[teamOneCode].legsColor);
	teamOne[0]->Load();
	
	teamOne[1] = new FSPlayer(quickModel, FS_PLAYER_TWO, teams[teamOneCode].bodyColor, teams[teamOneCode].legsColor);
	teamOne[1]->Load();
	
	teamOne[2] = new FSPlayer(quickModel, FS_PLAYER_THREE, teams[teamOneCode].bodyColor, teams[teamOneCode].legsColor);
	teamOne[2]->Load();
	
	teamOne[3] = new FSPlayer(quickModel, FS_PLAYER_FOUR, teams[teamOneCode].bodyColor, teams[teamOneCode].legsColor);
	teamOne[3]->Load();
	
	teamOne[4] = new FSPlayer(quickModel, FS_PLAYER_FIVE, teams[teamOneCode].bodyColor, teams[teamOneCode].legsColor);
	teamOne[4]->Load();
	
	/*
	teamOne[0] = new FSPlayer(quickModel, FS_PLAYER_ONE, 3514.0, 300.0, -570.0);
	teamOne[0]->Load();
	
	teamOne[1] = new FSPlayer(quickModel, FS_PLAYER_TWO, 4590.0, 300.0, -1920.0);
	teamOne[1]->Load();
	
	teamOne[2] = new FSPlayer(quickModel, FS_PLAYER_THREE, 2248.0, 300.0, -3146.0);
	teamOne[2]->Load();
	
	teamOne[3] = new FSPlayer(quickModel, FS_PLAYER_FOUR, 4094.0, 300.0, -4534.0);
	teamOne[3]->Load();
	
	teamOne[4] = new FSPlayer(quickModel, FS_PLAYER_FIVE, 2094.0, 300.0, -4534.0);
	teamOne[4]->Load();
	*/
	currentOne = teamOne[1];
	
	//printf("%f, %f, %f\n", teams[teamTwoCode].bodyColor.r, teams[teamTwoCode].bodyColor.g, teams[teamTwoCode].bodyColor.b);
	teamTwo[0] = new FSPlayer(quickModel, FS_PLAYER_SIX, teams[teamTwoCode].bodyColor, teams[teamTwoCode].legsColor);
	teamTwo[0]->Load();
	
	teamTwo[1] = new FSPlayer(quickModel, FS_PLAYER_SEVEN, teams[teamTwoCode].bodyColor, teams[teamTwoCode].legsColor);
	teamTwo[1]->Load();
	
	teamTwo[2] = new FSPlayer(quickModel, FS_PLAYER_EIGHT, teams[teamTwoCode].bodyColor, teams[teamTwoCode].legsColor);
	teamTwo[2]->Load();
	
	teamTwo[3] = new FSPlayer(quickModel, FS_PLAYER_NINE, teams[teamTwoCode].bodyColor, teams[teamTwoCode].legsColor);
	teamTwo[3]->Load();
	
	teamTwo[4] = new FSPlayer(quickModel, FS_PLAYER_TEN, teams[teamTwoCode].bodyColor, teams[teamTwoCode].legsColor);
	teamTwo[4]->Load();
	/*
	teamTwo[0] = new FSPlayer(quickModel, FS_PLAYER_SIX, 3514.0, 300.0, -18500.0);
	teamTwo[0]->Load();
	
	teamTwo[1] = new FSPlayer(quickModel, FS_PLAYER_SEVEN, 4590.0, 300.0, -3920.0);
	teamTwo[1]->Load();
	
	teamTwo[2] = new FSPlayer(quickModel, FS_PLAYER_EIGHT, 2248.0, 300.0, -3146.0);
	teamTwo[2]->Load();
	
	teamTwo[3] = new FSPlayer(quickModel, FS_PLAYER_NINE, 4094.0, 300.0, -4534.0);
	teamTwo[3]->Load();
	
	teamTwo[4] = new FSPlayer(quickModel, FS_PLAYER_TEN, 2094.0, 300.0, -4534.0);
	teamTwo[4]->Load();*/
	
	currentTwo = teamTwo[1];
	
	/*
	 
	 x: 3514.000000, z: -570.000000
	 
	x: 4590.000000, z: -2920.000000
	 
	 x: 2248.000000, z: -3146.000000
	 
	 x: 3094.000000, z: -4534.000000
	 x: 3836.000000, z: -4748.000000
	*/
	
	
	/*cameraX = 500.0f;s
	cameraY = 150.0f;
	cameraZ = 200.0f;
	
	lookX = 500.0f;
	lookY = 0.0f;
	lookZ = -300.0;
	*/
	
	cameraX = 7000.0f;
	cameraY = 9000.0f;
	cameraZ = -2000.0f;
	
	lookX = 2500.0f;
	lookY = 0.0f;
	lookZ = -2000.0;
	
	while(introTime <= 4.0)
	{
		introTime += (FSTimePast() / 1000.0);
	}
}

void moveCamera(Uint32 deltaT)
{
	//if(ball->velocity.z == 0)
	//{
		if(cameraZ < (ball->position.z-200))
		{
			cameraZ += 2 * deltaT;
			lookZ += 2 * deltaT;
		}
		else if(cameraZ > (ball->position.z+200))
		{
			cameraZ -= 2 * deltaT;
			lookZ -= 2 * deltaT;
		}
	//}
	/*else
	{*/
		float time = deltaT / 1000.0f;
		cameraZ += ball->velocity.z * time + ball->acceleration.z * (time*time*0.5);
		lookZ += ball->velocity.z * time + ball->acceleration.z * (time*time*0.5);
	//}
	
	//if(ball->velocity.x == 0)
	//{
		if(cameraX < (ball->position.x+3700))
		{
			cameraX += 2 * deltaT;
			lookX += 2 * deltaT;
		}
		else if(cameraX > (ball->position.x+4000))
		{
			cameraX -= 2 * deltaT;
			lookX -= 2 * deltaT;
		}
	//}
	/*else
	{*/
		//float time = deltaT / 1000.0f;
		cameraX += ball->velocity.x * time + ball->acceleration.x * (time*time*0.5);
		lookX += ball->velocity.x * time + ball->acceleration.x * (time*time*0.5);
	//}
	
	/*
	if(ball->position.x > 3500 && cameraX < 9800)
	{
		cameraX += 2 * deltaT;//ball->position.x + 1000;
		lookX += 2 * deltaT;
	}
	else if(ball->position.x < 3500 && cameraX > 6000)
	{
		cameraX -= 2 * deltaT;//ball->position.x + 1000;
		lookX -= 2 * deltaT;
	}*/
	//lookX = ball->position.x;
	return;
}

void render() 
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);         
	glLoadIdentity();
	
	
	
	
	
	
	//gluLookAt(150.0, 150.0, 200.0, 150.0, 0.0, -300.0, 0.0, 1.0, 0.0);
	gluLookAt(cameraX, cameraY, cameraZ, lookX, lookY, lookZ, 0.0, 1.0, 0.0);
	
	// do physics/movement
	
	Uint32 deltaT = FSTimePast();
	
	if(deltaT >= 1000.0)
		deltaT = 1000.0;
	
	if(ball->takenBy != teamOne[0]->player || teamOne[0]->position.z < -2000.0)
		gameTime -= (deltaT / 1000.0);
	
	int factor1 = (uirand()%30)-(teams[teamOneCode].players[0].goalkeeping);
	int factor2 = (uirand()%30)-(teams[teamTwoCode].players[0].goalkeeping);
	
	if(teamOne[0]->player != currentOne->player)
		teamOne[0]->moveGoalKeeper(deltaT, ball, factor1);
	
	teamTwo[0]->moveGoalKeeper(deltaT, ball, factor2);
	
	for(int i = 0; i < 5; i++)
		teamOne[i]->move(deltaT, ground, ball);
	
	for(int i = 0; i < 5; i++)
		teamTwo[i]->move(deltaT, ground, ball);
	
	ball->move(deltaT, ground);
	
	moveCamera(deltaT);
	
	if(ball->takenBy != FS_NO_PLAYER && ball->takenBy != currentOne->player /*&& ball->takenBy != currentTwo->player*/)
	{
		for(int i = 0; i < 5; i++)
		{
			if(ball->takenBy == teamOne[i]->player)
			{
				currentOne->velocity = FSVector(0,0,0);
				currentOne->status = FS_WAIT;
				currentOne = teamOne[i];
				currentOne->status = FS_WAIT;
				currentOne->move(x, y, 1.0);
			}
			/*else if(ball->takenBy == teamTwo[i]->player)
			{
				currentTwo->velocity = FSVector(0,0,0);
				currentTwo->status = FS_WAIT;
				currentTwo = teamTwo[i];
				currentTwo->status = FS_WAIT;
				currentTwo->move(x2, y2, 1.0);
			}*/
		}
		/*
		if(ball->takenBy != currentTwo->player)
			for(int i = 0; i < 5; i++)
			{
				if(ball->takenBy == teamTwo[i]->player)
				{
					currentTwo->velocity = FSVector(0,0,0);
					currentTwo->status = FS_WAIT;
					currentTwo = teamTwo[i];
					currentTwo->status = FS_WAIT;
					currentTwo->move(x, y, 1.0);
				}
			}
		 */
	}
	
	runTactic();
			
	// draw objects
	ground->Draw();
	
	goalTwo.Draw();
	goalOne.Draw();
	
	
	glEnable(GL_TEXTURE_2D);
		  
	glBindTexture(GL_TEXTURE_2D, shadowTex.texID);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
	  

	glEnable(GL_BLEND);
	  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	  glColor4f(1.0, 1.0, 1.0, 1.0);
	  
	  for(int i = 0; i < 5; i++)
	  {
			  glPushMatrix();
			  glTranslatef(teamOne[i]->position.x-300.0, 0.0 ,teamOne[i]->position.z-300.0);
			  glBegin(GL_QUADS);
				glTexCoord2f(0.0, 1.0);
				glVertex3d(0.0, 0.0, 0.0);
				glTexCoord2f(1.0, 1.0);
				glVertex3d(500.0, 0.0, 0.0);
				glTexCoord2f(1.0, 0.0);
				glVertex3d(500.0, 0.0, 500.0);
				glTexCoord2f(0.0, 0.0);
				glVertex3d(0.0, 0.0, 500.0);
			  glEnd();
			  glPopMatrix();
		  
			  glPushMatrix();
			  glTranslatef(teamTwo[i]->position.x-300.0, 0.0 ,teamTwo[i]->position.z-300.0);
			  glBegin(GL_QUADS);
			  glTexCoord2f(0.0, 1.0);
			  glVertex3d(0.0, 0.0, 0.0);
			  glTexCoord2f(1.0, 1.0);
			  glVertex3d(500.0, 0.0, 0.0);
			  glTexCoord2f(1.0, 0.0);
			  glVertex3d(500.0, 0.0, 500.0);
			  glTexCoord2f(0.0, 0.0);
			  glVertex3d(0.0, 0.0, 500.0);
			  glEnd();
			  glPopMatrix();
	  }
		  glPushMatrix();
		  glTranslatef(ball->position.x-200.0, 0.0 ,ball->position.z-200.0);
		  glBegin(GL_QUADS);
		  glTexCoord2f(0.0, 1.0);
		  glVertex3d(0.0, 0.0, 0.0);
		  glTexCoord2f(1.0, 1.0);
		  glVertex3d(400.0, 0.0, 0.0);
		  glTexCoord2f(1.0, 0.0);
		  glVertex3d(400.0, 0.0, 400.0);
		  glTexCoord2f(0.0, 0.0);
		  glVertex3d(0.0, 0.0, 400.0);
		  glEnd();
		  glPopMatrix();
	glDisable(GL_BLEND);
	glDisable(GL_TEXTURE_2D);
		  
	
	struct
	{
		float x;
		short index;
	} xs[11], tmp;
	
	
	
	for(int i = 0; i < 5; i++)
	{
		xs[i].x = teamOne[i]->position.x;
		xs[i].index = i;
	}
	
	for(int i = 0; i < 5; i++)
	{
		int index = i + 5;
		xs[index].x = teamTwo[i]->position.x;
		xs[index].index = index;
	}
	
	xs[10].x = ball->position.x;
	xs[10].index = 10;
	
	for (int i = 0; i < 10; i++) 
	{
		for (int j = 0; j < 10-i; j++)
			if (xs[j+1].x < xs[j].x) 
			{
				tmp.x = xs[j].x;
				tmp.index = xs[j].index;
				xs[j].x = xs[j+1].x;
				xs[j].index = xs[j+1].index;
				xs[j+1].x = tmp.x;
				xs[j+1].index = tmp.index;
			}
	}

	glDisable(GL_LIGHTING);
	for(int i = 0; i < 11; i++)
	{
		if(xs[i].index < 5)
			teamOne[xs[i].index]->Draw();
		else if(xs[i].index < 10)
			teamTwo[(xs[i].index)-5]->Draw();
		else
			ball->Draw();
	}
	/*
	for(int i = 0; i < 5; i++)
	{
		if(teamOne[i]->player != ball->takenBy)
			teamOne[i]->Draw();
		else
			if(ball->position.x < teamOne[i]->position.x)
			{
				ball->Draw();
				teamOne[i]->Draw();
			}
			else
			{
				teamOne[i]->Draw();
				ball->Draw();
			}
	}
	
	for(int i = 0; i < 5; i++)
	{
		if(teamTwo[i]->player != ball->takenBy)
			teamTwo[i]->Draw();
		else
			if(ball->position.x < teamTwo[i]->position.x)
			{
				ball->Draw();
				teamTwo[i]->Draw();
			}
		else
		{
			teamTwo[i]->Draw();
			ball->Draw();
		}
	}
	
	if(ball->takenBy == FS_NO_PLAYER)
		ball->Draw();
	*/
	glColor3f(1.0f, 0.0, 0.0f);
	
	//drawstr(620, 570, "FPS: %f", 1.0 / (deltaT/1000.0));
	drawFlags();
	
	
	if(shooting || crossing)
	{
		loadTime += (deltaT/1000.0);
		
		if(loadTime >= 1)
		{
			float minDistance = 999999999.0;
			float minX = 0;
			float minZ = 0;
			
			if(shooting)
			{
				shooting = false;
				
				if(ball->takenBy == currentOne->player)
				{
					int x = 4000, z = -19000, goalIndex = 0;
					
					for(int i = 0; i < 3; i++)
					{
						float currentDistance = abs( (goalsOne[i][0] + 
													  (tan((currentOne->angle * 6.28) / 360) * 
													   (currentOne->position.z - goalsOne[i][1])) - currentOne->position.x) /
													 sqrt((1 + tan((currentOne->angle * 6.28) / 360))*(1 + tan((currentOne->angle * 6.28) / 360))));
						
						if(currentDistance < minDistance)
						{
							minDistance = currentDistance;
							goalIndex = i;
						}
					}
					
					goalIndex += modifier;
					
					if(goalIndex == -1)
						goalIndex = 0;
					else if(goalIndex == 3)
						goalIndex = 2;
					
					if(minDistance != 999999999.0) // no players
					{
						minDistance = 999999999.0;
						x = goalsOne[goalIndex][0];
						z = goalsOne[goalIndex][1];
					}
					
					currentOne->angle = (6.28 * atan( ( z - (currentOne->position.z)) / ( x - (currentOne->position.x))  )) / 360; // TO-DO: doesn't work
																																   //printf("angle: %d\n", (int)currentOne->angle);
					if(currentOne->position.z < z)
						currentOne->angle = 180 + currentOne->angle;
					
					ball->position = FSVector(currentOne->position.x + -(500 * sin((6.28*currentOne->angle)/360)), 100, currentOne->position.z + -(500 * cos((6.28*currentOne->angle)/360)));
					
					ball->velocity = ballVelocityToPoint( x, z, 2000 * (1+loadTime*1.5), 9000 * (1+loadTime)); // TO-DO: TEAM BASED
					ball->takenBy = FS_NO_PLAYER;
				}
				else if(AI)
				{
					runShootAI();
				}
				
			}
			else
			{
				crossing = false;
				
				if(ball->takenBy == currentOne->player)
				{
					int teamIndex = 1;
					int teamIndex2 = 1;
					float minDistance2 = 20000.0;
					int minX2 = 0;
					int minZ2 = 0;
					
					for(int i = 1; i < 5; i++)
					{
						if(teamOne[i]->player != currentOne->player)
						{
							if( (currentOne->angle == 0 && teamOne[i]->position.z < currentOne->position.z) ||
								(currentOne->angle == 180 && teamOne[i]->position.z > currentOne->position.z) ||
								(currentOne->angle == 90 && teamOne[i]->position.x < currentOne->position.x) ||
								(currentOne->angle == 270 && teamOne[i]->position.x > currentOne->position.x) ||
								(currentOne->angle == 45 && 
								 teamOne[i]->position.z < currentOne->position.z && teamOne[i]->position.x < currentOne->position.x) ||
								(currentOne->angle == 135 && 
								 teamOne[i]->position.z > currentOne->position.z && teamOne[i]->position.x < currentOne->position.x) ||
								(currentOne->angle == 225 && 
								 teamOne[i]->position.z > currentOne->position.z && teamOne[i]->position.x > currentOne->position.x) ||
								(currentOne->angle == 315 && 
								 teamOne[i]->position.z < currentOne->position.z && teamOne[i]->position.x > currentOne->position.x))
							{
								float currentDistance = abs( (teamOne[i]->position.x + 
															  (tan((currentOne->angle * 6.28) / 360) * 
															   (currentOne->position.z - teamOne[i]->position.z)) - currentOne->position.x) /
															 sqrt((1 + tan((currentOne->angle * 6.28) / 360))*(1 + tan((currentOne->angle * 6.28) / 360))));
								
								
								if(currentDistance < minDistance)
								{
									minDistance = currentDistance;
									minX = teamOne[i]->position.x;
									minZ = teamOne[i]->position.z;
									teamIndex = i;
								}
							}
						}
					}
					if(minDistance != 999999999.0) // no players
					{
						ball->velocity = ballVelocityToPoint( minX, minZ, 3000 * (1+loadTime), 2000 * (1+loadTime));
						ball->takenBy = FS_NO_PLAYER;
						minDistance = 999999999.0;
						currentOne->velocity = FSVector(0,0,0);
						currentOne = teamOne[teamIndex];
						currentOne->status = FS_WAIT;
						currentOne->move(x, y, 1.0);
					}
				}
				
			}
		}
		else if(loadTime >= 0.2 && ball->takenBy != currentOne->player && AI)
		{
			runShootAI();
		}
		
		drawBar();
		//drawstr(200, 100, "loading shoot: %f", loadTime);
	}
	
	glPushMatrix();
	glTranslatef(currentOne->position.x, 800.0, currentOne->position.z);
	glRotatef(180.0, 0.0, 0.0, 1.0);
	glColor3f(1.0, 1.0, 0.0);
	/*glRotatef(cursorAngle, 0.0, 1.0, 0.0);
	cursorAngle += 180.0 * (deltaT / 1000.0);
	if(cursorAngle >= 360.0)
		cursorAngle = 0.0;*/
	
	glBegin(GL_TRIANGLES);                                  // Start Drawing The Pyramid

		glVertex3f( 0.0f, 100.0f, 0.0f);                  // Top Of Triangle (Front)
		glVertex3f(-100.0f,-100.0f, 100.0f);                  // Left Of Triangle (Front)
		glVertex3f( 100.0f,-100.0f, 100.0f);                  // Right Of Triangle (Front)

		glVertex3f( 0.0f, 100.0f, 0.0f);                  // Top Of Triangle (Right)
		glVertex3f( 100.0f,-100.0f, 100.0f);                  // Left Of Triangle (Right)
		glVertex3f( 100.0f,-100.0f, -100.0f);                 // Right Of Triangle (Right)
		
		glVertex3f( 0.0f, 100.0f, 0.0f);                  // Top Of Triangle (Back)
		glVertex3f( 100.0f,-100.0f, -100.0f);                 // Left Of Triangle (Back)
		glVertex3f(-100.0f,-100.0f, -100.0f);                 // Right Of Triangle (Back)
				
		glVertex3f( 0.0f, 100.0f, 0.0f);                  // Top Of Triangle (Left)
		glVertex3f(-100.0f,-100.0f,-100.0f);                  // Left Of Triangle (Left)
		glVertex3f(-100.0f,-100.0f, 100.0f);                  // Right Of Triangle (Left)
	
	glEnd();
	glPopMatrix();
	
	if(!AI)
	{
		glPushMatrix();
		glTranslatef(currentTwo->position.x, 800.0, currentTwo->position.z);
		glRotatef(180.0, 0.0, 0.0, 1.0);
		glColor3f(0.0, 1.0, 1.0);
		/*glRotatef(cursorAngle, 0.0, 1.0, 0.0);
		cursorAngle += 180.0 * (deltaT / 1000.0);
		if(cursorAngle >= 360.0)
			cursorAngle = 0.0;*/
		
		glBegin(GL_TRIANGLES);                                  // Start Drawing The Pyramid
		
			glVertex3f( 0.0f, 100.0f, 0.0f);                  // Top Of Triangle (Front)
			glVertex3f(-100.0f,-100.0f, 100.0f);                  // Left Of Triangle (Front)
			glVertex3f( 100.0f,-100.0f, 100.0f);                  // Right Of Triangle (Front)
			
			glVertex3f( 0.0f, 100.0f, 0.0f);                  // Top Of Triangle (Right)
			glVertex3f( 100.0f,-100.0f, 100.0f);                  // Left Of Triangle (Right)
			glVertex3f( 100.0f,-100.0f, -100.0f);                 // Right Of Triangle (Right)
			
			glVertex3f( 0.0f, 100.0f, 0.0f);                  // Top Of Triangle (Back)
			glVertex3f( 100.0f,-100.0f, -100.0f);                 // Left Of Triangle (Back)
			glVertex3f(-100.0f,-100.0f, -100.0f);                 // Right Of Triangle (Back)
						
			glVertex3f( 0.0f, 100.0f, 0.0f);                  // Top Of Triangle (Left)
			glVertex3f(-100.0f,-100.0f,-100.0f);                  // Left Of Triangle (Left)
			glVertex3f(-100.0f,-100.0f, 100.0f);                  // Right Of Triangle (Left)
		
		glEnd();
		glPopMatrix();
	}
	
	
	
	if(gameTime <= 60.0 && oneMinuteWarningTime == -1.0)
	{
		oneMinuteWarningTime = 3.0;
		playSirenSound();
		//stopMusicOne();
		setMusic(FS_MUSIC_ONE_FAST);
		//playMusicOne();
	}
	
	if(!isPlayingMusicOne())
	{
		stopMusicOne();
		playMusicOne();
	}
	
	if(oneMinuteWarningTime >= 0.0)
	{
		//printf("omw: %f\n", oneMinuteWarningTime);
		drawOneMinuteWarning();
		oneMinuteWarningTime -= (deltaT / 1000.0);
	}
	else if(oneMinuteWarningTime > -1.0)
	{
		oneMinuteWarningTime = -2.0;
	}
	
	if(beginningMatch)
	{
		beginningMatch = false;
		
		drawIntro();
		
		
		glFlush();
		//int swapInterval = 1;
		//CGLSetParameter(CGLGetCurrentContext(), kCGLCPSwapInterval, &swapInterval);
		SDL_GL_SwapBuffers();
	}
	
	//font.PrintText(50, 50, 0, "FPSs.,kf;lksod;kds;ksd;okfs");
	/*
	if(ball->position.z < -5500 && ball->position.z > -7500)
	{
		if(teamOne[1] != currentOne)
		{
			if(teamOne[1]->position.z < -7350  && teamOne[1]->position.z > -7450 &&
				teamOne[1]->position.x < -5350  && teamOne[1]->position.x > 5250)
				teamOne[1]->velocity = FSVector(0,0,0);
			else
				teamOne[1]->moveToPoint(5282, -7400);
		}
			
		if(teamOne[2] != currentOne)
		{
			if(teamOne[2]->position.z < -8150  && teamOne[2]->position.z > -8250 &&
			   teamOne[2]->position.x < 1550  && teamOne[2]->position.x > 1450)
				teamOne[2]->velocity = FSVector(0,0,0);
			else
				teamOne[2]->moveToPoint(1500, -8300);
		}
		
		if(teamOne[3] != currentOne)
		{
			if(teamOne[3]->position.z < -5950 && teamOne[3]->position.z > -6050 &&
			   teamOne[3]->position.x < 3250  && teamOne[3]->position.x > 3150)
				teamOne[3]->velocity = FSVector(0,0,0);
			else
				teamOne[3]->moveToPoint(3200, -6000);
		}
	
	}
	else if(ball->position.z <= -7500)
	{
		if(teamOne[1] != currentOne && (ball->position.x > 6000 || ball->position.x < 2000))
		{
			if(teamOne[1]->position.z < -7950  && teamOne[1]->position.z > -8050 &&
			   teamOne[1]->position.x < 3750  && teamOne[1]->position.x > 3650)
				teamOne[1]->velocity = FSVector(0,0,0);
			else
				teamOne[1]->moveToPoint(3700, -8000);
		}
		
		if(teamOne[2] != currentOne && (ball->position.x > 6000 || ball->position.x < 2000))
		{
			if(teamOne[2]->position.z < -7650  && teamOne[2]->position.z > -7750 &&
			   teamOne[2]->position.x < 2950  && teamOne[2]->position.x > 2850)
				teamOne[2]->velocity = FSVector(0,0,0);
			else
				teamOne[2]->moveToPoint(2900, -7700);
		}
		
		if(teamOne[3] != currentOne)
		{
			if(teamOne[3]->position.z < -6550 && teamOne[3]->position.z > -6650 &&
			   teamOne[3]->position.x < 3350  && teamOne[3]->position.x > 3250)
				teamOne[3]->velocity = FSVector(0,0,0);
			else
				teamOne[3]->moveToPoint(3300, -6600);
		}
		
	}
	*/
	glFlush();
	
	//int swapInterval = 1;
	//CGLSetParameter(CGLGetCurrentContext(), kCGLCPSwapInterval, &swapInterval);
	SDL_GL_SwapBuffers();
}

void CleanUp()
{
	if(audio)
	{
		unloadSounds();
		/*if(logoSound)
		{
			Mix_FreeChunk(logoSound);
			logoSound = NULL;
		}
		
		Mix_CloseAudio();*/
	}
	
	SDL_ShowCursor(SDL_ENABLE);
	
	ground->Unload();
	delete ground;
	ground = NULL;
	
	ball->Unload();
	delete ball;
	ball = NULL;
	
	for(int i = 0; i < 4; i++)
	{
		teamOne[i]->Unload();
		delete teamOne[i];
		teamOne[i] = NULL;
	}
	
	quickModel[0].DeleteModel();
	
	goalTwo.Unload();
	goalOne.Unload();
}


FSVector ballVelocityToPoint(int x, int z, int h, int speed)
{
	float deltaZPerDeltaX = ( z - (ball->position.z)) / ( x - (ball->position.x));
	
	float theX = (cos (atan(  deltaZPerDeltaX  ))  ) * speed;
	
	if(ball->position.x > x)
		theX = -theX;
	
	float theZ = (sin (atan( -abs( deltaZPerDeltaX  )))  ) * speed;
	
	if(ball->position.z < z)
		theZ = -theZ;
	
	return FSVector( theX, h, theZ);
}

float distanceBetweenPoints(float x1, float y1, float x2, float y2)
{
	return sqrt( ((y2 - y1) * (y2 - y1)) + ((x2 - x1) * (x2 - x1)) );
}

void oneScored()
{
	SDL_Event event;
	
	for(int i = 0; i < 5; i++)
	{
		teamOne[i]->velocity = FSVector(0.0, 0.0, 0.0);
		teamOne[i]->jump();
		
		teamTwo[i]->velocity = FSVector(0.0, 0.0, 0.0);
	}
	
	scoreOne++;
	
	pauseMusicOne();
	playGoalSound();
	
	float time = 0.0;
	
	while(time < 3.0)
	{
		
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);         
		glLoadIdentity();

		gluLookAt(cameraX, cameraY, cameraZ, lookX, lookY, lookZ, 0.0, 1.0, 0.0);
		
		
		for(int i = 0; i < 5; i++)
		{
			if(teamOne[i]->velocity.y == 0.0);
				teamOne[i]->jump();
		}
		
		float deltaT = FSTimePast();
		
		time += deltaT / 1000.0;
		
		for(int i = 0; i < 5; i++)
			teamOne[i]->move(deltaT, ground, ball);
		
		for(int i = 0; i < 5; i++)
			teamTwo[i]->move(deltaT, ground, ball);
		
		ball->move(deltaT, ground);
		
		moveCamera(deltaT);
		
		ground->Draw();
		
		goalTwo.Draw();
		goalOne.Draw();
		
		
		glEnable(GL_TEXTURE_2D);
		
		glBindTexture(GL_TEXTURE_2D, shadowTex.texID);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
		
		
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glColor4f(1.0, 1.0, 1.0, 1.0);
		
		for(int i = 0; i < 5; i++)
		{
			glPushMatrix();
			glTranslatef(teamOne[i]->position.x-300.0, 0.0 ,teamOne[i]->position.z-300.0);
			glBegin(GL_QUADS);
			glTexCoord2f(0.0, 1.0);
			glVertex3d(0.0, 0.0, 0.0);
			glTexCoord2f(1.0, 1.0);
			glVertex3d(500.0, 0.0, 0.0);
			glTexCoord2f(1.0, 0.0);
			glVertex3d(500.0, 0.0, 500.0);
			glTexCoord2f(0.0, 0.0);
			glVertex3d(0.0, 0.0, 500.0);
			glEnd();
			glPopMatrix();
			
			glPushMatrix();
			glTranslatef(teamTwo[i]->position.x-300.0, 0.0 ,teamTwo[i]->position.z-300.0);
			glBegin(GL_QUADS);
			glTexCoord2f(0.0, 1.0);
			glVertex3d(0.0, 0.0, 0.0);
			glTexCoord2f(1.0, 1.0);
			glVertex3d(500.0, 0.0, 0.0);
			glTexCoord2f(1.0, 0.0);
			glVertex3d(500.0, 0.0, 500.0);
			glTexCoord2f(0.0, 0.0);
			glVertex3d(0.0, 0.0, 500.0);
			glEnd();
			glPopMatrix();
		}
		glPushMatrix();
		glTranslatef(ball->position.x-200.0, 0.0 ,ball->position.z-200.0);
		glBegin(GL_QUADS);
		glTexCoord2f(0.0, 1.0);
		glVertex3d(0.0, 0.0, 0.0);
		glTexCoord2f(1.0, 1.0);
		glVertex3d(400.0, 0.0, 0.0);
		glTexCoord2f(1.0, 0.0);
		glVertex3d(400.0, 0.0, 400.0);
		glTexCoord2f(0.0, 0.0);
		glVertex3d(0.0, 0.0, 400.0);
		glEnd();
		glPopMatrix();
		glDisable(GL_BLEND);
		glDisable(GL_TEXTURE_2D);
		
		struct
		{
			float x;
			short index;
		} xs[11], tmp;
		
		
		
		for(int i = 0; i < 5; i++)
		{
			xs[i].x = teamOne[i]->position.x;
			xs[i].index = i;
		}
		
		for(int i = 0; i < 5; i++)
		{
			int index = i + 5;
			xs[index].x = teamTwo[i]->position.x;
			xs[index].index = index;
		}
		
		xs[10].x = ball->position.x;
		xs[10].index = 10;
		
		for (int i = 0; i < 10; i++) 
		{
			for (int j = 0; j < 10-i; j++)
				if (xs[j+1].x < xs[j].x) 
				{
					tmp.x = xs[j].x;
					tmp.index = xs[j].index;
					xs[j].x = xs[j+1].x;
					xs[j].index = xs[j+1].index;
					xs[j+1].x = tmp.x;
					xs[j+1].index = tmp.index;
				}
		}
			
		glDisable(GL_LIGHTING);
		for(int i = 0; i < 11; i++)
		{
			if(xs[i].index < 5)
				teamOne[xs[i].index]->Draw();
			else if(xs[i].index < 10)
				teamTwo[(xs[i].index)-5]->Draw();
			else
				ball->Draw();
		}
		
		glColor3f(1.0f, 0.0, 0.0f);
		
		//drawstr(620, 570, "FPS: %f", 1.0 / (deltaT/1000.0));
		drawFlags();
		drawGoal();
		
		
		glFlush();
		
		//int swapInterval = 1;
		//CGLSetParameter(CGLGetCurrentContext(), kCGLCPSwapInterval, &swapInterval);
		SDL_GL_SwapBuffers();
		
		
		while( SDL_PollEvent(& event) )
		{
			switch ( event.type )
			{  
				case SDL_KEYDOWN:
					
					switch(event.key.keysym.sym)
					{
						case SDLK_q:
							if(event.key.keysym.mod & KMOD_META)
							{
								CleanUp();
								exit(0);
							}
							break;
							
						case SDLK_RIGHT:
							x = 1.0;
							rightPressed = true;
							break;
							
						case SDLK_LEFT:
							x = -1.0;
							leftPressed = true;
							break;
							
						case SDLK_UP:
							y = 1.0;
							upPressed = true;
							break;
							
						case SDLK_DOWN:
							y = -1.0;
							downPressed = true;
							break;
					}
					
					break;
					
				case SDL_KEYUP:
					
					switch(event.key.keysym.sym)
					{
						case SDLK_RIGHT:
							rightPressed = false;
							if(leftPressed)
								x = -1.0;
							else
								x = 0.0;
							break;
							
						case SDLK_LEFT:
							leftPressed = false;
							if(rightPressed)
								x = 1.0;
							else
								x = 0.0;
							break;
							
						case SDLK_UP:
							upPressed = false;
							if(downPressed)
								y = -1.0;
							else
								y = 0.0;
							break;
							
						case SDLK_DOWN:
							downPressed = false;
							if(upPressed)
								y = 1.0;
							else
								y = 0.0;
							
							break;	
					}
					
					break;
			}
		}
		
	}
	
	kickOff(FS_TWO);
	mainLoop();
}

void twoScored()
{
	SDL_Event event;
	
	for(int i = 0; i < 5; i++)
	{
		teamTwo[i]->velocity = FSVector(0.0, 0.0, 0.0);
		teamTwo[i]->jump();
		
		teamOne[i]->velocity = FSVector(0.0, 0.0, 0.0);
	}
	
	scoreTwo++;
	
	pauseMusicOne();
	playGoalSound();
	
	float time = 0.0;
	
	while(time < 3.0)
	{
		
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);         
		glLoadIdentity();
		
		gluLookAt(cameraX, cameraY, cameraZ, lookX, lookY, lookZ, 0.0, 1.0, 0.0);
		
		
		for(int i = 0; i < 5; i++)
		{
			if(teamTwo[i]->velocity.y == 0.0);
				teamTwo[i]->jump();
		}
		
		float deltaT = FSTimePast();
		
		time += deltaT / 1000.0;
		
		for(int i = 0; i < 5; i++)
			teamOne[i]->move(deltaT, ground, ball);
		
		for(int i = 0; i < 5; i++)
			teamTwo[i]->move(deltaT, ground, ball);
		
		ball->move(deltaT, ground);
		
		moveCamera(deltaT);
		
		ground->Draw();
		
		goalTwo.Draw();
		goalOne.Draw();
		
		
		
		glEnable(GL_TEXTURE_2D);
		
		glBindTexture(GL_TEXTURE_2D, shadowTex.texID);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
		
		
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glColor4f(1.0, 1.0, 1.0, 1.0);
		
		for(int i = 0; i < 5; i++)
		{
			glPushMatrix();
			glTranslatef(teamOne[i]->position.x-300.0, 0.0 ,teamOne[i]->position.z-300.0);
			glBegin(GL_QUADS);
			glTexCoord2f(0.0, 1.0);
			glVertex3d(0.0, 0.0, 0.0);
			glTexCoord2f(1.0, 1.0);
			glVertex3d(500.0, 0.0, 0.0);
			glTexCoord2f(1.0, 0.0);
			glVertex3d(500.0, 0.0, 500.0);
			glTexCoord2f(0.0, 0.0);
			glVertex3d(0.0, 0.0, 500.0);
			glEnd();
			glPopMatrix();
			
			glPushMatrix();
			glTranslatef(teamTwo[i]->position.x-300.0, 0.0 ,teamTwo[i]->position.z-300.0);
			glBegin(GL_QUADS);
			glTexCoord2f(0.0, 1.0);
			glVertex3d(0.0, 0.0, 0.0);
			glTexCoord2f(1.0, 1.0);
			glVertex3d(500.0, 0.0, 0.0);
			glTexCoord2f(1.0, 0.0);
			glVertex3d(500.0, 0.0, 500.0);
			glTexCoord2f(0.0, 0.0);
			glVertex3d(0.0, 0.0, 500.0);
			glEnd();
			glPopMatrix();
		}
		glPushMatrix();
		glTranslatef(ball->position.x-200.0, 0.0 ,ball->position.z-200.0);
		glBegin(GL_QUADS);
		glTexCoord2f(0.0, 1.0);
		glVertex3d(0.0, 0.0, 0.0);
		glTexCoord2f(1.0, 1.0);
		glVertex3d(400.0, 0.0, 0.0);
		glTexCoord2f(1.0, 0.0);
		glVertex3d(400.0, 0.0, 400.0);
		glTexCoord2f(0.0, 0.0);
		glVertex3d(0.0, 0.0, 400.0);
		glEnd();
		glPopMatrix();
		glDisable(GL_BLEND);
		glDisable(GL_TEXTURE_2D);
		
		
		struct
		{
			float x;
			short index;
		} xs[11], tmp;
		
		
		
		for(int i = 0; i < 5; i++)
		{
			xs[i].x = teamOne[i]->position.x;
			xs[i].index = i;
		}
		
		for(int i = 0; i < 5; i++)
		{
			int index = i + 5;
			xs[index].x = teamTwo[i]->position.x;
			xs[index].index = index;
		}
		
		xs[10].x = ball->position.x;
		xs[10].index = 10;
		
		for (int i = 0; i < 10; i++) 
		{
			for (int j = 0; j < 10-i; j++)
				if (xs[j+1].x < xs[j].x) 
				{
					tmp.x = xs[j].x;
					tmp.index = xs[j].index;
					xs[j].x = xs[j+1].x;
					xs[j].index = xs[j+1].index;
					xs[j+1].x = tmp.x;
					xs[j+1].index = tmp.index;
				}
		}
			
		glDisable(GL_LIGHTING);
		for(int i = 0; i < 11; i++)
		{
			if(xs[i].index < 5)
				teamOne[xs[i].index]->Draw();
			else if(xs[i].index < 10)
				teamTwo[(xs[i].index)-5]->Draw();
			else
				ball->Draw();
		}
		
		glColor3f(1.0f, 0.0, 0.0f);
		
		//drawstr(620, 570, "FPS: %f", 1.0 / (deltaT/1000.0));
		drawFlags();
		drawGoal();
		
		
		glFlush();
		
		//int swapInterval = 1;
		//CGLSetParameter(CGLGetCurrentContext(), kCGLCPSwapInterval, &swapInterval);
		SDL_GL_SwapBuffers();
		
		while( SDL_PollEvent(& event) )
		{
			switch ( event.type )
			{  
				case SDL_KEYDOWN:
					
					switch(event.key.keysym.sym)
					{
						case SDLK_q:
							if(event.key.keysym.mod & KMOD_META)
							{
								CleanUp();
								exit(0);
							}
							break;
							
						case SDLK_RIGHT:
							x = 1.0;
							rightPressed = true;
							break;
							
						case SDLK_LEFT:
							x = -1.0;
							leftPressed = true;
							break;
							
						case SDLK_UP:
							y = 1.0;
							upPressed = true;
							break;
							
						case SDLK_DOWN:
							y = -1.0;
							downPressed = true;
							break;
					}
					
					break;
					
				case SDL_KEYUP:
					
					switch(event.key.keysym.sym)
					{
						case SDLK_RIGHT:
							rightPressed = false;
							if(leftPressed)
								x = -1.0;
							else
								x = 0.0;
							break;
							
						case SDLK_LEFT:
							leftPressed = false;
							if(rightPressed)
								x = 1.0;
							else
								x = 0.0;
							break;
							
						case SDLK_UP:
							upPressed = false;
							if(downPressed)
								y = -1.0;
							else
								y = 0.0;
							break;
							
						case SDLK_DOWN:
							downPressed = false;
							if(upPressed)
								y = 1.0;
							else
								y = 0.0;
							
							break;	
					}
					
					break;
			}
		}
	}
	
	kickOff(FS_ONE);
	mainLoop();	
}

void oneWins()
{
	SDL_Event event;
	
	for(int i = 0; i < 5; i++)
	{
		teamOne[i]->velocity = FSVector(0.0, 0.0, 0.0);
		teamOne[i]->jump();
		
		teamTwo[i]->velocity = FSVector(0.0, 0.0, 0.0);
	}
	
	stopMusicOne();
	playWinSound();
	
	float time = 0.0;
	
	while(time < 3.0)
	{
		
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);         
		glLoadIdentity();
		
		gluLookAt(cameraX, cameraY, cameraZ, lookX, lookY, lookZ, 0.0, 1.0, 0.0);
		
		
		for(int i = 0; i < 5; i++)
		{
			if(teamOne[i]->velocity.y == 0.0);
			teamOne[i]->jump();
		}
		
		float deltaT = FSTimePast();
		
		time += deltaT / 1000.0;
		
		for(int i = 0; i < 5; i++)
			teamOne[i]->move(deltaT, ground, ball);
		
		for(int i = 0; i < 5; i++)
			teamTwo[i]->move(deltaT, ground, ball);
		
		ball->move(deltaT, ground);
		
		moveCamera(deltaT);
		
		ground->Draw();
		
		goalTwo.Draw();
		goalOne.Draw();
		
		glEnable(GL_TEXTURE_2D);
		
		glBindTexture(GL_TEXTURE_2D, shadowTex.texID);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
		
		
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glColor4f(1.0, 1.0, 1.0, 1.0);
		
		for(int i = 0; i < 5; i++)
		{
			glPushMatrix();
			glTranslatef(teamOne[i]->position.x-300.0, 0.0 ,teamOne[i]->position.z-300.0);
			glBegin(GL_QUADS);
			glTexCoord2f(0.0, 1.0);
			glVertex3d(0.0, 0.0, 0.0);
			glTexCoord2f(1.0, 1.0);
			glVertex3d(500.0, 0.0, 0.0);
			glTexCoord2f(1.0, 0.0);
			glVertex3d(500.0, 0.0, 500.0);
			glTexCoord2f(0.0, 0.0);
			glVertex3d(0.0, 0.0, 500.0);
			glEnd();
			glPopMatrix();
			
			glPushMatrix();
			glTranslatef(teamTwo[i]->position.x-300.0, 0.0 ,teamTwo[i]->position.z-300.0);
			glBegin(GL_QUADS);
			glTexCoord2f(0.0, 1.0);
			glVertex3d(0.0, 0.0, 0.0);
			glTexCoord2f(1.0, 1.0);
			glVertex3d(500.0, 0.0, 0.0);
			glTexCoord2f(1.0, 0.0);
			glVertex3d(500.0, 0.0, 500.0);
			glTexCoord2f(0.0, 0.0);
			glVertex3d(0.0, 0.0, 500.0);
			glEnd();
			glPopMatrix();
		}
		glPushMatrix();
		glTranslatef(ball->position.x-200.0, 0.0 ,ball->position.z-200.0);
		glBegin(GL_QUADS);
		glTexCoord2f(0.0, 1.0);
		glVertex3d(0.0, 0.0, 0.0);
		glTexCoord2f(1.0, 1.0);
		glVertex3d(400.0, 0.0, 0.0);
		glTexCoord2f(1.0, 0.0);
		glVertex3d(400.0, 0.0, 400.0);
		glTexCoord2f(0.0, 0.0);
		glVertex3d(0.0, 0.0, 400.0);
		glEnd();
		glPopMatrix();
		glDisable(GL_BLEND);
		glDisable(GL_TEXTURE_2D);
		
		
		struct
		{
			float x;
			short index;
		} xs[11], tmp;
		
		
		
		for(int i = 0; i < 5; i++)
		{
			xs[i].x = teamOne[i]->position.x;
			xs[i].index = i;
		}
		
		for(int i = 0; i < 5; i++)
		{
			int index = i + 5;
			xs[index].x = teamTwo[i]->position.x;
			xs[index].index = index;
		}
		
		xs[10].x = ball->position.x;
		xs[10].index = 10;
		
		for (int i = 0; i < 10; i++) 
		{
			for (int j = 0; j < 10-i; j++)
				if (xs[j+1].x < xs[j].x) 
				{
					tmp.x = xs[j].x;
					tmp.index = xs[j].index;
					xs[j].x = xs[j+1].x;
					xs[j].index = xs[j+1].index;
					xs[j+1].x = tmp.x;
					xs[j+1].index = tmp.index;
				}
		}
			
		glDisable(GL_LIGHTING);
		for(int i = 0; i < 11; i++)
		{
			if(xs[i].index < 5)
				teamOne[xs[i].index]->Draw();
			else if(xs[i].index < 10)
				teamTwo[(xs[i].index)-5]->Draw();
			else
				ball->Draw();
		}
		
		
		glColor3f(1.0f, 0.0, 0.0f);
		
		//drawstr(620, 570, "FPS: %f", 1.0 / (deltaT/1000.0));
		drawFlags();
		
		drawWinner();
		
		
		glFlush();
		
		//int swapInterval = 1;
		//CGLSetParameter(CGLGetCurrentContext(), kCGLCPSwapInterval, &swapInterval);
		SDL_GL_SwapBuffers();
		
		while( SDL_PollEvent(& event) )
		{
			switch ( event.type )
			{  
				case SDL_KEYDOWN:
					
					switch(event.key.keysym.sym)
					{
						case SDLK_q:
							if(event.key.keysym.mod & KMOD_META)
							{
								CleanUp();
								exit(0);
							}
							break;
							
						case SDLK_RIGHT:
							x = 1.0;
							rightPressed = true;
							break;
							
						case SDLK_LEFT:
							x = -1.0;
							leftPressed = true;
							break;
							
						case SDLK_UP:
							y = 1.0;
							upPressed = true;
							break;
							
						case SDLK_DOWN:
							y = -1.0;
							downPressed = true;
							break;
					}
					
					break;
					
				case SDL_KEYUP:
					
					switch(event.key.keysym.sym)
					{
						case SDLK_RIGHT:
							rightPressed = false;
							if(leftPressed)
								x = -1.0;
							else
								x = 0.0;
							break;
							
						case SDLK_LEFT:
							leftPressed = false;
							if(rightPressed)
								x = 1.0;
							else
								x = 0.0;
							break;
							
						case SDLK_UP:
							upPressed = false;
							if(downPressed)
								y = -1.0;
							else
								y = 0.0;
							break;
							
						case SDLK_DOWN:
							downPressed = false;
							if(upPressed)
								y = 1.0;
							else
								y = 0.0;
							
							break;	
					}
					
					break;
			}
		}
	}
}

void twoWins()
{
	SDL_Event event;
	
	for(int i = 0; i < 5; i++)
	{
		teamTwo[i]->velocity = FSVector(0.0, 0.0, 0.0);
		teamTwo[i]->jump();
		
		teamOne[i]->velocity = FSVector(0.0, 0.0, 0.0);
	}
	
	stopMusicOne();
	playEndSound();
	
	float time = 0.0;
	
	while(time < 3.0)
	{
		
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);         
		glLoadIdentity();
		
		gluLookAt(cameraX, cameraY, cameraZ, lookX, lookY, lookZ, 0.0, 1.0, 0.0);
		
		
		for(int i = 0; i < 5; i++)
		{
			if(teamTwo[i]->velocity.y == 0.0);
				teamTwo[i]->jump();
		}
		
		float deltaT = FSTimePast();
		
		time += deltaT / 1000.0;
		
		for(int i = 0; i < 5; i++)
			teamOne[i]->move(deltaT, ground, ball);
		
		for(int i = 0; i < 5; i++)
			teamTwo[i]->move(deltaT, ground, ball);
		
		ball->move(deltaT, ground);
		
		moveCamera(deltaT);
		
		ground->Draw();
		
		goalTwo.Draw();
		goalOne.Draw();
		
		
		glEnable(GL_TEXTURE_2D);
		
		glBindTexture(GL_TEXTURE_2D, shadowTex.texID);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
		
		
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glColor4f(1.0, 1.0, 1.0, 1.0);
		
		for(int i = 0; i < 5; i++)
		{
			glPushMatrix();
			glTranslatef(teamOne[i]->position.x-300.0, 0.0 ,teamOne[i]->position.z-300.0);
			glBegin(GL_QUADS);
			glTexCoord2f(0.0, 1.0);
			glVertex3d(0.0, 0.0, 0.0);
			glTexCoord2f(1.0, 1.0);
			glVertex3d(500.0, 0.0, 0.0);
			glTexCoord2f(1.0, 0.0);
			glVertex3d(500.0, 0.0, 500.0);
			glTexCoord2f(0.0, 0.0);
			glVertex3d(0.0, 0.0, 500.0);
			glEnd();
			glPopMatrix();
			
			glPushMatrix();
			glTranslatef(teamTwo[i]->position.x-300.0, 0.0 ,teamTwo[i]->position.z-300.0);
			glBegin(GL_QUADS);
			glTexCoord2f(0.0, 1.0);
			glVertex3d(0.0, 0.0, 0.0);
			glTexCoord2f(1.0, 1.0);
			glVertex3d(500.0, 0.0, 0.0);
			glTexCoord2f(1.0, 0.0);
			glVertex3d(500.0, 0.0, 500.0);
			glTexCoord2f(0.0, 0.0);
			glVertex3d(0.0, 0.0, 500.0);
			glEnd();
			glPopMatrix();
		}
		glPushMatrix();
		glTranslatef(ball->position.x-200.0, 0.0 ,ball->position.z-200.0);
		glBegin(GL_QUADS);
		glTexCoord2f(0.0, 1.0);
		glVertex3d(0.0, 0.0, 0.0);
		glTexCoord2f(1.0, 1.0);
		glVertex3d(400.0, 0.0, 0.0);
		glTexCoord2f(1.0, 0.0);
		glVertex3d(400.0, 0.0, 400.0);
		glTexCoord2f(0.0, 0.0);
		glVertex3d(0.0, 0.0, 400.0);
		glEnd();
		glPopMatrix();
		glDisable(GL_BLEND);
		glDisable(GL_TEXTURE_2D);
		
		struct
		{
			float x;
			short index;
		} xs[11], tmp;
		
		
		
		for(int i = 0; i < 5; i++)
		{
			xs[i].x = teamOne[i]->position.x;
			xs[i].index = i;
		}
		
		for(int i = 0; i < 5; i++)
		{
			int index = i + 5;
			xs[index].x = teamTwo[i]->position.x;
			xs[index].index = index;
		}
		
		xs[10].x = ball->position.x;
		xs[10].index = 10;
		
		for (int i = 0; i < 10; i++) 
		{
			for (int j = 0; j < 10-i; j++)
				if (xs[j+1].x < xs[j].x) 
				{
					tmp.x = xs[j].x;
					tmp.index = xs[j].index;
					xs[j].x = xs[j+1].x;
					xs[j].index = xs[j+1].index;
					xs[j+1].x = tmp.x;
					xs[j+1].index = tmp.index;
				}
		}
			
		glDisable(GL_LIGHTING);
		for(int i = 0; i < 11; i++)
		{
			if(xs[i].index < 5)
				teamOne[xs[i].index]->Draw();
			else if(xs[i].index < 10)
				teamTwo[(xs[i].index)-5]->Draw();
			else
				ball->Draw();
		}
			
		glColor3f(1.0f, 0.0, 0.0f);
		
		//drawstr(620, 570, "FPS: %f", 1.0 / (deltaT/1000.0));
		drawFlags();
		
		drawGameover();
		
		glFlush();
		
		//int swapInterval = 1;
		//CGLSetParameter(CGLGetCurrentContext(), kCGLCPSwapInterval, &swapInterval);
		SDL_GL_SwapBuffers();
		
		while( SDL_PollEvent(& event) )
		{
			switch ( event.type )
			{  
				case SDL_KEYDOWN:
					
					switch(event.key.keysym.sym)
					{
						case SDLK_q:
							if(event.key.keysym.mod & KMOD_META)
							{
								CleanUp();
								exit(0);
							}
							break;
							
						case SDLK_RIGHT:
							x = 1.0;
							rightPressed = true;
							break;
							
						case SDLK_LEFT:
							x = -1.0;
							leftPressed = true;
							break;
							
						case SDLK_UP:
							y = 1.0;
							upPressed = true;
							break;
							
						case SDLK_DOWN:
							y = -1.0;
							downPressed = true;
							break;
					}
					
					break;
					
				case SDL_KEYUP:
					
					switch(event.key.keysym.sym)
					{
						case SDLK_RIGHT:
							rightPressed = false;
							if(leftPressed)
								x = -1.0;
							else
								x = 0.0;
							break;
							
						case SDLK_LEFT:
							leftPressed = false;
							if(rightPressed)
								x = 1.0;
							else
								x = 0.0;
							break;
							
						case SDLK_UP:
							upPressed = false;
							if(downPressed)
								y = -1.0;
							else
								y = 0.0;
							break;
							
						case SDLK_DOWN:
							downPressed = false;
							if(upPressed)
								y = 1.0;
							else
								y = 0.0;
							
							break;	
					}
					
					break;
			}
		}
	}
}

void extraTime()
{
	SDL_Event event;
	
	for(int i = 0; i < 5; i++)
	{
		teamTwo[i]->velocity = FSVector(0.0, 0.0, 0.0);
		
		teamOne[i]->velocity = FSVector(0.0, 0.0, 0.0);
	}
	
	stopMusicOne();
	playWinSound();
	
	float time = 0.0;
	
	while(time < 3.0)
	{
		
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);         
		glLoadIdentity();
		
		gluLookAt(cameraX, cameraY, cameraZ, lookX, lookY, lookZ, 0.0, 1.0, 0.0);
		
		
		float deltaT = FSTimePast();
		
		time += deltaT / 1000.0;
		
		for(int i = 0; i < 5; i++)
			teamOne[i]->move(deltaT, ground, ball);
		
		for(int i = 0; i < 5; i++)
			teamTwo[i]->move(deltaT, ground, ball);
		
		ball->move(deltaT, ground);
		
		moveCamera(deltaT);
		
		ground->Draw();
		
		goalTwo.Draw();
		goalOne.Draw();
		
		glEnable(GL_TEXTURE_2D);
		
		glBindTexture(GL_TEXTURE_2D, shadowTex.texID);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
		
		
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glColor4f(1.0, 1.0, 1.0, 1.0);
		
		for(int i = 0; i < 5; i++)
		{
			glPushMatrix();
			glTranslatef(teamOne[i]->position.x-300.0, 0.0 ,teamOne[i]->position.z-300.0);
			glBegin(GL_QUADS);
			glTexCoord2f(0.0, 1.0);
			glVertex3d(0.0, 0.0, 0.0);
			glTexCoord2f(1.0, 1.0);
			glVertex3d(500.0, 0.0, 0.0);
			glTexCoord2f(1.0, 0.0);
			glVertex3d(500.0, 0.0, 500.0);
			glTexCoord2f(0.0, 0.0);
			glVertex3d(0.0, 0.0, 500.0);
			glEnd();
			glPopMatrix();
			
			glPushMatrix();
			glTranslatef(teamTwo[i]->position.x-300.0, 0.0 ,teamTwo[i]->position.z-300.0);
			glBegin(GL_QUADS);
			glTexCoord2f(0.0, 1.0);
			glVertex3d(0.0, 0.0, 0.0);
			glTexCoord2f(1.0, 1.0);
			glVertex3d(500.0, 0.0, 0.0);
			glTexCoord2f(1.0, 0.0);
			glVertex3d(500.0, 0.0, 500.0);
			glTexCoord2f(0.0, 0.0);
			glVertex3d(0.0, 0.0, 500.0);
			glEnd();
			glPopMatrix();
		}
		glPushMatrix();
		glTranslatef(ball->position.x-200.0, 0.0 ,ball->position.z-200.0);
		glBegin(GL_QUADS);
		glTexCoord2f(0.0, 1.0);
		glVertex3d(0.0, 0.0, 0.0);
		glTexCoord2f(1.0, 1.0);
		glVertex3d(400.0, 0.0, 0.0);
		glTexCoord2f(1.0, 0.0);
		glVertex3d(400.0, 0.0, 400.0);
		glTexCoord2f(0.0, 0.0);
		glVertex3d(0.0, 0.0, 400.0);
		glEnd();
		glPopMatrix();
		glDisable(GL_BLEND);
		glDisable(GL_TEXTURE_2D);
		
		
		struct
		{
			float x;
			short index;
		} xs[11], tmp;
		
		
		
		for(int i = 0; i < 5; i++)
		{
			xs[i].x = teamOne[i]->position.x;
			xs[i].index = i;
		}
		
		for(int i = 0; i < 5; i++)
		{
			int index = i + 5;
			xs[index].x = teamTwo[i]->position.x;
			xs[index].index = index;
		}
		
		xs[10].x = ball->position.x;
		xs[10].index = 10;
		
		for (int i = 0; i < 10; i++) 
		{
			for (int j = 0; j < 10-i; j++)
				if (xs[j+1].x < xs[j].x) 
				{
					tmp.x = xs[j].x;
					tmp.index = xs[j].index;
					xs[j].x = xs[j+1].x;
					xs[j].index = xs[j+1].index;
					xs[j+1].x = tmp.x;
					xs[j+1].index = tmp.index;
				}
		}
			
		glDisable(GL_LIGHTING);
		for(int i = 0; i < 11; i++)
		{
			if(xs[i].index < 5)
				teamOne[xs[i].index]->Draw();
			else if(xs[i].index < 10)
				teamTwo[(xs[i].index)-5]->Draw();
			else
				ball->Draw();
		}
			
		glColor3f(1.0f, 0.0, 0.0f);
		
		//drawstr(620, 570, "FPS: %f", 1.0 / (deltaT/1000.0));
		drawFlags();
		
		drawExtratime();
		
		glFlush();
		
		//int swapInterval = 1;
		//CGLSetParameter(CGLGetCurrentContext(), kCGLCPSwapInterval, &swapInterval);
		SDL_GL_SwapBuffers();
		
		while( SDL_PollEvent(& event) )
		{
			switch ( event.type )
			{  
				case SDL_KEYDOWN:
					
					switch(event.key.keysym.sym)
					{
						case SDLK_q:
							if(event.key.keysym.mod & KMOD_META)
							{
								CleanUp();
								exit(0);
							}
							break;
							
						case SDLK_RIGHT:
							x = 1.0;
							rightPressed = true;
							break;
							
						case SDLK_LEFT:
							x = -1.0;
							leftPressed = true;
							break;
							
						case SDLK_UP:
							y = 1.0;
							upPressed = true;
							break;
							
						case SDLK_DOWN:
							y = -1.0;
							downPressed = true;
							break;
					}
					
					break;
					
				case SDL_KEYUP:
					
					switch(event.key.keysym.sym)
					{
						case SDLK_RIGHT:
							rightPressed = false;
							if(leftPressed)
								x = -1.0;
							else
								x = 0.0;
							break;
							
						case SDLK_LEFT:
							leftPressed = false;
							if(rightPressed)
								x = 1.0;
							else
								x = 0.0;
							break;
							
						case SDLK_UP:
							upPressed = false;
							if(downPressed)
								y = -1.0;
							else
								y = 0.0;
							break;
							
						case SDLK_DOWN:
							downPressed = false;
							if(upPressed)
								y = 1.0;
							else
								y = 0.0;
							
							break;	
					}
					
					break;
			}
		}
	}
	
	//stopMusicOne();
	//onlySetMusic(FS_MUSIC_ONE);
	runMatch(FS_EXTRA_TIME);
}

void mainLoop ()
{
    gameDone = false;
    SDL_Event event;
	float minDistance = 999999999.0;
	int minX = 0;
	int minZ = 0;
	
    while(!gameDone)
    {
        while( SDL_PollEvent(& event) )
        {
            switch ( event.type )
            {
                case SDL_QUIT:
                    gameDone = true;
                    break;
					
                case SDL_KEYDOWN:
                    
					//Uint8 *keystate = SDL_GetKeyState(NULL);
					//if ( keystate[SDLK_RETURN] ) printf("Return Key Pressed.\n");
					
					switch(event.key.keysym.sym)
					{
						case SDLK_q:
							if(event.key.keysym.mod & KMOD_META)
							{
								CleanUp();
								exit(0);
							}
							break;
							
						case SDLK_RIGHT:
							x = 1.0;
							rightPressed = true;
							currentOne->move(x, y, 1.0);
							break;
						
						case SDLK_LEFT:
							x = -1.0;
							leftPressed = true;
							currentOne->move(x, y, 1.0);
							break;
							
						case SDLK_UP:
							if(!shooting)
							{
								y = 1.0;
								upPressed = true;
								currentOne->move(x, y, 1.0);
							}
							else
								modifier = -1;
							break;
							
						case SDLK_DOWN:
							if(!shooting)
							{
								y = -1.0;
								downPressed = true;
								currentOne->move(x, y, 1.0);
							}
							else
								modifier = +1;
							break;
						/*	
						case SDLK_p:
							printf("x: %f, z: %f\n", currentOne->position.x, currentOne->position.z);
							break;
						
						case SDLK_t:
							gameTime -= 10.0;
							break;
						*/	
						case SDLK_ESCAPE:
							if(!shooting && !crossing)
								pauseGame();
							break;
						/*	
						case SDLK_k:
							kickOff(FS_ONE);
							break;
							
						case SDLK_j:
							currentOne->jump();
							break;
							
						case SDLK_a:
							AI = !AI;
							break;
						*/	
						case SDLK_SPACE:
							if(ball->takenBy == currentOne->player)
							{
								shooting = true;
								modifier = 0;
								loadTime = 0.0;
							}
							break;
							
						case SDLK_LALT:
						case SDLK_RALT:
							
							if(ball->takenBy == currentOne->player)
							{
								int teamIndex = 0;
								
								for(int i = 0; i < 5; i++)
								{
									if(teamOne[i]->player != currentOne->player)
									{
										
										if( (currentOne->angle == 0 && teamOne[i]->position.z < currentOne->position.z) ||
											(currentOne->angle == 180 && teamOne[i]->position.z > currentOne->position.z) ||
											(currentOne->angle == 90 && teamOne[i]->position.x < currentOne->position.x) ||
											(currentOne->angle == 270 && teamOne[i]->position.x > currentOne->position.x) ||
											(currentOne->angle == 45 && 
												teamOne[i]->position.z < currentOne->position.z && teamOne[i]->position.x < currentOne->position.x) ||
											(currentOne->angle == 135 && 
												teamOne[i]->position.z > currentOne->position.z && teamOne[i]->position.x < currentOne->position.x) ||
											(currentOne->angle == 225 && 
												teamOne[i]->position.z > currentOne->position.z && teamOne[i]->position.x > currentOne->position.x) ||
											(currentOne->angle == 315 && 
												teamOne[i]->position.z < currentOne->position.z && teamOne[i]->position.x > currentOne->position.x))
										{
											 
											float currentDistance = abs( (teamOne[i]->position.x + 
																		  (tan((currentOne->angle * 6.28) / 360) * 
																		   (currentOne->position.z - teamOne[i]->position.z)) - currentOne->position.x) /
																		 sqrt((1 + tan((currentOne->angle * 6.28) / 360))*(1 + tan((currentOne->angle * 6.28) / 360))));
											
											
											
											
											if(currentDistance < minDistance)
											{
												minDistance = currentDistance;
												minX = teamOne[i]->position.x;
												minZ = teamOne[i]->position.z;
												teamIndex = i;
											}
										}
										//printf("cur_dis: %f min_dis: %f minX: %d minZ: %d player: %d\n", currentDistance, minDistance, minX, minZ, teamOne[i]->player);
									}
								}
									
								if(minDistance != 999999999.0) // no players
								{
									float dis = distanceBetweenPoints(teamOne[teamIndex]->position.x, teamOne[teamIndex]->position.z, 
																		currentOne->position.x, currentOne->position.z);
									
									float force = 6000.0;
									
									if(dis >= 4000.0)
										force = 9000.0;
									else if(dis >= 6000.0)
										force = 15000.0;

									ball->velocity = ballVelocityToPoint( minX, minZ, 1000, force); // TO-DO: TEAM BASED
									ball->takenBy = FS_NO_PLAYER;
									minDistance = 999999999.0;
									currentOne->velocity = FSVector(0,0,0);
									currentOne = teamOne[teamIndex];
									currentOne->status = FS_WAIT;
									currentOne->move(x, y, 1.0);
								}
							}
							else
							{
								int teamIndex = 0;
								
								for(int i = 0; i < 5; i++)
								{
									float currentDistance = 
										distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, ball->position.x, ball->position.z);
								
									if(currentDistance < minDistance)
									{
										minDistance = currentDistance;
										teamIndex = i;
									}
								}
								
								if(minDistance != 999999999.0) // no players
								{
									minDistance = 999999999.0;
									currentOne->velocity = FSVector(0,0,0);
									currentOne->status = FS_WAIT;
									currentOne = teamOne[teamIndex];
									currentOne->status = FS_WAIT;
									currentOne->move(x, y, 1.0);
								}
							}
							break;
							
						case SDLK_LCTRL:
						case SDLK_RCTRL:
							
							if(ball->takenBy == currentOne->player)
							{
								crossing = true;
								loadTime = 0.0;
							}
							else
							{
								currentOne->tackling = true;
								currentOne->tackleVelocity = currentOne->velocity * 1.1;
								currentOne->tackleAngle = currentOne->angle;
							}
							/*
											float currentDistance = 
											distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, 
																  currentOne->position.x, currentOne->position.z);
											
											*/
											/*
											if(currentDistance < minDistance)
											{
												if(minDistance != 20000.0)
												{
													minDistance2 = minDistance;
													minX2 = minX;
													minZ2 = minZ;
													teamIndex2 = teamIndex;
												}
												
												minDistance = currentDistance;
												minX = teamOne[i]->position.x;
												minZ = teamOne[i]->position.z;
												teamIndex = i;
											}
											else if(currentDistance < minDistance2)
											{
												minDistance2 = currentDistance;
												minX2 = teamOne[i]->position.x;
												minZ2 = teamOne[i]->position.z;
												teamIndex2 = i;
											}*/
										
										
										/*if( (currentOne->angle == 0 && teamOne[i]->position.z < currentOne->position.z) ||
											(currentOne->angle == 180 && teamOne[i]->position.z > currentOne->position.z) ||
											(currentOne->angle == 90 && teamOne[i]->position.x < currentOne->position.x) ||
											(currentOne->angle == 270 && teamOne[i]->position.x > currentOne->position.x) ||
											(currentOne->angle == 45 && 
											 teamOne[i]->position.z < currentOne->position.z && teamOne[i]->position.x < currentOne->position.x) ||
											(currentOne->angle == 135 && 
											 teamOne[i]->position.z > currentOne->position.z && teamOne[i]->position.x < currentOne->position.x) ||
											(currentOne->angle == 225 && 
											 teamOne[i]->position.z > currentOne->position.z && teamOne[i]->position.x > currentOne->position.x) ||
											(currentOne->angle == 315 && 
											 teamOne[i]->position.z < currentOne->position.z && teamOne[i]->position.x > currentOne->position.x))
										{
											float currentDistance = 
											distanceBetweenPoints(teamOne[i]->position.x, teamOne[i]->position.z, 
																  currentOne->position.x, currentOne->position.z);
											
											
											if(currentDistance < minDistance)
											{
												minDistance = currentDistance;
												minX = teamOne[i]->position.x;
												minZ = teamOne[i]->position.z;
											}
										}*/
										//printf("cur_dis: %f min_dis: %f minX: %d minZ: %d player: %d\n", currentDistance, minDistance, minX, minZ, teamOne[i]->player);
		
								/*
								if(minDistance2 != 20000.0) // no players
								{
									ball->velocity = ballVelocityToPoint( minX2, minZ2, 1000, 5000); // TO-DO: TEAM BASED  4000, 3000
									ball->takenBy = FS_NO_PLAYER;
									minDistance2 = 20000.0;
									minDistance = 20000.0;
									currentOne->velocity = FSVector(0,0,0);
									currentOne = teamOne[teamIndex2];
									currentOne->status = FS_WAIT;
									currentOne->move(x, y, 1.0);
								}*/
							break;
							
						default:
							break;
					}
					
					break;
					
				case SDL_KEYUP:
					
					switch(event.key.keysym.sym)
					{
						case SDLK_RIGHT:
							rightPressed = false;
							if(leftPressed)
								x = -1.0;
							else
								x = 0.0;
							
							currentOne->move(x, y, 1.0);
							break;
							
						case SDLK_LEFT:
							leftPressed = false;
							if(rightPressed)
								x = 1.0;
							else
								x = 0.0;

							currentOne->move(x, y, 1.0);
							break;
							
						case SDLK_UP:
							upPressed = false;
							if(downPressed)
								y = -1.0;
							else
								y = 0.0;

							currentOne->move(x, y, 1.0);
							break;
							
						case SDLK_DOWN:
							downPressed = false;
							if(upPressed)
								y = 1.0;
							else
								y = 0.0;

							currentOne->move(x, y, 1.0);
							break;
							
						case SDLK_SPACE:
							if(shooting)
							{
								shooting = false;
								
								playBounceSound();
								
								if(ball->takenBy == currentOne->player)
								{
									int x = 4000, z = -19000, goalIndex = 0;
									
									for(int i = 0; i < 3; i++)
									{
										float currentDistance = abs( (goalsOne[i][0] + 
																	  (tan((currentOne->angle * 6.28) / 360) * 
																	   (currentOne->position.z - goalsOne[i][1])) - currentOne->position.x) /
																	 sqrt((1 + tan((currentOne->angle * 6.28) / 360))*(1 + tan((currentOne->angle * 6.28) / 360))));
									
										if(currentDistance < minDistance)
										{
											minDistance = currentDistance;
											goalIndex = i;
										}
									}
									
									goalIndex += modifier;
									
									if(goalIndex == -1)
										goalIndex = 0;
									else if(goalIndex == 3)
										goalIndex = 2;
									
									if(minDistance != 999999999.0) // no players
									{
										minDistance = 999999999.0;
										x = goalsOne[goalIndex][0];
										z = goalsOne[goalIndex][1];
									}
									
									currentOne->angle = (6.28 * atan( ( z - (currentOne->position.z)) / ( x - (currentOne->position.x))  )) / 360; // TO-DO: doesn't work
																																				   //printf("angle: %d\n", (int)currentOne->angle);
									if(currentOne->position.z < z)
										currentOne->angle = 180 + currentOne->angle;
									
									ball->position = FSVector(currentOne->position.x + -(500 * sin((6.28*currentOne->angle)/360)), 100, currentOne->position.z + -(500 * cos((6.28*currentOne->angle)/360)));
									
									
									int i;
									for(i = 0; i < 5; i++)
										if(teamOne[i]->player == currentOne->player)
											break;
									
									int factor = (uirand()%(10-teams[teamOneCode].players[i].accuracy)) * 1000;
									
									if(uirand()%2 != 0)
										factor = -factor;
									
									ball->velocity = ballVelocityToPoint( x + factor, z + factor, 2000 * (1+loadTime*1.5), 9000 * (1+loadTime)); // TO-DO: TEAM BASED
									ball->takenBy = FS_NO_PLAYER;
								}
							}
							break;
						
							case SDLK_LCTRL:
							case SDLK_RCTRL:
								if(crossing)
								{
									crossing = false;
									
									playBounceSound();
									
									if(ball->takenBy == currentOne->player)
									{
										int teamIndex = 1;
										int teamIndex2 = 1;
										float minDistance2 = 20000.0;
										int minX2 = 0;
										int minZ2 = 0;
										
										for(int i = 1; i < 5; i++)
										{
											if(teamOne[i]->player != currentOne->player)
											{
												if( (currentOne->angle == 0 && teamOne[i]->position.z < currentOne->position.z) ||
													(currentOne->angle == 180 && teamOne[i]->position.z > currentOne->position.z) ||
													(currentOne->angle == 90 && teamOne[i]->position.x < currentOne->position.x) ||
													(currentOne->angle == 270 && teamOne[i]->position.x > currentOne->position.x) ||
													(currentOne->angle == 45 && 
													 teamOne[i]->position.z < currentOne->position.z && teamOne[i]->position.x < currentOne->position.x) ||
													(currentOne->angle == 135 && 
													 teamOne[i]->position.z > currentOne->position.z && teamOne[i]->position.x < currentOne->position.x) ||
													(currentOne->angle == 225 && 
													 teamOne[i]->position.z > currentOne->position.z && teamOne[i]->position.x > currentOne->position.x) ||
													(currentOne->angle == 315 && 
													 teamOne[i]->position.z < currentOne->position.z && teamOne[i]->position.x > currentOne->position.x))
												{
													float currentDistance = abs( (teamOne[i]->position.x + 
																				  (tan((currentOne->angle * 6.28) / 360) * 
																				   (currentOne->position.z - teamOne[i]->position.z)) - currentOne->position.x) /
																				 sqrt((1 + tan((currentOne->angle * 6.28) / 360))*(1 + tan((currentOne->angle * 6.28) / 360))));
													
													
													if(currentDistance < minDistance)
													{
														minDistance = currentDistance;
														minX = teamOne[i]->position.x;
														minZ = teamOne[i]->position.z;
														teamIndex = i;
													}
												}
											}
										}
										if(minDistance != 999999999.0) // no players
										{
											ball->velocity = ballVelocityToPoint( minX, minZ, 2700 * (1+loadTime), 3000 * (1+loadTime));
											ball->takenBy = FS_NO_PLAYER;
											minDistance = 999999999.0;
											currentOne->velocity = FSVector(0,0,0);
											currentOne = teamOne[teamIndex];
											currentOne->status = FS_WAIT;
											currentOne->move(x, y, 1.0);
										}
									}
								}
								break;
						
						default:
							break;
					}
					
					
					//cameraX -= 100.0f;
					//lookX += 50.0f;
					//cameraZ -= 20.0f;
					break;
					
                default:
                    break;
            }
        }
		
        render();
		
		if(ball->status != FS_GAME || gameTime <= 0.0)
			gameDone = true;
    }
	
	if(ball->status == FS_GOAL_TWO)
		oneScored();
	else if(ball->status == FS_GOAL_ONE)
		twoScored();
	else if(gameTime <= 0.0)
	{
		if(scoreOne > scoreTwo)
			oneWins();
		else if(scoreOne < scoreTwo)
			twoWins();
		else
			extraTime();
	}
}

void runArcade()
{
	bool gameover = false;
	short match = 0;
	bool *teamsToChoose = malloc(sizeof(bool)*teamsCount);
	
	for(int i = 0; i < teamsCount; i++)
	{
		if(i != teamOneCode)
			teamsToChoose[i] = false;
		else
			teamsToChoose[i] = true;
	}
	
	while(!gameover && match < 6)
	{
		int index = uirand()%(teamsCount-match-1);
		int freeCount = 0;
		
		for(int i = 0; i < teamsCount; i++)
		{
			if(teamsToChoose[i] == false)
			{
				if(freeCount == index)
				{
					teamTwoCode = i;
					teamsToChoose[i] = true;
					break;
				}
				else
					freeCount++;
			}
		}
		
		runMatch(FS_NORMAL);
		
		if(goToMain || scoreOne < scoreTwo)
			gameover = true;
		else
			match++;
	}
	
	if(!gameover)
		runCredits();
}

void runMatch(FSMode mode)
{
	glDisable(GL_LIGHTING);
	
	//teamOneCode = 0;
	//teamTwoCode = 1;
	/*
	if(logoSound)
	{
		Mix_FreeChunk(logoSound);
		logoSound = NULL;
	}*/
	
	if(mode == FS_NORMAL)
		gameTime = 180.0;
	else
		gameTime = 65.0;
	
	//AI = false;
	
	oneMinuteWarningTime = -1.0;
	
	scoreOne = scoreTwo = 0;
	goToMain = false;
	
	beginningMatch = true;
	
	for(int i = 0; i < 5; i++)
	{
		teamOne[i]->speed = teams[teamOneCode].players[i].speed * 250.0;
		teamTwo[i]->speed = teams[teamTwoCode].players[i].speed * 250.0;
	}
	/*
	music = Mix_LoadMUS("music.wav");
	printf("%s\n", Mix_GetError());
	Mix_PlayMusic(music, -1);
		*/
	onlySetMusic(FS_MUSIC_ONE);
	//if(audio)
		//playMusicOne();
	kickOff(FS_NEUTRAL);
	
	// Run our message loop
    mainLoop();
	
	//Mix_FreeMusic(music);
	//music = NULL;
	//if(audio)
		stopMusicOne();
	glDisable(GL_LIGHTING);
}

void renderMenu(float slideValue, int selectedMenuItem, bool displayPress = false)
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);         
	
	glDisable(GL_LIGHTING);
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	glOrtho(0.0, 800, 
			0.0, 600, -1.0, 1.0);
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();
	glColor3f(1.0,1.0,1.0);
	
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, screenTex.texID);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	
	glBegin(GL_QUADS);
	glTexCoord2f(0.0, 0.0);
	glVertex2d(0, 0);
	glTexCoord2f(1.0, 0.0);
	glVertex2d(800, 0);
	glTexCoord2f(1.0, 1.0);
	glVertex2d(800, 600);
	glTexCoord2f(0.0, 1.0);
	glVertex2d(0, 600);
	glEnd();
	
	glBindTexture(GL_TEXTURE_2D, logoTex.texID);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	
	
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glColor4f(1.0, 1.0, 1.0, 1.0);
	
	glBegin(GL_QUADS);
		glTexCoord2f(0.0, 0.0);
		glVertex2d(50.0, 125.0);
		glTexCoord2f(1.0, 0.0);
		glVertex2d(400, 125.0);
		glTexCoord2f(1.0, 1.0);
		glVertex2d(400, 475.0);
		glTexCoord2f(0.0, 1.0);
		glVertex2d(50.0, 475.0);
	glEnd();
	
	glDisable(GL_BLEND);
	
	
	glDisable(GL_TEXTURE_2D);
	glColor3f(1.0,1.0,1.0);
	glBegin(GL_QUADS);
	glVertex2d(slideValue + 200.0, 0.0);
	glVertex2d(800.0, 0.0);
	glVertex2d(800.0, 600.0);
	glVertex2d(slideValue + 200.0, 600.0);
	glEnd();
	glEnable(GL_TEXTURE_2D);
	
	glBindTexture(GL_TEXTURE_2D, circleTex.texID);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	
	
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glColor4f(1.0, 1.0, 1.0, 1.0);
	
	glBegin(GL_QUADS);
	glTexCoord2f(0.0, 0.0);
	glVertex2d(slideValue + 72.0, 0);
	glTexCoord2f(1.0, 0.0);
	glVertex2d(slideValue + 200, 0.0);
	glTexCoord2f(1.0, 1.0);
	glVertex2d(slideValue + 200, 600.0);
	glTexCoord2f(0.0, 1.0);
	glVertex2d(slideValue + 72.0, 600.0);
	glEnd();
	
	glDisable(GL_BLEND);
	
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glColor4f(1.0, 1.0, 1.0, 1.0);
	
	for(int i = 0; i < 4; i++)
	{
		glEnable(GL_TEXTURE_2D);
		if(i != selectedMenuItem)
			glBindTexture(GL_TEXTURE_2D, menuItem[i].texID);
		else
			glBindTexture(GL_TEXTURE_2D, menuItemH[i].texID);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		
		glPushMatrix();
		glTranslatef(slideValue + 225.0, 400.0 - ((float)i * 80.0), 0.0);
		
		glBegin(GL_QUADS);
		glTexCoord2f(0.0, 0.0);
		glVertex2d(0, 0);
		glTexCoord2f(1.0, 0.0);
		glVertex2d(256, 0);
		glTexCoord2f(1.0, 1.0);
		glVertex2d(256, 64);
		glTexCoord2f(0.0, 1.0);
		glVertex2d(0, 64);
		glEnd();
		glPopMatrix();
	}
	
	glDisable(GL_BLEND);
	
	if(displayPress)
	{
		glBindTexture(GL_TEXTURE_2D, pressanykeyTex.texID);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		
		
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glColor4f(1.0, 1.0, 1.0, 1.0);
		
		glBegin(GL_QUADS);
			glTexCoord2f(0.0, 0.0);
			glVertex2d(30.0, 20.0);
			glTexCoord2f(1.0, 0.0);
			glVertex2d(542.0, 20.0);
			glTexCoord2f(1.0, 1.0);
			glVertex2d(542.0, 148.0);
			glTexCoord2f(0.0, 1.0);
			glVertex2d(30.0, 148.0);
		glEnd();
		
		glDisable(GL_BLEND);
	}
	
	glPopMatrix();
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	
	glFlush();
	
	//int swapInterval = 1;
	//CGLSetParameter(CGLGetCurrentContext(), kCGLCPSwapInterval, &swapInterval);
	SDL_GL_SwapBuffers();
}

int chooseTeam(char *playerName)
{
	int code = -2;
	int selected = 0;
	float slideValue = 600.0;
	SDL_Event event;
	
	while(code == -2)
	{
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);         
		
		glDisable(GL_LIGHTING);
		glMatrixMode(GL_PROJECTION);
		glPushMatrix();
		glLoadIdentity();
		glOrtho(0.0, 800, 
				0.0, 600, -1.0, 1.0);
		glMatrixMode(GL_MODELVIEW);
		glPushMatrix();
		glLoadIdentity();
		glColor3f(1.0,1.0,1.0);
		
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, screenTex.texID);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		
		glBegin(GL_QUADS);
		glTexCoord2f(0.0, 0.0);
		glVertex2d(0, 0);
		glTexCoord2f(1.0, 0.0);
		glVertex2d(800, 0);
		glTexCoord2f(1.0, 1.0);
		glVertex2d(800, 600);
		glTexCoord2f(0.0, 1.0);
		glVertex2d(0, 600);
		glEnd();
		
		glBindTexture(GL_TEXTURE_2D, logoTex.texID);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		
		
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glColor4f(1.0, 1.0, 1.0, 1.0);
		
		glBegin(GL_QUADS);
		glTexCoord2f(0.0, 0.0);
		glVertex2d(50.0, 125.0);
		glTexCoord2f(1.0, 0.0);
		glVertex2d(400, 125.0);
		glTexCoord2f(1.0, 1.0);
		glVertex2d(400, 475.0);
		glTexCoord2f(0.0, 1.0);
		glVertex2d(50.0, 475.0);
		glEnd();
		
		glDisable(GL_BLEND);
		
		
		glDisable(GL_TEXTURE_2D);
		glColor3f(1.0,1.0,1.0);
		glBegin(GL_QUADS);
		glVertex2d(slideValue + 200.0, 0.0);
		glVertex2d(800.0, 0.0);
		glVertex2d(800.0, 600.0);
		glVertex2d(slideValue + 200.0, 600.0);
		glEnd();
		glEnable(GL_TEXTURE_2D);
		
		glBindTexture(GL_TEXTURE_2D, circleTex.texID);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		
		
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glColor4f(1.0, 1.0, 1.0, 1.0);
		
		glBegin(GL_QUADS);
		glTexCoord2f(0.0, 0.0);
		glVertex2d(slideValue + 72.0, 0);
		glTexCoord2f(1.0, 0.0);
		glVertex2d(slideValue + 200, 0.0);
		glTexCoord2f(1.0, 1.0);
		glVertex2d(slideValue + 200, 600.0);
		glTexCoord2f(0.0, 1.0);
		glVertex2d(slideValue + 72.0, 600.0);
		glEnd();
		
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, teamsTex.texID);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		
		glBegin(GL_QUADS);
			glTexCoord2f(0.0, 0.0);
			glVertex2d(50.0, 50.0);
			glTexCoord2f(1.0, 0.0);
			glVertex2d(600.0, 50.0);
			glTexCoord2f(1.0, 1.0);
			glVertex2d(600.0, 590.0);
			glTexCoord2f(0.0, 1.0);
			glVertex2d(50.0, 590.0);
		glEnd();
		
		
		glDisable(GL_BLEND);
		
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glColor4f(1.0, 1.0, 1.0, 1.0);
		
		glBindTexture(GL_TEXTURE_2D, selectteamTex.texID);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		
		glPushMatrix();
		glTranslatef(60.0, 490.0, 0.0);
		
		glBegin(GL_QUADS);
			glTexCoord2f(0.0, 0.0);
			glVertex2d(0, 0);
			glTexCoord2f(1.0, 0.0);
			glVertex2d(320, 0);
			glTexCoord2f(1.0, 1.0);
			glVertex2d(320, 75.0);
			glTexCoord2f(0.0, 1.0);
			glVertex2d(0, 75.0);
		glEnd();
		glPopMatrix();
		
		glDisable(GL_BLEND);
		
		
		glColor3f(0.0, 1.0, 1.0);
		glBegin(GL_QUADS);
			glVertex2d((80*(selected%6)) + 65.0, 485.0 - (60*(selected/6)));
			glVertex2d((80*(selected%6)) + 139.0, 485.0 - (60*(selected/6)));
			glVertex2d((80*(selected%6)) + 139.0, 443.0 - (60*(selected/6)));
			glVertex2d((80*(selected%6)) + 65.0, 443.0 - (60*(selected/6)));
		glEnd();
		
		glColor3f(1.0, 1.0, 1.0);
		
		int row = 0;
		
		for(int i = 0; i < teamsCount; i++)
		{
			glEnable(GL_TEXTURE_2D);
			glBindTexture(GL_TEXTURE_2D, flagsTextures[i].texID);
			glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
			glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
			glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
			glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
			
			glBegin(GL_QUADS);
				glTexCoord2f(0.0, 0.0);
				glVertex2d((80*(i%6)) + 70.0, 480.0 - (60*row));
				glTexCoord2f(1.0, 0.0);
				glVertex2d((80*(i%6)) + 134.0, 480.0 - (60*row));
				glTexCoord2f(1.0, 1.0);
				glVertex2d((80*(i%6)) + 134.0, 448.0 - (60*row));
				glTexCoord2f(0.0, 1.0);
				glVertex2d((80*(i%6)) + 70.0, 448.0 - (60*row));
			glEnd();
			
			if( ((i+1)%6) == 0)
				row++;
		}
		glDisable(GL_TEXTURE_2D);
		
		drawstr(100, 78, playerName);
		drawstr(300, 78, teams[selected].name);
		
		glPopMatrix();
		glMatrixMode(GL_PROJECTION);
		glPopMatrix();
		glMatrixMode(GL_MODELVIEW);
		
		glFlush();
		
		//int swapInterval = 1;
		//CGLSetParameter(CGLGetCurrentContext(), kCGLCPSwapInterval, &swapInterval);
		SDL_GL_SwapBuffers();
		
		while( SDL_PollEvent(& event) )
        {
			switch ( event.type )
            {
                case SDL_QUIT:
                    break;
					
                case SDL_KEYDOWN:
					if(event.key.keysym.sym == SDLK_SPACE || event.key.keysym.sym == SDLK_RETURN)
					{
						code = selected;
						playSelectSound();
					}
					else if(event.key.keysym.sym == SDLK_ESCAPE)
						code = -1;
					else if(event.key.keysym.sym == SDLK_RIGHT)
					{
						playMoveSound();
						selected++;
						if(selected >= teamsCount)
							selected = 0;
					}
					else if(event.key.keysym.sym == SDLK_LEFT)
					{
						playMoveSound();
						selected--;
						if(selected < 0)
							selected = teamsCount-1;
					}
					else if(event.key.keysym.sym == SDLK_DOWN)
					{
						playMoveSound();
						if(selected+6 < teamsCount)
						{
							selected += 6;
							row++;
						}
						else
						{
							selected = selected%6;
							row = 0;
						}
					}
					else if(event.key.keysym.sym == SDLK_UP)
					{
						playMoveSound();
						if(selected-6 >= 0)
						{
							selected -= 6;
							row--;
						}
						else
						{
							int rows = teamsCount / 6;
							
							if(teamsCount%6 == 0 || teamsCount%6 < selected%6)
							{
								row = rows;
								selected = teamsCount-1-6+ (selected%6);
							}
							else
							{
								row = rows+1;
								selected = teamsCount-1-(teamsCount%6) + (selected%6);
							}
						}
					}
					else if(event.key.keysym.sym == SDLK_q)
					{
						if(event.key.keysym.mod & KMOD_META)
						{
							CleanUp();
							exit(0);
						}
						break;
					}
					break;
			}
		}
		
	}
	
	return code;
}

void showInstructions()
{
	float slideValue = 600.0;
	SDL_Event event;
	bool done = false;
	
	while(!done)
	{
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);         
		
		glDisable(GL_LIGHTING);
		glMatrixMode(GL_PROJECTION);
		glPushMatrix();
		glLoadIdentity();
		glOrtho(0.0, 800, 
				0.0, 600, -1.0, 1.0);
		glMatrixMode(GL_MODELVIEW);
		glPushMatrix();
		glLoadIdentity();
		glColor3f(1.0,1.0,1.0);
		
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, screenTex.texID);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		
		glBegin(GL_QUADS);
		glTexCoord2f(0.0, 0.0);
		glVertex2d(0, 0);
		glTexCoord2f(1.0, 0.0);
		glVertex2d(800, 0);
		glTexCoord2f(1.0, 1.0);
		glVertex2d(800, 600);
		glTexCoord2f(0.0, 1.0);
		glVertex2d(0, 600);
		glEnd();
		
		glBindTexture(GL_TEXTURE_2D, logoTex.texID);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		
		
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glColor4f(1.0, 1.0, 1.0, 1.0);
		
		glBegin(GL_QUADS);
		glTexCoord2f(0.0, 0.0);
		glVertex2d(50.0, 125.0);
		glTexCoord2f(1.0, 0.0);
		glVertex2d(400, 125.0);
		glTexCoord2f(1.0, 1.0);
		glVertex2d(400, 475.0);
		glTexCoord2f(0.0, 1.0);
		glVertex2d(50.0, 475.0);
		glEnd();
		
		glDisable(GL_BLEND);
		
		
		glDisable(GL_TEXTURE_2D);
		glColor3f(1.0,1.0,1.0);
		glBegin(GL_QUADS);
		glVertex2d(slideValue + 200.0, 0.0);
		glVertex2d(800.0, 0.0);
		glVertex2d(800.0, 600.0);
		glVertex2d(slideValue + 200.0, 600.0);
		glEnd();
		glEnable(GL_TEXTURE_2D);
		
		glBindTexture(GL_TEXTURE_2D, circleTex.texID);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		
		
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glColor4f(1.0, 1.0, 1.0, 1.0);
		
		glBegin(GL_QUADS);
		glTexCoord2f(0.0, 0.0);
		glVertex2d(slideValue + 72.0, 0);
		glTexCoord2f(1.0, 0.0);
		glVertex2d(slideValue + 200, 0.0);
		glTexCoord2f(1.0, 1.0);
		glVertex2d(slideValue + 200, 600.0);
		glTexCoord2f(0.0, 1.0);
		glVertex2d(slideValue + 72.0, 600.0);
		glEnd();
		
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, instructionsTex.texID);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		
		glBegin(GL_QUADS);
			glTexCoord2f(0.0, 0.0);
			glVertex2d(50.0, 50.0);
			glTexCoord2f(1.0, 0.0);
			glVertex2d(600.0, 50.0);
			glTexCoord2f(1.0, 1.0);
			glVertex2d(600.0, 590.0);
			glTexCoord2f(0.0, 1.0);
			glVertex2d(50.0, 590.0);
		glEnd();
		
		
		glDisable(GL_BLEND);
		glDisable(GL_TEXTURE_2D);
		
		
		glPopMatrix();
		glMatrixMode(GL_PROJECTION);
		glPopMatrix();
		glMatrixMode(GL_MODELVIEW);
		
		glFlush();
		
		//int swapInterval = 1;
		//CGLSetParameter(CGLGetCurrentContext(), kCGLCPSwapInterval, &swapInterval);
		SDL_GL_SwapBuffers();
		
		while( SDL_PollEvent(& event) )
        {
			switch ( event.type )
            {
                case SDL_QUIT:
                    break;
					
                case SDL_KEYDOWN:
					if(event.key.keysym.sym == SDLK_q)
					{
						if(event.key.keysym.mod & KMOD_META)
						{
							CleanUp();
							exit(0);
						}
						break;
					}
					else
						done = true;
					break;
			}
		}
		
	}
}

void runCredits()
{
	SDL_Event event;
	bool done = false;
	float pos = 0.0;
	oldTime = SDL_GetTicks();
	
	while(!done)
	{
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);         
		
		glDisable(GL_LIGHTING);
		glMatrixMode(GL_PROJECTION);
		glPushMatrix();
		glLoadIdentity();
		glOrtho(0.0, 800, 
				0.0, 600, -1.0, 1.0);
		glMatrixMode(GL_MODELVIEW);
		glPushMatrix();
		glLoadIdentity();
		

		float deltaT = FSTimePast();
		pos += 80.0 * (deltaT / 1000.0);

		glColor3f(0.0, 0.0, 0.0);
			glBegin(GL_QUADS);
			glVertex2d(0, 0);
			glVertex2d(800, 0);
			glVertex2d(800, 600);
			glVertex2d(0, 600);
		glEnd();
		
		glPopMatrix();
		glMatrixMode(GL_PROJECTION);
		glPopMatrix();
		glMatrixMode(GL_MODELVIEW);
		
		for(int i = 0; i < creditsCount; i++)
			drawstr2(20.0, pos - (i*20.0), credits[i]);
		
		if((pos - (i*20.0)) > 550.0)
			done = true;
		
		glFlush();
		
		//int swapInterval = 1;
		//CGLSetParameter(CGLGetCurrentContext(), kCGLCPSwapInterval, &swapInterval);
		SDL_GL_SwapBuffers();
		
		while( SDL_PollEvent(& event) )
        {
			switch ( event.type )
            {
                case SDL_QUIT:
                    break;
					
                case SDL_KEYDOWN:
					if(event.key.keysym.sym == SDLK_SPACE || event.key.keysym.sym == SDLK_RETURN)
						done = true;
					else if(event.key.keysym.sym == SDLK_q)
					{
						if(event.key.keysym.mod & KMOD_META)
						{
							CleanUp();
							exit(0);
						}
						break;
					}
					break;
			}
		}
		
	}
}

void runMenu()
{
	bool done = false;
	SDL_Event event;
	short selectedMenuItem = 0;
	float slideValue = 600.0;
	float time = 0.0;
	playRooster();
	
	while(!done)
	{		
		renderMenu(slideValue, selectedMenuItem, true);
		
		while( SDL_PollEvent(& event) )
        {
			switch ( event.type )
            {
                case SDL_QUIT:
					CleanUp();
					exit(0);
					break;
					
                case SDL_KEYDOWN:
					if(event.key.keysym.sym == SDLK_q)
					{
						if(event.key.keysym.mod & KMOD_META)
						{
							CleanUp();
							exit(0);
						}
						break;
					}
					else
						done = true;
					break;
			}
		}
	}
	
	oldTime = SDL_GetTicks();
	
	playMenuSound();
	
	while(slideValue > 300.0)
	{
		float deltaT = FSTimePast();
		
		renderMenu(slideValue, selectedMenuItem);
		
		slideValue -= 250.0 * (deltaT / 1000.0);
		
		/*
		while( SDL_PollEvent(& event) )
        {
			switch ( event.type )
            {
                case SDL_QUIT:
                    slideValue = 300.0;
                    break;
					
                case SDL_KEYDOWN:
					slideValue = 300.0;
					break;
			}
		}*/
	}
	
	done = false;
	int theOneCode;
	while(!done)
    {
		renderMenu(slideValue, selectedMenuItem);
		while( SDL_PollEvent(& event) )
        {
			switch ( event.type )
            {
                case SDL_QUIT:
                    done = true;
                    break;
					
                case SDL_KEYDOWN:
					switch(event.key.keysym.sym)
					{
						case SDLK_q:
							if(event.key.keysym.mod & KMOD_META)
								done = true;
							break;
							
						case SDLK_DOWN:
							playMoveSound();
							selectedMenuItem++;
							if(selectedMenuItem == 4)
								selectedMenuItem = 0;
							break;
							
						case SDLK_UP:
							playMoveSound();
							selectedMenuItem--;
							if(selectedMenuItem == -1)
								selectedMenuItem = 3;
							break;
						
						case SDLK_SPACE:
						case SDLK_RETURN:
							playSelectSound();
							switch(selectedMenuItem)
							{
								case 0:
									oldTime = SDL_GetTicks();
									
									while(slideValue < 600.0)
									{
										float deltaT = FSTimePast();
										
										renderMenu(slideValue, selectedMenuItem);
										
										slideValue += 250.0 * (deltaT / 1000.0);
									}
										
									theOneCode = chooseTeam("Player One (Human): ");
									
									if(theOneCode != -1)
									{
										teamOneCode = theOneCode;
										AI = true;
										runArcade();
									}
									else
									{
										playMenuSound();
										
										oldTime = SDL_GetTicks();
										
										while(slideValue > 300.0)
										{
											float deltaT = FSTimePast();
											
											renderMenu(slideValue, selectedMenuItem);
											
											slideValue -= 250.0 * (deltaT / 1000.0);
										}
									}
									break;
								
								case 1:
									oldTime = SDL_GetTicks();
									
									while(slideValue < 600.0)
									{
										float deltaT = FSTimePast();
										
										renderMenu(slideValue, selectedMenuItem);
										
										slideValue += 250.0 * (deltaT / 1000.0);
									}
										
									showInstructions();
									
									playMenuSound();
									
									oldTime = SDL_GetTicks();
									
									while(slideValue > 300.0)
									{
										float deltaT = FSTimePast();
										
										renderMenu(slideValue, selectedMenuItem);
										
										slideValue -= 250.0 * (deltaT / 1000.0);
									}
										
									break;
									
								case 2:
									runCredits();
									break;
									
								case 3:
									done = true;
									break;
							}
							
							slideValue = 300.0;
							break;
					}
			}
		}
	}
	
	CleanUp();
}

int main(int argc, char *argv[])
{
	if( SDL_Init(SDL_INIT_AUDIO|SDL_INIT_VIDEO) < 0 )
    {
        printf("Failed initializing SDL Video : %s\n", SDL_GetError());
        return 1;
    }
	
	/*if(Mix_OpenAudio(22050, AUDIO_S16SYS, 1, 2048) < 0)
	{
		printf("I can't use SDL_mixer library (audio).\n");
		audio = false;
	}
	else*/
		audio = true;
	
	atexit(SDL_Quit);
	
    int videoFlags		= SDL_OPENGL;
    videoFlags			|= SDL_HWPALETTE;
    videoFlags			|= SDL_RESIZABLE;
	videoFlags			|= SDL_FULLSCREEN;
	
    const SDL_VideoInfo *videoInfo = SDL_GetVideoInfo();
	
    if(!videoInfo)
    {
        printf("Failed getting Video Info : %s\n", SDL_GetError());
        exit(0);
    }
	
    if(videoInfo -> hw_available)
        videoFlags |= SDL_HWSURFACE;
    else        
		videoFlags |= SDL_SWSURFACE;
    
    if(videoInfo -> blit_hw)
        videoFlags |= SDL_HWACCEL;
	
    SDL_GL_SetAttribute( SDL_GL_DOUBLEBUFFER, 1 );         // tell SDL that the GL drawing is going to be double buffered
    SDL_GL_SetAttribute( SDL_GL_DEPTH_SIZE,   SCREEN_DEPTH);         // size of depth buffer
    SDL_GL_SetAttribute( SDL_GL_STENCIL_SIZE, 0);          // we aren't going to use the stencil buffer
    SDL_GL_SetAttribute( SDL_GL_ACCUM_RED_SIZE, 0);        // this and the next three lines set the bits allocated per pixel -
    SDL_GL_SetAttribute( SDL_GL_ACCUM_GREEN_SIZE, 0);      // - for the accumulation buffer to 0
    SDL_GL_SetAttribute( SDL_GL_ACCUM_BLUE_SIZE, 0);
    SDL_GL_SetAttribute( SDL_GL_ACCUM_ALPHA_SIZE, 0);
	
	
	SDL_Surface	*screen = SDL_SetVideoMode(SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_DEPTH, videoFlags);
	
    if(!screen)
    {
        printf("Failed to Create Window : %s\n", SDL_GetError());
        exit(0);
    }
	
    SDL_WM_SetCaption("Feathered Soccer", "Feathered Soccer");
	
    resizeScreen(SCREEN_WIDTH, SCREEN_HEIGHT);
	SDL_ShowCursor(SDL_DISABLE);
	
	//int swapInterval = 1;
	//CGLSetParameter(CGLGetCurrentContext(), kCGLCPSwapInterval, &swapInterval);
	//SDL_GL_SwapBuffers();
	
	init();
	
    runMenu();

	return 0;
}
