
#ifndef FS_TEXTURE
#define FS_TEXTURE

#include <stdio.h>
#include <strings.h>
#include <stdlib.h>
#include <math.h>
#include <OpenGL/gl.h>
#include <OpenGL/glu.h>

enum texTypes_t
{
	PCX,
	BMP,
	TGA
};

// only partial pcx file header
typedef struct
{
	unsigned char manufacturer;
	unsigned char version;
	unsigned char encoding;
	unsigned char bits;
	unsigned char xMin;
	unsigned char yMin;
	unsigned char xMax;
	unsigned char yMax;
	unsigned char *palette;
} PCXHEADER;


class FSTexture
{
private:
	long int scaledWidth;
	long int scaledHeight;

	unsigned char *palette;

	//unsigned char *LoadBitmapFile(char *filename, BITMAPINFOHEADER *bitmapInfoHeader);
	unsigned char *LoadPCXFile(char *filename, PCXHEADER *pcxHeader);
	void LoadPCXTexture(char *filename);
	//void LoadBMPTexture(char *filename);

public:
	texTypes_t textureType;

	int width;
	int height;
	int bpp;
	unsigned int texID;

	unsigned char *data;

	FSTexture() { data = NULL; palette = NULL; }
	~FSTexture() {}

	bool LoadTexture(char *filename);
	
	bool LoadTGA_RAW(FILE *in_file, GLubyte *imageData);
	bool LoadTGA_CMP(FILE *in_file, GLubyte *imageData);
	
	void Unload()
	{
		glDeleteTextures(1, &texID);

		if (data != NULL)
			free(data);
		if (palette != NULL)
			free(palette);
		
		data = NULL;
		palette = NULL;
	}
};

#endif