//
//  FSSound.m
//  FeatheredSoccer
//
//  Created by Ludovico Rossi on 03/11/04.
//  Copyright 2004 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <QuickTime/QuickTime.h>

#import "FSSound.h"

@interface FSCocoaSound : NSObject {
	NSSound *bounce;
	NSSound *kickOff;
	NSSound *tackleSound;
	NSSound *sirenSound;
	NSMovie *backgroundMusic1;
	NSMovie *backgroundMusic1f;
	void *theMusic;
	void *oldMusic;
}
- (void) doPlayBounce:(id)anObject;
- (void) doPlayTackle:(id)anObject;
- (void) doPlayKickOff:(id)anObject;
- (void) doPlayGoal:(id)anObject;
- (void) doPlaySiren:(id)anObject;
- (void) doPlayMusic:(id)anObject;
- (void) doStopMusic:(id)anObject;
- (void) doPauseMusic:(id)anObject;
- (void) doSwitchMusic:(id)anObject;
- (bool) isPlayingMusic;
- (void) setMusic:(FSMusic)m;
- (void) onlySetMusic:(FSMusic)m;

@end

@implementation FSCocoaSound

- (void) doPlayBounce:(id)anObject

{
    NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	
	[bounce stop];
	[bounce play];
	
    [pool release];
	
    return;
}

- (void) doPlayTackle:(id)anObject

{
    NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	
	[tackleSound play];
	
    [pool release];
	
    return;
}

- (void) doPlaySiren:(id)anObject

{
    NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	
	[sirenSound play];
	
    [pool release];
	
    return;
}

- (void) doPlayKickOff:(id)anObject

{
    NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	
	[kickOff play];
	
    [pool release];
	
    return;
}

- (void) doPlayGoal:(id)anObject

{
    NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	
	[bounce stop];
	[[NSSound soundNamed:@"goal"] play];
	
    [pool release];
	
    return;
}

- (void) doPlayMusic:(id)anObject

{
    NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	
	StartMovie(theMusic);
	
    [pool release];
	
    return;
}

- (void) doStopMusic:(id)anObject

{
    NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	
	StopMovie(theMusic);
	GoToBeginningOfMovie(theMusic);
	
    [pool release];
	
    return;
}

- (void) doPauseMusic:(id)anObject

{
    NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	
	StopMovie(theMusic);
	
    [pool release];
	
    return;
}

- (void) doSwitchMusic:(id)anObject

{
    NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	
	StopMovie(oldMusic);
	GoToBeginningOfMovie(theMusic);
	StartMovie(theMusic);
	
    [pool release];
	
    return;
}

- (bool) isPlayingMusic
{
    return !IsMovieDone(theMusic);
}

- (void) setMusic:(FSMusic)m
{
	oldMusic = theMusic;
	
	switch(m)
	{
		case FS_MUSIC_ONE:
			theMusic = [backgroundMusic1 QTMovie];
			break;
			
		case FS_MUSIC_ONE_FAST:
			theMusic = [backgroundMusic1f QTMovie];
			break;
	}
	
	[NSThread detachNewThreadSelector:@selector(doSwitchMusic:) toTarget:self withObject:nil];
}

- (void) onlySetMusic:(FSMusic)m
{
	switch(m)
	{
		case FS_MUSIC_ONE:
			theMusic = [backgroundMusic1 QTMovie];
			break;
			
		case FS_MUSIC_ONE_FAST:
			theMusic = [backgroundMusic1f QTMovie];
			break;
	}
	
	GoToBeginningOfMovie(theMusic);
}

- (id) init

{
    self = [super init];
	
	bounce = [NSSound soundNamed:@"bounce"];
	kickOff = [NSSound soundNamed:@"kickOff"];
	tackleSound = [NSSound soundNamed:@"tackle"];
	sirenSound = [NSSound soundNamed:@"siren"];
	
	NSString *path;
	NSURL *URL;
	
	path = [[NSBundle mainBundle] pathForResource: @"theme1" ofType: @"mp3"];
	URL = [NSURL fileURLWithPath: path];
	backgroundMusic1 = [[NSMovie alloc] initWithURL:URL byReference:YES];
	
	path = [[NSBundle mainBundle] pathForResource: @"theme1_f" ofType: @"mp3"];
	URL = [NSURL fileURLWithPath: path];
	backgroundMusic1f = [[NSMovie alloc] initWithURL:URL byReference:YES];
	
	theMusic = [backgroundMusic1 QTMovie];
	
	
    return self;
}

/*- (void) dealloc
{
	//StopMovie(theMusic);
	//[backgroundMusic1 release];
	//[backgroundMusic1f release];
}*/
@end

FSCocoaSound *cocoaSound;

void loadSounds()
{
	cocoaSound = [[FSCocoaSound alloc] init];
}

void unloadSounds()
{
	//[cocoaSound dealloc];
}

void playMusicOne()
{
	[NSThread detachNewThreadSelector:@selector(doPlayMusic:) toTarget:cocoaSound withObject:nil];
}

void stopMusicOne()
{
	[NSThread detachNewThreadSelector:@selector(doStopMusic:) toTarget:cocoaSound withObject:nil];
}

void pauseMusicOne()
{
	[NSThread detachNewThreadSelector:@selector(doPauseMusic:) toTarget:cocoaSound withObject:nil];
}

bool isPlayingMusicOne()
{
	return [cocoaSound isPlayingMusic];
}

void setMusic(FSMusic m)
{
	[cocoaSound setMusic:m];
}

void onlySetMusic(FSMusic m)
{
	[cocoaSound onlySetMusic:m];
}

void playLogoSound()
{
	[[NSSound soundNamed:@"logo"] play];
}

void playMenuSound()
{
	[[NSSound soundNamed:@"menu"] play];
}

void playSelectSound()
{
	[[NSSound soundNamed:@"select"] play];
}

void playKickOffSound()
{
	[NSThread detachNewThreadSelector:@selector(doPlayKickOff:) toTarget:cocoaSound withObject:nil];
}

void playEndSound()
{
	[[NSSound soundNamed:@"end"] play];
}

void playBounceSound()
{
	[NSThread detachNewThreadSelector:@selector(doPlayBounce:) toTarget:cocoaSound withObject:nil];
}

void playMoveSound()
{
	[[NSSound soundNamed:@"move"] stop];
	[[NSSound soundNamed:@"move"] play];
}

void playWinSound()
{
	[[NSSound soundNamed:@"win"] play];
}

void playRooster()
{
	[[NSSound soundNamed:@"rooster"] play];
}

void playGoalSound()
{
	[NSThread detachNewThreadSelector:@selector(doPlayGoal:) toTarget:cocoaSound withObject:nil];
}

void playTackleSound()
{
	[NSThread detachNewThreadSelector:@selector(doPlayTackle:) toTarget:cocoaSound withObject:nil];
}

void playSirenSound()
{
	[NSThread detachNewThreadSelector:@selector(doPlaySiren:) toTarget:cocoaSound withObject:nil];
}