/*
 *  FSPlayer.h
 *  FeatheredSoccer
 *
 *  Created by Ludovico Rossi on 23/08/04.
 *  Copyright 2004 __MyCompanyName__. All rights reserved.
 *
 */

#ifndef FS_PLAYER
#define FS_PLAYER

#include <OpenGL/gl.h>
#include <OpenGL/glu.h>
#include <GLUT/glut.h>
#include <math.h>
#include "FSVector.h"
#include "FSObject.h"
#include "FSTexture.h"
#include "FSPlane.h"
#include "FSGround.h"
#include "FSBall.h"
#include "ModelType.h"

typedef struct _MoveDelay
{
	float x;
	float y;
	float scale;
	float endTime;
	float time;
} MoveDelay;

typedef struct FSColor
{
	float r;
	float g;
	float b;
} FSColor;

enum FSAIStatus
{
	FS_WAIT,
	FS_WAIT_FOR_TWO,
	FS_MOVING_TO_ONE,
	FS_MOVING_TO_TWO,
	FS_UPDATING_WAIT,
	FS_UPDATING_ROLE,
	FS_FOLLOWING_BALL,
	FS_DRIBBLING,
	FS_IDLE,
	FS_MOVING_TO_GOAL,
	FS_WAIT_FOR_GOAL
};

class FSPlayer : public FSObject
{
	private:
		ModelType *model;
		float radius;
		float colorMatrix[6][3];
		
		MoveDelay moveDelay;
		bool walking;
		int pose;
		float timeAnim;
		bool wasAdd;
				
	public:
		float speed;
		FSPlayers player;	
		float angle;
		FSAIStatus status;
		FSAIStatus nextStatus;
		float dribblingTime;
		FSVector addTemp;
		float add;
		bool updateBall;
		bool dontMove;
		bool tackling;
		float tacklingTime;
		FSVector tackleVelocity;
		float tackleAngle;
		bool falling;
		float fallingTime;
		float fallAngle;
		float timer;
		float timer2;
		
		FSPlayer(ModelType *theModel, FSPlayers thePlayer, FSColor theBodyColor, FSColor theLegsColor); 
		~FSPlayer(){}

		void Init();
		void Load();
		void Unload();

		void Draw();
		void jump();
		void moveGoalKeeper(int deltaT, FSBall *ball, int factor);
		void move(int deltaT, FSGround *field, FSBall *ball);
		void move(float x, float y, float scale);
		void moveToPoint(int x, int z, FSBall *ball);
};

#endif 

