#ifndef FS_OBJECT
#define FS_OBJECT

#include "FSVector.h"

class FSObject
{
public:
     FSVector position;        // position of object
     FSVector velocity;        // velocity of object
     FSVector acceleration;    // acceleration of object
     FSScalar size;           // size of bounding sphere

public:
     FSObject() {};            // constructor
     ~FSObject() {};           // destructor

     virtual void Load() = 0;      // load into memory
     virtual void Unload() = 0;    // unload from memory
     virtual void Draw() = 0;      // draw object
};


#endif