#ifndef FS_GROUND
#define FS_GROUND

#include <OpenGL/gl.h>
#include <OpenGL/glu.h>
#include <math.h>
#include "FSVector.h"
#include "FSObject.h"
#include "FSTexture.h"
#include "FSPlane.h"

/*

  FSGround (derived from FSObject)

  Description: The air hockey table. Holds the table corner coordinates,
               table wall planes, and table texture.
*/

class FSGround : public FSObject
{
private:
     FSTexture iceTex;              // table texture
	 FSTexture ambientTex;
	 FSTexture centerTex;
	 FSTexture wallTex;
	 FSTexture ads[8];
public:
     float tableCorners[4][3];     // table corner coordinates
     FSPlane tableWalls[4];         // table wall planes
	 FSPlane groundPlane;
	 short ground;

     FSGround() 
     {
          position = FSVector(0.0, 0.0, 0.0);
     }

     ~FSGround(){}

     void Load();
     void Unload();

     void Draw();
     void SetupTexture();
};

#endif 